/****************************
 * systemJs.js
 * Main system for Node-Webkit studysystem
 * 20.5.2014
 * Petri Sallasmaa
 * Petri Salmela
 ****************************/
{ // General additions
    Function.prototype.inheritsFrom = function( parentClassOrObject ) { 
        if ( parentClassOrObject.constructor == Function ) { // Normal Inheritance
            this.prototype = new parentClassOrObject;
            this.prototype.constructor = this;
            this.prototype.parentClass = parentClassOrObject.prototype;
        } 
        else { // Pure Virtual Inheritance
            this.prototype = parentClassOrObject;
            this.prototype.constructor = this;
            this.prototype.parentClass = parentClassOrObject;
        }
        return this;
    };
    
    /******
     * A simple hash for strings.
     ******/
    String.prototype.hashCode = function() {
        var hash = 0, i, l, char;
        if (this.length == 0) {
            return hash;
        }
        for (i = 0, l = this.length; i < l; i++) {
            char  = this.charCodeAt(i);
            hash  = ((hash<<5)-hash)+char;
            hash |= 0; // Convert to 32bit integer 
        }
        return hash;
    };
}

/*************************
* for debuging
*************************/
window.errorlog=[];
/************************/

(function ($) {
    /*****************************************************************
     * System
     * Constructor
     *****************************************************************/
    function System(place, params) {
        
        var systemSelf = this;
        systemSelf.started = false;
        this.fileSystem = new appFileSystem({"place":place});
        //enable console.logs for debuging
        this.debugmode = true;
        this.debugconnectionmode = false;
        this.defaulParameters = {
                config: {
                    
                    system: {
                        systemversion: "0.9.1:2017.1031",
                        archiveMessages : true,
                        noselect: true,
                        lastupdate: "0",
                        includeApplications:[],
                        includePlugings:[],
                        includeSystem:[],
                        lastupdates:{},
                        headerText:{"en":"ViRum application","sv":"ViRum applikation","fi":"ViRum sovellus"},
                        chatURL : "https://meet.jit.si/",
                        connection:{
                            //serverURL:"http://virum.fi/service/app",
                            //homeURL: "https://virum.fi",
                            registerURL : "https://virum.fi/service/register",
                            webshopbubble:"virum"
                        }
                    },
                    general:{
                        lang: "en-US",
                        uilang: "en",
                        theme: {name:"default",template:"1"}
                    },
                    user:{
                        username:"anonymous",
                        applicationkey: null,
                        email:null,
                        firstname:"",
                        lastname:"",
                        defaultlang:"en",
                        defaultroles:["student"],
                        dontPromptUser : false
                    },
                    content:{},
                    updatehadling:{
                        contentupdates:{
                            sending:{},
                            sent:[]
                        },
                        contentinfo:{
                            sending:{},
                            sent:[]
                        },
                        pendingcontexts:[]
                    },
                    uithemetemplates:{
                        defaulttemplate:{
                            "header" : {
                                "containers" : [
                                    {
                                        "HTMLtype" : "span",
                                        "id" : "",
                                        "classes" : ["applicationHeader"]
                                    },
                                    {
                                        "HTMLtype" : "span",
                                        "id" : "",
                                        "classes" : ["settingsMenu"]
                                    }
                                ]
                            },
                            "footer" : {
                                "containers" : [
                                    {
                                        "HTMLtype" : "span",
                                        "id" : "",
                                        "classes" : ["logoImage"]
                                    }
                                ]
                            },
                            "applications" : {
                                "bookself" : {},
                                "courses" : {},
                                "notebooks" : {}
                            },
                            "templateicons" : {
                                "removeActiveIcon" : "<svg height=\"50\" xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"50\" viewBox=\"0 0 30 30\" class=\"mini-icon mini-icon-trashcan-open default_removeactive\">    <path style=\"stroke: none; \" fill=\"white\" d=\"M6 6.5 l7 -2 l-0.2 -1 l2 -0.4 l0.2 1 l7 -2 l0.6 2 l-16 4.4 z \"></path>    <path style=\"stroke: none;\" d=\"M5 5.5 l7 -2 l-0.2 -1 l2 -0.4 l0.2 1 l7 -2 l0.6 2 l-16 4.4 z \"></path>    <path class=\"can\" style=\"stroke: none;fill: white;\" d=\"M8 9 l16 0 l-3 20 l-10 0z M10 11 l2 15 l2 0 l-1 -15z M14.5 11 l0.5 15 l2 0 l0.5 -15z M22 11 l-3 0 l-1 15 l2 0z\"></path>    <path class=\"can shadow\" style=\"stroke: none;\" d=\"M7 8 l16 0 l-3 20 l-10 0z M9 10 l2 15 l2 0 l-1 -15z M13.5 10 l0.5 15 l2 0 l0.5 -15z M21 10 l-3 0 l-1 15 l2 0z\"></path></svg>",
                                "removeInactiveIcon" : "<svg height=\"50\" xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"50\" viewBox=\"0 0 30 30\" class=\"mini-icon mini-icon-trashcan-closed default_removeinactive\">    <path style=\"stroke: none;\" fill=\"white\" d=\"M8 6.5 l7 -0 l-0 -1 l2 -0 l0 1 l7 0 l0 2 l-16 0 z\"></path>    <path style=\"stroke: none;\" d=\"M7 5.5 l7 -0 l-0 -1 l2 -0 l0 1 l7 0 l0 2 l-16 0 z\"></path>    <path class=\"can\" style=\"stroke: none;fill: white;\" d=\"M8 9 l16 0 l-3 20 l-10 0z M10 11 l2 15 l2 0 l-1 -15z M14.5 11 l0.5 15 l2 0 l0.5 -15z M22 11 l-3 0 l-1 15 l2 0z\"></path>    <path class=\"can shadow\" style=\"stroke: none;\" d=\"M7 8 l16 0 l-3 20 l-10 0z M9 10 l2 15 l2 0 l-1 -15z M13.5 10 l0.5 15 l2 0 l0.5 -15z M21 10 l-3 0 l-1 15 l2 0z\"></path></svg>",
                                "settingsIcon" : "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"3 3 44 44\" class=\"defaultsettingsicon\"><path stroke=\"none\" fill=\"white\" d=\"M21 6 a20 20 0 0 1 10 0 a3 6 22.5 0 0 5.3 2.2 a20 20 0 0 1 7 7 a3 6 67.5 0 0 2.2 5.3 a20 20 0 0 1 0 10 a3 6 112.5 0 0 -2.2 5.3 a20 20 0 0 1 -7 7 a3 6 157.5 0 0 -5.3 2.2 a20 20 0 0 1 -10 0 a3 6 -157.5 0 0 -5.3 -2.2 a20 20 0 0 1 -7 -7 a3 6 -112.5 0 0 -2.2 -5.3 a20 20 0 0 1 0 -10 a3 6 -67.5 0 0 2.2 -5.3 a20 20 0 0 1 7 -7 a3 6 -22.5 0 0 5.3 -2.2z m5 13 a7 7 0 0 0 0 14 a7 7 0 0 0 0 -14z\"></path><path stroke=\"none\" fill=\"black\" d=\"M20 5 a20 20 0 0 1 10 0 a3 6 22.5 0 0 5.3 2.2 a20 20 0 0 1 7 7 a3 6 67.5 0 0 2.2 5.3 a20 20 0 0 1 0 10 a3 6 112.5 0 0 -2.2 5.3 a20 20 0 0 1 -7 7 a3 6 157.5 0 0 -5.3 2.2 a20 20 0 0 1 -10 0 a3 6 -157.5 0 0 -5.3 -2.2 a20 20 0 0 1 -7 -7 a3 6 -112.5 0 0 -2.2 -5.3 a20 20 0 0 1 0 -10 a3 6 -67.5 0 0 2.2 -5.3 a20 20 0 0 1 7 -7 a3 6 -22.5 0 0 5.3 -2.2z m5 13 a7 7 0 0 0 0 14 a7 7 0 0 0 0 -14z\"></path></svg>",
                                "defaultsettingscloseicon" : "X"
                            }
                        }
                    }
                        
                },
                contentupdatetypes:{
                    books:"book",
                    notebooks:"own_notes",
                    courses:"course"
                },
                registeredApplications:{},
                pluginJavascripts:{},
                settingsMenu:[
                    //TODO: implement usersettings to application
                    {text: "User", type: "usersettings"},
                    {text: "General", type: "general"},
                    {text: "About", type: "about"}],
                appViews : {}
                
            };
        // Handle params.
        var extended = $.extend(true,
            {},
            this.defaulParameters,
            {config:{system:this.fileSystem.getSystemOptions()}},    //get saved systemoptions from file
            {config:{general:this.fileSystem.getGeneralOptions()}},  //get saved generaloptions from file
            {config:{user:this.fileSystem.getUserOptions()}},        //get saved useroptions from file
            {config:{library: this.fileSystem.getLibraryOptions()}},        //get saved libraryoptions from file
            {config:{content:this.fileSystem.getContentOptions()}},  //get saved contentoptions from file
            {config:{updatehadling:this.fileSystem.getUpdateInfo()}},//get saved updateinfos from file
            {config:{uithemetemplates:this.fileSystem.getUiThemeTemplates()}},//get saved updateinfos from file
            params
        );
        for (var item in extended) {
            this[item] = extended[item];
        }
        this.place = place;
        this.connectionHandler = new appConnection(jQuery.extend(this.config.system.connection,{"debugmode":this.debugconnectionmode}));
        this.place.addClass('system');
        //hide notifications
        this.place.addClass('noNotifications');
        //Disable selections in system application
        if (this.config.system.noselect) this.place.addClass('noselect');
        // Make sure, the webshopbubble is correct and the homeURL exists.
        if (this.config.system.connection.registerURL.includes('virum.fi')) {
            this.config.system.connection.webshopbubble = 'virum';
        };
        if (this.config.system.connection.registerURL.includes('fourferries.com')) {
            this.config.system.connection.webshopbubble = '4ferries';
        };
        if (!this.config.system.connection.homeURL) {
            this.config.system.connection.homeURL = {
                "virum": "https://virum.fi",
                "4ferries": "https://fourferries.com"
            }[this.config.system.connection.webshopbubble];
        };
        //Init eventHandlers
        this.eventHandlers(place);
        //sendinformation
        this.sessionSend = {contentupdates:{},contentinfo:{}};
        this.sendAmount = 0;
        this.state = "opening";
        this.webshopLink =  'https://fourferries.com/webshop/'+systemSelf.config.general.uilang+'/product-category/'+systemSelf.config.system.connection.webshopbubble+'-'+({"en":"library","fi":"kirjasto","sv":"biblioteket"})[systemSelf.config.general.uilang]+'/';
        this.localizer = new systemLocalizer(this.config.general.uilang);
        this.localizer.addTranslations(
            //TODO: read translations from file
            //this.fileSystem.getLocalizatorData()
            {
                "en":{
                    "system:activate_remove" : "Activate remove",
                    "system:deactivate_remove" : "Disable remove",
                    "system:usersettings" : "Userinformation",
                    "system:languageselect": "Select your language",
                    "system:general" : "General",
                    "system:about" : "About",
                    "system:aboutheader" : "This is 4f Studio application.",
                    "system:abouttext" : "For more information visit <span class=\"fakelink\" data-fakeurl=\"studiourl\">the webpage</a>.",
                    "system:aboutcredits" : "Credits: <span class=\"fakelink\" data-fakeurl=\"librarycredits\">libraries</span>, <span class=\"fakelink\" data-fakeurl=\"nwjscredits\">NW.js</span>.",
                    "system:demowelcome" : "Welcome",
                    "system:demowelcometext" : "This is a demo version of the ViRum application, which gives you the opportunity to try out some interactive text books and create your own electronic notebooks using our large set of tools. Choose your language below – you can later switch to another language at any time inside the application.",
                    "system:copy":"Copy",
                    "system:cut":"Cut",
                    "system:paste":"Paste",
                    "bookshelf":"Bookshelf",
                    "notebooks":"Notebook",
                    "courses":"Courses",
                    "system:remove_element_confirm":"Remove element. Are you sure?",
                    "system:gettingupdates":"Getting updates to system...",
                    "system:cancel":"cancel",
                    "system:updatingsystem":"Updating system",
                    "system:processingdata":"Processing data",
                    "system:working":"Application working... Please wait.",
                    "system:continue":"Continue",
                    "system:goback":"Back",
                    "system:ok":"OK",
                    "system:updatecanceled":"Update canceled",
                    "system:servererror_updates":"Error getting updates from server",
                    "system:sending":"Sending...",
                    "system:redoupdates":"Redo updates",
                    "system:name": "Name",
                    "system:username":"Username",
                    "system:password":"Password",
                    "system:logininfo":"Login",
                    "system:verificationinfo":"Email verification",
                    "system:registerinfo":"Register as a new user",
                    "system:register":"Register",
                    "system:language":"Language",
                    "system:themes":"Themes",
                    "system:default":"Default",
                    "system:schools": "Schools",
                    "system:subscription_expiration_time": "Subscription expires",
                    "system:subscription_nolimit": "No limit",
                    "system:checking_remaining_quota": "Checking quota",
                    "system:checks": "checks",
                    "system:expires": "expires",
                    "system:days": "days",
                    "system:subscription_expires_soon": "Your subscription is about to expire soon.",
                    "system:checking_quota_low": "Checking quota is low.",
                    "system:checking_quota_expiring": "Checking quota is about to expire.",
                    "system:eulaagreement":"EULA",
                    "system:agree":"Accept",
                    "system:disagree":"I do not accept",
                    "system:explain_eula":"You must accept EULA to be able to use this software.",
                    "system:buyserviceTitle":"Buy service",
                    "system:buyservice":"Buy subscription",
                    "system:buychecks": "Buy checks",
                    "system:6month_subscription": "6 months",
                    "system:12month_subscription": "12 months",
                    "system:buyservicetext":"<p>You can not start the app without a subscription. Please click the link below to go to the webshop to buy a subscription.</p><p>When you have bought your subscription, you can start to use the application.</p>",
                    "system:buyServiceTime":"Buy servicetime from webshop",
                    "system:refresh_system":"Reload application",
                    "system:ready":"Ready",
                    "system:buying_done": "Paid",
                    "system:activationneeded": "<p>We have sent you a verification email.</p><p>Activate your account by clicking the activation link in that message.</p><p>After that you can return here to finish the start of the application.</p>",
                    "system:serviceExpired":"<p>Service has expired</p>",
                    "system:continue_without_service": "Continue without",
                    "system:service_bought": "Bought",
                    "system:welcome": "Welcome!",
                    "system:welcome-instructions": "<p>The application is now ready for use.</p><p>Welcome!</p>",
                    "error:SERVICE_EXPIRED":"<p>Your service subscription has ended. You can continue to use application without sevice subscription, but some functionalities will not be available without service.</p><p>You can renew your subscription from webshop.</p>",
                    "error:CONNECTION_FAILED":"<p>Someting wrong with server connection</p>",
                    "error:DATAPARSING_ERROR":"<p>Someting wrong with server response</p>",
                    "error:WRONG_CREDENTIALS":"<p>Wrong username or password</p>",
                    "error:USER_NOT_ACTIVATED":"<p>You haven't activated yourself. Please click activationlink in email that system has sent to you to activate yourself.</p>"
                    },
                "sv":{
                    "system:activate_remove": "Tillåt avlägsnande av material",
                    "system:deactivate_remove": "Avsluta avlägsnande av material",
                    "system:usersettings": "Användarinformation",
                    "system:languageselect": "Välj ditt språk",
                    "system:general": "Generell",
                    "system:about": "Om",
                    "system:aboutheader": "Det här är 4f Studio -appen.",
                    "system:abouttext": "För mera information: gå till <span class=\"fakelink\" data-fakeurl=\"studiourl\">hemsida</span>.",
                    "system:aboutcredits" : "Krediter till: <span class=\"fakelink\" data-fakeurl=\"librarycredits\">bibliotek</span>, <span class=\"fakelink\" data-fakeurl=\"nwjscredits\">NW.js</span>.",
                    "system:demowelcome": "Välkommen",
                    "system:demowelcometext": "Detta är en demoversion av ViRum-appen som ger dig möjlighet att bekanta dig med några interaktiva textböcker samt skapa dina egna elektroniska häften med våra skräddarsydda verktyg. Välj önskat språk för appen nedan. Vid behov kan du byta språk inne i applikationen i ett senare skede.",
                    "system:copy": "Kopiera",
                    "system:cut": "Klipp ut",
                    "system:paste": "Klistra in",
                    "bookshelf": "Bokhylla",
                    "notebooks": "Häften",
                    "courses": "Kurser",
                    "system:remove_element_confirm": "Ta bort elementet. Är du säker?",
                    "system:gettingupdates": "Hämtar systemuppdateringar...",
                    "system:cancel": "Avbryt",
                    "system:continue": "Fortsätt",
                    "system:goback":"Tillbaka",
                    "system:updatecanceled": "Uppdateringen avbruten",
                    "system:sending": "Skickar...",
                    "system:redoupdates": "Uppdatera på nytt",
                    "system:name": "Namn",
                    "system:username": "Användarnamn",
                    "system:password": "Lösenord",
                    "system:language": "Språk",
                    "system:themes": "Teman",
                    "system:default": "Standard",
                    "system:schools": "Skolor",
                    "system:subscription_expiration_time": "Prenumerationen utgår",
                    "system:subscription_nolimit": "Ingen gräns",
                    "system:checking_remaining_quota": "Kvot rättningar",
                    "system:checks": "rättningar",
                    "system:expires": "utgår",
                    "system:days": "dagar",
                    "system:subscription_expires_soon": "Din prenumeration upphör snart.",
                    "system:checking_quota_low": "AC-kvot låg",
                    "system:checking_quota_expiring": "AC-kvoten är på väg att ta slut.",
                    "system:updatingsystem": "Uppdaterar ",
                    "system:logininfo":"Logga in",
                    "system:verificationinfo":"Email verification",
                    "system:register": "Registrera mig",
                    "system:registerinfo": "Registrera dig som ny användare",
                    "system:servererror_updates": "Ett fel uppstod då uppdateringarna hämtades",
                    "system:ok": "OK",
                    "system:working": "Appen arbetar... Var god vänta.",
                    "system:processingdata": "Data bearbetas",
                    "system:eulaagreement":"Slutanvändaravtal",
                    "system:agree":"Jag godkänner avtalet",
                    "system:disagree":"Jag godkänner INTE avtalet",
                    "system:explain_eula":"Du måste godkänna användaravtalen för att kunna använda programvaran.",
                    "system:buyserviceTitle":"Prenumeration saknas",
                    "system:buyservice": "Köp prenumeration",
                    "system:buychecks": "Köp rättningar",
                    "system:6month_subscription": "6 månader",
                    "system:12month_subscription": "12 månader",
                    "system:buyservicetext":"<p>Du kan inte starta appen utan en prenumeration. Var god klicka på länken nedan för att gå till webshopen, där du kan köpa en prenumeration.</p><p>Efter att du köpt en prenumeration, kan du börja använda appen.</p>",
                    "system:buyServiceTime":"Köp prenumeration",
                    "system:refresh_system":"Ladda om appen",
                    "system:ready":"Färdig",
                    "system:buying_done": "Köpt",
                    "system:continue_without_service": "Fortsätt utan",
                    "system:service_bought": "Köpt",
                    "system:welcome": "Välkommen!",
                    "system:welcome-instructions": "<p>Appen är nu klar för användning.</p><p>Välkommen!</p>",
                    "system:activationneeded": "<p>Vi har skickat ett bekräftelsemeddelande till dig per epost.</p><p>Aktivera ditt konto genom att klicka på aktiveringslänken i meddelandet.</p><p>Efter att du gjort detta kan du återkomma hit för att slutföra ibruktagandet av appen.</p> ",
                    "error:SERVICE_EXPIRED":"<p>Din serviceprenumeration har förfallit. Du kan fortsätta använda appen utan prenumeration, men en del av funkionerna är då inte tillgängliga.</p><p>Du kan förnya din prenumeration via webshopen.</p> ",
                    "system:serviceExpired":"<p>Din prenumeration har gått ut.</p>",
                    "error:CONNECTION_FAILED":"<p>Problem med kontakten till servern</p>",
                    "error:DATAPARSING_ERROR":"<p>Appen kunde inte tolka serversvar</p>",
                    "error:WRONG_CREDENTIALS":"<p>Fel användarnamn eller lösenord</p>",
                    "error:USER_NOT_ACTIVATED":"<p>Du har inte aktiverat dina användaruppgifter. Klicka på länken i meddelandet som systemet har skickat till din e-post för att aktivera dig.</p>"
                },
                "fi":{
                    "system:activate_remove" : "Käynnistä poisto",
                    "system:deactivate_remove" : "Lopeta poisto",
                    "system:usersettings" : "Käyttäjätiedot",
                    "system:languageselect": "Valitse kielesi",
                    "system:general" : "Yleiset",
                    "system:about" : "Tietoja",
                    "system:aboutheader" : "Tämä on 4f Studio -sovellus.",
                    "system:abouttext" : "Jos haluat lisää tietoa, käy <span class=\"fakelink\" data-fakeurl=\"studiourl\">verkkosivuilla</span>.",
                    "system:aboutcredits" : "Käytetty avoin lähdekoodi: <span class=\"fakelink\" data-fakeurl=\"librarycredits\">kirjastot</span>, <span class=\"fakelink\" data-fakeurl=\"nwjscredits\">NW.js</span>.",
                    "system:demowelcome" : "Tervetuloa",
                    "system:demowelcometext" : "Tämä on demoversio 4f Studio -sovelluksesta, joka antaa sinulle mahdollisuuden tutustua muutamaan interaktiiviseen tekstikirjaan, sekä luoda omia sähköisiä vihkoja eri työkaluja käyttäen. Valitse haluamasi kieli alta – voit myös vaihtaa kieltä sovelluksen asetuksista. ",
                    "system:copy":"Kopioi",
                    "system:cut":"Leikkaa",
                    "system:paste":"Liitä",
                    "bookshelf":"Kirjahylly",
                    "notebooks":"Vihkot",
                    "courses":"Kurssit",
                    "system:remove_element_confirm":"Haluatko varmasti poistaa sisällön?",
                    "system:gettingupdates":"Haetaan päivityksiä järjestelmään...",
                    "system:cancel":"peruuta",
                    "system:updatingsystem":"Järjestelmää päivitetään",
                    "system:processingdata":"Prosessoi dataa",
                    "system:working":"Sovellus on käynnissä ... Odota hetki.",
                    "system:continue":"Jatka",
                    "system:goback":"Takaisin",
                    "system:ok":"OK",
                    "system:updatecanceled":"Päivitys peruutettu",
                    "system:servererror_updates":"Päivitysten saamisessa tapahtui virhe",
                    "system:sending":"Lähettää...",
                    "system:redoupdates":"Päivitä uudelleen",
                    "system:name": "Nimi",
                    "system:username":"Käyttäjätunnus",
                    "system:password":"Salasana",
                    "system:language": "Kieli",
                    "system:themes": "Teemat",
                    "system:default": "Oletus",
                    "system:schools": "Koulut",
                    "system:subscription_expiration_time": "Tilaus vanhenee",
                    "system:subscription_nolimit": "Ei aikarajaa",
                    "system:checking_remaining_quota": "Tarkistusten määrä",
                    "system:checks": "tarkistusta",
                    "system:expires": "päättyy",
                    "system:days": "päivää",
                    "system:subscription_expires_soon": "Tilauksesi päättyy kohta.",
                    "system:checking_quota_low": "Tarkistusten määrä vähissä.",
                    "system:checking_quota_expiring": "Tarkistuksesi vanhenevat kohta.",
                    "system:logininfo":"Kirjaudu sisään",
                    "system:verificationinfo":"Sähköpostin vahvistus",
                    "system:registerinfo":"Rekisteröidy uudeksi käyttäjäksi",
                    "system:register":"Rekisteröidy",
                    "system:eulaagreement":"Loppukäyttäjän lisenssisopimus",
                    "system:agree":"Hyväksyn",
                    "system:disagree":"En hyväksy",
                    "system:explain_eula":"Jotta voit käyttää sovellusta sinun pitää hyväksyä järjestelmän loppukäyttäjän lisenssisopimus.",
                    "system:buyserviceTitle":"Osta käyttöaikaa",
                    "system:buyservice":"Osta käyttöaikaa",
                    "system:buychecks": "Osta tarkistuksia",
                    "system:6month_subscription": "6 kuukautta",
                    "system:12month_subscription": "12 kuukautta",
                    "system:buyservicetext":"<p>Jotta sovellusta voi käyttää, sinun on ostettava palvelinkäyttöaikaa. Ostoksen voi tehdä alla olevan linkin kautta.</p><p>Kun sinulla on käyttöaikaa voit aloittaa sovelluksen käytön.</p>",
                    "system:buyServiceTime":"Osta käyttöaikaa verkkokaupasta",
                    "system:refresh_system":"Käynnistä sovellus uudelleen",
                    "system:ready":"Valmis",
                    "system:buying_done": "Maksettu",
                    "system:continue_without_service": "Jatka ilman",
                    "system:service_bought": "Ostettu",
                    "system:welcome": "Tervetuloa!",
                    "system:welcome-instructions": "<p>Sovellus on nyt käyttövalmis.</p><p>Tervetuloa!</p>",
                    "system:activationneeded": "<p>Olemme lähettäneet vahvistusviestin sähköpostiisi.</p><p>Aktivoi tunnuksesi klikkaamalla viestissä olevaa aktivointilinkkiä.</p><p>Palaa sen jälkeen tänne viimeistelemään ohjelman käyttöönotto.</p>",
                    "error:SERVICE_EXPIRED":"<p>Palvelimen käyttöaikasi on loppunut. Voit jatkaa sovelluksen käyttöä ilman palvelua, mutta osa toiminnallisuuksista ei toimi ilman sitä.</p><p>Voit uusia tilauksen verkkokaupassa.</p>",
                    "system:serviceExpired":"<p>Palvelimen käyttöaikasi on loppunut</p>",
                    "error:CONNECTION_FAILED":"<p>Palvelinyhteydessä on jotain vikaa</p>",
                    "error:DATAPARSING_ERROR":"<p>Palvelimen vastauksessa on jotain vikaa</p>",
                    "error:WRONG_CREDENTIALS":"<p>Väärä käyttäjätunnus tai salasana</p>",
                    "error:USER_NOT_ACTIVATED":"<p>Et ole vielä aktivoinut tunnustasi. Itsesi aktivoimiseksi sinun tulee klikata aktivointilinkkiä, jonka löydän järjestelmän sinulle lähettämästä sähköpostista.</p>"
                    }
            }
        );
        this.nw_gui = require('nw.gui');
        this.mainWindow = this.nw_gui.Window.get();
        this.mainWindow.on('close',function(){
            console.log('tutwin', this.tutorialWindow);
            if (systemSelf.tutorialWindow) {
                systemSelf.tutorialWindow.close();
                systemSelf.tutorialWindow = false;
            };
            systemSelf.place.trigger('closeallwindows',{action:"exit"});
        });
        //handler for windows that is open
        this.winHandler = new windowHandler({place:this.place,mainWindow:this.mainWindow});

        //Set demomode
        this.inDemoMode = false;
        this.menuInDemo =['general','about'];
        
        //Set theme in use
        this.setTheme();
        //Information if servicetime expired error is shown
        this.promptServiceExpiredError = true;
        //Server connection
        this.serverIsConnected = true;
        //Start initialisation of system
        setTimeout(function() { systemSelf.initSystem() }, 0); // Allow ping response to be handled immitideately when it comes.
        
        this.__triggerf = function(eventType, eventObject) {
            if ( // eventObject is an object with a target (to) and data (data).
                typeof(eventObject) === 'object' &&
                typeof(eventObject['to'] !== 'undefined') &&
                typeof(eventObject['data']) !== 'undefined'
            ) {
                var target = eventObject.to;
                var data = eventObject.data;
                
                // TODO check that target exists
                // TODO if target exists, trigger event with eventType and data on it.
            }
            /* else throw('Malformed event object'); // This should be handled on dev (= not run)level */
            systemSelf.place.trigger(eventType, eventObject);
        }
    }
        
    /******
     * Trigger event
     ******/
    System.prototype.triggerEvent = function(eventname,data,target,eventtype,plaindata) {
        //console.log('triggerEvent',eventname,data,target,eventtype);
        if(typeof(target) ==="undefined"){
            this.__triggerf(eventname,data);
        }else{
            if(eventtype && eventtype ==="jQuery"){
                target.ownerDocument.defaultView.$(target)
                    .trigger(
                        eventname,
                        (typeof(plaindata) !=="undefined" && plaindata?data:{detail:data})
                    );
            }else{
                var callbackEvent = new CustomEvent(eventname,{detail:data});
                target.dispatchEvent(callbackEvent);
            }
        }
    }
    /**
     * Get the webshoplink
     * @param {String} [product]   An optional parameter for the product
     */
    System.prototype.getWebshopLink = function(product){
        var webshopLink = this.webshopLink;
        if (product) {
            var library = this.config.system.connection.webshopbubble;
            var lang = this.config.general.uilang;
            var productid = {
                "virum": {
                    "en": {
                        "6months": "327",
                        "12months": "1431",
                        "100checks": "1864",
                        "250checks": "1787"
                    },
                    "fi": {
                        "6months": "328",
                        "12months": "1432",
                        "100checks": "1865",
                        "250checks": "1788"
                    },
                    "sv": {
                        "6months": "329",
                        "12months": "1433",
                        "100checks": "1866",
                        "250checks": "1789"
                    }
                },
                "4ferries": {
                    "en": {
                        "6months": "817",
                        "12months": "1426",
                        "100checks": "1867",
                        "250checks": "1784"
                    },
                    "fi": {
                        "6months": "826",
                        "12months": "1429",
                        "100checks": "1868",
                        "250checks": "1785"
                    },
                    "sv": {
                        "6months": "827",
                        "12months": "1430",
                        "100checks": "1869",
                        "250checks": "1786"
                    }
                }
            }[library][lang][product];
            var checkout = {
                en: 'checkout',
                fi: 'kassalle',
                sv: 'till-kassan'
            }[lang] || 'checkout';
            var username = this.config.user.username;
            var email = this.config.user.email;
            webshopLink = `https://fourferries.com/webshop/${lang}/${checkout}/?add-to-cart=${productid}&target_user=${username}&target_user_email=${encodeURIComponent(email)}`;
        }
        return webshopLink;
    }
    /******
     * get stored contentinfo
     ******/
    System.prototype.getContentinfo = function(type,id) {
        if(this.config.content[type] && this.config.content[type][id]){
            return this.config.content[type][id];
        }
        else{
            return {};
        }
       
    }
        
    /******
     * set new or modified contentinfo
     ******/
    System.prototype.setContentinfo = function(type,id,data) {
        if(typeof(this.config.content[type]) === "undefined"){
            this.config.content[type]={};
        }
        this.config.content[type][id] = data;
        return true;
       
    }
        
    /******
     * Temporary function while dataformat is not fixed and developing all the time
     ******/
    System.prototype.convertcontenttype = function(type,key) {
        var converter = {};
        converter.getcontentinfo={
            'notebook':'own_notes',
            'notebooks':'own_notes'
        };
        if(typeof(converter[type]) !=="undefined" && typeof(converter[type][key]) !=="undefined" ){
            return converter[type][key];
        }
        return key;
        
    }
    /******
     * System eventhandlers
     ******/
    System.prototype.eventHandlers = function(place) {
        var systemSelf = this;
        if(typeof(place) ==="undefined") place = this.place;
        place.off('windowsreadyforexit').on('windowsreadyforexit', function(e, data) {
            systemSelf.mainWindow.close(true);
        });
        
        place.off('SERVICE_EXPIRED_error').on('SERVICE_EXPIRED_error', function(e) {
            systemSelf.serverIsConnected = false;
            systemSelf.informServiceExpired();
        });
        place.off('EULA_NOT_ACCEPTED_error').on('EULA_NOT_ACCEPTED_error', function(e) {
            systemSelf.askForEULAaccept();
        });
        place.off('NO_SERVICETIME_error').on('NO_SERVICETIME_error', function(e) {
            systemSelf.sendToBuyServicetime();
        });
        place.off('startPlugin.system').on('startPlugin.system', function(e, data) {
            var newWindow = systemSelf.openPluginInNewWindow(data.plugins, data.menu, data.parameters);
        });
        place.off('startTutorial.system').on('startTutorial.system', function(e, data) {
            if (!systemSelf.tutorialWindow) {
                var newWindow = systemSelf.openTutorialInNewWindow(data.plugins, data.menu);
            } else {
                systemSelf.tutorialWindow.focus();
            };
        });
        place.off('closetutorial').on('closetutorial', function(e, data) {
            if (systemSelf.tutorialWindow) {
                systemSelf.tutorialWindow = false;
            };
        });
        place.off('closeallwindows').on('closeallwindows', function(e, data) {
            if (systemSelf.tutorialWindow) {
                systemSelf.tutorialWindow.close();
                systemSelf.tutorialWindow = false;
            };
        });
        place.off('getAvailableContent.system').on('getAvailableContent.system', function(e,data) {
            //TODO:
            //make all content information available in  systemSelf.config.content
            if(typeof(systemSelf.config.content[data.path]) !=="undefined" ){
                var contentList = systemSelf.config.content[data.path];
            }else{
                // TODO: check if contentlist can be readed for filesystem
                // var contentList = systemSelf.fileSystem.getAvailableContent(data.path,data.type);
                var contentList = {};
            }
            jQuery(e.target).trigger(data.event,{"contentList": contentList, subjects: systemSelf.config.library && systemSelf.config.library.subjects || []});
        });
        /*This call return now always viewcount of 0
        * TODO: fix so that this isn't needed
        */
        place.off('getAvailableViews.system').on('getAvailableViews.system', function(e,data) {
            // var viewAreaCount = systemSelf.appView.find(".appview").length; NO view in version 0.2
            var viewAreaCount =0;
            jQuery(e.target).trigger(data.event,{views:viewAreaCount});
        });
        place.off('newContentinfo.system').on('newContentinfo.system', function(e,newContentinfo_data) {
            var localdata = false;
            //TODO: make more generic!
            if(newContentinfo_data.includelocal) {
                //TODO: localdata is more than id/filename
                localdata = {
                    "filename": systemSelf.fileSystem.getNewContext(systemSelf.config.user.username, newContentinfo_data.contenttype),
                    "username": systemSelf.config.user.username,
                    "firstname" :systemSelf.config.user.firstname,
                    "lastname": systemSelf.config.user.lastname,
                    "uilang": systemSelf.config.general.uilang,
                    "schools": systemSelf.config.user.schools || [],
                    "availableschools": systemSelf.config.library && systemSelf.config.library.schools || [],
                    "subjects": systemSelf.config.library && systemSelf.config.library.subjects || []
                };
                if(newContentinfo_data.includeavailableaddcontexts){
                    localdata['availableaddcontexts'] = systemSelf.getAvailableaddcontexts(newContentinfo_data.includeavailableaddcontexts);
                }
            }
            if(newContentinfo_data.includeserverdata){
                var contentinfodata = {"callback":{"target":e.target,"event":newContentinfo_data.event,"callbacktype":newContentinfo_data.callbacktype},"localdata":localdata,"contenttype":newContentinfo_data.contenttype,"servercontenttype":newContentinfo_data.servercontenttype};
                systemSelf.getServerContent(contentinfodata);
            }else{
                if(newContentinfo_data.callbacktype ==="jQuery"){
                    var dataToSend = {"localdata":localdata};
                    console.log(systemSelf.serverIsConnected);
                    if(!systemSelf.serverIsConnected){
                        dataToSend['errortype']=13;
                        dataToSend['localizableerror']="SERVICE_EXPIRED";
                    }
                    jQuery(e.target).trigger(newContentinfo_data.event,dataToSend);
                }else{
                    //TODO:pure javascript-event
                }
            }
        });

        place.off('importContent.system').on('importContent.system', function(e,data) {
            var updateid = [];
            var updatetype = data.updatetype;
            var callbackEvent = data.event;
            var callbackTarget = e.target;
            systemSelf.importContentCount = data.content.length;
            
            for(var i=0;i<data.content.length;i++){
                var content_data = JSON.parse(data.content[i].data);
                var contentid = content_data.contentid || content_data.id || content_data.contextid;
                updateid.push(contentid);
            }
            place.off('updateafterImportContent').on('updateafterImportContent',function(){
                place.trigger('importContentUpdates.system',{
                    "updatelist":[
                        {
                            "updateid": updateid,            //old implementation
                            "updatetype": updatetype,   //old implementation
                            "contextid": updateid,           //new implementation
                            "contexttype": updatetype,  //new implementation
                            "lastupdate": "0"
                        }
                    ],
                    "callback":{
                        "callbackEvent": callbackEvent,
                        "callbackTarget": callbackTarget,
                        "callbackType": "jQuery"
                    }
                });
                place.off('updateafterImportContent');
            });
            place.off('server-error').on('server-error',function(e,data){
                systemSelf.triggerEvent(callbackEvent,data,callbackTarget,"jQuery",true); 
                place.off('server-error');
            });
            
            for(var i=0;i<data.content.length;i++){
                var writedata = {"one_data" : JSON.parse(data.content[i].data), "one_context" : data.content[i],"type":data.type,"filetype":data.filetype};
                if(data.content[i].user_registered){
                    place.trigger('getStartdata.system',{"writedata":writedata});
                }else{
                    place.trigger('registercontext.system',{"writedata":writedata});
                }
                // place.trigger('writeimportContent.system',);
            }
        });

        place.off('getStartdata.system').on('getStartdata.system', function(e,data) {
            var registerData = data;
            registerData.contextid = data.writedata.one_context.contextid;
            registerData.contexttype = data.writedata.one_context.contexttype;
            registerData.returnTarget = jQuery(systemSelf.place)[0];
            registerData.callbacktype = 'jQuery';
            registerData.callbackevent = 'writeimportContent.system';
            systemSelf.getStartdata(registerData);
        });
        
        place.off('registercontext.system').on('registercontext.system', function(e,data) {
            var registerData = data;
            registerData.contextid = data.writedata.one_context.contextid;
            registerData.contexttype = data.writedata.one_context.contexttype;
            registerData.contextkey = data.writedata.one_context.contextkey;
            registerData.returnTarget = jQuery(systemSelf.place)[0];
            registerData.callbacktype = 'jQuery';
            registerData.callbackevent = 'writeimportContent.system';
            systemSelf.registerContentgroup(registerData);
        });

        place.off('writeimportContent.system').on('writeimportContent.system', function(e,data) {
            var newcontent = data.writedata.one_data.createdata;
            if(typeof(newcontent) === "undefined"){
                newcontent = {
                    "contentdata":{},
                    "savetype": "objtofiles",
                    "contenttype": data.writedata.one_context.contexttype,
                    "contextid": data.writedata.one_context.contextid
                }
            }
            if(typeof(data.startdata) !== "undefined"){
                for(var i=0;i<data.startdata.length;i++){
                    try{
                        var oneStartdata = JSON.parse(data.startdata[i].data);
                        if(newcontent['contentdata'][oneStartdata.key.replace(/\.json$/,"")]){
                            jQuery.extend(newcontent['contentdata'][oneStartdata.key.replace(/\.json$/,"")],(typeof(oneStartdata['value']) === "string"?JSON.parse(oneStartdata['value']):oneStartdata['value']));
                        }else{
                            newcontent['contentdata'][oneStartdata.key.replace(/\.json$/,"")] = (typeof(oneStartdata['value']) === "string"?JSON.parse(oneStartdata['value']):oneStartdata['value']);
                        }
                        
                    }catch(err){
                        console.log("Materialdata error",err);
                    }
                }
            }
            systemSelf.importContentCount --;
            place.trigger('createNewContent.system',{
                contexttype:data.writedata.one_context.contexttype,
                contextid:data.writedata.one_context.contextid,
                type:data.writedata.type,
                newcontent:newcontent,
                filename:data.writedata.one_data.filename,
                filetype:data.writedata.filetype,
                nottoserver:true,
                info:data.writedata.one_data
            });
            if(systemSelf.importContentCount === 0){
                place.trigger('updateafterImportContent');
            }

            
        });

        place.off('importContentUpdates.system').on('importContentUpdates.system', function(e,data) {
            systemSelf.getImportUpdates(data.updatelist, data.callback);
        });

        place.off('createNewContent.system').on('createNewContent.system', function(e,data) {
            var context_type = data.contexttype || data.newcontent.contexttype || "";
            var context_id = data.contextid || data.newcontent.contextid || "";
            if (!context_type || !context_id){
                //TODO: notification that something is wrong
                console.log("Error create content",data,context_type,context_id);
                return true;
            }
            
            data.originalTarget = data.originalTarget || e.target;
            if (data.newcontent && data.sendStartdata){
                //sendStartdata
                data.startdata = systemSelf.fileSystem.makeStartdata(data.newcontent);
                systemSelf.sendStartDataToServer(data);
            }else{
                //crete new contentfile
                var newcontent = systemSelf.fileSystem.createNewContent(data);
                
                //mark new file to system's content info
                if (typeof(systemSelf.config.content[context_type]) ==="undefined")systemSelf.config.content[context_type] = {};
                //TODO: pick properties that is needed dont't save all properties
                //Fix: remove createdata from contentinfo
                // var contentinfo = data.info;
                delete data.info.createdata;
                systemSelf.config.content[context_type][context_id]=data.info;
                
                //save system content settings
                systemSelf.place.trigger('savecontentsettings.system');
                //if new send to server
                if (typeof(data.nottoserver) ==="undefined")systemSelf.sendContentinfoToServer(data);
                
                //trigger event if needed
                //if(typeof(data.event) ==="string")jQuery(data.originalTarget?data.originalTarget:e.target).trigger(data.event,{data:newcontent});
            }
        });
        
        place.off("systemrequest.system").on("systemrequest.system",function(e,data){
            systemSelf.systemRequest(e,data);}
        );
        
        place.off('registerContentpath.system').on('registerContentpath.system', function(e, data) {
            if(typeof(systemSelf.config.content[data.type])==="undefined"){
                systemSelf.config.content[data.type]={};
                systemSelf.place.trigger('savecontentsettings.system');
            }
            systemSelf.fileSystem.addContentPath(data);
        });
        place.off('appendTo.system').on('appendTo.system', function(e, data) {
            systemSelf.appendToAreas(data);
        });
        place.off('notify.system').on('notify.system', function(e,data) {
            try{
                systemSelf.notification(data.msg,data.type);
            }catch(error){
                console.log("notificationError");
                console.log(error);
                console.log(e);
                console.log(data);
            }
        });
        place.off('checkUpdates.system').on('checkUpdates.system', function(e) {
            systemSelf.notification("Updating system");
            systemSelf.openDialog('getupdates');
        });
        place.off('startsystem.system').on('startsystem.system', function(e) {
            systemSelf.notification("Start system");
            systemSelf.started = true;
            systemSelf.state = "started";
            systemSelf.main();
        });
        place.off('initialized.system').on('initialized.system', function(e) {
            systemSelf.notification("Loading applications");
            systemSelf.loadApplications();
        });
        place.off('applicationsReady.system').on('applicationsReady.system', function(e,data) {
            /*
            if(!systemSelf.started){
                systemSelf.place.trigger('startsystem.system');
                return true;
            }*/
            // For DEMO/"OFFLINE" use if appkey if empty now it meens that on updates or serverconnection wanted
            if(!systemSelf.config.user.applicationkey){
                systemSelf.place.trigger('startsystem.system');
            }else{
                systemSelf.place.trigger('checkUpdates.system');
            }
        });
        
        place.off('saveusersettings.system').on('saveusersettings.system', function(e, data) {
            function __callback() {
                // No action required. Function is here as a future placeholder (user notifications etc).
            }
            systemSelf.fileSystem.saveUserOptions(systemSelf.config.user);
            if(typeof(data) ==="object" && typeof(data.reload) !=="undefined" && data.reload){
                place.trigger('reloadSystem.system');
            }
        });
        
        place.off('savelibrarysettings.system').on('savelibrarysettings.system', function(e, data) {
            function __callback() {
                // No action required. Function is here as a future placeholder (user notifications etc).
            };
            systemSelf.fileSystem.saveLibraryOptions(systemSelf.config.library);
            if (typeof(data) === "object" && typeof(data.reload) !== "undefined" && data.reload){
                place.trigger('reloadSystem.system');
            };
        });
        
        place.off('savesettings.system').on('savesettings.system', function(e, data) {
            function __callback() {
                // No action required. Function is here as a future placeholder (user notifications etc).
            }
            systemSelf.fileSystem.saveSystemOptions(systemSelf.config.system);
            // systemSelf.saveSystemSettings(__callback, configFiles);
            
            if(typeof(data) ==="object" && typeof(data.reload) !=="undefined" && data.reload){
                place.trigger('reloadSystem.system');
            }
        });
        place.off('savegeneralsettings.system').on('savegeneralsettings.system', function(e, data) {
            function __callback() {
                // No action required. Function is here as a future placeholder (user notifications etc).
            }
            systemSelf.fileSystem.saveGeneralOptions(systemSelf.config.general);
            if(typeof(data) ==="object" && typeof(data.reload) !=="undefined" && data.reload){
                place.trigger('reloadSystem.system');
            }
        });
        place.off('savecontentsettings.system').on('savecontentsettings.system', function(e, data) {
            function __callback() {
                // No action required. Function is here as a future placeholder (user notifications etc).
            }
            systemSelf.fileSystem.saveContentOptions(systemSelf.config.content);
            if(typeof(data) ==="object" && typeof(data.reload) !=="undefined" && data.reload){
                place.trigger('reloadSystem.system');
            }
        });
        place.off('saveupdatesettings.system').on('saveupdatesettings.system', function(e, data) {
            function __callback() {
                // No action required. Function is here as a future placeholder (user notifications etc).
            }
            systemSelf.fileSystem.saveUpdateInfo(systemSelf.config.updatehadling);
        });
        place.off('saveAllsettings.system').on('saveAllsettings.system', function(e, data) {
            function __callback() {
                // No action required. Function is here as a future placeholder (user notifications etc).
            }
            place.trigger('saveusersettings.system');
            place.trigger('savegeneralsettings.system');
            place.trigger('savesettings.system');
            place.trigger('savecontentsettings.system');
            place.trigger('saveupdatesettings.system');
            if(typeof(data) ==="object" && typeof(data.reload) !=="undefined" && data.reload){
                place.trigger('reloadSystem.system');
            }
        });
        
        // Notification click event handlers
        place.on('infonotifhandler warningnotifhandler quickmsgack trafficnotifclick', function(event, data) {
            event.stopPropagation();
            data = data && data.data || {};
            var evname = data.event || '';
            var evdata = data.data || {};
            systemSelf.place.trigger(evname, [evdata])
        });
        
        // Open settings dialogs
        place.on('usersettingsopen', function(event) {
            event.stopPropagation();
            systemSelf.openDialog('usersettings');
        }).on('generalsettingsopen', function(event) {
            event.stopPropagation();
            systemSelf.openDialog('general');
        });
        
        //Open and close settigns menu
        place.on( "click", "span.settingsMenu", function() {
              jQuery( this ).toggleClass('showSettings');
        });
        //Close settigns menu and do settings
        place.on( "click", "span.settingsMenu li", function() {
            systemSelf.openDialog(jQuery(this).attr('settingstype'));
        });
        //Check needed plugins
        place.off('neededPlugins.system').on('neededPlugins.system', function(e,data) {
            var missingPlugins = systemSelf.fileSystem.checkPlugins(data.pluginlist);
            jQuery(e.target).trigger(data.event,{pluginsAvailable : !missingPlugins.length,missing:missingPlugins});
        });
        //reload application functionality
        place.off('reloadSystem.system').on('reloadSystem.system', function(e,data) {
            systemSelf.state = "reload";
            systemSelf.forceCloseDialog();
            systemSelf.emptyScreen();
            systemSelf.initSystem()
        });
        //logolink to ViRum webpage
        place.on('click','#applicationFooter span.logoImage,#applicationHeader span.logoImage', function(e,data) {
            //TODO:get url from some settings
            systemSelf.openInExternalBrowser(systemSelf.config.system.connection.homeURL || "http://virum.fi");
        });
        // Handle "fakelink" with external browser.
        place.on('click','.fakelink[data-fakeurl]', function(e,data) {
            var fakeurl = $(this).attr('data-fakeurl');
            var uilang = systemSelf.config.general.uilang;
            var url = systemSelf.urls[fakeurl] && systemSelf.urls[fakeurl][uilang];
            if (url) {
                systemSelf.openInExternalBrowser(url);
            };
        });
        //"click trashcan"
        place.on('click','.applicationControlbutton.removeState span.removeIcon', function(e,data) {
            jQuery(this).parent().toggleClass('active');
            jQuery('#applicationControl').toggleClass('removeActive');
            jQuery('#applicationControl .oneApp').toggleClass('removeActive');
        });
        //removeFrom sent
        place.off('removesentinfo').on('removesentinfo',function(e,data){
            var index = systemSelf.config.updatehadling[data.type].sent.indexOf(data.item);
            if(index > -1){
                systemSelf.config.updatehadling[data.type].sent.splice(index,1);
            };
        });
        //redraw application
        place.off('redrawSystem.system').on('redrawSystem.system', function(e,data) {
            systemSelf.state = "redraw";
            systemSelf.emptyScreen();
            systemSelf.initSystem();
        });
        //Gives tranlation
        place.off('translateThis.system').on('translateThis.system', function(e,data) {
            jQuery(e.target).trigger(data.event,{translation : systemSelf.localizer.localizeText(data.term,data.lang)});
        });
        //mark that context is open in application
        place.off('contextopen').on('contextopen', function(e,data) {
            jQuery('[contexttype="'+data.contexttype+'"][contextid="'+data.contextid+'"]').addClass('contextOpen');
        });
        //remove information that context is open
        place.off('contextclosed').on('contextclosed', function(e,data) {
            jQuery('[contexttype="'+data.contexttype+'"][contextid="'+data.contextid+'"]').removeClass('contextOpen');
        });
        //File-save event from filesystem
        document.body.addEventListener("file-saved",function(e){
            //TODO 
            //console.log("File-saved",e.detail);
        });
        //refresh_options
        document.body.addEventListener("refresh_options",function(e){
            try{
                systemSelf.config[e.detail.refresh]=e.detail.data;
            }catch(err){
                console.log("refresh-error",err);
            }
        });

    }
    
    /******
     * set userdata from data
     ******/
    System.prototype.getUserData = function(level) {
        var user = jQuery.extend(true,{},this.config.user);
        if(typeof(level) ==="undefined"){
            return user;
        }
        
    }
    
    /******
     * set userdata from data
     ******/
    System.prototype.setUserData = function(userdata) {
        var user = jQuery.extend(true,{},this.config.user);
        if (userdata.username) user.username = userdata.username.toLowerCase();
        if (userdata.applicationkey) user.applicationkey = userdata.applicationkey;
        if (userdata.email) user.email = userdata.email;
        if (userdata.firstname) user.firstname = userdata.firstname;
        if (userdata.lastname) user.lastname = userdata.lastname;
        if (userdata.defaultlang) user.defaultlang = userdata.defaultlang;
        if (userdata.defaultroles) user.defaultroles = userdata.defaultroles;
        if (userdata.dontPromptUser) user.dontPromptUser = userdata.dontPromptUser;
        if (userdata.dontShowFirstrun) user.dontShowFirstrun = userdata.dontShowFirstrun;
        this.config.user = user;
        return user;
    }
    
    /******
    * update config.contentInfo
    ******/
    System.prototype.updateContentinfo= function(data,updatetype){
        //TODO: define data
        switch(updatetype){
            case 'remove':
                try{
                    delete this.config.content[data.contexttype][data.contextid];
                    this.place.trigger('savecontentsettings.system');
                }catch(e){
                    console.log("update contentinfo error:",e,data,updatetype);
                }
                try{
                    var updatehandlingtype = data.contenttype;
                    var updatehandlinglist = this.config.updatehadling.contentupdates.sent;
                    for(var i=0;i<updatehandlinglist.length;i++){
                        var rex = new RegExp('^'+data.contenttype+data.filename)
                        if(updatehandlinglist[i].match(rex)){
                            updatehandlinglist.splice(i,1);
                        }
                    }
                    this.config.updatehadling.contentupdates.sent = updatehandlinglist;
                }catch(e){
                    console.log("update updatehadling.contentupdates.sent error:",e);
                }
                try{
                    //delete lastupdateinformation
                    delete this.config.system.lastupdates[data.contexttype][data.contextid];
                }catch(err){
                    console.log('Error removing lastupdates',err,data);
                }
                this.place.trigger('savesettings.system');
            break;
            default:
            break;
        }
        
    }
    /******
     * usedTheme
     ******/
    System.prototype.usedTheme = function() {
        return jQuery('body').attr('data-apptheme');
    }
    /******
     * *Set theme
     ******/
    System.prototype.setTheme = function(themeobject) {
        var reload = false;
        //if themename not give use one in the config
        if(typeof(themeobject) !=="undefined"){
            if(themeobject.template !== jQuery('body').attr('data-appthemetemplate'))reload = true;
            this.config.general.theme = themeobject;
        }
        
        if(typeof(this.config.uithemetemplates['template_'+this.config.general.theme.template]) !== "undefined"){
            this.config.themetemplate = this.config.uithemetemplates['template_'+this.config.general.theme.template];
        }else{
            this.config.themetemplate = this.config.uithemetemplates['defaulttemplate'];
        }
        jQuery('body').attr('data-apptheme',this.config.general.theme.name).attr('data-appthemetemplate',this.config.general.theme.template);
        if(reload) this.place.trigger('redrawSystem');
    }
    /******
     * *Get themes
     ******/
    System.prototype.getThemes = function() {
        // Get all link-tags with themes
        var themestyles = $('head link[type="text/css"][href*="systemtheme-"]');
        // Extract the theme names from href-attributes to an array.
        return themestyles.map(function(i, style){
            var tname = $(style).attr('href').replace(/^.*systemtheme-([^.]*)\.css$/, '$1');
            var themeSplit = tname.split('_');
            return {name:themeSplit[0],template:themeSplit[1]};
        }).get();
    }
    /******
     * Check new contentlist
     ******/
    System.prototype.contentExist = function(contenttype,contentlist) {
        var exist = [],notexist=[];
        try{
            for(var i=0;i<contentlist.length;i++){
                var id= contentlist[i].contextid || contentlist[i].contentid || contentlist[i].updateid;
                if(this.config.content[contenttype] && typeof(this.config.content[contenttype][id]) !=="undefined"){
                    exist.push(contentlist[i]);

                }else{
                    notexist.push(contentlist[i]);
                }
            }
        }
        catch(err){
            console.log('contentExist_error:',err);
        }
        return {exist:exist,notexist:notexist};
    }
    /******
     * Make system notification
     ******/
    System.prototype.notification = function(msg,msgtype) {
        /*******
        * notification types
        * - notification
        * - warning
        * - error
        *******/
        if(typeof(msgtype)==="undefined"){
            msgtype = "notification";
        }
        if(this.config.system.archiveMessages){
            var currentMsgText = this.notificationArea.find(".currentMsg").text();
            var currentMsgType = this.notificationArea.find(".currentMsg").attr("type");
            this.notificationArea.find(".msgArchive").append("<span type=\""+currentMsgType+"\">"+currentMsgText+"</span>");
        }
        this.notificationArea.find(".currentMsg").attr("type",msgtype).text(msg);
        /*
        TODO: append flag if notification should be shown as user notification also
        */
    }
    
    /******
     * User notification
     * @param {Object|String} message    The message as an object or a string. (String is treated as "quick" type message)
     * @param {String} message.id        The id of the message. The message can be "denotified" by using this id.
     * @param {String} message.nclass    The class of the notification
     * @param {String} message.message   The message string
     * @param {String} message.icon      Optional icon for this message as svg. If not given, the default icon of 'nclass' is used instead.
     * @param {String} message.state     The state for "trafficlight" type notifications
     * @param {Number} message.ttl       Time to live of the message in milliseconds. If given, the message will "selfdistruct" after this time.
     * @param {Object} message.data      Optional data object that is triggered together with the event of 'nclass'.
     * @param {Boolean} message.localizable  If true, the message.message should be localized before showing.
     ******/
    System.prototype.notify = function(message) {
        /*TODO:
            -make non-modal "dialog" for notifications
            -messages send as "messageskey"
                -message lokalization with messagekey
            -types
            -action after?
        */
        if (typeof(message) === 'string') {
            message = {
                nclass : 'quick',
                message: message,
            };
        };
        if (message.localizable) {
            message.message = this.localizer.localize(message.message);
        };
        this.notifarea.trigger('newnotification', message);
    };
    
    /**
     * Init the user notification system
     */
    System.prototype.initNotify = function() {
        var settings = {
            classes: [
                {
                    name: 'network',
                    label: 'Network',
                    type: 'trafficlight',
                    icon: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="30" height="30" viewBox="-5 -5 40 40" class="mini-icon mini-icon-cloudup"><path style="stroke: none;" d="M5 25 a4 4 0 1 1 2 -10 a6 6 0 0 1 12 0 a4 4 0 0 1 7 3 a3 3 0 0 1 0 7z m7 -2 l4 0 l0 -3 l2 0 l-4 -4 l-4 4 l2 0z" /></svg>',
                    event: 'networknotifclick',
                    level: 0
                },
                {
                    name: 'quick',
                    label: 'Quick messages',
                    type: 'quickmsg',
                    icon: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="30" height="30" viewBox="0 0 30 30" class="mini-icon mini-icon-information"><circle class="mini-icon-background" stroke="none" fill="none" cx="15" cy="15" r="15" /><path class="mini-icon-foreground" style="stroke: none;" d="M15 2 a13 13 0 0 1 0 26 a13 13 0 0 1 0 -26 m0 3 a10 10 0 0 0 0 20 a10 10 0 0 0 0 -20 m0 2 a2 2 0 0 1 0 4 a2 2 0 0 1 0 -4 m-2 7 a2 2 0 0 1 4 0 v7 a2 2 0 0 1 -4 0z"></path></svg>',
                    event: 'quickmsgack',
                    level: 0
                },
                {
                    name: 'information',
                    label: 'Information',
                    event: 'infonotifhandler',
                    level: 0,
                    icon: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="30" height="30" viewBox="0 0 30 30" class="mini-icon mini-icon-information"><circle class="mini-icon-background" stroke="none" fill="none" cx="15" cy="15" r="15" /><path class="mini-icon-foreground" style="stroke: none;" d="M15 2 a13 13 0 0 1 0 26 a13 13 0 0 1 0 -26 m0 3 a10 10 0 0 0 0 20 a10 10 0 0 0 0 -20 m0 2 a2 2 0 0 1 0 4 a2 2 0 0 1 0 -4 m-2 7 a2 2 0 0 1 4 0 v7 a2 2 0 0 1 -4 0z"></path></svg>'
                },
                {
                    name: 'warning',
                    label: 'Warning',
                    event: 'warningnotifhandler',
                    level: 0,
                    icon: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="25" height="25" viewBox="0 0 30 30" class="mini-icon mini-icon-warning"><path style="stroke: none;" fill="red" d="M15 2 l13 26 h-26z m-2 10 l1 10 h2 l1 -10z m1 12 v2 h2 v-2z"></path></svg>'
                }
            ],
            level: 3,
            align: 'right'
        };
        this.notifarea = this.place.find('#notificationbox');
        if ($.fn.vnotifier) {
            this.notifarea.vnotifier(settings);
        };
    };

    
    /******
     * openPluginInNewWindow
     ******/
    System.prototype.openPluginInNewWindow = function(pluginList, menu, contentParams) {
        var systemSelf = this;
        var gui= this['nw_gui'];
        if (window.navigator.platform.toUpperCase().indexOf('MAC') >= 0){
            var mb = new gui.Menu({type: "menubar"});
            mb.createMacBuiltin("Studio", {hideWindow: true});
            gui.Window.get().menu = mb;
        };
        gui.Window.open("data/empty.html", {/*nodejs:false,*/position: 'center', width: 1000, height: 800}, function(WindowObj) {
            var windowData = {"windowobject": WindowObj};
            //For test usage. TODO: get somekind of context for opened window type+_+id?
            if (contentParams) {
                if (contentParams.contentPath) {
                    windowData['context'] = contentParams.contentPath;
                } else if (contentParams.contexttype && contentParams.contextid) {
                    windowData['context'] = contentParams.contexttype + '_' + contentParams.contextid;
                    windowData['contexttype'] = contentParams.contexttype;
                    windowData['contextid'] = contentParams.contextid;
                } 
            }
            systemSelf.place.trigger('addwindow', windowData);
            WindowObj.on("document-end", function(){
                WindowObj.window.pluginParameters = pluginList;
                WindowObj.window.systemWid = WindowObj.id || WindowObj.frameId;
                var new_document = WindowObj.window.document;
                new_document.body.addEventListener("system.request", function(e, data) {systemSelf.systemRequest(e, data);});
                //TODO:check if jQuery and add jQuery eventhandler
                // Get all plugin js-files that need to be loaded.
                for (var i = 0; i < pluginList.length; i++) {
                    if (!systemSelf.pluginLoadlist || typeof(systemSelf.pluginLoadlist[pluginList[i].pluginName]) === "undefined"){
                        if (!systemSelf.pluginLoadlist) systemSelf.pluginLoadlist = {};
                        systemSelf.pluginLoadlist[pluginList[i].pluginName] = systemSelf.fileSystem.getPluginloadList(pluginList[i].pluginName);
                    };
                };
                var loadList = (pluginList.length ? jQuery.extend(true, {}, systemSelf.pluginLoadlist[pluginList[0].pluginName]) : {});
                // Add all js-files into the same object.
                for (var i = 1; i < pluginList.length; i++) {
                    for (var key in systemSelf.pluginLoadlist[pluginList[i].pluginName]) {
                        for (var j = 0; j < systemSelf.pluginLoadlist[pluginList[i].pluginName][key].length; j++) {
                            if (loadList[key].indexOf(systemSelf.pluginLoadlist[pluginList[i].pluginName][key][j]) === -1){
                                loadList[key].push(systemSelf.pluginLoadlist[pluginList[i].pluginName][key][j]);
                            }
                        }
                    }
                }
                //add available themeCSSfile references
                for (var i = 0; i < pluginList.length; i++) {
                    var currentPluginname = pluginList[i].pluginName;
                    if (currentPluginname ==="reader"){
                        currentPluginname = "notebook";
                    }
                    var themeCSSfiles = systemSelf.fileSystem.getPluginthemeFiles(currentPluginname);
                    for (var j = 0; j < themeCSSfiles.length; j++) {
                       themeCSSfiles[j] =currentPluginname+"-themes/"+themeCSSfiles[j];
                    }
                    loadList.csslist = loadList.csslist.concat(themeCSSfiles);
                }
                
                WindowObj.window.pluginload = new loader(loadList, pluginList, new_document, WindowObj.window);

                if (typeof(menu) !== "undefined" && menu.length > 0) {
                    // Window menu
                    if (typeof(mb) !== "undefined") {
                        var windowMenu = mb;
                        for (var i = 0; i < menu.length; i++) {
                            var oneMenu = new gui.Menu();
                            windowMenu.append(new gui.MenuItem({
                                label: menu[i].label || "Item"+i,
                                submenu: (menu[i].submenu?oneMenu:null),
                                click: function(){
                                    //TODO: do what needed
                                }
                            }));
                            for (var j = 0; j < menu[i].submenu.length; j++) {
                                var appendMenu = menu[i].submenu[j];
                                if (typeof(appendMenu.click) !== "function") {
                                    var clickAction =  (function(){
                                        var triggerEvent = menu[i].submenu[j]['click'];
                                        var returnfunction = function(){
                                            WindowObj.window.jQuery(WindowObj.window.document.getElementsByTagName("body")[0]).trigger(triggerEvent);
                                        }
                                        return returnfunction;
                                    })();
                                    appendMenu.click = clickAction;
                                }
                                oneMenu.append(new gui.MenuItem(appendMenu));
                            }
                        }
                    } else {
                        var windowMenu = new gui.Menu({type: 'menubar'});
                        for (var i = 0; i < menu.length; i++) {
                            var oneMenu = new gui.Menu();
                            windowMenu.append(new gui.MenuItem({
                                label: menu[i].label || "Item" + i,
                                submenu: (menu[i].submenu ? oneMenu : null),
                                click: function(){
                                    //TODO: do what needed
                                }
                            }));
                            for (var j = 0; j < menu[i].submenu.length; j++) {
                                var appendMenu = menu[i].submenu[j];
                                if (typeof(appendMenu.click) !== "function") {
                                    var clickAction =  (function(){
                                        var triggerEvent = menu[i].submenu[j]['click'];
                                        var returnfunction = function(){
                                            WindowObj.window.jQuery(WindowObj.window.document.getElementsByTagName("body")[0]).trigger(triggerEvent);
                                        }
                                        return returnfunction;
                                    })();
                                    appendMenu.click = clickAction;
                                }
                                oneMenu.append(new gui.MenuItem(appendMenu));
                            }
                        }
                    }
                    // Assign to window
                    WindowObj.menu = windowMenu;
                }       
                var newWindowGui = WindowObj.window.require('nw.gui');
                // Add cut/copy/paste menu to mouse right click contextmenu
                var ccp_menu = new newWindowGui.Menu({type:'contextmenu'});
                var p_menu = new newWindowGui.Menu({type:'contextmenu'});

                ccp_menu.append(new newWindowGui.MenuItem({label: systemSelf.localizer.localize('system:cut'),click: function() {WindowObj.window.document.execCommand("cut");}}));
                ccp_menu.append(new newWindowGui.MenuItem({label: systemSelf.localizer.localize('system:copy'),click: function() {WindowObj.window.document.execCommand("copy");}}));
                ccp_menu.append(new newWindowGui.MenuItem({label: systemSelf.localizer.localize('system:paste'),click: function() {var clipboard = gui.Clipboard.get(); WindowObj.window.document.execCommand("insertText", false, clipboard.get());}}));
                p_menu.append(new newWindowGui.MenuItem({label: systemSelf.localizer.localize('system:paste'),click: function() {var clipboard = gui.Clipboard.get(); WindowObj.window.document.execCommand("insertText", false, clipboard.get());}}));

                WindowObj.window.document.addEventListener("contextmenu", function(e) {
                    e.preventDefault();
                    if (WindowObj.window.getSelection().isCollapsed){
                        p_menu.popup(e.x, e.y);
                    } else {
                        ccp_menu.popup(e.x,e.y);
                    }
                });
                WindowObj.ccp_memu = ccp_menu;
                WindowObj.p_memu = p_menu;
                WindowObj.on('close', function(e) {
                    WindowObj.window.isClosing = true;
                    WindowObj.window.jQuery(WindowObj.window.document.getElementsByTagName("body")[0]).off('allcloseok').on("allcloseok", function(e, data) {
                        var windowData={"windowobject": WindowObj};
                        //For test usage. TODO: get somekindof context for opened window type+_+id?
                        if (contentParams) {
                            if (contentParams.contentPath) {
                                windowData['context']=contentParams.contentPath;
                            } else if (contentParams.contenttype && contentParams.contentid) {
                                windowData['context'] = contentParams.contenttype + '_' + contentParams.contentid;
                                windowData['contexttype'] = contentParams.contenttype;
                                windowData['contextid'] = contentParams.contentid;
                            } else if (contentParams.contexttype && contentParams.contextid) {
                                windowData['context'] = contentParams.contexttype + '_' + contentParams.contextid;
                                windowData['contexttype'] = contentParams.contexttype;
                                windowData['contextid'] = contentParams.contextid;
                            }
                        }
                        systemSelf.place.trigger('removewindow',windowData);
                        WindowObj.close(true);
                    });
                    WindowObj.window.jQuery(WindowObj.window.document.getElementsByTagName("body")[0]).trigger("closeALLApps");
                });
                WindowObj.removeAllListeners("document-end");
            })
        });
        return true;
    };
    
    /**
     * Open Tutorial in new Window
     */
    System.prototype.openTutorialInNewWindow = function(pluginList, menu) {
        var systemSelf = this;
        var gui= this['nw_gui'];
        if (window.navigator.platform.toUpperCase().indexOf('MAC') >= 0){
            var mb = new gui.Menu({type: "menubar"});
            mb.createMacBuiltin("Studio", {hideWindow: true});
            gui.Window.get().menu = mb;
        };
        var tutorialdata = this.getTutorialData();
        gui.Window.open("data/empty.html", {/*nodejs:false,*/position: 'center', width: 1000, height: 800}, function(WindowObj) {
            systemSelf.tutorialWindow = WindowObj;
            // When the window is open, prepare it for the tutorial.
            WindowObj.on("document-end", function(){
                //WindowObj.window.pluginParameters = pluginList;
                WindowObj.window.systemWid = WindowObj.id || WindowObj.frameId;
                var new_document = WindowObj.window.document;
                // Callback to send the data to the tutorial, when the window is ready.
                var __giveData = function(e) {
                    if (e.detail.type === 'getContentAsObject') {
                        // Do this only once
                        new_document.body.removeEventListener('system.request', __giveData);
                        // Send the tutorialdata to the notebook with 'notebookdataReady'.
                        var loadEvent = new CustomEvent('notebookdataReady', {detail: tutorialdata});
                        new_document.body.dispatchEvent(loadEvent);
                    };
                };
                // Listen for 'system.request' to know, when the window is ready to take the data.
                new_document.body.addEventListener("system.request", __giveData);
                // Find the js-files to load
                if (!systemSelf.pluginLoadlist || typeof(systemSelf.pluginLoadlist['notebook']) === "undefined"){
                    if (!systemSelf.pluginLoadlist) systemSelf.pluginLoadlist = {};
                    systemSelf.pluginLoadlist['notebook'] = systemSelf.fileSystem.getPluginloadList('notebook');
                };
                var loadList = JSON.parse(JSON.stringify(systemSelf.pluginLoadlist['notebook']));
                // Find the css-files to load
                var themeCSSfiles = systemSelf.fileSystem.getPluginthemeFiles('notebook');
                for (var j = 0; j < themeCSSfiles.length; j++) {
                   themeCSSfiles[j] = 'notebook-themes/' + themeCSSfiles[j];
                };
                loadList.csslist = loadList.csslist.concat(themeCSSfiles);
                // Load the files with loader.
                WindowObj.window.pluginload = new loader(loadList, pluginList, new_document, WindowObj.window);

                // Create menus
                if (typeof(menu) !== "undefined" && menu.length > 0) {
                    // Window menu
                    if (typeof(mb) !== "undefined") {
                        var windowMenu = mb;
                        for (var i = 0; i < menu.length; i++) {
                            var oneMenu = new gui.Menu();
                            windowMenu.append(new gui.MenuItem({
                                label: menu[i].label || "Item"+i,
                                submenu: (menu[i].submenu ? oneMenu : null),
                                click: function(){
                                    //TODO: do what needed
                                }
                            }));
                            for (var j = 0; j < menu[i].submenu.length; j++) {
                                var appendMenu = menu[i].submenu[j];
                                if (typeof(appendMenu.click) !== "function") {
                                    var clickAction =  (function(){
                                        var triggerEvent = menu[i].submenu[j]['click'];
                                        var returnfunction = function(){
                                            WindowObj.window.jQuery(WindowObj.window.document.getElementsByTagName("body")[0]).trigger(triggerEvent);
                                        }
                                        return returnfunction;
                                    })();
                                    appendMenu.click = clickAction;
                                }
                                oneMenu.append(new gui.MenuItem(appendMenu));
                            }
                        }
                    } else {
                        var windowMenu = new gui.Menu({type: 'menubar'});
                        for (var i = 0; i < menu.length; i++) {
                            var oneMenu = new gui.Menu();
                            windowMenu.append(new gui.MenuItem({
                                label: menu[i].label || "Item" + i,
                                submenu: (menu[i].submenu ? oneMenu : null),
                                click: function(){
                                    //TODO: do what needed
                                }
                            }));
                            for (var j = 0; j < menu[i].submenu.length; j++) {
                                var appendMenu = menu[i].submenu[j];
                                if (typeof(appendMenu.click) !== "function") {
                                    var clickAction =  (function(){
                                        var triggerEvent = menu[i].submenu[j]['click'];
                                        var returnfunction = function(){
                                            WindowObj.window.jQuery(WindowObj.window.document.getElementsByTagName("body")[0]).trigger(triggerEvent);
                                        }
                                        return returnfunction;
                                    })();
                                    appendMenu.click = clickAction;
                                }
                                oneMenu.append(new gui.MenuItem(appendMenu));
                            }
                        }
                    }
                    // Assign to window
                    WindowObj.menu = windowMenu;
                };
                var newWindowGui = WindowObj.window.require('nw.gui');
                // Add cut/copy/paste menu to mouse right click contextmenu
                var ccp_menu = new newWindowGui.Menu({type:'contextmenu'});
                var p_menu = new newWindowGui.Menu({type:'contextmenu'});
                
                ccp_menu.append(new newWindowGui.MenuItem({label: systemSelf.localizer.localize('system:cut'),click: function() {WindowObj.window.document.execCommand("cut");}}));
                ccp_menu.append(new newWindowGui.MenuItem({label: systemSelf.localizer.localize('system:copy'),click: function() {WindowObj.window.document.execCommand("copy");}}));
                ccp_menu.append(new newWindowGui.MenuItem({label: systemSelf.localizer.localize('system:paste'),click: function() {var clipboard = gui.Clipboard.get(); WindowObj.window.document.execCommand("insertText", false, clipboard.get());}}));
                p_menu.append(new newWindowGui.MenuItem({label: systemSelf.localizer.localize('system:paste'),click: function() {var clipboard = gui.Clipboard.get(); WindowObj.window.document.execCommand("insertText", false, clipboard.get());}}));
                
                WindowObj.window.document.addEventListener("contextmenu", function(e) {
                    e.preventDefault();
                    if (WindowObj.window.getSelection().isCollapsed){
                        p_menu.popup(e.x, e.y);
                    } else {
                        ccp_menu.popup(e.x,e.y);
                    }
                });
                WindowObj.ccp_memu = ccp_menu;
                WindowObj.p_memu = p_menu;
                // When the Tutorial is closed, inform the parent system.
                WindowObj.on('close', function(e) {
                    systemSelf.place.trigger('closetutorial');
                    WindowObj.close(true);
                });
                WindowObj.removeAllListeners("document-end");
            })
            //WindowObj.showDevTools();
        });
        return true;
    };
    
    /**
     * Get the data for the tutorial
     */
    System.prototype.getTutorialData = function() {
        var uilang = this.config.general.uilang;
        var data = {};
        data.fileasobject = this.fileSystem.readTutorialToObject(uilang);
        data.fileasobject.materialdata = {
            'notebook-4fnotes-tutorial': {
                type: 'book',
                name: 'notebook-4fnotes-tutorial',
                data: {
                    defaultlang: uilang,
                    langs: ['fi', 'sv', 'en']
                }
            }
        };
        data.contentinfo = {
            material: [
                {
                    type: 'notebook',
                    jq: 'notebookview',
                    id: 'notebook-4fnotes-tutorial'
                }
            ],
            apps: [],
            users: [
                {
                    username: '4fnotesuser',
                    realname: {
                        firstname: 'Notes',
                        lastname: 'User'
                    }
                }
            ],
            groups: [
                {
                    gid: 'noteusers',
                    description: 'käyttäjäryhmä',
                    tags: ['student'],
                    members: [
                        '4fnotesuser'
                    ]
                }
            ],
            rights: {
                "edit": {
                    "notebookcontent": [
                        {"whoid": "noteusers", "whotype": "group"}
                    ],
                    "message": [],
                    "hamessage": [],
                    "solution": [
                        {"whoid": "noteusers", "whotype": "group"}
                    ],
                    "review": [
                        {"whoid": "noteusers", "whotype": "group"}
                    ],
                    "booknote": [
                        {"whoid": "noteusers", "whotype": "group"}
                    ],
                    "marginnote": [
                        {"whoid": "noteusers", "whotype": "group"}
                    ]
                },
                "publish": {
                    "message": [
                    ],
                    "solution": [
                    ],
                    "review": [
                    ],
                    "notebookcontent": [
                    ]
                },
                "elementclasses": {
                    "general": [
                        {"whoid": "noteusers", "whotype": "group"}
                    ],
                    "math": [
                        {"whoid": "noteusers", "whotype": "group"}
                    ],
                    "media": [
                    ],
                    "programming": [
                        {"whoid": "noteusers", "whotype": "group"}
                    ],
                    "container": [
                        {"whoid": "noteusers", "whotype": "group"}
                    ],
                    "bookmarks": [
                        {"whoid": "noteusers", "whotype": "group"}
                    ],
                    "action": [
                    ],
                    "lists": [
                    ],
                    "assignments": [
                    ]
                }
            }
        };
        data.userinfo = {username: '4fnotesuser'};
        data.libraryinfo = this.config.library;
        data.generalsettings = this.config.general;
        data.containerId = 'plugin_0';
        data.contentId = 'notebook-4fnotes-tutorial';
        data.bookid = 'notebook-4fnotes-tutorial';
        return data;
    };
    
    /******
     * Handle system request from different windows( or applications or plugins)
     ******/
    System.prototype.systemRequest = function(event,data){
        var event_data = event.detail   //javascript-event
                || data                 //jQuery-event 
                ||{};                   //TODO: what to do if data is missing
        var callbackData= {};
        callbackData.userinfo = this.config.user;
        callbackData.generalsettings = this.config.general;
        switch (event_data.type) {
            case "getFileAsObject":
                callbackData.fileasobject = this.fileSystem.readFileToObject(event_data.getFileAsObject);
                try{
                    callbackData.contentinfo = this.config.content[event_data.getFileAsObject.type][event_data.getFileAsObject.context.contextid]
                }catch (err) {
                    console.log(err,event_data,"getContentAsObject contentinfoadd");
                };
                break;
            case "getContentAsObject":
                callbackData.fileasobject = this.fileSystem.readContextToObject(event_data.getContentAsObject);
                try{
                    callbackData.contentinfo = this.config.content[event_data.getContentAsObject.type][event_data.getContentAsObject.context.contextid]
                }catch(err){
                    console.log(err,event_data,"getContentAsObject contentinfoadd");
                }
                break;
            case "getFileListAsObject":
                callbackData.fileasobject = this.fileSystem.readFileListToObject(event_data.getFileListAsObject);
                break;
            case "saveObjectAsFile":
                //TODO:contentsave vs objectsave
                var savestatus = this.fileSystem.saveObjectToFile(event_data.saveObjectAsFile);
                var callbackEventData = [];
                for(var i=0;i<event_data.saveObjectAsFile.callbackData.contentdata.length;i++){
                    callbackEventData.push({"success":savestatus,data:event_data.saveObjectAsFile.callbackData.contentdata[i]});
                }
                //if callbacktype = jQuery otherwise pure javascriptevent ?
                event_data.saveObjectAsFile.callbackTarget
                    .ownerDocument.defaultView.$(event_data.saveObjectAsFile.callbackTarget)
                    .trigger(event_data.saveObjectAsFile.callbackEvent,
                        {
                            contentsaveStatus:callbackEventData,
                            appinfo:event_data.saveObjectAsFile.callbackData.appinfo
                        }
                    );
                callbackData = false;
                break;
            case "removeContent":
                callbackData.saveStatus = this.fileSystem.removeContent({category:"content",type:event_data.removeFile.content,context:{contextid:event_data.removeFile.contextid}});
                this.updateContentinfo(event_data.removeFile,'remove');
                break;
            case "refreshFileInfo":
                callbackData.status = this.fileSystem.refreshFileInfo(event_data.refresh_files);
                jQuery('#'+event_data.refresh_application)[event_data.refresh_application]('refresh');
                break;
            case "sendCourseData":
                var sendData = {};
                sendData.returnTarget = event_data.sendData.originalTarget;
                jQuery.extend(sendData,event_data.sendData);
                this.sendContent(sendData);
                callbackData = false;
                break;
            case "saveCourseData":
                var success = this.fileSystem.saveContentData(event_data.sendData);
                for(var i=0;i<event_data.sendData.contentData.length;i++){
                    event_data.sendData.originalTarget.ownerDocument.defaultView.$(event_data.sendData.originalTarget).trigger(event_data.sendData.callbackEvent,{"success":success,data:event_data.sendData.contentData[i]});
                }
                callbackData = false;
                break;
            case "saveStorageData":
                var success = this.fileSystem.saveContentData(event_data.sendData);
                callbackData = false;
                break;
            case "saveContentData":
                var sendData = {};
                sendData.returnTarget = event.target;
                jQuery.extend(sendData,event_data);
                this.saveAndSendContent(sendData);
                callbackData = false;
                break;
            case "openExternalBrowser":
                callbackData = false;
                this.openInExternalBrowser(event_data.openExternalBrowser);
                break;
            case "updaterequest":
                callbackData = false;
                this.getRequestUpdates(event_data.requestdata,event_data);
                break;
            case "contextsave":
                var savestatus = this.fileSystem.saveContentData(event_data.contextsave.savedata);
                break;
            case "allWindowEvent":
                callbackData = false;
                this.place.trigger('allwindowevent',event_data.allWindowEvent);
                break;
            case "contentdatasave":
                //TODO:contentsave vs objectsave
                var callbackEventData = this.fileSystem.saveContentData(event_data.contentdatasave.savedata);
                //if callbacktype = jQuery otherwise pure javascriptevent ?
                event_data.contentdatasave.saveCallbackData.callbackTarget
                    .ownerDocument.defaultView.$(event_data.contentdatasave.saveCallbackData.callbackTarget)
                    .trigger(event_data.contentdatasave.saveCallbackData.callbackEvent,
                        {
                            contentsaveStatus:callbackEventData,
                            info:event_data.contentdatasave.saveCallbackData.info
                        }
                    );
                this.sendContent(event_data.contentdatasave);
                callbackData = false;
                break;
            case "registercontent":
                callbackData = false;
                var regData = {};
                regData.returnTarget = event.target;
                jQuery.extend(regData,event_data);
                this.registerContentgroup(regData);
                break;
            case "videocall":
                this.openvideochatwindow(event_data.videocall);
                break;
            case "contextchanged":
                this.makeContentInfochanges(event_data.contextchanged);
                break;
            case "getContentAfterRegister":
                callbackData = false;
                if(typeof(event_data.requestdata.returnTarget)==="undefined"){
                    event_data.requestdata.returnTarget = event.target;
                }
                this.getContentAfterRegister(event_data.requestdata);
            default:
                console.log("systemRequest:");
                try{
                    console.log(JSON.stringify(event_data));
                }catch(e){
                    console.log(event_data);
                }                
                
        }
        if (event_data.callbackEvent && callbackData){
            if (typeof(event_data.relayParams) === "object"){
                callbackData = jQuery.extend(true, {}, callbackData, event_data.relayParams);
            };
            callbackData.userinfo = this.config.user;
            callbackData.libraryinfo = this.config.library;
            this.triggerEvent(event_data.callbackEvent, callbackData, event.target, event_data.callbacktype);            
        }
    } 
    /******
     * Save User settings
     ******/
    System.prototype.saveUser = function(userdata, next){
        this.setUserData(userdata);
        this.place.trigger('saveusersettings.system');
        this.place.trigger('redrawSystem');
        if (typeof(next)==="string"){
            this.place.trigger(next);
        }
    } 
    /******
     * sendToBuyServicetime
     ******/
    System.prototype.sendToBuyServicetime = function(dialog,systemSelf) {
        this.openDialog('buyService');
    }
    /**
     * Welcome the user
     */
    System.prototype.openWelcomeUser = function(dialog, systemSelf) {
        this.openDialog('welcomeUser');
    };
    /******
     * askForEULAaccept
     ******/
    System.prototype.askForEULAaccept = function() {
        this.openDialog('EULAaccept');
    } 
    /******
     * informServiceExpired
     ******/
    System.prototype.informServiceExpired = function() {
        if (this.dialogelement){
            this.dialogelement.close();
        } else {
            jQuery.modal.close();
            
        };
        this.openDialog('serviceExpired');
    } 
    System.prototype.agreeEULA = function() {
        this.activeServerConnection(
            'accectEula',
            {
                type:19,
                username:this.config.user.username,
                appkey:this.config.user.applicationkey
            }
        );
    } 
    /******
     * Close the system and save settings.
     ******/
    System.prototype.close = function() {
        
        //$.notify('System.prototype.close is incomplete.', 'warn');
        // TODO Gather settings from the plugins / tell them to save their state.
        
        this.saveSystemSettings();
        this.systemWindow.close(true);
    }
    
    /******
     * Dialog forceclose
     ******/
    System.prototype.forceCloseDialog = function() {
        try{
            jQuery.modal.close();
        }catch(err){
            console.log("jquery modal error");
        }
    }
    
    
    /******
     * Dialog open
     ******/
    System.prototype.openDialog = function(type, options) {
        this.dialog(this.dialogTexts(type), typeof(options) === "undefined" ? this.dialogSettings(type) : options);
    }
    
    /******
     * Dialog
     ******/
    System.prototype.dialog = function(message, options) {
        var systemSelf = this;
        var open = function (dialog) {
            dialog.overlay.fadeIn(100, function () {
                dialog.container.fadeIn(20, function () {
                    dialog.data.fadeIn(20, function () {
                        if (options && typeof(options.openFunction) === "function") options.openFunction(dialog, systemSelf);
                    });
                });
            });
        };
        var show = function (dialog) {
            if (options && typeof(options.showFunction) === "function") options.showFunction(dialog, systemSelf);
        };
        var close = function (dialog) {
            if (options && typeof(options.closeFunction) === "function") {
                options.closeFunction(dialog, systemSelf);
                jQuery.modal.close();
            }else{
                jQuery.modal.close();
            }
        };
        // var close = function (dialog) {
            // dialog.data.fadeOut(1, function () {
                    // dialog.container.fadeOut(1, function () {
                        // dialog.overlay.fadeOut(1, function () {
                            // $.modal.close();
                        // });
                    // });
                // });
        // };
        var dialogOptions = {
            closeHTML: `<a href='#' title='Close' class='modal-close'>${this.icons.close}</a>`,
            close: true,
            position: [],
            minWidth:500,
            minHeight:500,
            onOpen: open,
            onShow: show,
            onClose: close,
            overlayId: undefined,
            containerId: undefined,
            escClose: false
        };
        jQuery.extend(dialogOptions,options);
        try{
            this.dialogelement = jQuery.modal((message ? message : "<h1>Dialog</h1>"), dialogOptions);
        } catch(err) {
            console.log(err);
        }
    }
    /******
     * Dialog texts
     ******/   
    System.prototype.dialogTexts = function(type) {
        var text = '<h1 class="sm-content-maintitle maintitle">'+this.localizer.localize('system:'+type)+"</h1>";
        switch(type){
            case "usersettings":
            case "general":
            case "languageselect":
            // case "addnotebook_old":
            case "demowelcome":
            break;
            case "getupdates":
                text =`<h1 class="sm-content-maintitle maintitle">${this.localizer.localize('system:updatingsystem')}</h1>
                    <div class="sm-content-container updating serverconnection dialog_message show">
                        <span class="infotext">${this.localizer.localize('system:gettingupdates')}</span>
                        <span class="applicationButton cancelUpdate cancel-button">${this.localizer.localize('system:cancel')}</span>
                    </div>`;
            break;
            case "systemworking":
                text =`<h1 class="sm-content-maintitle maintitle">${this.localizer.localize('system:processingdata')}</h1>
                    <div class="sm-content-container processingdata serverconnection dialog_message show">
                        <div class="container">
                            <span class="infotext">${this.localizer.localize('system:working')}</span>
                            <table class="matrixprocesstable" style="margin: 2em auto;  border: 1px dotted #aaa;  background-color: #555;  color: lime;  width: 8em;  padding-left: 5px;">
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>`;
            break;
            case "about":
                text += `<p>${this.localizer.localize('system:aboutheader')}</p>
                    <p>${this.localizer.localize('system:abouttext')}</p>
                    <div class="companylogo fakelink" data-fakeurl="companyurl">${this.icons['4flogo']}</div>
                    <p>${this.localizer.localize('system:aboutcredits')}</p>`;
            break;
            case "buyService":
                text = `<h1 class="sm-content-maintitle maintitle">${this.localizer.localize('system:buyserviceTitle')}</h1>
                    <div class="progresscircles step4">
                        ${this.progressdots}
                    </div>
                    <div class="sm-content-container container">
                        <div class="sm-content-container-data buyserviceText">${this.localizer.localize('system:buyservicetext')}</div>
                        <div class="buyservicetime-area">
                            <div class="buyserviceprompt">
                                ${this.localizer.localize('system:buyServiceTime')}
                            </div>
                            <div class="buyservicetime-buttons">
                                <div class="dialogSelectButton buyserviceTime6">${this.localizer.localize('system:6month_subscription')}</div>
                                <span class="buyspinner" style="display: none;">${this.icons.waitspinner}</span>
                                <div class="dialogSelectButton buyserviceTime12">${this.localizer.localize('system:12month_subscription')}</div>
                            </div>
                            <div class="choises dialogButtons buttons">
                                <span></span>
                                <span class="servicetime_bought applicationButton ok-button">${this.localizer.localize('system:buying_done')}</span>
                            </div>
                        </div>
                    </div>`;
            break;
            case "welcomeUser":
                text = `<h1 class="sm-content-maintitle maintitle">${this.localizer.localize('system:welcome')}</h1>
                    <div class="progresscircles step5">
                        ${this.progressdots}
                    </div>
                    <div class="sm-content-container container">
                        <div class="sm-content-container-data welcomeText">${this.localizer.localize('system:welcome-instructions')}</div>
                        <div class="welcome-area">
                            <div class="choises dialogButtons buttons">
                                <span></span>
                                <span class="refresh_system applicationButton ok-button">${this.localizer.localize('system:ready')}</span>
                            </div>
                        </div>
                    </div>`;
            break;
            case "EULAaccept":
                text = `<h1 class="sm-content-maintitle maintitle">${this.localizer.localize('system:eulaagreement')}</h1>
                    <div class="sm-content-container container">
                        <div class="sm-content-container-data eulatext"></div>
                        <div class="explain_eula">${this.localizer.localize('system:explain_eula')}</div>
                        <div class="choises buttons dialogButtons">
                            <span class="agree_eula applicationButton ok-button">${this.localizer.localize('system:agree')}</span>
                            <span class="disagree_eula applicationButton cancel-button">${this.localizer.localize('system:disagree')}</span>
                        </div>
                    </div>`;
            break;
            case "serviceExpired":
                text = `<h1 class="sm-content-maintitle maintitle">${this.localizer.localize('system:serviceExpired')}</h1>
                    <div class="sm-content-container container">
                        <div class="buyserviceText">
                            ${this.localizer.localize('error:SERVICE_EXPIRED')}
                        </div>
                    </div>
                    <div>
                        <div class="buyserviceprompt">
                            ${this.localizer.localize('system:buyServiceTime')}
                        </div>
                        <div class="buyservicetime-buttons">
                            <div class="dialogSelectButton buyserviceTime6">${this.localizer.localize('system:6month_subscription')}</div>
                        <span class="buyspinner" style="display: none;">${this.icons.waitspinner}</span>
                            <div class="dialogSelectButton buyserviceTime12">${this.localizer.localize('system:12month_subscription')}</div>
                        </div>
                    </div>
                    <div class="buttons dialogButtons">
                        <span class="applicationButton continue-button">${this.localizer.localize('system:continue_without_service')}</span>
                        <span class="applicationButton redo-button">${this.localizer.localize('system:service_bought')}</span>
                    </div>
                    `;
            break;
            default:
                text += ""
            break;
        }
        return text;
    } 
    /******
     * Dialog options
     ******/   
    System.prototype.dialogSettings = function(type) {
        //add if needed
        // -openFunction (run when open)
        // -showFunction (run when show)
        // -closeFunction (run when closed)
        // -closeHTML (close html-element)
        // -close (boolean if dialog can be closen by user)
        
        var systemSelf = this;
        var options = {'containerId':type};
        options.close = true;
        switch(type){
            case "languageselect":
                options.openFunction = systemSelf.promptLang;
                options.showFunction = systemSelf.langPromptShow;
                options.close = false;
                break;
            case "usersettings":
                if (this.config.user.applicationkey) {
                    options.openFunction = systemSelf.userSettings;
                    options.showFunction = systemSelf.showUserSettings;
                } else {
                    options.close = false;
                    options.openFunction = systemSelf.promptUser;
                    options.showFunction = systemSelf.userpromptShow;
                };
                break;
            case "general":
                options.openFunction = systemSelf.openGeneraloptions;
                options.showFunction = systemSelf.showGeneraloptions;
                options.closeFunction = systemSelf.closeGeneraloptions;
                break;
            case "demowelcome":
                options.minWidth = 600;
                options.openFunction = systemSelf.openDemowelcome;
                options.showFunction = systemSelf.showDemowelcome;
                options.closeFunction = systemSelf.closeDemowelcome;
                break;
            case "getupdates":
                options.openFunction = systemSelf.getUpdates;
                options.showFunction = systemSelf.getUpdatesDialogShow;
                break;
            case "systemworking":
                options.closeHTML = "";
                options.openFunction = systemSelf.systemWorking;
                options.showFunction = systemSelf.systemWorkingShow;
                options.closeFunction = systemSelf.systemWorkingClose;
                break;
            case "EULAaccept":
                options.minWidth = 900;
                options.minHeight = 800;
                options.close = false;
                options.openFunction = systemSelf.EULAaccept;
                options.showFunction = systemSelf.EULAacceptShow;
                break;
            case "buyService":
                options.close = false;
                options.openFunction = systemSelf.buyService;
                options.showFunction = systemSelf.buyServiceShow;
                break;
            case "welcomeUser":
                options.close = true;
                options.openFunction = systemSelf.welcomeUser;
                options.showFunction = systemSelf.welcomeUserShow;
                break;
            case "serviceExpired":
                options.showFunction = systemSelf.serviceExpiredShow;
                break;
            case "about":
                options.showFunction = systemSelf.aboutShow;
                break;
            default:
                break;
        }
        return options;
    } 


    /******
     * Dialogfunctions
     ******/
    System.prototype.getUpdatesDialogShow = function(dialog, systemSelf) {
        var endUpdate = function(endtype,buttons,enddata){
            var buttonText = {
                "continue"   : systemSelf.localizer.localize('system:continue'),
                "ok"         : systemSelf.localizer.localize('system:ok'),
                "redo"       : systemSelf.localizer.localize('system:redoupdates')
            };
            var notificationText = {
                updateCanceled   : systemSelf.localizer.localize('system:updatecanceled'),
                serverError      : systemSelf.localizer.localize('system:servererror_updates'),
                updatingSystem   : systemSelf.localizer.localize('system:updatingsystem')
            };
            dialog.container.find('.updating').removeClass('show');
            systemSelf.disactiveServerConnection('getupdates');
            dialog.data.append(
                '<div class="sm-content-container endnotification '+endtype+'" '+
                    (enddata && typeof(enddata.success) != "undefined" && enddata.success == false && enddata.errortype?
                        'errortype="'+enddata.errortype+'"'
                        :
                        ''
                    )+
                '><div class="sm-content-container-data">'+
                '<p>'+notificationText[endtype]+'</p>'
                +(enddata?
                    (enddata.localizableerror?
                        systemSelf.localizer.localize('error:'+enddata.localizableerror)
                            :
                        (enddata.errormessage?
                            '<p>'+enddata.errormessage+'</p>'
                                :
                            ''
                        )
                    )
                    :
                    ''
                )+'</div><div class="buttons dialogButtons">'+
                (function(){
                    var buttonstring = "";
                    for(var i=0;i<buttons.length;i++){
                        buttonstring +='<span class="applicationButton '+buttons[i]+'-button">'+buttonText[buttons[i]]+'</span>'
                    }
                    return buttonstring;
                })()+'</div></div>');
        }
        dialog.container.on("click",".ok-button,.continue-button",function(){
            var clickedButton = jQuery(this);
            if(clickedButton.hasClass('buyserviceTime')){
                return false;
            }
            if(clickedButton.hasClass('continue-button') && clickedButton.parents('.endnotification').eq(0).attr('errortype') == "13"){
                systemSelf.promptServiceExpiredError = false;
                systemSelf.serverIsConnected = false;
            }
            systemSelf.place.trigger('initialized.system');
            jQuery.modal.close();
            
        });
        dialog.container.on("click",".redo-button",function(){
            dialog.data.find('.updateCanceled,.endnotification').remove();
            dialog.data.find('.serverconnection.dialog_message').addClass('show');
            systemSelf.getUpdates(dialog,systemSelf);
        });
        dialog.container.on("click",".cancelUpdate",function(){
            endUpdate("updateCanceled",["continue","redo"])
        });
        dialog.container.on("updating",function(){
            endUpdate("updatingSystem",[])
        });
        dialog.container.on("getupdates_done",function(){
            jQuery.modal.close();
            systemSelf.place.trigger('startsystem.system');
        });
        dialog.container.on("server-error",function(e,data){
            console.log('ERROR', data);
            if (data.errortype === 13) {
                // SERVICE_EXPIRED
                systemSelf.place.trigger('SERVICE_EXPIRED_error');
            } else {
                endUpdate("serverError",["continue","redo"],data);
            };
            systemSelf.place.trigger('startsystem.system');
        });
        
        dialog.container.on("click",".buyserviceTime",function(){
            systemSelf.openInExternalBrowser(systemSelf.getWebshopLink());
        });
        dialog.container.on("click", ".buyserviceTime6", function() {
            systemSelf.openInExternalBrowser(systemSelf.getWebshopLink('6months'));
        });
        dialog.container.on("click", ".buyserviceTime12", function() {
            systemSelf.openInExternalBrowser(systemSelf.getWebshopLink('12months'));
        });
        
    }
    
    /**
     * aboutShow
     */
    System.prototype.aboutShow = function(dialog, systemSelf) {
        dialog.container.on('click', '.fakelink[data-fakeurl]', function(event) {
            var fakeurl = $(this).attr('data-fakeurl');
            var uilang = systemSelf.config.general.uilang;
            var url = systemSelf.urls[fakeurl] && systemSelf.urls[fakeurl][uilang];
            if (url) {
                systemSelf.openInExternalBrowser(url);
            };
        });
    };
    
    /******
     * serviceExpiredShow
     ******/
    System.prototype.serviceExpiredShow = function(dialog,systemSelf) {
        dialog.container.on("click",".redo-button",function(){
            systemSelf.promptServiceExpiredError = true;
            systemSelf.serverIsConnected = true;
            if (systemSelf.dialogelement){
                systemSelf.dialogelement.close();
            } else {
                jQuery.modal.close();
            };
            systemSelf.place.trigger('checkUpdates.system');
        });
        dialog.container.on("click", ".continue-button",function(){
            systemSelf.promptServiceExpiredError = false;
            systemSelf.serverIsConnected = false;
            systemSelf.place.trigger('initialized.system');
            jQuery.modal.close();
        });
        dialog.container.on("click",".buyserviceTime",function(){
            systemSelf.openInExternalBrowser(systemSelf.getWebshopLink());
        });
        dialog.container.on("click", ".buyserviceTime6", function() {
            var spinner = $(this).closest('.buyservicetime-buttons').children('.buyspinner');
            spinner.show();
            setTimeout(function(){spinner.hide()}, 5000);
            systemSelf.openInExternalBrowser(systemSelf.getWebshopLink('6months'));
        });
        dialog.container.on("click", ".buyserviceTime12", function() {
            var spinner = $(this).closest('.buyservicetime-buttons').children('.buyspinner');
            spinner.show();
            setTimeout(function(){spinner.hide()}, 5000);
            systemSelf.openInExternalBrowser(systemSelf.getWebshopLink('12months'));
        });
    }
        
    /******
     * buyService
     ******/
    System.prototype.buyService = function(dialog,systemSelf) {
    }
        
    System.prototype.buyServiceShow = function(dialog,systemSelf) {
        dialog.container.on("click",".buyserviceTime",function(){
            systemSelf.openInExternalBrowser(systemSelf.getWebshopLink());
        });
        dialog.container.on("click", ".buyserviceTime6", function() {
            var spinner = $(this).closest('.buyservicetime-buttons').children('.buyspinner');
            spinner.show();
            setTimeout(function(){spinner.hide()}, 5000);
            systemSelf.openInExternalBrowser(systemSelf.getWebshopLink('6months'));
        });
        dialog.container.on("click", ".buyserviceTime12", function() {
            var spinner = $(this).closest('.buyservicetime-buttons').children('.buyspinner');
            spinner.show();
            setTimeout(function(){spinner.hide()}, 5000);
            systemSelf.openInExternalBrowser(systemSelf.getWebshopLink('12months'));
        });
        dialog.container.on("click", ".servicetime_bought",function(){
            systemSelf.place.trigger('reloadSystem.system');
        });
        dialog.container.on("click",".refresh_system",function(){
            systemSelf.place.trigger('reloadSystem.system');
        });
    };
    
    /**
     * welcomeUser
     */
    System.prototype.welcomeUser = function(dialog, systemSelf) {
        dialog.container.on('click', '.ok-button', function() {
            if (systemSelf.dialogelement){
                systemSelf.dialogelement.close();
            } else {
                jQuery.modal.close();
            };
        });
    };
    
    System.prototype.welcomeUserShow = function(dialog, systemSelf) {
        dialog.container.on("click", ".ok-button",function(){
            systemSelf.saveUser({dontShowFirstrun: true});
            if (systemSelf.dialogelement){
                systemSelf.dialogelement.close();
            } else {
                jQuery.modal.close();
            };
        });
    }
    /******
     * EULAaccept
     ******/
    System.prototype.EULAaccept = function(dialog,systemSelf) {
        systemSelf.activeServerConnection('getEULA',{type:18},{});
    }
    System.prototype.EULAacceptShow = function(dialog,systemSelf) {
        dialog.container.on("click",".agree_eula",function(){
            systemSelf.agreeEULA();
        });
        dialog.container.on("click",".disagree_eula",function(){
            systemSelf.place.trigger('windowsreadyforexit');
        });
    }
    
    /**
     * Open a new window for registration
     * @param {String} lang        The language
     * @param {Function} callback  To do after successfull registration.
     */
    System.prototype.openRegistration = function(lang, callback) {
        lang = lang || 'en';
        var regurl = this.config.system.connection.registerURL + '/lang=' + lang + '&embed=true';
        var sysself = this;
        //var userRegistered = function(userdata) {
        //    sysself.connectionHandler.request.post({
        //        url: sysself.connectionHandler.serverURL,
        //        form: {
        //            type: 1,
        //            username: userdata.username,
        //            password: userdata.password
        //        }
        //    }, function(error, response, body) {
        //        if (!error) {
        //            var result = {};
        //            try {
        //                result = JSON.parse(body);
        //            } catch(e) {
        //                result = {errortype: 0}
        //            };
        //            if (result.errortype === 3) {
        //                alert('username: ' + userdata.username + '\npassword: ' + userdata.password);
        //            } else {
        //                console.log(userdata, error, response, body);
        //            };
        //        };
        //    });
        //};
        this.nw_gui.Window.open(regurl, {width: 900, height: 800, position: 'center', title: this.localizer.localize('system:register')}, function(win) {
            sysself.regwin = win;
            var runready = function() {
                var userdata = {};
                var intval = setInterval(function() {
                    var completed = win.window.document.getElementsByClassName('registrationCompleted').length > 0;
                    if (completed) {
                        clearInterval(intval);
                        callback(userdata);
                        win.close();
                    };
                }, 2000);
                win.window.document.getElementById('register').parentElement.addEventListener('click', function(event) {
                    userdata.username = win.window.document.getElementById('username').value;
                    userdata.password = win.window.document.getElementById('password').value;
                    //userRegistered(userdata);
                });
                setTimeout(function(){win.window.document.head.getElementsByTagName('title')[0].innerHTML = sysself.localizer.localize('system:register');}, 1000);
            };
            var intval = setInterval(function() {
                var regbutton = win.window.document.getElementById('register');
                var theme = win.window.document.querySelectorAll('.virumtheme, .fftheme');
                if (regbutton && theme.length > 0) {
                    clearInterval(intval);
                    runready();
                };
            }, 500);
        });
    }
    
    /**
     * Prompt language
     */
    System.prototype.promptLang = function(dialog, systemSelf) {
        if (typeof(systemSelf) === "undefined") systemSelf = this;
        var uilang = systemSelf.config.general.uilang || 'en';
        var langlist = [
            {
                id: 'en',
                name: 'English'
            },
            {
                id: 'fi',
                name: 'suomi'
            },
            {
                id: 'sv',
                name: 'svenska'
            }
        ];
        langlist.sort(function(a, b) {return (a.name.toLowerCase() < b.name.toLowerCase() ? -1 : 1)});
        var getLangs = function() {
            var result = ['<ul class="langselectlist">'];
            for (var i = 0, len = langlist.length; i < len; i++) {
                result.push(`<li class="langselectitem ${(uilang === langlist[i].id ? 'selectedlang' : '')}" data-lang="${langlist[i].id}">${langlist[i].name}</li>`);
            };
            result.push('</ul>');
            return result.join('\n');
        };
        dialog.data.append(
            `<div class="progresscircles step1">
                ${systemSelf.progressdots}
            </div>
            <div class="langselector">
                ${getLangs()}
            </div>`
        );
    };
    
    /**
     * Prompt language show
     */
    System.prototype.langPromptShow = function(dialog, systemSelf) {
        if (typeof(systemSelf) === "undefined") systemSelf = this;
        dialog.container.on('click', 'li.langselectitem', function(event) {
            event.stopPropagation();
            var uilang = $(this).attr('data-lang');
            systemSelf.config.general.uilang = uilang;
            systemSelf.place.trigger('savegeneralsettings.system');
            systemSelf.localizer.setLanguage(uilang);
            if (systemSelf.dialogelement){
                systemSelf.dialogelement.close();
            } else {
                jQuery.modal.close();
                
            };
            systemSelf.openDialog('usersettings');
        });
    };
    
    /******
     * promptUser
     ******/
    System.prototype.promptUser = function(dialog, systemSelf) {
        if (typeof(systemSelf) === "undefined") systemSelf = this;
        dialog.data.append(
            `<div class="sending serverconnection dialog_message">
                <div class="container">
                    <span class="infotext">${systemSelf.localizer.localize('system:sending')}</span>
                    <span class="applicationButton cancelSend cancel-button">${systemSelf.localizer.localize('system:cancel')}</span>
                </div>
            </div>
            <div class="progresscircles step2">
                ${systemSelf.progressdots}
            </div>
            <div class="register">
                <h2>${systemSelf.localizer.localize('system:registerinfo')}</h2>
                <span class="applicationButton register-button">${systemSelf.localizer.localize('system:register')}</span>
            </div>
            <div class="login">
                <h2>${systemSelf.localizer.localize('system:logininfo')}</h2>
                <label class="usernameinput"><span class="inputlabel">${systemSelf.localizer.localize('system:username')}</span> <input class="username" type="text"></label>
                <label class="passwordinput"><span class="inputlabel">${systemSelf.localizer.localize('system:password')}</span> <input class="password" type="password"></label>
                <div class="buttons dialogButtons">
                    <span></span>
                    <span class="applicationButton ok-button buttondisabled">${systemSelf.localizer.localize('system:ok')}</span>
                </div>
            </div>
            <div class="activationNeeded" style="display: none;">
                <h2>${systemSelf.localizer.localize('system:verificationinfo')}</h2>
                <div class="login-error">${systemSelf.localizer.localize('system:activationneeded')}</div>
                <div class="verification-spinner">
                    ${systemSelf.icons.waitspinner}
                </div>
                <div class="verification-buttons">
                    <span class="button applicationButton back-button">${systemSelf.localizer.localize('system:goback')}</span>
                    <span class="button applicationButton continue-button">${systemSelf.localizer.localize('system:continue')}</span>
                </div>
            </div>
        `);
        dialog.data.find('.login .username').focus();
    };
    
    System.prototype.userpromptShow = function(dialog, systemSelf) {
        if (typeof(systemSelf) === "undefined") systemSelf = this;
        var regCallback = function(userdata) {
            dialog.container.find('.login input.username').val(userdata.username);
            dialog.container.find('.login input.password').val(userdata.password);
            dialog.container.find('.login input.password').trigger('keyup');
            dialog.container.find('.dialogButtons .ok-button').click();
        };
        dialog.container.on("keyup",'input[type="text"], input[type="password"]',function(e){
            dialog.container.trigger("validLogin");
            if(e.keyCode ===13){
                if(jQuery(this).attr('type')==="text"){
                    jQuery(this).parents('.login').find('input[type="password"]').focus();
                }else{
                    dialog.container.find('.dialogButtons .ok-button').click();
                }
            }
        });
        
        dialog.container.on("mouseup",function(){
            dialog.container.trigger("validLogin");
        });
        
        dialog.container.on("click", ".ok-button",function(){
            if (jQuery(this).hasClass('buttondisabled')) return false;
            if (!dialog.container.find(".login").hasClass('disablelogin')){
                dialog.container.trigger("sendLogin");
            } else {
                systemSelf.useOffline(dialog.container.find('.username').val());
            }
        });
        dialog.container.on("click",".cancelSend",function(){
            dialog.container.find('.sending').removeClass('show');
            systemSelf.disactiveServerConnection('login');            
        });
        dialog.container.on("click",".register-button",function(){
            //systemSelf.openInExternalBrowser(systemSelf.config.system.connection.registerURL);
            var uilang = systemSelf.config.general.uilang;
            if (uilang === 'sv') {
                uilang = 'se';
            };
            systemSelf.openRegistration(uilang, regCallback);
        });
        dialog.container.on('click', '.continue-button', function() {
            if (systemSelf.loginPoll) {
                clearTimeout(systemSelf.loginPoll);
            };
            dialog.container.trigger('sendLogin');
        });
        dialog.container.on("sendLogin", function(){
            /*send info to server*/
            dialog.container.find('span.login-error').remove();
            dialog.container.find('.sending').addClass('show');
            systemSelf.activeServerConnection('login',{
                type:1,
                username:dialog.container.find('.username').val(),
                password:dialog.container.find('.password').val()
            });
            systemSelf.loginPoll = setTimeout(function() {
                dialog.container.trigger('sendLogin');
            }, 120000); // Two minutes polling.
        });
        dialog.container.on("validLogin", function(e,data){
            var username = dialog.container.find('.username');
            var passwordfield = dialog.container.find('.password');
            username.removeClass('invalidInput');
            passwordfield.removeClass('invalidInput');
            if (username.val() === "") username.addClass('invalidInput');
            if (!dialog.container.find(".login").hasClass("disablelogin")){
                if(passwordfield.val() === "")passwordfield.addClass('invalidInput');
            }
            dialog.container.trigger(dialog.container.find('.invalidInput').length === 0 ? 'loginValid' : 'loginInvalid');
            
        });
        dialog.container.on("loginValid",function(){
            dialog.container.find(".ok-button").removeClass("buttondisabled");
        });
        dialog.container.on("loginInvalid",function(){
            dialog.container.find(".ok-button").addClass("buttondisabled");
        });
        dialog.container.on("login-error",function(e,data){
            if(data.errortype && data.errortype == 3){
                dialog.container.find(".login, .register").hide();
                dialog.container.find(".activationNeeded").show();
                dialog.container.find('.progresscircles').removeClass('step2').addClass('step3');
            }else{
                dialog.container.find(".login").css("border","2px solid red").append('<span class="login-error">'+systemSelf.localizer.localize('error:'+data.localizableerror)+'</span>');
            };
        });
        dialog.container.on('click', '.back-button', function(e, data) {
            if (systemSelf.loginPoll) {
                clearTimeout(systemSelf.loginPoll);
            };
            dialog.container.find('.login, .register').show();
            dialog.container.find('.activationNeeded').hide();
            dialog.container.find('.progresscircles').removeClass('step3').addClass('step2');
        });
    } 
    /******************
     * Demowelcome
     ******************/
    System.prototype.openDemowelcome = function(dialog,systemSelf){
        var languageList = dialog.data.append('<div class="welcometext">'+systemSelf.localizer.localize('system:demowelcometext')+'</div><div class="ui-lang_selector"><ul></ul></div><div class="buttons dialogButtons"><span class="applicationButton ok-button">'+systemSelf.localizer.localize('system:ok')+'</span><span class=\"logoImage\"></span></div><div class="logoarea"></div>').find('.ui-lang_selector ul');
        var availLangs = [{lang:"fi",text:"Suomeksi"},{lang:"sv",text:"Svenska"},{lang:"en",text:"English"}];
        for(var i=0;i<availLangs.length;i++){
            languageList.append('<li'+(systemSelf.config.general.uilang ===availLangs[i].lang?" class=\"lang_selector selectedLang originLang\" ":" class=\"lang_selector\" ")+' data-setlang="'+availLangs[i].lang+'"><label>'+availLangs[i].text+'<input type="radio" name="selectAppLang" '+(systemSelf.config.general.uilang ===availLangs[i].lang?" checked=\"checked\" ":"")+'/></label></li>');
        }
    }
    System.prototype.showDemowelcome = function(dialog,systemSelf){
        
        dialog.container.on("click",".ui-lang_selector li",function(e,data){
            systemSelf.config.general.uilang = jQuery(this).data('setlang');
            dialog.container.find('.selectedLang').removeClass('selectedLang');
            jQuery(this).addClass('selectedLang');
            dialog.container.find('.welcometext').empty().text(systemSelf.localizer.localize('system:demowelcometext',jQuery(this).data('setlang')));
            dialog.container.find('h1.maintitle').empty().text(systemSelf.localizer.localize('system:demowelcome',jQuery(this).data('setlang')));
        });
        dialog.container.on("click",".applicationButton.ok-button",function(e,data){
            jQuery.modal.close();
        });
        
        
    }
    System.prototype.closeDemowelcome = function(dialog,systemSelf){
        if(typeof(systemSelf)==="undefined") systemSelf=this;
        if(!dialog.container.find('.selectedLang').hasClass('originLang')){
            systemSelf.place.trigger('savegeneralsettings.system');
        }
        systemSelf.saveUser({"username":"demouser","applicationkey":"","email":"nomail@no.com","firstname":"demo","lastname":"demo","defaultlang":dialog.container.find('.selectedLang').data('setlang'),"defaultroles":["teacher"],"dontPromptUser":true},'initialized.system');
    }
    
    
    /******************
     * Generaloptions
     ******************/
    System.prototype.openGeneraloptions = function(dialog,systemSelf){
        dialog.data.append('<div class="sm-content-container"><div class="ui-lang_selector"><h4>'+systemSelf.localizer.localize('system:language')+'</h4><ul></ul></div><div class="themes"><label>'+systemSelf.localizer.localize('system:themes')+':<select>'+'</select></label></div></div><div class="buttons dialogButtons"><span class="applicationButton ok-button">'+systemSelf.localizer.localize('system:ok')+'</span></div>');
        var usedtheme = systemSelf.usedTheme();
        var otherThemes = {place:dialog.data.find('.themes select'),list:systemSelf.getThemes()};
        for(var i=0;i<otherThemes.list.length;i++){
            otherThemes.place.append('<option value="'+otherThemes.list[i].name+"_"+otherThemes.list[i].template+'"'+(otherThemes.list[i].name===usedtheme?" selected":"")+'>'+otherThemes.list[i].name+'</option>');
        }
        var languageList = dialog.data.find('.ui-lang_selector ul');
        var availLangs = [{lang:"fi",text:"Suomeksi"},{lang:"sv",text:"Svenska"},{lang:"en",text:"English"}];
        for(var i=0;i<availLangs.length;i++){
            languageList.append('<li'+(systemSelf.config.general.uilang ===availLangs[i].lang?" class=\"lang_selector selectedLang originLang\" ":" class=\"lang_selector\" ")+' data-setlang="'+availLangs[i].lang+'"><label>'+availLangs[i].text+'<input type="radio" name="selectAppLang" '+(systemSelf.config.general.uilang ===availLangs[i].lang?" checked=\"checked\" ":"")+'/></label></li>');
        }
    }
    System.prototype.showGeneraloptions = function(dialog,systemSelf){
        dialog.container.on("click",".ui-lang_selector li",function(e,data){
            systemSelf.config.general.uilang = jQuery(this).data('setlang');
            dialog.container.find('.selectedLang').removeClass('selectedLang');
            jQuery(this).addClass('selectedLang');
            systemSelf.localizer.setLanguage(jQuery(this).data('setlang'));
        });
        dialog.container.on("click",".applicationButton.ok-button",function(e,data){
            jQuery.modal.close();
        });
        dialog.container.on("change",".themes select",function(e,data){
            var themeSplit = jQuery(this).val().split("_");
            systemSelf.setTheme({name:themeSplit[0],template:themeSplit[1]});
        });
        
        
    }
    System.prototype.closeGeneraloptions = function(dialog,systemSelf){
        systemSelf.place.trigger('savegeneralsettings.system');
        if(!dialog.container.find('.selectedLang').hasClass('originLang')){
            try{
                systemSelf.dialogelement.close();
            }catch(err){
                console.log(err);
            }
            systemSelf.place.trigger('redrawSystem');
        }
        
    }
    System.prototype.systemWorking = function(dialog,systemSelf){
        
    }
    System.prototype.systemWorkingShow = function(dialog,systemSelf){
        dialog.container.on('updatetable',function(){
            var workingtable = dialog.container.find('table');
            if(workingtable.find('tr').length >7){
                workingtable.find('tr').eq(0).remove();
            }
            var nrolist = [];
            for (var i=0; i<8; i++) {
                nrolist.push(Math.round(Math.random()))
            }
            var appendtds = "<tr><td>"+nrolist.join('</td><td>')+"<td></tr>";
            workingtable.append(appendtds);
        });
        setInterval(function(){dialog.container.trigger('updatetable')},100)
        
    }
    System.prototype.systemWorkingClose = function(dialog,systemSelf){
    }
    
    
    /******
     * End of dialog functions
     ******/    
    
    /**
     * Get content for usersettings
     * @returns {String}   html-text
     */
    System.prototype.getUserSettingsHtml = function() {
        var systemSelf = this;
        var getSchools = function() {
            var result = [];
            var schools = systemSelf.config.user.schools;
            var mapping = systemSelf.config.library.schools;
            for (var i = 0, len = mapping.length; i < len; i++) {
                if (schools.indexOf(mapping[i].id) > -1) {
                    result.push(mapping[i].name);
                };
            };
            return result;
        };
        var remainingDays = function(datestr) {
            result = '';
            if (datestr) {
                var ending = (new Date(datestr)).getTime();
                var now = (new Date()).getTime();
                result = Math.floor((ending - now) / 86400000);
            };
            return result;
        };
        var uilang = systemSelf.config.general.uilang || 'en';
        var expday = systemSelf.config.library.expires;
        var remDays = remainingDays(expday);
        var remdaystr = '';
        var buymore = '';
        if (typeof(remDays) === 'number') {
            remdaystr = `(<span class="usersettings-remainigdays ${remDays <= 30 ? 'usersettings-subscription-expiration-soon' : ''}">${remDays} ${systemSelf.localizer.localize('system:days')}</span>)`
            if (remDays <= 30) {
                buymore = `<br>${systemSelf.localizer.localize('system:buyservice')}:<br>
                <span class="usersettings-buy usersettings-buy-6months" data-product="6months">${systemSelf.localizer.localize('system:6month_subscription')}</span>
                <span class="usersettings-buy usersettings-buy-12months" data-product="12months">${systemSelf.localizer.localize('system:12month_subscription')}</span>`;
            };
        };
        var checkerQuota = systemSelf.config.library.checker_quota_left | 0; // Make sure, this is a number.
        var checkerExpires = systemSelf.config.library.checker_quota_expires;
        var checkDaysRemain = remainingDays(checkerExpires);
        var checkerExpiresstr = checkerExpires && (new Date(checkerExpires)).toLocaleDateString(uilang) || '';
        var buycheck = '';
        if (checkerQuota <= 30 || checkDaysRemain <= 30) {
            buycheck = `<br>${systemSelf.localizer.localize('system:buychecks')}:<br>
                <span class="usersettings-buy usersettings-buy-100checks" data-product="100checks">100 ${systemSelf.localizer.localize('system:checks')}</span>
                <span class="usersettings-buy usersettings-buy-250checks" data-product="250checks">250 ${systemSelf.localizer.localize('system:checks')}</span>`;
        };
        var html = `
            <div class="sm-content-container">
                <table class="usersettings-table">
                    <tr>
                        <th>${systemSelf.localizer.localize('system:name')}:</th>
                        <td>${systemSelf.config.user.firstname + ' ' + systemSelf.config.user.lastname}</td>
                    </tr>
                    <tr>
                        <th>${systemSelf.localizer.localize('system:username')}:</th>
                        <td>${systemSelf.config.user.username}</td>
                    </tr>
                    <tr>
                        <th>${systemSelf.localizer.localize('system:schools')}:</th>
                        <td>${getSchools().join(', ')}</td>
                    </tr>
                    <tr>
                        <th>${systemSelf.localizer.localize('system:subscription_expiration_time')}:</th>
                        <td>
                            ${expday ? (new Date(expday)).toLocaleDateString(uilang) : systemSelf.localizer.localize('system:subscription_nolimit')} &nbsp;&nbsp;
                            ${remdaystr}
                            ${buymore}
                        </td>
                    </tr>
                    <tr>
                        <th>${systemSelf.localizer.localize('system:checking_remaining_quota')}:</th>
                        <td>
                            <span class="usersettings-checkleft ${checkerQuota < 15 ? 'usersettings-subscription-expiration-soon' : ''}">${checkerQuota} ${systemSelf.localizer.localize('system:checks')}</span> &nbsp;&nbsp;
                            (<span class="usersettings-checkexpireday ${checkDaysRemain <= 15  ? 'usersettings-subscription-expiration-soon' : ''}">${systemSelf.localizer.localize('system:expires')} ${checkerExpiresstr}</span>)
                            ${buycheck}
                        </td>
                    </tr>
                </table>
                <div class="usersettings-waitspinner">
                    ${systemSelf.icons.waitspinner}
                </div>
            </div>`
        return html;
    }
    
    /******
     * User Settings
     ******/
    System.prototype.userSettings = function(dialog, systemSelf) {
        //dialog.data.append('<div class="dialog_message">Not implemented.</div>');
        systemSelf = systemSelf || this;
        systemSelf.getUserUpdates({replytarget: dialog.container});
        dialog.data.append(systemSelf.getUserSettingsHtml());
    };
    
    System.prototype.showUserSettings = function(dialog, systemSelf) {
        dialog.container.on('click', '.usersettings-buy', function(event) {
            event.stopPropagation();
            var product = $(this).attr('data-product');
            var waiter = dialog.container.find('.usersettings-waitspinner');
            waiter.addClass('visible-wait');
            systemSelf.openInExternalBrowser(systemSelf.getWebshopLink(product));
            setTimeout(function(){waiter.removeClass('visible-wait')}, 3000);
        });
        dialog.container.on('userupdatesready', function(event) {
            event.stopPropagation();
            dialog.data.find('.sm-content-container').remove();
            dialog.data.append(systemSelf.getUserSettingsHtml())
        });
    };
    
    /******
     * Offline use
     ******/
    System.prototype.useOffline = function(username) {
        this.config.user.username       = username;
        this.config.user.dontPromptUser = true;
        this.place.trigger('saveusersettings.system');
        jQuery.modal.close();
        //TODO: Make some kind of notification that user can login later 
        //this.notify("setUserinfoLater");
        this.place.trigger('initialized.system');
    }
    
    /**
     * Check if some things are going to expire soon (subscription, quota, etc)
     */
    System.prototype.checkExpirations = function() {
        var expires = this.config.library.expires;
        var now = (new Date()).getTime();
        var exptime, timediff, expnotif;
        if (expires) {
            exptime = (new Date(expires)).getTime();
            timediff = Math.floor((exptime - now) / (24 * 60 * 60 * 1000));
            if (timediff < 15) {
                expnotif = {
                    id: 'endofsubscriptionnear',
                    nclass: 'information',
                    message: 'system:subscription_expires_soon',
                    localizable: true,
                    data: {
                        event: 'usersettingsopen'
                    }
                };
                if (timediff < 5) {
                    expnotif.nclass = 'warning';
                };
                this.notify(expnotif);
            };
        };
        var cexpires = this.config.library.checker_quota_expires;
        if (cexpires) {
            exptime = (new Date(cexpires)).getTime();
            timediff = Math.floor((exptime - now) / (24 * 60 * 60 * 1000));
            if (timediff < 15) {
                expnotif = {
                    id: 'checkquotaexpirationnear',
                    nclass: 'information',
                    message: 'system:checking_quota_expiring',
                    localizable: true,
                    data: {
                        event: 'usersettingsopen'
                    }
                };
                if (timediff < 5) {
                    expnotif.nclass = 'warning';
                };
                this.notify(expnotif);
            };
        };
        var quota = this.config.library.checker_quota_left | 0;
        if (quota > 0 && quota < 15) {
            expnotif = {
                id: 'endofquotanear',
                nclass: 'information',
                message: 'system:checking_quota_low',
                localizable: true,
                data: {
                    event: 'usersettingsopen'
                }
            };
            if (quota < 5) {
                expnotif.nclass = 'warning';
            };
            this.notify(expnotif);
        };
    };
    
    /******
     * Draw the systen on the screen.
     ******/
    System.prototype.draw = function() {}
    /******
     * Empty systemscreen
     ******/
    System.prototype.emptyScreen = function() {
        this.place.empty();
    }
    /******
     * Draw notification
     ******/
    System.prototype.drawNotification = function() {
        // Find or create notification area.
        this.notificationArea = jQuery("#notificationArea").length?
            jQuery("#notificationArea")
                :
        this.place.append("<div id=\"notificationArea\"><span class=\"currentMsg\"></span><span class=\"msgArchive\"></span></div>").find("#notificationArea");        
    }
    
    /******
     * Draw the systen on the screen.
     ******/
    System.prototype.drawLayout = function() {
        var systemSelf = this;
                
        //Application header
        this.header = jQuery("#applicationHeader").length?
            jQuery("#applicationHeader")
                :
            this.place.append("<div id=\"applicationHeader\"></div>").find("#applicationHeader");
        this.drawContainer(this.header, this.config.themetemplate.header.containers);
        if(this.config.themetemplate.header.icons && this.config.themetemplate.header.icons.length){
            this.drawIcons(this.header, this.config.themetemplate.header.icons);
        }
        if(this.header.find('.applicationHeader').length > 0){
            try{
                if(this.config.system.headerText && this.config.system.headerText[this.config.general.uilang]){
                    var appHeaderText = this.config.system.headerText[this.config.general.uilang];
                }else if(this.config.system.headerText && this.config.system.headerText['en']){
                    var appHeaderText = this.config.system.headerText['en']
                }else{
                    var appHeaderText = (this.defaulParameters.config.system.headerText[this.config.general.uilang]?this.defaulParameters.config.system.headerText[this.config.general.uilang]:this.defaulParameters.config.system.headerText['en']);
                }
            }catch(e){
                console.log("appHeaderTextError",e);
                var appHeaderText = "ViRum Application";
            }
            
            this.header.find('.applicationHeader').text(appHeaderText);
        }
        //Application control
        this.appControl = jQuery("#applicationControl").length?
            jQuery("#applicationControl")
                :
            this.place.append("<div id=\"applicationControl\"></div>").find("#applicationControl");
        //Footer
        this.footer = jQuery("#applicationFooter").length?
            jQuery("#applicationFooter")
                :
            this.place.append("<div id=\"applicationFooter\"></div>").find("#applicationFooter");
        this.drawContainer(this.footer, this.config.themetemplate.footer.containers);
        //DialogArea
        this.dialogArea = jQuery(".dialogArea").length?
            jQuery(".dialogArea")
                :
            this.place.append("<div class=\"dialogArea\"></div>").find(".dialogArea");
        this.drawSettingsmenu();
    }
    
    /******
     * Draw icons to container
     ******/
    System.prototype.drawIcons = function(containerplace,icons) {
        for(var i=0;i<icons.length;i++){
            containerplace.find(icons[i].appendplace).append(icons[i].icondata);
        }
    }
    
    /******
     * Draw content to container
     ******/
    System.prototype.drawContainer = function(containerplace,content) {
        for(var i=0;i<content.length;i++){
            var appendElement = jQuery("<"+content[i].HTMLtype+">");
            if(content[i].id){
                appendElement.attr("id",content[i].id);
            }
            if(content[i].title){
                appendElement.attr("id",content[i].title);
            }
            for(var j=0;j<content[i].classes.length;j++){
                appendElement.addClass(content[i].classes[j]);
            }
            containerplace.append(appendElement);
            if(content[i].containers && content[i].containers.length){
                this.drawContainer(appendElement,content[i].containers);
            }
        }
    }
    /******
     * Draw settingsmenu
     ******/
    System.prototype.drawSettingsmenu = function() {
        //append settingsmenu
        var appendPlace = jQuery(".settingsMenu");
        appendPlace.append('<span class="settingsIcon">'+
                (this.config.themetemplate.templateicons && this.config.themetemplate.templateicons.settingsIcon?this.config.themetemplate.templateicons.settingsIcon:'<svg xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="3 3 44 44" class="defaultsettingsicon"><path stroke="none" fill="white" d="M21 6 a20 20 0 0 1 10 0 a3 6 22.5 0 0 5.3 2.2 a20 20 0 0 1 7 7 a3 6 67.5 0 0 2.2 5.3 a20 20 0 0 1 0 10 a3 6 112.5 0 0 -2.2 5.3 a20 20 0 0 1 -7 7 a3 6 157.5 0 0 -5.3 2.2 a20 20 0 0 1 -10 0 a3 6 -157.5 0 0 -5.3 -2.2 a20 20 0 0 1 -7 -7 a3 6 -112.5 0 0 -2.2 -5.3 a20 20 0 0 1 0 -10 a3 6 -67.5 0 0 2.2 -5.3 a20 20 0 0 1 7 -7 a3 6 -22.5 0 0 5.3 -2.2z m5 13 a7 7 0 0 0 0 14 a7 7 0 0 0 0 -14z"></path><path stroke="none" fill="black" d="M20 5 a20 20 0 0 1 10 0 a3 6 22.5 0 0 5.3 2.2 a20 20 0 0 1 7 7 a3 6 67.5 0 0 2.2 5.3 a20 20 0 0 1 0 10 a3 6 112.5 0 0 -2.2 5.3 a20 20 0 0 1 -7 7 a3 6 157.5 0 0 -5.3 2.2 a20 20 0 0 1 -10 0 a3 6 -157.5 0 0 -5.3 -2.2 a20 20 0 0 1 -7 -7 a3 6 -112.5 0 0 -2.2 -5.3 a20 20 0 0 1 0 -10 a3 6 -67.5 0 0 2.2 -5.3 a20 20 0 0 1 7 -7 a3 6 -22.5 0 0 5.3 -2.2z m5 13 a7 7 0 0 0 0 14 a7 7 0 0 0 0 -14z"></path></svg>')+
                '</span>'+
                '<span class="closeSettings">'+
                (this.config.themetemplate.templateicons && this.config.themetemplate.templateicons.defaultsettingscloseicon?this.config.themetemplate.templateicons.defaultsettingscloseicon:'<span class="defaultsettingscloseicon">X</span>')
                +'</span></span>');
        
        //Settings menu
        appendPlace.append("<ul class=\"applicationSettings\"></ul>");
        for (var i = 0; i < this.settingsMenu.length; i++) {
            if (!this.inDemoMode || this.menuInDemo.indexOf(this.settingsMenu[i].type) !== -1) {
                if (this.localizer.isTranslated("system:" + this.settingsMenu[i].type)) {
                    var typeText = this.localizer.localize("system:"+this.settingsMenu[i].type);
                } else {
                    var typeText = this.settingsMenu[i].text
                };
                appendPlace.find(".applicationSettings").append("<li class=\"applicationButton\" settingstype=\""+this.settingsMenu[i].type+"\" textkey=\""+this.settingsMenu[i].text+"\">"+typeText+"</li>");
            }
            
        }
    }    
    /******
     * Draw settingsmenu
     ******/
    System.prototype.applicationLogo = function() {
        //append settingsmenu
        var appendPlace = this.footer;
        if(this.config.general.theme.template === "1"){
            appendPlace = this.header;
        }
        appendPlace.append('<span class=\"logoImage\"></span>');
    }
    
    /******
     * Append to system areas
     ******/
    System.prototype.appendToAreas = function(options) {
    }
    /******
     * Disactive connectionhandler with server
     ******/
    System.prototype.disactiveServerConnection = function(type){
        try{
            jQuery('.simplemodal-container .serverconnection.dialog_message').removeClass('show');
        }catch(err){
            
        }
        type = type.replace(/^connection-/,"");
        this.place.off('connection-'+type);
    }
    /******
     * Connection with server
     ******/
    System.prototype.activeServerConnection = function(typeid, data, relay, connectionkey) {
        var connectionid = typeof(connectionkey) !== "undefined" ? connectionkey : typeid
        var systemSelf = this;
        this.place.off('connection-' + connectionid).on('connection-' + connectionid, function(e, data) {
            systemSelf.serverResponse(data, relay);
            systemSelf.disactiveServerConnection('connection-' + connectionid);
        });
        try {
            jQuery('.simplemodal-container .serverconnection.dialog_message').addClass('show');
        } catch(err) {
            
        }
        this.connectionHandler.serverConnection(typeid, data, this.place, connectionid);
    }
     
    /******
     * Action after Server response by type
     ******/

    System.prototype.serverResponse  = function(data, relayData){
        if (this.debugmode) {
            console.log((!data.success?"Server-error!\nError:":"Success-server\nData:"), data, "\nRelay:", relayData);
        };
        jQuery('.serverconnection.dialog_message').removeClass('show');
        var systemSelf = this;
        if (!data.success && data.errortype == 11){
            this.sendAmount = 0;
            if(this.dialogelement){
                this.dialogelement.close();
            };
            jQuery.modal.close();
            systemSelf.place.trigger('NO_SERVICETIME_error');
            return false;
        }
        if(!data.success && data.errortype == 12){
            this.sendAmount = 0;
            if(this.dialogelement){
                this.dialogelement.close();
            }
            jQuery.modal.close();
            systemSelf.place.trigger('EULA_NOT_ACCEPTED_error');
            return false;
            
            
        }
        if(!data.success && data.errortype == 13 && !systemSelf.promptServiceExpiredError){
            this.sendAmount = 0;
            if(this.dialogelement){
                this.dialogelement.close();
            }
            jQuery.modal.close();
            
        }
        switch(data.requesttype){
            case "login":
                if(!data.success){
                    jQuery('#usersettings').trigger('login-error',data);
                } else {
                    if (this.loginPoll) {
                        clearTimeout(this.loginPoll);
                    };
                    if (this.dialogelement) {
                        this.dialogelement.close();
                    } else {
                        jQuery.modal.close();
                        
                    };
                    this.fileSystem.writeManifest(data.applicationkey,this.debugmode);
                    this.saveUser(data ,'checkUpdates.system');
                }
            break;
            case "getupdates":
                var dialogPlace = jQuery('#getupdates');
                if(!data.success){
                    dialogPlace.trigger('server-error',data);
                }else{
                    //move timestamp updating later
                    // for now here so broken updates don't break loop
                    dialogPlace.trigger('updating');
                    var updateelements = JSON.parse(data.originalData.updatefor);
                    if (data.contentinfo && data.contentinfo.length ){
                        this.processContentInfos(data.contentinfo);
                    }
                    var updatestatus = this.fileSystem.processUpdates(data, dialogPlace, jQuery.extend(true, {}, this.config.updatehadling, {place: this.place}));
                    this.updateLastupdateTimes(data.updated, updateelements, updatestatus);
                    this.place.trigger('savesettings.system');
                    if (data.libraryupdate) {
                        systemSelf.processLibraryUpdates(data.libraryupdate);
                    };
                    if (!this.config.user.dontShowFirstrun) {
                        this.openWelcomeUser();
                    };
                    this.checkExpirations();
                }
            break;
            case "addcontent":
            case "addpendingcontentupdates":
                this.sendAmount--;
                if (!data.success){
                    this.place.trigger('server-error',data);
                    if (this.state !== "started" && this.state !== 'loadsettings') {
                        if (data.errortype === 9) {
                            var ddata = {};
                            try {
                                ddata = JSON.parse(data.originalData.updatefor);
                            } catch (err) {};
                            if (data.requesttype === 'addpendingcontentupdates') {
                                this.removeUnsendable(relayData.contentkey, 'contentupdates');
                            };
                        };
                        if ((data.errortype === 13 || this.sendAmount === 0)){
                            this.sendAmount = 0;
                            this.forceCloseDialog();
                            this.loadSettings();
                        };
                    }
                }else{
                    /*TODO: 
                        - trigger send-ready event informing that send was success
                        - remove converter                    
                    */
                    var converter = {
                        "notebook": "own_notes"
                    }
                    if(data.requesttype === "addpendingcontentupdates"){
                        this.moveSendingdataSent(relayData.contentkey, 'contentupdates');
                        if(this.sendAmount === 0) {
                            this.forceCloseDialog();
                            this.loadSettings();
                        }
                    } else {
                        this.moveSendingdataSent(relayData.connid, 'contentupdates');
                        if (typeof(relayData.callbackEvent) !== "undefined"){
                            console.log('FIX THIS');
                        };
                        if (typeof(relayData.callbackdata) !== "undefined"){
                            if (typeof(relayData.callbackdata.callbacktype) !== "undefined"){
                                if (relayData.callbackdata.callbacktype === "jQuery"){
                                    try {
                                        relayData.callbackdata.callbackTarget.ownerDocument.defaultView.$(relayData.callbackdata.callbackTarget).trigger(relayData.callbackdata.callbackEvent, jQuery.extend(true, {}, relayData, {'success':true}));
                                        
                                    }catch(err){}
                                }
                            }
                        }
                        
                    }
                }
            break;
            case "addcontentinfo":
            case "addpendingcontentinfo":
                if(this.sendAmount > 0)this.sendAmount--;
                if(!data.success){
                    this.place.trigger('server-error',data);
                    console.log('server-error',data,this.sendAmount);
                    if(data.requesttype == "addpendingcontentinfo" && data.errortype ==13){
                        this.sendAmount=0;
                        this.forceCloseDialog();
                        this.loadSettings();
                        return false;
                    }
                    if(data.requesttype == "addpendingcontentinfo" && this.sendAmount===0){
                        this.sendPendingContentupdates();
                    }
                }else{
                    /*TODO: 
                        - trigger send-ready event informing that send was success                  
                    */
                    if(data.requesttype ==="addpendingcontentinfo"){
                        this.moveSendingdataSent(relayData.contentkey,'contentinfo');
                        if(this.sendAmount===0){
                            this.sendPendingContentupdates();
                        }
                    }else{
                        this.moveSendingdataSent(relayData.contexttype+relayData.contextid,'contentinfo');
                    }
                    this.clearPendingContext({contexttype:relayData.contexttype,contextid:relayData.contextid});
                    this.markServersync({contexttype:relayData.contexttype,contextid:relayData.contextid});

                }
                if(relayData.event && relayData.originalTarget){
                    systemSelf.triggerEvent(
                        relayData.event,
                        data,
                        relayData.originalTarget,
                        "jQuery",
                        true);
                }
                
            break;
            case "getcontentinfo":
                var dataToSend = {localdata:relayData.localdata}; 
                if(!data.success){
                    this.place.trigger('server-error',data);
                    console.log('server-error',data);
                    dataToSend['serverdata'] = [];//No content from server because of servererror
                    jQuery.extend(dataToSend,data);
                }else{
                    dataToSend['serverdata'] = this.contentExist(relayData.contenttype,data.availablecontent).notexist;
                }
                this.triggerEvent(relayData.callback.event,dataToSend,relayData.callback.target,relayData.callback.callbacktype);
            break;
            case "getimportupdates":
                if(!data.success){
                    this.place.trigger('server-error',data);
                    console.log('server-error',data);
                    systemSelf.triggerEvent(doafterData.callbackEvent,{"success":false},doafterData.callbackTarget,doafterData.callbackType);
                    
                }else{
                    this.updateLastupdateTimes(data.updated,JSON.parse(data.originalData.updatefor));
                    this.place.trigger('savesettings.system');
                    var doafterData = relayData;
                    this.place.off('getimportupdates_done').on('getimportupdates_done',function(){
                        systemSelf.triggerEvent(doafterData.callbackEvent,{"success":true},doafterData.callbackTarget,doafterData.callbackType,true);
                        systemSelf.place.off('getimportupdates_done');
                    });
                    if(data.contentinfo && data.contentinfo.length ){
                        this.processContentInfos(data.contentinfo);
                    };
                    this.fileSystem.processUpdates(data,this.place,jQuery.extend(true,{},this.config.updatehadling,{place:this.place}));
                    // this.triggerEvent(relayData.callbackEvent,{},relayData.callbackTarget,relayData.callbackType);
                }
            break;
            case "getrequestedupdates":
                if (!data.success){
                    this.place.trigger('server-error',data);
                    console.log('server-error',data);
                    //TODO:replay to client that server have some issues
                } else {
                    if (data.contentinfo && data.contentinfo.length ) {
                        var comparation = this.compareContentInfos(data.contentinfo);
                        if (!jQuery.isEmptyObject(comparation)) {
                            systemSelf.triggerEvent("info_changed",
                                [{info_changed: comparation, info: relayData.requestdata}],
                                relayData.requestdata.originalTarget,
                                relayData.requestdata.callbacktype,
                                true
                            );
                        };
                        this.processContentInfos(data.contentinfo);
                    };
                    if (data.contentupdate && data.contentupdate.length) {
                        var doafterData = relayData.requestdata;
                        this.place.off('getrequestedupdates_done').on('getrequestedupdates_done', function() {
                            systemSelf.updateLastupdateTimes(data.updated, JSON.parse(data.originalData.updatefor));
                            systemSelf.place.trigger('savesettings.system');
                            var returnData =[];
                            for (var i = 0; i < data.contentupdate.length; i++) {
                                returnData.push(JSON.parse(data.contentupdate[i].data));
                            };
                            systemSelf.triggerEvent(doafterData.callbackEvent, [returnData], doafterData.originalTarget, doafterData.callbacktype, true);
                            systemSelf.place.off('getrequestedupdates_done');
                        });
                        this.fileSystem.processUpdates(data, this.place, jQuery.extend(true, {}, this.config.updatehadling, {place: this.place}));
                    };
                    if (data.libraryupdate) {
                        systemSelf.processLibraryUpdates(data.libraryupdate);
                    };
                };
            break;
            case "registergroup":
                if(!data.success){
                    this.place.trigger('server-error',data);
                    console.log('server-error',data,"relay",relayData);
                }else{
                    systemSelf.triggerEvent(
                        relayData.callbackevent,
                        jQuery.extend(true,{},relayData,{"success":data.success,"startdata":(data.startdata?data.startdata:[])}),
                        relayData.returnTarget,
                        relayData.callbacktype,
                        true);
                }
                
                
            break;
            case "getstartdata":
                if(!data.success){
                    this.place.trigger('server-error',data);
                    console.log('server-error',data,"relay",relayData);
                }
                systemSelf.triggerEvent(
                    relayData.callbackevent,
                    jQuery.extend(true,{},relayData,{"success":data.success,"startdata":(data.startdata?data.startdata:[])}),
                    relayData.returnTarget,
                    relayData.callbacktype,
                    true);
                
            break;
            case "sendstartdata":
                if(!data.success){
                    this.place.trigger('server-error',data);
                    console.log('server-error',data);
                    systemSelf.triggerEvent(
                        relayData.event,
                        data,
                        relayData.originalTarget,
                        'jQuery',
                        true);
                }else{
                    relayData.sendStartdata = false;
                    this.place.trigger('createNewContent.system',relayData);
                }
            break;
            case "getupdatesafterregisteration":
                if(!data.success){
                    this.place.trigger('server-error',data);
                    console.log('server-error',data);
                }else{
                    if(data.contentinfo && data.contentinfo.length){
                        this.processContentInfos(data.contentinfo);
                    }
                    var updateelements = JSON.parse(data.originalData.updatefor);
                    this.fileSystem.processUpdates(data,systemSelf.place,jQuery.extend(true,{},this.config.updatehadling,{place:this.place}));
                    this.updateLastupdateTimes(data.updated,updateelements);
                    this.place.trigger('savesettings.system');
                    
                };
                systemSelf.triggerEvent(
                    relayData.callbackEvent,
                    {"success":(data.success)},
                    relayData.returnTarget,
                    relayData.callbacktype,
                    true);
            break;
            case "getEULA":
                if(!data.success){
                    this.place.trigger('server-error',data);
                    console.log('server-error',data);
                }else{
                    var iframe = jQuery("#EULAaccept .container .eulatext").empty().append('<iframe style="width:90%; height: 100%; margin-left: 3em;" ></iframe>').find('iframe');
                    iframe.contents()[0].write(data.eulatext);
                }
            break;
            case "accectEula":
                if(!data.success){
                    this.place.trigger('server-error',data);
                    console.log('server-error',data);
                }else{
                    this.place.trigger('reloadSystem.system');
                }
            break;
            case "getuserupdates":
                var dialogPlace = relayData.replytarget || jQuery('#usersettings');
                if (!data.success) {
                    dialogPlace.trigger('server-error',data);
                } else {
                    if (data.libraryupdate) {
                        systemSelf.processLibraryUpdates(data.libraryupdate);
                    };
                    dialogPlace.trigger('userupdatesready');
                }
                this.checkExpirations();
                break;
            default:
                console.log("No handler for type:",data.requesttype,"\nData:",data,"\nrelaydata:",relayData);
            break;
        }
    } 
    
    /******
     * 
     ******/
    System.prototype.getStartdata = function(data) {
            this.activeServerConnection(
                "getstartdata",
                {
                    type:16,
                    username:this.config.user.username,
                    appkey:this.config.user.applicationkey,
                    contexttype:data.contexttype,
                    contextid :data.contextid
                },
                data
                ,
                data.contexttype+data.contextid+"getstartdata"
            );
        
    }
    /******
     * 
     ******/
    System.prototype.registerContentgroup = function(data) {
            this.activeServerConnection(
                "registergroup",
                {
                    type: 9,
                    username: this.config.user.username,
                    appkey: this.config.user.applicationkey,
                    contexttype: data.contexttype,
                    contextid: data.contextid,
                    contextkey: data.contextkey,
                },
                data
                ,
                data.contexttype+data.contextid+"greg"
            );
        
    }
    /******
     * Get content updates when importing content from the server.
     ******/
    System.prototype.getImportUpdates = function(contentlist,callback) {
        this.getServerUpdates('getimportupdates', [], contentlist,callback);
    }
    /******
     * 
     ******/
    System.prototype.getContentAfterRegister = function(data) {
        this.getServerUpdates('getupdatesafterregisteration',[],[{"contexttype":data.contexttype,lastupdate:"0",contextid:[data.contextid]}],data);
    }
    
    /******
     * Get system updates and content updates from the server.
     ******/
    System.prototype.getUpdates = function(dialog,systemSelf) {
        if(typeof(systemSelf) ==="undefined") systemSelf = this;
        systemSelf.getServerUpdates(
            'getupdates',
            systemSelf.systemUpdatesList(),
            systemSelf.contentUpdatesList(),
            {}
        );
    }
    
    /**
     * Get updates for user and library data.
     */
    System.prototype.getUserUpdates = function(callbackdata) {
        this.getServerUpdates('getuserupdates', [], [], callbackdata || {}); // No systemupdates, no contentupdates
    };
    
    /******
     * Get requested updates from the server.
     ******/
    System.prototype.getRequestUpdates = function(content, callbackdata) {
        this.getServerUpdates('getrequestedupdates', [], this.updateList(content.contexttype, [content.contextid], this.config.system.lastupdates), callbackdata);
    }
        
    /******
     * Get updates from the server.
     ******/
    System.prototype.getServerUpdates = function(updateidentifier, systemupdatelist, contentupdatelist, callbackdata) {
        this.activeServerConnection(updateidentifier,{
            type: 3,
            username: this.config.user.username,
            appkey: this.config.user.applicationkey,
            lastupdate: this.config.system.lastupdate,
            updatefor: JSON.stringify({
                system: systemupdatelist,
                content: contentupdatelist
            })
        },(typeof(callbackdata) !== "undefined" ? callbackdata : {}));
    };
    /******
     * Send content to the server.
     * 
     ******/
    System.prototype.sendContent = function(sendData) {
        
        var onesend;
        this.sendAmount += sendData.sentdata.sentdatalist.length;
        for(var i=0;i<sendData.sentdata.sentdatalist.length;i++){
            onesend={
                callbackdata:sendData.sendCallbackData,
                data:sendData.sentdata.sentdatalist[i]
            };
            this.sendContentToServer(onesend);
        }
    }
    /******
     * Get available contentinfos from server.
     ******/
    System.prototype.getServerContent = function(infodata) {
        var systemSelf = this;
        //to make sure that contenttype is set right
        // TODO: remove when dataformat is finally
        var ctype = typeof(infodata.servercontenttype) !== "undefined"?infodata.servercontenttype:this.convertcontenttype('getcontentinfo',infodata.contenttype);
        systemSelf.activeServerConnection('getcontentinfo',{
                    type:8,
                    username     : systemSelf.config.user.username,
                    appkey       : systemSelf.config.user.applicationkey,
                    contenttype  : ctype,                                   //old implementation
                    contexttype  : ctype,                                   //new implementation
                    typeasstring : 'getcontentinfo'
                    
                },
                infodata);
    }

    
    /******
     * Send content to the server.
     ******/
    System.prototype.sendContentToServer = function(send) {
        /**********************
        **********************/
        if(typeof(systemSelf) === "undefined") systemSelf = this;
        var dataToServer = {
                type:5,
                username:systemSelf.config.user.username,
                appkey:systemSelf.config.user.applicationkey,
                updatefor :JSON.stringify(send.data),
                typeasstring:"sendcontent_"+send.data.datatype  ,
                datamodified: send.data.datamodified
            };
        var uniquekey = send.data.contexttype+send.data.contextid+send.data.dataid;
        this.markSendingData('addcontent',uniquekey,dataToServer,send,'contentupdates');
        send.connid = uniquekey;
        systemSelf.activeServerConnection('addcontent',dataToServer,send,uniquekey);
    }    
    /******
     * Send content to the server.
     ******/
    System.prototype.sendContentToServer2 = function(send) {
        /**********************
        * TODO:
        * CONVERSION for data JSON key 
        * Remove when data-format is finally fixed 
        * and apps like notebook sends correct keys
        **********************/
        
        
        var updateType ={
            "notebook":"own_notes",
            "owndata":"own_notes"
        },changedClass;
        if(send.data.apptype ==="notebook" && typeof(send.data.dataclass)!=="undefined" && send.data.dataclass ==="owndata"){
            changedClass = "own_notes";
        }
        try{
            var datamodified = (typeof(send.data.datamodified) !=="undefined" ?send.data.datamodified : send.data.data.contentdata.metadata.modified);
        }catch(e){
            console.log("Error parsing datamodified",e);
            var datamodified = new Date();
        }
        if(typeof(systemSelf)==="undefined") var systemSelf = this;
        var updateData ={
            "updatetype"       :   send.data.updatetype, 
            "updateid"         :   send.data.updateid,
            "dataid"           :   send.data.dataid,
            "data"             :   JSON.stringify(send.data.data),
            "pubtype"          :   (typeof(send.data.pubtype)==="undefined" ? "own" : (send.data.pubtype ==="group"?"all":send.data.pubtype)),          
            "public_to_id"     :   (typeof(send.data.public_to)==="undefined" || send.data.pubtype !=="user" ? null : send.data.public_to),          
            "dataclass"        :   (typeof(send.data.dataclass) !=="undefined"?(typeof(changedClass) !== "undefined"?changedClass:send.data.dataclass):"own_notes"),     
            "datatype"         :   (typeof(send.data.datatype)==="undefined" ? "owndata" : send.data.datatype),     
            "contentid"        :   (typeof(send.data.containerid) !=="undefined"?send.data.containerid:send.data.updateid),          
            "datamodified"     :   datamodified
        };
        var dataToServer = {
                "type"         : 5,
                "username"     : systemSelf.config.user.username,
                "appkey"       : systemSelf.config.user.applicationkey,
                "updatefor"    : JSON.stringify(updateData),
                "typeasstring" : "sendcontent_"+send.type  ,
                "datamodified" : datamodified
            };
        var uniquekey = updateData.updatetype+updateData.updateid+updateData.dataid;
        this.markSendingData('addcontent',uniquekey,dataToServer,send,'contentupdates');
        send.connid = uniquekey;
        systemSelf.activeServerConnection('addcontent',dataToServer,send,uniquekey);
    }
    /******
     * Send contentinfo to the server.
     ******/
    System.prototype.sendStartDataToServer = function(send) {
        if(typeof(systemSelf)==="undefined") var systemSelf = this;
        var updateData = send.serverdata || send.data;
        var uniquekey = "sendStartData_"+updateData.contexttype+updateData.contextid;
        var dataToServer = {
                type: 15,
                username        : systemSelf.config.user.username,
                appkey          : systemSelf.config.user.applicationkey,
                startdataobject :  JSON.stringify({
                    "data": JSON.stringify(send.startdata),
                    "dataid": "startdata_"+updateData.contexttype+updateData.contextid,
                    "contexttype": updateData.contexttype
                }),
                typeasstring    : "sendstartdata_"+uniquekey  ,
                datamodified    : send.serverdata.timestamp
            };
        //TODO:
        //- is data need to be stored somewhere
        //var connid = 
        //this.markSendingData('addcontentinfo',uniquekey,dataToServer,send,'contentinfo');
        //this.markPendingContext({contexttype:updateData.contexttype,contextid:updateData.contextid});
        send.connid = uniquekey;
        systemSelf.activeServerConnection('sendstartdata',dataToServer,send,uniquekey);
    }
    /******
     * Send contentinfo to the server.
     ******/
    System.prototype.sendContentinfoToServer = function(send) {
        if(typeof(systemSelf)==="undefined") var systemSelf = this;
        var updateData = send.serverdata || send.data;
        var dataToServer = {
                type:7,
                username     : systemSelf.config.user.username,
                appkey       : systemSelf.config.user.applicationkey,
                contentinfo  : JSON.stringify(updateData),
                typeasstring : "sendcontentinfo_"+send.type  ,
                datamodified : send.serverdata.timestamp
            };
        var uniquekey = "sendcontentinfo_"+updateData.contexttype+updateData.contextid;
        var connid = this.markSendingData('addcontentinfo',updateData.contexttype+updateData.contextid,dataToServer,send,'contentinfo');
        this.markPendingContext({contexttype:updateData.contexttype,contextid:updateData.contextid});
        send.connid = uniquekey;
        systemSelf.activeServerConnection('addcontentinfo',dataToServer,send,uniquekey);
    }
    /******
     * 
     ******/
    System.prototype.markPendingContext = function(datakey) {
        if(this.inDemoMode) return true;
        this.config.updatehadling.pendingcontexts.push(datakey);
        this.place.trigger('saveupdatesettings.system');
    }
    /******
     * 
     ******/
    System.prototype.clearPendingContext = function(datakey) {
        var systemSelf = this;
        this.config.updatehadling.pendingcontexts.forEach(function(value,index){
            if(value.contexttype === datakey.contexttype && value.contextid === datakey.contextid){
                systemSelf.config.updatehadling.pendingcontexts.splice(index,1);
                systemSelf.place.trigger('saveupdatesettings.system');
                return false;
            }
        });
    }
    /******
     * 
     ******/
    System.prototype.isPendingContext = function(datakey) {
        var founded = false;
        this.config.updatehadling.pendingcontexts.forEach(function(value,index){
            if(value.contexttype === datakey.contexttype && value.contextid === datakey.contextid){
                founded = true;
                return false;
            }
        });
        return founded;
    }
    /******
     * 
     ******/
    System.prototype.makeContentInfochanges = function(data) {
        var contextTochange= this.config.content[data.contexttype][data.contextid];
        for(var i=0;i<data.data.length;i++){
            this.makeOneContentInfochange(contextTochange,data.data[i]);
        }
        this.place.find('[appcontexttype="'+data.contexttype+'"]').trigger('refreshview');
        this.place.trigger('savecontentsettings.system');
    }
    /******
     * Check what to do with contentinfo change
     * different functionality to edit, add, remove and replace contentinfo data
     ******/
    System.prototype.makeOneContentInfochange = function(contextinfo,changedata) {
        switch(changedata.chtype){
            case "edit":
                jQuery.extend(contextinfo,changedata.data);
            break;
            case "add":
            case "remove":
            case "replace":
            break;
            default:
            break;
        }
    }
    /*******
    *
    *******/
    System.prototype.markServersync = function(datakey){
        console.log('markServersync',datakey);
        try{
            this.config.content[datakey.contexttype][datakey.contextid].serversync = true;
            this.place.trigger('savecontentsettings.system');
            //TODO:triggerinfo to all windows also
        }catch(err){
            console.log("markServersync error",err);
        }
    }
    
    /******
     * 
     ******/
    System.prototype.markSendingData = function(type,datakey,dataToServer,originalsend,datatype) {
        // if(this.inDemoMode) return true;
        this.config.updatehadling[datatype].sending[datakey] = 
            {
                servertexttype:'addcontent',
                serverData:dataToServer          
            };
        this.sessionSend[datatype][datakey] = 
            {
                servertexttype:'addcontent',
                serverData:dataToServer,
                originalsend:originalsend            
            };
        this.place.trigger('saveupdatesettings.system');
    }
    
    /******
     * 
     ******/
    System.prototype.moveSendingdataSent = function(updatekey, type) {
        if (this.inDemoMode) {
             this.config.updatehadling[type].sent.push(updatekey + this.config.updatehadling[type].sending[updatekey].serverData.datamodified);
        } else {
            if (typeof(this.config.updatehadling[type].sending[updatekey]) !== "undefined"){
                this.config.updatehadling[type].sent.push(updatekey + this.config.updatehadling[type].sending[updatekey].serverData.datamodified);
            };
        };
        
        delete this.config.updatehadling[type].sending[updatekey];
        delete this.sessionSend[type][updatekey];
        if(this.sendAmount ===0 || this.sendAmount < 0){
            if(this.sendAmount <0) this.sendAmount = 0;
            this.place.trigger('saveupdatesettings.system');
        }
    }
    
    /**
     * Remove unsendable data from send queue
     */
    System.prototype.removeUnsendable = function(updatekey, type) {
        if (typeof(this.config.updatehadling[type].unsendable) === 'undefined') {
            this.config.updatehadling[type].unsendable = {};
        };
        if (typeof(this.config.updatehadling[type].sending[updatekey]) !== 'undefined') {
            this.config.updatehadling[type].unsendable[updatekey] = this.config.updatehadling[type].sending[updatekey];
            delete this.config.updatehadling[type].sending[updatekey];
        };
        this.place.trigger('saveupdatesettings.system');
    };
    
    /******
     * local save And Send Content to server
     ******/
    System.prototype.saveAndSendContent = function(sendData) {
        var onesend;
        this.sendAmount += sendData.saveContentData.contentData.length;
        for(var i=0;i<sendData.saveContentData.contentData.length;i++){
            onesend={
                callbackEvent:sendData.callbackEvent,
                callbackTarget: sendData.returnTarget,
                type:sendData.saveContentData.type,
                id:sendData.saveContentData.id,
                data:sendData.saveContentData.contentData[i]
            };
            
            this.sendContentToServer(onesend);
        }
        sendData.returnTarget.ownerDocument.defaultView.$(sendData.returnTarget).trigger('saveContentNotified');
    }
    
    /******
     * Build one update info list
     ******/
    System.prototype.updateList = function(type,files,times) {
        var returnList = [];
        for(var i=0;i<files.length;i++){
            returnList.push({
                "contextid":[files[i]], //new implementation
                "contexttype":type,     //new implementation
                "updateid":[files[i]],  //old implementation
                "updatetype":type,      //old implementation
                "lastupdate":
                    (times[type] && times[type][files[i]]?
                        times[type][files[i]]  :  "0")
                })
        }
        return returnList;
    }
    
    /******
     * Build system update info
     ******/
    System.prototype.systemUpdatesList = function() {
        if(typeof(systemSelf)==="undefined") var systemSelf = this;
        var updateTimes = systemSelf.config.system.lastupdates;
        return [].concat(
            this.updateList('system',systemSelf.config.system.includeSystem,updateTimes),
            this.updateList('plugin',systemSelf.config.system.includePlugings,updateTimes),
            this.updateList('application',systemSelf.config.system.includeApplications,updateTimes)
        )
    }
    
    /******
     * Build content update info
     * TODO: make with id not filename if id attribute exists
     ******/
    System.prototype.contentUpdatesList = function() {
        if(typeof(systemSelf)==="undefined") var systemSelf = this;
        var contentupdates = [];
        var updateTimes = this.config.system.lastupdates;
        for(var key in this.config.content){
            var contentfilelist=[];
            for(var onecontent in this.config.content[key]){
                contentfilelist.push(this.config.content[key][onecontent].id);
            }
            contentupdates = contentupdates.concat(this.updateList((this.contentupdatetypes[key]?this.contentupdatetypes[key]:key),contentfilelist,updateTimes));
        }
        return contentupdates;
    }
    
    /******
     * Update lastupdateTimes
     * -TODO: times for content also
     ******/
    System.prototype.updateLastupdateTimes = function(newTime,requestedfor,updatestatus){
        console.log(newTime,requestedfor,updatestatus);
        for(var updateTypes in requestedfor){
            var updatesFor = requestedfor[updateTypes];
            try{
                var updatestatusFor = updatestatus[updateTypes];
            }catch(err){
                var updatestatusFor ={"updateerror":{}}
            }
            for(var i=0;i<updatesFor.length;i++){
                var type = updatesFor[i].updatetype || updatesFor[i].contexttype
                if(typeof(this.config.system.lastupdates[type]) ==="undefined"){
                    this.config.system.lastupdates[type] ={};
                }
                var idlist = updatesFor[i].updateid || updatesFor[i].contextid;
                for(var j=0;j<idlist.length;j++){
                    if(updatestatusFor && updatestatusFor.updateerror && updatestatusFor.updateerror[type] && updatestatusFor.updateerror[type].indexOf(idlist[j]) !== -1)continue;
                    this.config.system.lastupdates[type][idlist[j]] = newTime;
                }
                   
            }
        }
        
    }
    
    /******
     * SendPendingSends
     ******/
    System.prototype.sendPendingContentInfo = function() {
        this.sendPendingUpdates('contentinfo');
    }
    
    /******
     * SendPendingSends
     ******/
    System.prototype.sendPendingContentupdates = function() {
        this.sendPendingUpdates('contentupdates');
    }
    /******
     * SendPendingSends
     ******/
    System.prototype.sendPendingUpdates = function(type) {
        this.sendAmount += Object.keys(this.config.updatehadling[type].sending).length;
        for(var update in this.config.updatehadling[type].sending){
            try{
                this.activeServerConnection(
                    "addpending"+type,
                    jQuery.extend(
                        true,
                        {},
                        this.config.updatehadling[type].sending[update].serverData,
                        {username:this.config.user.username,appkey:this.config.user.applicationkey}
                    ),
                    {"contentkey":update,data:{contexttype:this.config.updatehadling[type].sending[update].serverData.contexttype,contextid:this.config.updatehadling[type].sending[update].serverData.contextid}},
                    update
                );
                
            }catch(err){
                console.log('sendPendingUpdates extend error:',err);
                console.log("addpending"+type,this.config.updatehadling[type].sending[update].serverData,{"contentkey":update},update);
            }
        }
        if(this.sendAmount ===0){
            this.loadSettings();
        }
    }
    
    
    /******
     * checkPendingSends
     ******/
    System.prototype.checkPendingSends = function() {
        this.state = "sendpendingcontent";
        //Try if there is some errors open application anyway
        try{
            if(jQuery.isEmptyObject(this.config.updatehadling.contentupdates.sending) && jQuery.isEmptyObject(this.config.updatehadling.contentinfo.sending)){
                this.notification("load settings");
                this.loadSettings();
            }else{
                this.openDialog('systemworking');
                if(jQuery.isEmptyObject(this.config.updatehadling.contentinfo.sending)){
                    this.sendPendingContentupdates();
                }else{
                    this.sendPendingContentInfo();
                }
            }
        }catch(e){
            console.log("error",e);
            this.notification("load settings");
            this.loadSettings();
        }
        
    }
    
    /******
     * Open browser in OS with given url
     ******/
    System.prototype.openInExternalBrowser = function(URL) {
        var fullurl = '';
        if (URL.match(/^https?:\/\//)) {
            fullurl = URL;
        } else {
            fullurl = 'file://' + process.cwd() + '/' + URL;
        }
        this['nw_gui'].Shell.openExternal(fullurl);
    };
    
    /******
     * Start the system.
     ******/
    System.prototype.main = function() {
        var systemSelf = this;
        this.notification("System ready");
    }
    
    /******
     * Handle IO-errors
     ******/
    System.prototype.handleIOErrors = function(result) {
        if (result && result.errors)
        for (var item = 0; item < result.errors.length; ++item) {
            this.place.trigger('erroritem.offlinefs', JSON.stringify(result.errors[item]));
        }
    };
    
    // General IO functions
    /******
     * Init the system.
     ******/
    System.prototype.initSystem = function() {
        this.drawNotification();
        this.notification("Loading Layout");
        this.drawLayout();
        this.initNotify();
        this.notification("check pending sends");
        this.checkPendingSends();
        
        // moved application load after settings are loaded
        // this.notification("Loading applications");
        // this.loadApplications();       
    }
    /******
     * load applications.
     ******/
    System.prototype.loadApplications = function() {
        var systemSelf = this;
        systemSelf.appControl.empty();
        systemSelf.place.find('.removeState.applicationControlbutton').empty();
        var applicationlist = this.fileSystem.getApplicationJS();
        for(var i=0;i<applicationlist.list.length;i++){
            var application_name = applicationlist.list[i].replace(".js","");
            systemSelf.appControl.append("<div class=\"oneApp\" id=\""+application_name+"\"></div>");
            var __callback =  (function(){
                    var application = application_name;
                    var returnfunction = function(){
                        try{
                            systemSelf.notification(application+": load Done");
                            jQuery("#"+application).empty();
                            jQuery("#"+application)[application]({config:{"general":systemSelf.config.general,"user":systemSelf.config.user,"localizer":systemSelf.localizer,"uitheme":systemSelf.config.themetemplate.applications[application]}});
                        }catch(e){
                            jQuery("#"+application).remove();
                            console.log(e);
                            console.log(application+": loadError");
                        }
                    }
                    return returnfunction;
            })();
            this.embedToHead(applicationlist.path+"/",applicationlist.list[i],"js",__callback);
        }
        if(applicationlist.list.length){//Add remove if there is applications
            var removeControlplace = systemSelf.place.find('.applicationControlbutton.removeState');
            if(removeControlplace.length ===0){
                removeControlplace = this.appControl.append('<span class="applicationControlbutton removeState"></span>').find('.applicationControlbutton.removeState');
            }
            removeControlplace.append('<span title="'+systemSelf.localizer.localize('system:deactivate_remove')+'" class="removeActive removeIcon"><span class="removeActiveIcon">'+(systemSelf.config.themetemplate.templateicons['removeActiveIcon']?systemSelf.config.themetemplate.templateicons['removeActiveIcon']:'<svg height=\"50\" xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"50\" viewBox=\"0 0 30 30\" class=\"mini-icon mini-icon-trashcan-open default_removeactive\"><path style=\"stroke: none;\" d=\"M5 5.5 l7 -2 l-0.2 -1 l2 -0.4 l0.2 1 l7 -2 l0.6 2 l-16 4.4 z M7 8 l16 0 l-3 20 l-10 0z M9 10 l2 15 l2 0 l-1 -15z M13.5 10 l0.5 15 l2 0 l0.5 -15z M21 10 l-3 0 l-1 15 l2 0z\"></path></svg>')+'</span></span><span title="'+systemSelf.localizer.localize('system:activate_remove')+'" class="removeIcon removeInactive"><span class="removeInactiveIcon">'+(systemSelf.config.themetemplate.templateicons['removeInactiveIcon']?systemSelf.config.themetemplate.templateicons['removeInactiveIcon']:'<svg height="50" xmlns="http://www.w3.org/2000/svg" version="1.1" width="50" viewBox="0 0 30 30" class="mini-icon mini-icon-trashcan-closed default_removeinactive">    <path style="stroke: none;" fill="white" d="M8 6.5 l7 -0 l-0 -1 l2 -0 l0 1 l7 0 l0 2 l-16 0 z"></path>    <path style="stroke: none;" d="M7 5.5 l7 -0 l-0 -1 l2 -0 l0 1 l7 0 l0 2 l-16 0 z"></path>    <path class="can" style="stroke: none;fill: white;" d="M8 9 l16 0 l-3 20 l-10 0z M10 11 l2 15 l2 0 l-1 -15z M14.5 11 l0.5 15 l2 0 l0.5 -15z M22 11 l-3 0 l-1 15 l2 0z"></path>    <path class="can shadow" style="stroke: none;" d="M7 8 l16 0 l-3 20 l-10 0z M9 10 l2 15 l2 0 l-1 -15z M13.5 10 l0.5 15 l2 0 l0.5 -15z M21 10 l-3 0 l-1 15 l2 0z"></path></svg>')+'</span></span>');
        }
        this.place.trigger('applicationsReady.system');
    }
    /******
     * load system settings.
     ******/
    System.prototype.embedToHead = function(path,filename, filetype, callback){
        var systemSelf = this;
        try{
            var fileInprogress=filename;
            if (filetype=="js"){ //if filename is a external JavaScript file
                var fileref=document.createElement('script');
                fileref.setAttribute("id",filename);
                fileref.setAttribute("type","text/javascript");
                fileref.setAttribute("src", path+filename);
            }
            else if (filetype=="css"){ //if filename is an external CSS file
                var fileref=document.createElement("link");
                fileref.setAttribute("rel", "stylesheet");
                fileref.setAttribute("type", "text/css");
                fileref.setAttribute("href", path+filename);
            }
            if (typeof fileref!="undefined"){
                try{
                    document.getElementsByTagName("head")[0].appendChild(fileref);
                }catch(e){
                    console.log("appendError:"+e);
                }
            }
            fileref.onload = function(e){
                callback();
                fileref.onload = null;
            }
        }catch(e){
            console.log("embedToHead:",e);
        }
    }
    /******
     * load system settings.
     ******/
    System.prototype.loadSettings = function() {
        var systemSelf=this;
        this.forceCloseDialog();
        this.state = "loadsettings";
        //TODO: settigns load
        //  - user
        if(!this.config.user.applicationkey && !this.config.user.dontPromptUser){
            if(this.inDemoMode){
                this.openDialog('demowelcome');
            }else{
                this.openDialog('languageselect');
            }
        }else{
            systemSelf.notification("Loading applications");
            systemSelf.loadApplications();
            
        }
    }
    /***************
    * generate contentinfos
    ***************/
    System.prototype.compareContentInfos = function(infolist){
        var systemSelf = this;
        var comparison = {};
        infolist.forEach(function(elem,ind){
            var storedinfo = systemSelf.getContentinfo(elem.contexttype,elem.contextid);
            //Check userlist
            var newUserlist = jQuery.extend(true,[],elem.users).sort(function(a,b){
                if(a.username < b.username){return -1;}else{return 1;}
            });
            var oldUserlist = jQuery.extend(true,[],storedinfo.users).sort(function(a,b){
                if(a.username < b.username){return -1;}else{return 1;}
            });
            for(var i=0;i<newUserlist.length;i++){
                var oneUser = newUserlist[i];
                if(oldUserlist.length===0){
                    if(typeof(comparison.userlist) ==="undefined"){
                        comparison.userlist={}
                    }
                    if(typeof(comparison.userlist.newelements) ==="undefined"){
                        comparison.userlist.newelements=[]
                    }
                    var middlename = oneUser.surname.split(" ");
                    comparison.userlist.newelements.push(jQuery.extend(true,{},oneUser,{realname:{firstname:oneUser.firsname,lastname:middlename.pop(),middlename:middlename.join(' ')}}));
                }
                for(var j=0;j<oldUserlist.length;j++){
                    if(oneUser.username === oldUserlist[j].username){
                        if(!(oneUser.surname === oldUserlist[j].surname && oneUser.firstname === oldUserlist[j].firstname && oneUser.email === oldUserlist[j].email)){
                            if(typeof(comparison.userlist) ==="undefined"){
                                comparison.userlist={}
                            }
                            if(typeof(comparison.userlist.update) ==="undefined"){
                                comparison.userlist.update=[]
                            }
                            var middlename = oneUser.surname.split(" ");
                            comparison.userlist.update.push(jQuery.extend(true,{},oneUser,{realname:{firstname:oneUser.firsname,lastname:middlename.pop(),middlename:middlename.join(' ')}}));
                        }
                        oldUserlist.splice(j,1);
                        break;
                    }else if(oneUser.username < oldUserlist[j].username){
                        if(typeof(comparison.userlist) ==="undefined"){
                            comparison.userlist={}
                        }
                        if(typeof(comparison.userlist.newelements) ==="undefined"){
                            comparison.userlist.newelements=[]
                        }
                        var middlename = oneUser.surname.split(" ");
                        comparison.userlist.newelements.push(jQuery.extend(true,{},oneUser,{realname:{firstname:oneUser.firsname,lastname:middlename.pop(),middlename:middlename.join(' ')}}));
                        break;
                    }else{
                        if(typeof(comparison.userlist) ==="undefined"){
                            comparison.userlist={}
                        }
                        if(typeof(comparison.userlist.removeelements) ==="undefined"){
                            comparison.userlist.removeelements=[]
                        }
                        comparison.userlist.removeelements.push(oldUserlist.splice(j,1));
                        j--;
                    }
                }
            }
            for(var j=0;j<oldUserlist.length;j++){
                if(typeof(comparison.userlist) ==="undefined"){
                    comparison.userlist={}
                }
                if(typeof(comparison.userlist.removeelements) ==="undefined"){
                    comparison.userlist.removeelements=[]
                }
                comparison.userlist.removeelements.push(oldUserlist[j]);
            }
            //Check groups
            var newGrouplist = jQuery.extend(true,[],elem.context_groups).sort(function(a,b){
                if(a.hash < b.hash){return -1;}else{return 1;}
            });
            var oldGrouplist = jQuery.extend(true,[],storedinfo.groups).sort(function(a,b){
                if(a.hash < b.hash){return -1;}else{return 1;}
            });
            for(var i=0;i<newGrouplist.length;i++){
                var oneGroup = newGrouplist[i];
                if(oldGrouplist.length===0){
                    if(typeof(comparison.groups) ==="undefined"){
                        comparison.groups={}
                    }
                    if(typeof(comparison.groups.newelements) ==="undefined"){
                        comparison.groups.newelements=[]
                    }
                    comparison.groups.newelements.push(jQuery.extend(true,{},oneGroup,{members:oneGroup.users,gid:oneGroup.hash}));
                }
                for(var j=0;j<oldGrouplist.length;j++){
                    if(oneGroup.hash === oldGrouplist[j].hash){
                        if(!(oneGroup.description === oldGrouplist[j].description && oneGroup.role === oldGrouplist[j].role && JSON.stringify(jQuery.extend(true,[],oneGroup.users).sort()) === JSON.stringify(jQuery.extend(true,[],oldGrouplist[j].users).sort()))){
                            if(typeof(comparison.groups) ==="undefined"){
                                comparison.groups={}
                            }
                            if(typeof(comparison.groups.update) ==="undefined"){
                                comparison.groups.update=[]
                            }
                            comparison.groups.update.push(jQuery.extend(true,{},oneGroup,{members:oneGroup.users,gid:oneGroup.hash}));
                        }
                        oldGrouplist.splice(j,1);
                        break;
                    }else if(oneGroup.hash < oldGrouplist[j].hash){
                        if(typeof(comparison.groups) ==="undefined"){
                            comparison.groups={}
                        }
                        if(typeof(comparison.groups.newelements) ==="undefined"){
                            comparison.groups.newelements=[]
                        }
                        comparison.groups.newelements.push(jQuery.extend(true,{},oneGroup,{members:oneGroup.users,gid:oneGroup.hash}));
                        break;
                    }else{
                        if(typeof(comparison.groups) ==="undefined"){
                            comparison.groups={}
                        }
                        if(typeof(comparison.groups.removeelements) ==="undefined"){
                            comparison.groups.removeelements=[]
                        }
                        comparison.groups.removeelements.push(oldGrouplist.splice(j,1));
                        j--;
                    }
                }
            }
            for(var j=0;j<oldGrouplist.length;j++){
                if(typeof(comparison.groups) ==="undefined"){
                    comparison.groups={}
                }
                if(typeof(comparison.groups.removeelements) ==="undefined"){
                    comparison.groups.removeelements=[]
                }
                comparison.groups.removeelements.push(oldGrouplist[j]);
            }
            //Check rigths TODO:when rights can be changed
            
            //Check context variables (title,ect...) TODO:when context variables can be changed
            
        });
        return comparison;
    }  
    /***************
    * generate contentinfos
    ***************/
    System.prototype.processContentInfos = function(infolist){
        var systemSelf = this;
        infolist.forEach(function(elem,ind){
            var contentinfo = JSON.parse(elem.data);
            if(typeof(contentinfo.rights) ==="undefined")contentinfo.rights={};
            for(var right in elem.rights){
                contentinfo.rights[right] = elem.rights[right];
            }
            var newUserlist = [];
            for(var i=0;i<elem.users.length;i++){
                var oneUser = elem.users[i];
                var middlename = oneUser.surname.split(" ");
                oneUser.realname={"firstname":oneUser.firstname,"lastname":middlename.pop(),"middlename":middlename.join(" ")}
                newUserlist.push(oneUser);
            }
            contentinfo.users = newUserlist;
            var newGroups = [];
            for(var i=0;i<elem.context_groups.length;i++){
                var oneGroup = elem.context_groups[i];
                oneGroup.gid=oneGroup.hash;
                oneGroup.members=oneGroup.users;
                newGroups.push(oneGroup);
            }
            contentinfo.groups=newGroups;
            systemSelf.setContentinfo(elem.contexttype,elem.contextid,contentinfo);
            
        });
        this.place.trigger('savecontentsettings.system');
    };
    
    /**
     * Save and use updated library information
     */
    System.prototype.processLibraryUpdates = function(data) {
        if (data.myschools && data.myschools.length) {
            this.config.user.schools = data.myschools.slice();
        } else {
            this.config.user.schools = this.config.user.schools || [];
        };
        if (typeof(data.expires) === 'string') {
            this.config.library.expires = data.expires;
        };
        if (typeof(data.checker_quota_left) !== 'undefined') {
            this.config.library.checker_quota_left = data.checker_quota_left;
        };
        if (typeof(data.checker_quota_expires) !== 'undefined') {
            this.config.library.checker_quota_expires = data.checker_quota_expires;
        };
        if (data.schools) {
            var schoollist = [];
            for (var id in data.schools) {
                schoollist.push({id: id, name: data.schools[id]})
            };
            this.config.library.schools = schoollist;
        } else {
            this.config.library.schools = this.config.library.schools || [];
        };
        if (data.subjects) {
            // TODO: Update subjects here, if they are parametrized in the library?
        };
        this.place.trigger('saveusersettings.system');
        this.place.trigger('savelibrarysettings.system');
    };
    
    /******
     * Get Available context to add as startdata
     ******/
    System.prototype.getAvailableaddcontexts = function(typelist) {
        if(typeof(typelist) === "undefined" || !typelist.length){
            typelist = ['book','course','own_notes'];
        }
        var availableaddcontexts = {};
        for(var index in typelist){
            var type = typelist[index];
            availableaddcontexts[type]=[];
            for(var index in this.config.content[type]){
                var content = this.config.content[type][index];
                availableaddcontexts[type].push(
                    {
                        "contextid":index,
                        "contexttype":content.contexttype,
                        "titles":content.titles,
                        "material":content.material,
                        "allowedit":!(!content.allowedit)
                        
                    }
                );
            }
        }
        return availableaddcontexts;
    }  
    /******
     * Videochat function
     ******/
    System.prototype.openvideochatwindow = function(data) {
        var md5 = require('MD5');
        var chatroom = md5(data.contexttype+"-"+data.contextid);
        this.nw_gui.Window.open(this.config.system.chatURL+chatroom);
    }
   
    /******
     * Reset for testing
     ******/
    System.prototype.resetData = function() {
        //TODO: Reset all!
        this.fileSystem.clearContentData(['course','own_notes']);
        this.config.content = {
            "books" : {"33":{"titles":{"fi":"MAY1 Luvut ja lukujonot","sv":"MAG1 Tal och talföljder"},"filename":"33_fi_sv.json","type":"book","serversync":true,"id":"33","description":"","material":[{"type":"reader","jq":"readerview","id":"33"}],"apps":[],"users":[],"groups":[{"hash":"33_reader","description":"reader","users":[],"gid":"33_reader","members":[]}],"rights":{"edit":{"solution":[{"whoid":"33_reader","whotype":"group"}]},"publish":{},"elementclasses":{"general":[{"whoid":"33_reader","whotype":"group"}],"math":[{"whoid":"33_reader","whotype":"group"}],"media":[{"whoid":"33_reader","whotype":"group"}],"programming":[{"whoid":"33_reader","whotype":"group"}],"container":[{"whoid":"33_reader","whotype":"group"}]}}},"35":{"titles":{"fi":"OPS16 Maa3: Geometria","sv":"OPS16 Maa3: Geometri"},"filename":"35_fi_sv.json","type":"book","serversync":true,"id":"33","description":"","material":[{"type":"reader","jq":"readerview","id":"35"}],"apps":[],"users":[],"groups":[{"hash":"35_reader","description":"reader","users":[],"gid":"35_reader","members":[]}],"rights":{"edit":{"solution":[{"whoid":"35_reader","whotype":"group"}]},"publish":{},"elementclasses":{"general":[{"whoid":"35_reader","whotype":"group"}],"math":[{"whoid":"35_reader","whotype":"group"}],"media":[{"whoid":"35_reader","whotype":"group"}],"programming":[{"whoid":"35_reader","whotype":"group"}],"container":[{"whoid":"35_reader","whotype":"group"}]}}}}


        };
        this.config.user = {};
        this.config.updatehadling = this.defaulParameters.config.updatehadling;
        this.config.system.lastupdates = {};
        this.place.trigger('saveAllsettings.system',{reload:true});
    }
    
    /**
     * Progressdots
     */
    System.prototype.progressdots = `<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="450" height="90" viewBox="0 0 500 100" class="progressdots">
        <circle class="progressdots-dot progressdots-step1" stroke="black" stroke-width="2" fill="white" cx="50" cy="50" r="25" />
        <text class="progressdots-text progressdots-step1" x="50" y="60" style="font-family: sans-serif; font-size: 30px; text-anchor: middle; alignment-baseline: baseline;">1</text>
        <path stroke="black" stroke-width="2" fill="none" d="M75 50 h50" />
        <circle class="progressdots-dot progressdots-step2" stroke="black" stroke-width="2" fill="white" cx="150" cy="50" r="25" />
        <text class="progressdots-text progressdots-step2" x="150" y="60" style="font-family: sans-serif; font-size: 30px; text-anchor: middle; alignment-baseline: baseline;">2</text>
        <path stroke="black" stroke-width="2" fill="none" d="M175 50 h50" />
        <circle class="progressdots-dot progressdots-step3" stroke="black" stroke-width="2" fill="white" cx="250" cy="50" r="25" />
        <text class="progressdots-text progressdots-step3" x="250" y="60" style="font-family: sans-serif; font-size: 30px; text-anchor: middle; alignment-baseline: baseline;">3</text>
        <path stroke="black" stroke-width="2" fill="none" d="M275 50 h50" />
        <circle class="progressdots-dot progressdots-step4" stroke="black" stroke-width="2" fill="white" cx="350" cy="50" r="25" />
        <text class="progressdots-text progressdots-step4" x="350" y="60" style="font-family: sans-serif; font-size: 30px; text-anchor: middle; alignment-baseline: baseline;">4</text>
        <path stroke="black" stroke-width="2" fill="none" d="M375 50 h50" />
        <circle class="progressdots-dot progressdots-step5" stroke="black" stroke-width="2" fill="white" cx="450" cy="50" r="25" />
        <text class="progressdots-text progressdots-step5" x="450" y="60" style="font-family: sans-serif; font-size: 30px; text-anchor: middle; alignment-baseline: baseline;">5</text>
    </svg>`;
    
    /**
     * Icons
     */
    System.prototype.icons = {
        close: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="30" height="30" viewBox="0 0 30 30" class="mini-icon mini-icon-close"><circle class="mini-icon-background" fill="white" cx="15" cy="15" r="14" /><path class="mini-icon-foreground" style="stroke: none;" fill="black" d="M15 1 a14 14 0 0 0 0 28 a14 14 0 0 0 0 -28z m0 1 a13 13 0 0 1 0 26 a13 13 0 0 1 0 -26z M7 11 a2 2 0 0 1 4 -4 l4 4 l4 -4 a2 2 0 0 1 4 4 l-4 4 l4 4 a2 2 0 0 1 -4 4 l-4 -4 l-4 4 a2 2 0 0 1 -4 -4 l4 -4z"></path></svg>',
        waitspinner: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="50" height="50" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="wait-circle-1"><circle style="stroke: rgba(0,0,0,0.2); stroke-width: 10; fill: none;" cx="50" cy="50" r="40"></circle><path class="waitspinner" style="stroke-linecap: round; stroke-width: 10; fill: none;" stroke="rgba(0,0,0,0.5)" d="M50 10 a40 40 0 1 1 -40 40"><animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 50 50" to="360 50 50" dur="2s" repeatCount="indefinite" /></path></svg>',
        '4flogo': '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="300" height="98" viewBox="0 0 520 170" class="logo-image logo-4ferries"><path style="stroke: none; stroke-width: 0.2px; fill: #00a0e4;" d="M70 8 h27 v104 h17 v-73 a34 35 0 0 1 34 -35 h20 v11 h-18 a17 18 0 0 0 -17 18 v20 h35 v9 h-35 v71 h-18 v-10 h-18 v45 h-21 v-45 h-71 v-15z m6 18 l-54 86 h54z m162 51 h-49 c4 22 20 20 34 16 l2 7 c-25 15 -53 0 -53 -29 c0 -26 23 -33 33 -33 c10 0 33 2 33 39z m-49 -11 h31 a15.5 18 0 0 0 -31 0z m57 40 v-35 a34 34 0 0 1 34 -34 h14 v10 c-17 -2 -30 3 -30 20 v39z m52 0 v-35 a34 34 0 0 1 34 -34 h14 v10 c-17 -2 -30 3 -30 20 v39z m55 0 v-69 h18 v69z m8 -79 a11.5 11.5 0 0 1 0 -23 a11.5 11.5 0 0 1 0 23z m86 50 h-49 c4 22 20 20 34 16 l2 7 c-25 15 -53 0 -53 -29 c0 -26 23 -33 33 -33 c10 0 33 2 33 39z m-49 -11 h31 a15.5 18 0 0 0 -31 0z m104.5 -11 c-8 -10 -34 -14 -34 -1.5 c0 7 10 8 17 11.5 c7 3.5 18 6 18 21 c0 15 -15 20 -24 20.5 c-9 -0.5 -14 0 -25 -3 l-1.5 -14 c8 8 20 7 23 7 c3 0 12.5 -2 12.5 -8 c0 -2 -2 -8 -17 -12.5 c-15 -4.5 -18.5 -14 -18.5 -20 c0 -11 11 -20 25 -20 c12 0 18 2 24 6z" /></svg>'
    };
    
    /**
     * Urls
     */
    System.prototype.urls = {
        companyurl: {
            en: 'https://fourferries.com',
            fi: 'https://fourferries.com',
            sv: 'https://fourferries.com'
        },
        studiourl: {
            en: 'https://fourferries.com/en/4f-studio-overview/',
            fi: 'https://fourferries.com/fi/4f-studio-yleiskatsaus/',
            sv: 'https://fourferries.com/sv/4f-studio-oversikt/'
        },
        librarycredits: {
            en: 'data/credits/index.html',
            fi: 'data/credits/index.html',
            sv: 'data/credits/index.html',
        },
        nwjscredits: {
            en: '../credits.html',
            fi: '../credits.html',
            sv: '../credits.html'
        }
    }

    
    { /** jQuery Plugin interface    **/
        var methods = {
            'init' : function(params) {
                return this.each( function() {
                    var system = new System($(this), params);
                    $(this).data('system', system);
                });
            },
            'close' : function() {
                return this.each( function() {
                    return $(this).data('system').close();
                });
            },
            'get' : function(params) {
                return $(this).data('system')[params];
            },
            'set' : function(params) {
                return $(this).data('system')[params[0]] = params[1];
            }
        }
        
        $.fn.system = function( method ) {
            if ( methods[method] ) {
                return methods[method].apply( this, Array.prototype.slice.call( arguments, 1 ));
            } else if ( typeof method === 'object' || ! method ) {
                return methods.init.apply( this, arguments );
            } else {
                $.error( 'Method ' +  method + ' does not exist.' );
                return false;
            }
        }
    }
})(jQuery)
