/****************************
 * windowHandler.js
 * handler for multiple windows and share event in application
 * 4.5.2016
 * Petri Sallasmaa
 * Petri Salmela
 ****************************/
 function windowHandler(params){
    var extended = $.extend(
        {
            windowsbycontext:{},
            allWindows:[],
            windowsById:{},
            mainWindow:window,
            place:window.body
        },
        params
    );
    
    for (var item in extended) {
        this[item] = extended[item];
    }
    this.init();
}
windowHandler.prototype.init = function(){
    var winhand = this;
    //eventHandlers
    this.place.off('logallwindows').on('logallwindows',function(){
        console.log(winhand);
    });
    this.place.off('closeallwindows').on('closeallwindows',function(event,event_data){
        winhand.closeAll();
        winhand.place.trigger('allwindowsclosed');
        try{
            if(event_data && event_data.action && event_data.action ==="exit"){
                winhand.place.trigger('windowsreadyforexit');
            }
        }catch(err){
            console.log(err);
        }
    });
    this.place.off('allwindowevent').on('allwindowevent',function(event,event_data){
        try{
            switch(event_data.triggerto){
                case "content":
                    winhand.triggerEventToContext(event_data);
                break;
                case "window":
                    winhand.triggerEventToWindow(event_data);
                case "all":
                break;
                default:
                break;
            }
        }catch(err){
            console.log('allwindoweventError:',err);
        }
        // console.log(event_data);
    });
    this.place.off('addwindow').on('addwindow',function(event,event_data){
        // console.log('addWindow',event,event_data);
        try{
            if(typeof(event_data.windowobject) ==="undefined"){
                var addwindow = event.target.ownerDocument.defaultView;
            }else{
                var addwindow = event_data.windowobject;
            }
            winhand.addWindow(event_data.context,addwindow);
            try{
                winhand.markOpen(event_data.contexttype,event_data.contextid);
            }catch(err){
                console.log("markOpen error",err);
            }
        }catch(err){
            console.log('addwindow eventwindow error'+err);
        }
    });
    this.place.off('removewindow').on('removewindow',function(event,event_data){
        try{
            if(typeof(event_data.windowobject) ==="undefined"){
                var removewindow = event.target.ownerDocument.defaultView;
            }else{
                var removewindow = event_data.windowobject;
            }
            winhand.removeWindow(event_data.context,removewindow);
            try{
                winhand.markClosed(event_data.contexttype,event_data.contextid);
            }catch(err){
                console.log("markClosed error",err);
            }
        }catch(err){
            console.log('removewindow eventwindow error'+err);
        }
    });
} 
windowHandler.prototype.triggerEventToContext = function(event_data){
    try{
        var triggerwindows = this.windowsbycontext[event_data.contenttype+'_'+event_data.contentid];
        for(var i=0;i<triggerwindows.length;i++){
            if(typeof(event_data.triggerself) !== "undefined" && !event_data.triggerself && event_data.windowid && triggerwindows[i].frameId === event_data.windowid ) continue;
            try{
                if(typeof(triggerwindows[i].window.jQuery) === "function"){
                    triggerwindows[i].window.jQuery('body').trigger(event_data.triggerevent,(typeof(event_data.triggereventdata) !=="undefined"? event_data.triggereventdata :{}));
                }else{
                    console.log('TODO: make purejavascript event triggerfunction')
                    //TODO: make purejavascript event triggerfunction
                }
            }catch(err){
                console.log("triggerToContextError(1):",err);
            }
        }
    }catch(err){
        console.log("triggerToContextError(2):",err,event_data);
    }
} 
windowHandler.prototype.triggerEventToWindow = function(event_data){
    try{
        var triggerwindow = this.windowsById[event_data.windowid];
        try{
            if(typeof(triggerwindow.window.jQuery) === "function"){
                triggerwindow.window.jQuery('body').trigger(event_data.triggerevent,(typeof(event_data.triggereventdata) !=="undefined"? event_data.triggereventdata :{}));
            }else{
                //TODO: make purejavascript event triggerfunction
            }
        }catch(err){
            console.log("triggerToContextError:",err);
        }
    }catch(err){
        console.log(err);
    }
} 
windowHandler.prototype.addWindow = function(context,addWindow){
    this.windowsbycontext[context]=this.windowsbycontext[context] || [];
    this.windowsbycontext[context].push(addWindow);
    this.windowsById[addWindow.frameId]= addWindow;
    this.allWindows.push(addWindow);
}  
windowHandler.prototype.markOpen = function(type,id){
    if(this.windowsbycontext[type+"_"+id].length === 1){
        this.place.trigger('contextopen',{"contexttype":type,"contextid":id});
    }
}  
windowHandler.prototype.removeWindow = function(context,remWindow){
    try{
        var inAll = this.allWindows.indexOf(remWindow);
        var inContext = this.windowsbycontext[context].indexOf(remWindow);
        delete this.windowsById[remWindow.frameId]
        if(inAll !== -1) this.allWindows.splice(inAll,1);
        if(inContext !== -1) this.windowsbycontext[context].splice(inContext,1);
    }catch(err){
        console.log("removeError",err,context,remWindow);
    }   
} 
windowHandler.prototype.markClosed = function(type,id){
    if(this.windowsbycontext[type+"_"+id].length === 0){
        this.place.trigger('contextclosed',{"contexttype":type,"contextid":id});
    }
} 
windowHandler.prototype.closeAll = function(){
    for(var i=0;i<this.allWindows.length;i++){
        this.allWindows[i].close();
    }
} 