/****************************
 * systemLocalizer.js
 * Class for translating / localizing system of ebooks.
 * 20.5.2014
 * Petri Salmela
 * Petri Sallasmaa
 * Four Ferries Oy
 ****************************/
 
var systemLocalizer = function(defaultlang){
    this.dictionary = {};
    this.defaultlang = defaultlang || 'en';
}

systemLocalizer.prototype.setLanguage = function(lang){
    this.defaultlang = lang;
}

systemLocalizer.prototype.localize = function(term, lang){
    if (typeof(lang) === 'undefined') {
        lang = this.defaultlang;
    }
    var translation = (this.dictionary[lang] && this.dictionary[lang][term]) ||
        (this.dictionary[this.defaultlang] && this.dictionary[this.defaultlang][term]) ||
        (this.dictionary['en'] && this.dictionary['en'][term]) || 'Missing translation: ' + term;
    return translation;
}

systemLocalizer.prototype.localizeText = function(text, lang){
    if (typeof(lang) === 'undefined') {
        lang = this.defaultlang;
    }
    var rex = /{%.*?%}/;
    var allmatch = text.match(/{%.*?%}/g);
    var maxcount = allmatch && allmatch.length || 0;
    var match = text.match(rex);
    var count = 0;
    while (match && count < maxcount){
        count++;
        var placeholder = match[0];
        var term = placeholder.substr(2, placeholder.length-4);
        var newtext = (this.dictionary[lang] && this.dictionary[lang][term]) ||
            (this.dictionary[this.defaultlang] && this.dictionary[this.defaultlang][term]) ||
            (this.dictionary['en'] && this.dictionary['en'][term]) || 'Missing translation: ' + term;
        text = text.replace(rex, newtext);
        match = text.match(rex);
    }
    return text;
}

systemLocalizer.prototype.addTranslations = function(data){
    this.dictionary = $.extend(true, this.dictionary, data);
}

systemLocalizer.prototype.isTranslated = function(term , lang){
    if (typeof(lang) === 'undefined') {
        lang = this.defaultlang;
    }
    return (typeof(this.dictionary[lang]) !== "undefined" && typeof(this.dictionary[lang][term]) !== "undefined");
}
