
/***********
 * object to handle dynamic javascriptloading
 * 20.5.2014
 * Petri Sallasmaa
 * Petri Salmela
 * Four Ferries Oy
 ***********/

function loader(list,pluginList, loaderDocument ,loaderWindow,pluginName){
    var self = this;
    this.pluginName = typeof(pluginName) !== "undefined" ? pluginName : null;
    this.pluginList = typeof(pluginList) !== "undefined" ? pluginList : [];
    this.document = typeof(loaderDocument) !== "undefined" ? loaderDocument : window.document;
    this.window = typeof(loaderWindow) !== "undefined" ? loaderWindow : window;
    this.fileList = typeof(list) !== "undefined"  ?  list   :   {path:".",jslist:[],csslist:[]};
    this.fileIndex=0;

    //catch error if loading systemjavascripts
    this.window.onerror = function (errorMsg, url, lineNumber) {
        // console.log(errorMsg, url, lineNumber);
        try{
            var spliturl = url.split("/");
            var element = self.document.getElementById(spliturl[spliturl.length-1]);
            element.onload = null;
            element.parentNode.removeChild(element);
            self.fileIndex +=1;
            self.fileList.jslist.push(spliturl[spliturl.length-1]);
            self.loadLoop();
            return true;
        }catch(e){
            this.window.console.log("windowError:"+e);
            this.window.console.log(e);
            return false;
        }
    }
    this.loadSystemCSS();
    this.startPlugin();    
}

loader.prototype.loadSystemCSS = function() {
    for(var i=0;i<this.fileList.csslist.length;i++){
        this.embedToHead(this.fileList.path+"/css/",this.fileList.csslist[i],"css");
    }
}

loader.prototype.loadLoop = function() {
    if(this.fileList.jslist.length >0 && this.fileList.jslist.length >= this.fileIndex){ 
        this.listItem = this.fileList.jslist.shift();
        try{
            this.embedToHead(this.fileList.path+"/js/",this.listItem,"js");
            
        }catch(e){
            console.log(this.listItem);
            this.fileList.jslist.push(this.listItem);
            console.log(this.fileList.jslist);
            this.fileIndex +=1;
            console.log(this.fileIndex);
            this.loadLoop();
        }
    }else{
        
            // console.log("1->"+JSON.stringify(this.fileList));
        if(this.fileList.pluginlist && this.fileList.pluginlist.length >0){
            for(var i=0;i<this.fileList.pluginlist.length;i++){
                this.fileList.jslist.push(this.fileList.pluginlist[i]);console.log(i);
            }
            // console.log("2->"+JSON.stringify(this.fileList));
            this.fileList.pluginlist=[];
            this.fileIndex =0;
            // console.log("3->"+JSON.stringify(this.fileList));
            this.loadLoop();
        }else{
            // console.log("4->"+JSON.stringify(this.fileList));
            this.doAfter();
        }
    }
}
loader.prototype.embedToHead = function(path,filename, filetype){
    var self = this;
    try{
        if (filetype=="js"){ //if filename is a external JavaScript file
            var fileref = self.document.createElement('script');
            fileref.setAttribute("id",filename);
            fileref.setAttribute("type","text/javascript");
            fileref.setAttribute("src", path+filename);
        }
        else if (filetype=="css"){ //if filename is an external CSS file
            var fileref = self.document.createElement("link");
            fileref.setAttribute("id",filename);
            fileref.setAttribute("rel", "stylesheet");
            fileref.setAttribute("type", "text/css");
            fileref.setAttribute("href", path+filename);
        }
        if (typeof fileref!="undefined"){
            try{
                self.document.getElementsByTagName("head")[0].appendChild(fileref);
            }catch(e){
                console.log("appendError:"+e);
            }
        }
        
        if(filetype=="js"){
            fileref.onload = function(e){
                try{
                    
                    try{
                        //Do if window.preload still exists if not everything it ready to go.
                        self.fileIndex = 0;
                        self.loadLoop();
                    }catch(e){
                        //Do nothing
                    }
                    this.onload = null;
                }catch(e){
                    console.log("onloadError:"+e);
                    this.onload = null;
                }
            }
        }
    }catch(e){
        console.log(e);
    }
}
loader.prototype.startPlugin= function(){
    var loader = this;
    var pluginRequests = {};
    var cssStyles=".plugincontainer{top:0;bottom:0;position:absolute;}\n";
    // Make plugincontainers;
    for(var i=0;i<this.pluginList.length;i++){
        var plugindiv = this.document.createElement('div');
        plugindiv.setAttribute('id','plugin_'+i);
        plugindiv.setAttribute('class','plugincontainer');
        if(this.pluginList[i].params.contentInfo){
            if(this.pluginList[i].params.contentInfo.contentType){
                plugindiv.setAttribute('contentType',this.pluginList[i].params.contentInfo.contentType);
            }
            if(this.pluginList[i].params.contentInfo.contentFile){
                plugindiv.setAttribute('contentFile',this.pluginList[i].params.contentInfo.contentFile);
            }
        }
        this.document.getElementsByTagName("body")[0].appendChild(plugindiv);
        for(var j=0;j<this.pluginList[i].params.systemRequests.length;j++){
            var request = this.pluginList[i].params.systemRequests[j];
            if(typeof(request.relayParams) === "object"){
                request.relayParams['containerId'] = 'plugin_'+i;
            }else{
                request['relayParams'] = {containerId:'plugin_'+i};
            }
            if(pluginRequests[this.pluginList[i].pluginName]){
                pluginRequests[this.pluginList[i].pluginName].push(request);
            }else{
                pluginRequests[this.pluginList[i].pluginName]=[request];
            }
        }
        cssStyles = cssStyles+"#plugin_"+i+"{position:absolute;left:"+parseInt(i*100/this.pluginList.length)+"%;right:"+(100-(parseInt(i*100/this.pluginList.length)+parseInt(100/this.pluginList.length)))+"%;}\n";
    }
    //Append css info
    var styleCss = this.document.createElement('style');
    styleCss.type = 'text/css';
    styleCss.appendChild(this.document.createTextNode(cssStyles));
    this.document.getElementsByTagName("head")[0].appendChild(styleCss);
    //Make systemrequest ready
    for(var plugin in pluginRequests){
        var __callback = (function(){
            var current = plugin;
            var requests = pluginRequests;
            var returnfunction = function(){
                for(var i=0;i<requests[current].length;i++){
                    loader.window.SystemRequest(requests[current][i]);
                }
            };
            
            return returnfunction;
        })()
        this.document.getElementsByTagName("body")[0].addEventListener(plugin+"-ready",__callback);
        this.window.console.log(plugin+"-ready->set");
    }
    this.loadLoop();

}

loader.prototype.doAfter = function(){
    this.window.onerror = null;
    try{
        for(var i=0;i<this.pluginList.length;i++){
            var event_ready = new CustomEvent(this.pluginList[i].pluginName+"-ready");
            this.window.document.body.dispatchEvent(event_ready);
        }
    }catch(err){
        console.log("doAfter error:",err);
    }
    delete this.window.pluginload;
} 
