/*****************************************************************
 * Class for "application" in main system
 * Constructor
 * 20.5.2014
 * Petri Sallasmaa
 * Petri Salmela
 * Four Ferries Oy
 *****************************************************************/
    function application(place, params) {
        
        var applicationSelf = this;
        this.started = false;
        // Handle params.
        var extended = $.extend(
            {
                config: {
                    lang: "en-US",
                    general: {
                        version: 2015.0227
                    }
                },
                applicationType:"default",
                neededPlugins:[],
                defaultCSSrules:[
                    {   
                        "element":".applicationIcon",
                        "rules":"list-style: none;border: 1px solid gray;padding: 0.3em;background-position: center;border-radius: 5px;box-shadow: 3px 3px 3px #999;position: relative;top: -10px;left: -10px;background-color: white;display: inline-block;"
                    },
                    {
                        "element":".appControlarea",
                        "rules":"width: 180px;float: left;"
                    },
                    {
                        "element":".controlpanel",
                        "rules":"width: 100%;"
                    },
                    {
                        "element":".missingPlugin",
                        "rules":"margin-top: 3em;"
                    },
                    {
                        "element":".itemselection",
                        "rules":"max-height: 124px;overflow-y: auto;"
                    }
                ]
            },
            params
        );
        for (var item in extended) {
            this[item] = extended[item];
        }
        this.place = place;
        this.initParams = extended;
        this.place.addClass(this.applicationType);
        
        this.place.append("<div class=\"appControlarea\"><div class=\"applicationIcon\">"+this.getTitle(this.initParams.config.uitheme)+"</div><div class=\"controlpanel\"></div>");
        //Initialization done, start main
        place.on('initialized.'+this.applicationType, function(e) {
            applicationSelf.started = true;
            applicationSelf.main();
            //System noticication
            applicationSelf.place.trigger(
                'notify.system',
                {msg:applicationSelf.applicationType+" runnig",type:"notification"}
                
            );
        });
        
        // setTimeout(function() { applicationSelf.init() }, 0); 
        applicationSelf.init()
        
    }
    
    /******
     * Event handlers
     ******/
    application.prototype.eventHandlerInit = function() {
        this.place.on('click','.downloadplugins', function(e,data) {
            applicationSelf.place.trigger('downloadplugin.system',{pluginmissing:jQuery(this).attr('missing')});
        });
    }
    
    /******
     * Get missing plugin
     ******/
    application.prototype.getMissingPlugin = function(missingList) {
        this.place.append('<div boxtype="error" class="missingPlugin"><span class="infotext">Some system plugins missing ('+JSON.stringify(missingList)+')</span><button class="loadMissing" missing="'+JSON.stringify(missingList)+'">Download plugins</button>');
        
    }
    /******
     * Get title
     ******/
    application.prototype.getTitle = function(template) {
        try{
            if(typeof(template) ==="undefined" || !template.apptitleshown)return "";
            if(template.apptitle){
                switch(template.apptitle.type){
                    case "string":
                        if(template.apptitle.text){
                            return '<div class="applicationTitle">'+template.apptitle.text+'</div>';
                        }else{
                            return "";
                        }
                    break;
                    case "localized_apptitle":
                        return '<div class="applicationTitle">'+this.config.localizer.localize(this.applicationType)+'</div>';
                }
            }else{
                return '<div class="applicationTitle">'+this.initParams.applicationType[0].toUpperCase() + this.initParams.applicationType.substring(1)+'</div>';
            }
        }catch(err){
            return "";
        }

    }
    /******
     * Add translations
     ******/
    application.prototype.addTranslations = function() {
        if(typeof(this.config.localizer) !== "undefined" && typeof(this.translations) !== "undefined"){
            this.config.localizer.addTranslations(this.translations);
        }
    }
    
    /******
     * Add HTML sanitotor
     ******/
    application.prototype.sanitize = function(text_to_sanitize,allow_tags) {
        if(typeof(DOMPurify) !== "undefined" && typeof(DOMPurify.sanitize) === "function"){
            return DOMPurify.sanitize(text_to_sanitize,{SAFE_FOR_JQUERY: true, ALLOWED_TAGS: (typeof(allow_tags) ==="object" && allow_tags.length?allow_tags:[])});
        }else{
            console.warn("No sanitizer found!");
            return this.escape_html(text_to_sanitize);
        }
    }    
    /******
     * HTML escape function
     ******/
    application.prototype.escape_html = function(text_to_escape,escape_quotes) {
        if(escape_quotes){
            return document.createElement('div')
                .appendChild(document.createTextNode(html))
                .parentNode
                .innerHTML
                .replace(/"/g, '&quot;', "g")
                .replace(/'/g, '&#39;', "g");
        }else {
            return document.createElement('div')
                .appendChild(document.createTextNode(html))
                .parentNode
                .innerHTML;
        }
    }
    
    
    /******
     * Add application CSS rules
     ******/
    application.prototype.addCSS = function() {
        var cssText="";
        for(var i=0;i<this.defaultCSSrules.length;i++){
            cssText += "."+this.applicationType+(this.defaultCSSrules[i].element.match(new RegExp('^\.'+this.applicationType))?"":" ")+ this.defaultCSSrules[i].element+"{"+this.defaultCSSrules[i].rules+"}\n";
        }
        for(var i=0;i<this.CSSrules.length;i++){
            cssText += "."+this.applicationType+(this.CSSrules[i].element.match(new RegExp('^\.'+this.applicationType))?"":" ")+ this.CSSrules[i].element+"{"+this.CSSrules[i].rules+"}\n";
        }
        if(jQuery("head #"+this.applicationType+"CSS").length ===0)
            jQuery('head').append("<style id=\""+this.applicationType+"CSS\" type=\"text/css\">"+cssText+"</style>")
    }
    /******
    /******
     *
     ******/
    application.prototype.main = function() {
        //If there will be general functionality for applications
        try{
            if(this.initParams.config.uitheme && this.initParams.config.uitheme.icons && this.initParams.config.uitheme.icons.length){
                var allIcons = this.initParams.config.uitheme.icons;
                for(var i=0; i< allIcons.length;i++){
                    jQuery(this.place).find(allIcons[i].selector)[allIcons[i].method](allIcons[i].icondata);
                }
            }
        }catch(err){
            console.log("application iconadd error",err);
        }
    }
    /******
     *Initialization
     ******/
    application.prototype.init = function() {
        this.eventHandlerInit();
        //System noticication
        this.place.trigger(
            'notify.system',
            {msg:this.applicationType+"Init",type:"notification"}
            
        )
        this.addCSS();
        this.addTranslations();
        //System noticication
        this.place.trigger(
            'notify.system',
            {msg:this.applicationType+"CheckPlugins",type:"notification"}
            
        );
        this.place.trigger('registerContentpath.system',{type:(typeof(this.applicationcontentpath)!=="undefined"?this.applicationcontentpath:this.applicationType),subpaths:this.applicationSubpaths});
        this.place.attr('appcontexttype',this.contexttype);
        this.checkPlugins();
    }
    /******
     *PluginCheck
     ******/
    application.prototype.checkPlugins = function() {
        this.place.trigger('neededPlugins.system',{pluginlist:this.neededPlugins,event:"pluginsAvailable."+this.applicationType});
    }
    
    /**
     * Icons
     */
    application.prototype.icons = {
        close: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="30" height="30" viewBox="0 0 30 30" class="mini-icon mini-icon-close"><circle class="mini-icon-background" fill="white" cx="15" cy="15" r="14" /><path class="mini-icon-foreground" style="stroke: none;" fill="black" d="M15 1 a14 14 0 0 0 0 28 a14 14 0 0 0 0 -28z m0 1 a13 13 0 0 1 0 26 a13 13 0 0 1 0 -26z M7 11 a2 2 0 0 1 4 -4 l4 4 l4 -4 a2 2 0 0 1 4 4 l-4 4 l4 4 a2 2 0 0 1 -4 4 l-4 -4 l-4 4 a2 2 0 0 1 -4 -4 l4 -4z"></path></svg>',
        waitspinner: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="50" height="50" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="wait-circle-1"><circle style="stroke: rgba(0,0,0,0.2); stroke-width: 10; fill: none;" cx="50" cy="50" r="40"></circle><path class="waitspinner" style="stroke-linecap: round; stroke-width: 10; fill: none;" stroke="rgba(0,0,0,0.5)" d="M50 10 a40 40 0 1 1 -40 40"><animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 50 50" to="360 50 50" dur="2s" repeatCount="indefinite" /></path></svg>'
    }
