// Requires: wikiFormatters, auxiliaryFunctions
// Has some easily removable connections to Tiddler object.

{ // Wikifier
    
    // Sisäinen, käyttäjät: wikify, wikifyStatic
    function getParser(tiddler, format)
    {
        if (tiddler) {
            if(!format) // The format wasn't given as a parameter, fetch from a tiddler field.
                format = tiddler.fields["wikiformat"];
            var i;
            if(format) { // Select the given format from the set of parsers / formatters.
                for(i in wikiEngine.parsers) {
                    if(format == wikiEngine.parsers[i].format)
                        return wikiEngine.parsers[i];
                }
            } else { // The format was not given neither as a parameter nor as a tiddler field.
                for(i in wikiEngine.parsers) {
                    if(tiddler.isTagged(wikiEngine.parsers[i].formatTag))
                        return wikiEngine.parsers[i];
                }
            }
        }
        // The tiddler was not defined, or the defined parser wasn't found. Return the default parser / formatter.
        return formatter;
    }
    
    // Ulkoinen, lukuisia käyttäjiä.
    function wikify(source, output, highlightRegExp, tiddler)
    {
        if(source) {
            var wikifier = new Wikifier(source,getParser(tiddler),highlightRegExp,tiddler);
            wikifier.subWikify(output);
        }
    }
    
    // ulkoinen, käyttäjät: tiddlerToRssItem
    function wikifyStatic(source,highlightRegExp,tiddler,format)
    {
        var e = createTiddlyElement(document.body,"pre");
        e.style.display = "none";
        var html = "";
        if(source && source != "") {
            if(!tiddler)
                tiddler = new Tiddler("temp");
            var wikifier = new Wikifier(source,getParser(tiddler,format),highlightRegExp,tiddler);
            wikifier.isStatic = true;
            wikifier.subWikify(e);
            html = e.innerHTML;
            removeNode(e);
        }
        return html;
    }
    
    // ulkoinen & sisäinen,
    // sisäiset käyttäjät: wikifyPlain;
    // ulkoiset käyttäjät: wikiEngine.macros.importTiddlers.onGetTiddlerList
    function wikifyPlainText(text,limit,tiddler)
    {
        if(limit > 0)
            text = text.substr(0,limit);
        var wikifier = new Wikifier(text,formatter,null,tiddler);
        return wikifier.wikifyPlain();
    }

    // ulkoinen, käyttäjät: wikiEngine.macros.view.views
    function highlightify(source,output,highlightRegExp,tiddler)
    {
        if(source) {
            var wikifier = new Wikifier(source,formatter,highlightRegExp,tiddler);
            wikifier.outputText(output,0,source.length);
        }
    }

    // Sisäinen, käyttäjät: wikify, wikifyStatic, wikifyPlainText, highlightify
    function Wikifier(source,formatter,highlightRegExp,tiddler)
    {
        this.source = source;
        this.output = null;
        this.formatter = formatter;
        this.nextMatch = 0;
        this.autoLinkWikiWords = tiddler && tiddler.autoLinkWikiWords() == false ? false : true;
        this.highlightRegExp = highlightRegExp;
        this.highlightMatch = null;
        this.isStatic = false;
        if(highlightRegExp) {
            highlightRegExp.lastIndex = 0;
            this.highlightMatch = highlightRegExp.exec(source);
        }
        this.tiddler = tiddler;
    }

    // Sisäinen, käyttäjät: wikifyPlainText
    Wikifier.prototype.wikifyPlain = function()
    {
        var e = createTiddlyElement(document.body,"div");
        e.style.display = "none";
        this.subWikify(e);
        var text = getPlainText(e);
        removeNode(e);
        return text;
    };

    Wikifier.prototype.subWikify = function(output,terminator)
    {
        try {
            if(terminator)
                this.subWikifyTerm(output,new RegExp("(" + terminator + ")","mg"));
            else
                this.subWikifyUnterm(output);
        } catch(ex) {
            showException(ex);
        }
    };

    // sisäinen, käyttäjät: Wikifier.subWikify
    Wikifier.prototype.subWikifyUnterm = function(output)
    {
        var oldOutput = this.output;
        this.output = output;
        this.formatter.formatterRegExp.lastIndex = this.nextMatch;
        var formatterMatch = this.formatter.formatterRegExp.exec(this.source);
        while(formatterMatch) {
            // Output any text before the match
            if(formatterMatch.index > this.nextMatch)
                this.outputText(this.output,this.nextMatch,formatterMatch.index);
            // Set the match parameters for the handler
            this.matchStart = formatterMatch.index;
            this.matchLength = formatterMatch[0].length;
            this.matchText = formatterMatch[0];
            this.nextMatch = this.formatter.formatterRegExp.lastIndex;
            for(var t=1; t<formatterMatch.length; t++) {
                if(formatterMatch[t]) {
                    this.formatter.formatters[t-1].handler(this);
                    this.formatter.formatterRegExp.lastIndex = this.nextMatch;
                    break;
                }
            }
            formatterMatch = this.formatter.formatterRegExp.exec(this.source);
        }
        if(this.nextMatch < this.source.length) {
            this.outputText(this.output,this.nextMatch,this.source.length);
            this.nextMatch = this.source.length;
        }
        this.output = oldOutput;
    };

    // sisäinen & ulkoinen;
    // sisäiset käyttäjät: Wikifier.subWikify
    // ulkoiset käyttäjät: monia (eri formatterien handler-funktiot)
    Wikifier.prototype.subWikifyTerm = function(output,terminatorRegExp)
    {
        var oldOutput = this.output;
        this.output = output;
        terminatorRegExp.lastIndex = this.nextMatch;
        var terminatorMatch = terminatorRegExp.exec(this.source);
        this.formatter.formatterRegExp.lastIndex = this.nextMatch;
        var formatterMatch = this.formatter.formatterRegExp.exec(terminatorMatch ? this.source.substr(0,terminatorMatch.index) : this.source);
        while(terminatorMatch || formatterMatch) {
            if(terminatorMatch && (!formatterMatch || terminatorMatch.index <= formatterMatch.index)) {
                if(terminatorMatch.index > this.nextMatch)
                    this.outputText(this.output,this.nextMatch,terminatorMatch.index);
                this.matchText = terminatorMatch[1];
                this.matchLength = terminatorMatch[1].length;
                this.matchStart = terminatorMatch.index;
                this.nextMatch = this.matchStart + this.matchLength;
                this.output = oldOutput;
                return;
            }
            if(formatterMatch.index > this.nextMatch)
                this.outputText(this.output,this.nextMatch,formatterMatch.index);
            this.matchStart = formatterMatch.index;
            this.matchLength = formatterMatch[0].length;
            this.matchText = formatterMatch[0];
            this.nextMatch = this.formatter.formatterRegExp.lastIndex;
            for(var t=1; t<formatterMatch.length; t++) {
                if(formatterMatch[t]) {
                    this.formatter.formatters[t-1].handler(this);
                    this.formatter.formatterRegExp.lastIndex = this.nextMatch;
                    break;
                }
            }
            terminatorRegExp.lastIndex = this.nextMatch;
            terminatorMatch = terminatorRegExp.exec(this.source);
            formatterMatch = this.formatter.formatterRegExp.exec(terminatorMatch ? this.source.substr(0,terminatorMatch.index) : this.source);
        }
        if(this.nextMatch < this.source.length) {
            this.outputText(this.output,this.nextMatch,this.source.length);
            this.nextMatch = this.source.length;
        }
        this.output = oldOutput;
    };

    Wikifier.prototype.outputText = function(place,startPos,endPos)
    {
        while(this.highlightMatch && (this.highlightRegExp.lastIndex > startPos) && (this.highlightMatch.index < endPos) && (startPos < endPos)) {
            if(this.highlightMatch.index > startPos) {
                createTiddlyText(place,this.source.substring(startPos,this.highlightMatch.index));
                startPos = this.highlightMatch.index;
            }
            var highlightEnd = Math.min(this.highlightRegExp.lastIndex,endPos);
            var theHighlight = createTiddlyElement(place,"span",null,"highlight",this.source.substring(startPos,highlightEnd));
            startPos = highlightEnd;
            if(startPos >= this.highlightRegExp.lastIndex)
                this.highlightMatch = this.highlightRegExp.exec(this.source);
        }
        if(startPos < endPos) {
            createTiddlyText(place,this.source.substring(startPos,endPos));
        }
    }
    
    Wikifier.prototype.register = function() {
        $.notify('Wikifier.prototype.register() is a stub.');
    }
}
