// Generated by CoffeeScript 1.7.1
(function() {
  "use strict";
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  (function(root, factory) {
    var htmlparser, jsdom;
    if ("object" === typeof exports) {
      htmlparser = require('htmlparser-jresig');
      jsdom = require("jsdom").jsdom;
      module.exports = factory(htmlparser, jsdom);
    } else if (typeof define !== "undefined" && define !== null ? define.amd : void 0) {
      define(['htmlparser'], factory);
    } else {
      root.upndown = factory(htmlparser);
    }
  })(this, function(htmlparser, jsdom) {
    var upndown;
    upndown = (function() {
      upndown.depth;

      upndown.buffer;

      upndown.prefixstack;

      upndown.currentollistack;

      upndown.inlineelements;

      upndown.tabindent;

      upndown.textnodetype;

      upndown.documentnodetype;

      upndown.document;

      upndown.prototype.setupParser = function() {
        this.depth = 0;
        this.buffer = {
          0: []
        };
        this.prefixstack = {
          0: ''
        };
        this.currentollistack = [];
        this.inlineelements = ['_text', 'strong', 'b', 'i', 'em', 'u', 'a', 'img', 'code'];
        this.nonmarkdownblocklevelelement = ['div', 'iframe'];
        this.tabindent = '    ';
        this.textnodetype = 3;
        this.documentnodetype = 9;
        if (jsdom) {
          return this.document = new jsdom();
        } else {
          return this.document = null;
        }
      };

      function upndown() {
        this.unescape = __bind(this.unescape, this);
        this.lastChildNonText = __bind(this.lastChildNonText, this);
        this.hasLastChildNonTextOfType = __bind(this.hasLastChildNonTextOfType, this);
        this.hasLastChildOfType = __bind(this.hasLastChildOfType, this);
        this.isWrappingRootNode = __bind(this.isWrappingRootNode, this);
        this.isFirstNodeNonText = __bind(this.isFirstNodeNonText, this);
        this.isFirstNode = __bind(this.isFirstNode, this);
        this.isLastChildNonTextUntilDepth0 = __bind(this.isLastChildNonTextUntilDepth0, this);
        this.isLastChildNonText = __bind(this.isLastChildNonText, this);
        this.isLastChild = __bind(this.isLastChild, this);
        this.isFirstChildNonTextOfParentType = __bind(this.isFirstChildNonTextOfParentType, this);
        this.hasFirstChildNonTextOfType = __bind(this.hasFirstChildNonTextOfType, this);
        this.isFirstChildNonText = __bind(this.isFirstChildNonText, this);
        this.isFirstChild = __bind(this.isFirstChild, this);
        this.firstChildNonText = __bind(this.firstChildNonText, this);
        this.hasNextSiblingNonTextOfType = __bind(this.hasNextSiblingNonTextOfType, this);
        this.hasPreviousSiblingNonTextOfType = __bind(this.hasPreviousSiblingNonTextOfType, this);
        this.nextsiblingnontext = __bind(this.nextsiblingnontext, this);
        this.isNextSiblingNonTextBlock = __bind(this.isNextSiblingNonTextBlock, this);
        this.isNextSiblingNonTextInline = __bind(this.isNextSiblingNonTextInline, this);
        this.isNextSiblingBlock = __bind(this.isNextSiblingBlock, this);
        this.isNextSiblingInline = __bind(this.isNextSiblingInline, this);
        this.previoussiblingnontext = __bind(this.previoussiblingnontext, this);
        this.isPreviousSiblingNonTextBlock = __bind(this.isPreviousSiblingNonTextBlock, this);
        this.isPreviousSiblingNonTextInline = __bind(this.isPreviousSiblingNonTextInline, this);
        this.isPreviousSiblingBlock = __bind(this.isPreviousSiblingBlock, this);
        this.isPreviousSiblingInline = __bind(this.isPreviousSiblingInline, this);
        this.isNonMarkdownBlockLevelElement = __bind(this.isNonMarkdownBlockLevelElement, this);
        this.isInline = __bind(this.isInline, this);
        this.convert = __bind(this.convert, this);
        this.escapeTextForMarkdown = __bind(this.escapeTextForMarkdown, this);
        this.hasAncestorOfType = __bind(this.hasAncestorOfType, this);
        this.hasParentOfType = __bind(this.hasParentOfType, this);
        this.prefixstack_pop = __bind(this.prefixstack_pop, this);
        this.prefixstack_push = __bind(this.prefixstack_push, this);
        this.getPrefix = __bind(this.getPrefix, this);
        this.parentTag = __bind(this.parentTag, this);
        this.currentdepth = __bind(this.currentdepth, this);
        this.setupParser = __bind(this.setupParser, this);
        this.setupParser();
        this.standardmethods = {
          open: {
            _default: (function(_this) {
              return function(node, prefix) {
                _this.prefixstack_push(prefix);
                _this.depth++;
                return _this.buffer[_this.currentdepth()] = [];
              };
            })(this)
          },
          close: {
            hx: (function(_this) {
              return function(node) {
                var depth, html, level, nl, prefix;
                depth = _this.currentdepth();
                _this.depth--;
                prefix = _this.prefixstack_pop();
                level = parseInt(node.tagName.toLowerCase().substr(1));
                html = prefix + Array(level + 1).join('#') + ' ' + _this.buffer[depth].join('').split('\n').join('\n' + prefix);
                nl = '';
                if (!_this.isFirstNodeNonText(node) && !_this.isFirstChildNonText(node)) {
                  nl = '\n';
                  nl += '\n';
                }
                return _this.buffer[depth - 1].push(nl + html);
              };
            })(this)
          }
        };
        this.methods = {};
        this.methods['_text'] = (function(_this) {
          return function(node) {
            var text;
            text = _this.unescape(node.data);
            if (text) {
              if (!(_this.hasParentOfType(node, 'code') && _this.isFirstChild(node)) && (!_this.isPreviousSiblingInline(node) || (_this.isFirstChild(node) && _this.hasParentOfType(node, 'li')))) {
                if (text.match(/^[\n\s\t]+$/)) {
                  return;
                }
                text = text.replace(/^[\s\t]*/, '');
              }
              if (!_this.hasParentOfType(node, 'pre') && !_this.hasParentOfType(node, 'code')) {
                text = text.replace(/\n/g, ' ');
                text = text.replace(/[\s\t]+/g, ' ');
              }
              return _this.buffer[_this.currentdepth()].push(_this.escapeTextForMarkdown(node, text));
            } else {
              return _this.buffer[_this.currentdepth()].push('');
            }
          };
        })(this);
        this.methods['open'] = {};
        this.methods['open']['_html'] = (function(_this) {
          return function(node) {
            var htmltag, i, tag;
            if (_this.isWrappingRootNode(node)) {
              return;
            }
            tag = node.tagName.toLowerCase();
            htmltag = '<' + tag;
            if (_this.isNonMarkdownBlockLevelElement(tag) && !_this.isFirstChildNonText(node)) {
              htmltag = '\n' + htmltag;
            }
            i = 0;
            while (i < node.attributes.length) {
              htmltag += " " + node.attributes[i].name + '="' + node.attributes[i].nodeValue + '"';
              i++;
            }
            htmltag += '>';
            _this.buffer[_this.currentdepth()].push(htmltag);
            _this.prefixstack_push('');
            _this.depth++;
            return _this.buffer[_this.currentdepth()] = [];
          };
        })(this);
        this.methods['open']['p'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['br'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['blockquote'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '> ');
          };
        })(this);
        this.methods['open']['pre'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, _this.tabindent);
          };
        })(this);
        this.methods['open']['code'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['hr'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['ul'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['ol'] = (function(_this) {
          return function(node) {
            _this.currentollistack.push(1);
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['li'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, _this.tabindent);
          };
        })(this);
        this.methods['open']['h1'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['h2'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['h3'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['h4'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['h5'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['h6'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['strong'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['b'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['em'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['i'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['a'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['img'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['open']['br'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.open._default(node, '');
          };
        })(this);
        this.methods['close'] = {};
        this.methods['close']['_html'] = (function(_this) {
          return function(node) {
            var depth, html, prefix;
            if (_this.isWrappingRootNode(node)) {
              return;
            }
            depth = _this.currentdepth();
            _this.depth--;
            prefix = _this.prefixstack_pop();
            html = prefix + _this.buffer[depth].join('');
            return _this.buffer[depth - 1].push(html + '</' + node.tagName.toLowerCase() + '>');
          };
        })(this);
        this.methods['close']['p'] = (function(_this) {
          return function(node) {
            var depth, html, nl, prefix;
            depth = _this.currentdepth();
            _this.depth--;
            prefix = _this.prefixstack_pop();
            nl = '';
            if (!_this.isFirstNodeNonText(node) && !_this.isFirstChildNonTextOfParentType(node, 'blockquote') && !(_this.hasParentOfType(node, 'li') && _this.isFirstChildNonText(node))) {
              nl += '\n\n';
            }
            html = prefix + _this.buffer[depth].join('').split('\n').join('\n' + prefix);
            return _this.buffer[depth - 1].push(nl + html);
          };
        })(this);
        this.methods['close']['hr'] = (function(_this) {
          return function(node) {
            var depth, html, nl, prefix;
            depth = _this.currentdepth();
            _this.depth--;
            prefix = _this.prefixstack_pop();
            nl = '';
            if (!_this.isFirstNodeNonText(node)) {
              nl = '\n\n';
            }
            html = prefix + nl + '* * *\n' + _this.buffer[depth].join('').split('\n').join('\n' + prefix);
            return _this.buffer[depth - 1].push(html);
          };
        })(this);
        this.methods['close']['blockquote'] = (function(_this) {
          return function(node) {
            var depth, html, nl, postnl, prefix;
            depth = _this.currentdepth();
            _this.depth--;
            prefix = _this.prefixstack_pop();
            html = prefix + _this.buffer[depth].join('').split('\n').join('\n' + prefix);
            nl = '';
            if (!_this.isFirstNodeNonText(node) && !_this.isFirstChildNonText(node)) {
              nl += '\n\n';
            }
            postnl = '';
            if (_this.isNextSiblingNonTextInline(node)) {
              postnl = '\n\n';
            }
            return _this.buffer[depth - 1].push(nl + html + postnl);
          };
        })(this);
        this.methods['close']['pre'] = (function(_this) {
          return function(node) {
            var beforenl, depth, html, prefix, prevsibling, superextrapadding;
            depth = _this.currentdepth();
            _this.depth--;
            prefix = _this.prefixstack_pop();
            html = prefix + _this.buffer[depth].join('').split('\n').join('\n' + prefix);
            beforenl = '';
            superextrapadding = '';
            if (!_this.isFirstNodeNonText(node)) {
              beforenl = '\n\n';
            }
            prevsibling = _this.previoussiblingnontext(node);
            if ((prevsibling && (prevsibling.tagName.toLowerCase() === 'ul' || prevsibling.tagName.toLowerCase() === 'li')) || (_this.hasParentOfType(node, 'li'))) {
              superextrapadding = '\n';
            } else {
              superextrapadding = '';
            }
            return _this.buffer[depth - 1].push(superextrapadding + beforenl + html);
          };
        })(this);
        this.methods['close']['code'] = (function(_this) {
          return function(node) {
            var begin, depth, end, html, prefix;
            depth = _this.currentdepth();
            _this.depth--;
            prefix = _this.prefixstack_pop();
            if (!_this.hasAncestorOfType(node, 'pre')) {
              begin = '`';
              end = '`';
            } else {
              begin = '';
              end = '';
            }
            html = prefix + unescape(begin + _this.buffer[depth].join('') + end).split('\n').join('\n' + prefix);
            return _this.buffer[depth - 1].push(html);
          };
        })(this);
        this.methods['close']['ul'] = (function(_this) {
          return function(node) {
            var depth, html, nl, prefix;
            depth = _this.currentdepth();
            _this.depth--;
            prefix = _this.prefixstack_pop();
            nl = '';
            if (!_this.isFirstNodeNonText(node)) {
              nl = '\n';
              if ((!_this.hasParentOfType(node, 'li') || _this.hasPreviousSiblingNonTextOfType(node, 'p')) && (!_this.hasParentOfType(node, 'blockquote') || !_this.isFirstChildNonText(node))) {
                nl += '\n';
              }
            }
            html = nl + prefix + _this.buffer[depth].join('').split('\n').join('\n' + prefix);
            return _this.buffer[depth - 1].push(html);
          };
        })(this);
        this.methods['close']['ol'] = (function(_this) {
          return function(node) {
            _this.currentollistack.pop();
            return _this.methods.close.ul(node);
          };
        })(this);
        this.methods['close']['li'] = (function(_this) {
          return function(node) {
            var currentolli, depth, html, nl, prefix, puce;
            depth = _this.currentdepth();
            _this.depth--;
            prefix = _this.prefixstack_pop();
            if (_this.hasParentOfType(node, 'ol')) {
              currentolli = _this.currentollistack[_this.currentollistack.length - 1];
              puce = currentolli + '.';
              puce += Array((4 - puce.length) + 1).join(' ');
              _this.currentollistack[_this.currentollistack.length - 1]++;
            } else {
              puce = '*   ';
            }
            if (!(_this.isFirstNodeNonText(node.parentNode) && _this.isFirstChildNonText(node)) && _this.hasPreviousSiblingNonTextOfType(node, 'li')) {
              nl = '\n';
            } else {
              nl = '';
            }
            if (!_this.isFirstChildNonText(node) && _this.hasFirstChildNonTextOfType(node, 'p')) {
              nl += '\n';
            }
            html = nl + puce + _this.buffer[depth].join('').split('\n').join('\n' + prefix);
            return _this.buffer[depth - 1].push(html);
          };
        })(this);
        this.methods['close']['h1'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.close.hx(node);
          };
        })(this);
        this.methods['close']['h2'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.close.hx(node);
          };
        })(this);
        this.methods['close']['h3'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.close.hx(node);
          };
        })(this);
        this.methods['close']['h4'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.close.hx(node);
          };
        })(this);
        this.methods['close']['h5'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.close.hx(node);
          };
        })(this);
        this.methods['close']['h6'] = (function(_this) {
          return function(node) {
            return _this.standardmethods.close.hx(node);
          };
        })(this);
        this.methods['close']['strong'] = (function(_this) {
          return function(node) {
            var depth, html, prefix;
            depth = _this.currentdepth();
            _this.depth--;
            prefix = _this.prefixstack_pop();
            html = prefix + '**' + _this.buffer[depth].join('').split('\n').join('\n' + prefix);
            return _this.buffer[depth - 1].push(html + '**');
          };
        })(this);
        this.methods['close']['b'] = (function(_this) {
          return function(node) {
            return _this.methods.close.strong(node);
          };
        })(this);
        this.methods['close']['em'] = (function(_this) {
          return function(node) {
            var depth, html, prefix;
            depth = _this.currentdepth();
            _this.depth--;
            prefix = _this.prefixstack_pop();
            html = prefix + '*' + _this.buffer[depth].join('').split('\n').join('\n' + prefix) + '*';
            return _this.buffer[depth - 1].push(html);
          };
        })(this);
        this.methods['close']['i'] = (function(_this) {
          return function(node) {
            return _this.methods.close.em(node);
          };
        })(this);
        this.methods['close']['a'] = (function(_this) {
          return function(node) {
            var depth, label, prefix, title, unescapedurl, url;
            depth = _this.currentdepth();
            _this.depth--;
            prefix = _this.prefixstack_pop();
            url = _this.attrOrFalse('href', node);
            title = _this.attrOrFalse('title', node);
            label = _this.buffer[depth].join('');
            unescapedurl = _this.unescape(url);
            if (url && url === label && (!title || title === '')) {
              return _this.buffer[depth - 1].push('<' + url + '>');
            } else if ((unescapedurl === label || unescapedurl.replace(/^mailto:/, '') === label) && (!title || title === '')) {
              return _this.buffer[depth - 1].push('<' + unescapedurl.replace(/^mailto:/, '') + '>');
            } else {
              return _this.buffer[depth - 1].push('[' + label + '](' + (url ? _this.unescape(url) : '') + (title ? ' "' + _this.unescape(title) + '"' : '') + ')');
            }
          };
        })(this);
        this.methods['close']['img'] = (function(_this) {
          return function(node) {
            var alt, depth, html, prefix, src, title;
            depth = _this.currentdepth();
            _this.depth--;
            prefix = _this.prefixstack_pop();
            alt = _this.attrOrFalse('alt', node);
            src = _this.attrOrFalse('src', node);
            title = _this.attrOrFalse('title', node);
            html = prefix + '![' + (alt ? alt : '') + '](' + (src ? src : '') + (title ? ' "' + title + '"' : '') + ')';
            return _this.buffer[depth - 1].push(html);
          };
        })(this);
        this.methods['close']['br'] = (function(_this) {
          return function(node) {
            var depth, html, prefix;
            depth = _this.currentdepth();
            _this.depth--;
            prefix = _this.prefixstack_pop();
            html = prefix + _this.buffer[depth].join('').split('\n').join('\n' + prefix);
            return _this.buffer[depth - 1].push(html + '  \n');
          };
        })(this);
      }

      upndown.prototype.currentdepth = function() {
        return this.depth;
      };

      upndown.prototype.parentTag = function(node) {
        if (node && node.parentNode && node.parentNode.nodeType !== this.documentnodetype) {
          return node.parentNode;
        } else {
          return null;
        }
      };

      upndown.prototype.getPrefix = function() {
        if (this.prefixstack[this.currentdepth()]) {
          this.prefixstack[this.currentdepth()];
        }
        return '';
      };

      upndown.prototype.prefixstack_push = function(prefix) {
        return this.prefixstack[this.currentdepth()] = prefix;
      };

      upndown.prototype.prefixstack_pop = function(prefix) {
        var before;
        before = this.prefixstack[this.currentdepth()];
        this.prefixstack[this.currentdepth()] = '';
        return before;
      };

      upndown.prototype.hasParentOfType = function(node, tagname) {
        var parent;
        parent = this.parentTag(node);
        return parent && parent.tagName.toLowerCase() === tagname;
      };

      upndown.prototype.hasAncestorOfType = function(node, tagname) {
        var parent;
        parent = this.parentTag(node);
        while (parent) {
          if (parent.tagName.toLowerCase() === tagname) {
            return true;
          }
          parent = this.parentTag(parent);
        }
        return false;
      };

      upndown.prototype.escapeTextForMarkdown = function(node, text) {
        var escapeChar;
        if (this.hasAncestorOfType(node, 'code') || this.hasAncestorOfType(node, 'pre')) {
          return text;
        }
        escapeChar = '\\';
        return text.replace(/\\/g, escapeChar + escapeChar).replace(/`/g, escapeChar + '`').replace(/\#/g, escapeChar + '#');
      };

      upndown.prototype.convert = function(html) {
        var dom, getNodeName, walkDOM;
        this.setupParser();
        getNodeName = function(node) {
          if (node.nodeType === 3) {
            return "_text";
          } else {
            return node.tagName.toLowerCase();
          }
        };
        walkDOM = function(node, cbktext, cbkopen, cbkexplore, cbkclose) {
          var orignode;
          if (node.nodeType === 3) {
            cbktext(node);
          } else {
            orignode = node;
            cbkopen(orignode);
            cbkexplore(orignode);
            node = node.firstChild;
            while (node) {
              walkDOM(node, cbktext, cbkopen, cbkexplore, cbkclose);
              node = node.nextSibling;
            }
            cbkclose(orignode);
          }
        };
        if (this.document) {
          dom = HTMLtoDOM('<div id="hello">' + html + '</div>', this.document);
        } else {
          dom = HTMLtoDOM('<div id="hello">' + html + '</div>');
        }
        walkDOM(dom.getElementById("hello"), (function(_this) {
          return function(node) {
            return _this.methods['_text'](node);
          };
        })(this), (function(_this) {
          return function(node) {
            if (_this.methods.open[node.tagName.toLowerCase()]) {
              return _this.methods.open[node.tagName.toLowerCase()](node);
            } else {
              return _this.methods.open['_html'](node);
            }
          };
        })(this), (function(_this) {
          return function(node) {
            return null;
          };
        })(this), (function(_this) {
          return function(node) {
            if (_this.methods.close[node.tagName.toLowerCase()]) {
              return _this.methods.close[node.tagName.toLowerCase()](node);
            } else {
              return _this.methods.close['_html'](node);
            }
          };
        })(this));
        return this.buffer[0].join('').replace(/\s*$/, '').replace(/^[ \t]+$/gm, '').replace(/\n{3,}/gm, '\n\n\n');
      };

      upndown.prototype.isInline = function(tag) {
        return __indexOf.call(this.inlineelements, tag) >= 0;
      };

      upndown.prototype.isNonMarkdownBlockLevelElement = function(tag) {
        return __indexOf.call(this.nonmarkdownblocklevelelement, tag) >= 0;
      };

      upndown.prototype.isPreviousSiblingInline = function(node) {
        return node && node.previousSibling && node.previousSibling.tagName && this.isInline(node.previousSibling.tagName.toLowerCase());
      };

      upndown.prototype.isPreviousSiblingBlock = function(node) {
        return node && node.previousSibling && node.previousSibling.tagName && !this.isInline(node.previousSibling.tagName.toLowerCase());
      };

      upndown.prototype.isPreviousSiblingNonTextInline = function(node) {
        var previous;
        if (node) {
          previous = this.previoussiblingnontext(node);
        }
        return node && previous && this.isInline(previous.tagName.toLowerCase());
      };

      upndown.prototype.isPreviousSiblingNonTextBlock = function(node) {
        var previous;
        if (node) {
          previous = this.previoussiblingnontext(node);
        }
        return node && previous && !this.isInline(previous.tagName.toLowerCase());
      };

      upndown.prototype.previoussiblingnontext = function(node) {
        var prevsibling;
        prevsibling = node;
        while (true) {
          if (prevsibling) {
            prevsibling = prevsibling.previousSibling;
          }
          if (prevsibling && prevsibling.nodeType !== this.textnodetype) {
            return prevsibling;
          }
          if (!(prevsibling && !this.isFirstChildNonText(prevsibling))) {
            break;
          }
        }
        return null;
      };

      upndown.prototype.isNextSiblingInline = function(node) {
        return node && node.nextSibling && node.nextSibling.tagName && this.isInline(node.nextSibling.tagName.toLowerCase());
      };

      upndown.prototype.isNextSiblingBlock = function(node) {
        return node && node.nextSibling && node.nextSibling.tagName && !this.isInline(node.nextSibling.tagName.toLowerCase());
      };

      upndown.prototype.isNextSiblingNonTextInline = function(node) {
        var next;
        if (node) {
          next = this.nextsiblingnontext(node);
        }
        return node && next && this.isInline(next.tagName.toLowerCase());
      };

      upndown.prototype.isNextSiblingNonTextBlock = function(node) {
        var next;
        if (node) {
          next = this.previoussiblingnontext(node);
        }
        return node && next && !this.isInline(next.tagName.toLowerCase());
      };

      upndown.prototype.nextsiblingnontext = function(node) {
        var nextsibling;
        nextsibling = node;
        while (true) {
          if (nextsibling) {
            nextsibling = nextsibling.nextSibling;
          }
          if (nextsibling && nextsibling.nodeType !== this.textnodetype) {
            return nextsibling;
          }
          if (!(nextsibling && !this.isLastChildNonText(nextsibling))) {
            break;
          }
        }
        return null;
      };

      upndown.prototype.hasPreviousSiblingNonTextOfType = function(node, tagname) {
        var previoussiblingnontext;
        previoussiblingnontext = this.previoussiblingnontext(node);
        return previoussiblingnontext && previoussiblingnontext.tagName.toLowerCase() === tagname;
      };

      upndown.prototype.hasNextSiblingNonTextOfType = function(node, tagname) {
        var nextsiblingnontext;
        nextsiblingnontext = this.nextsiblingnontext(node);
        return nextsiblingnontext && nextsiblingnontext.tagName.toLowerCase() === tagname;
      };

      upndown.prototype.firstChildNonText = function(node) {
        var i;
        i = 0;
        while (i < node.childNodes.length) {
          if (node.childNodes[i].nodeType !== this.textnodetype) {
            return node.childNodes[i];
          }
          i++;
        }
        return null;
      };

      upndown.prototype.isFirstChild = function(node) {
        return !(!!node && !!node.previousSibling);
      };

      upndown.prototype.isFirstChildNonText = function(node) {
        return node.parentNode && (this.firstChildNonText(node.parentNode) === node);
      };

      upndown.prototype.hasFirstChildNonTextOfType = function(node, childtype) {
        if (!node || !node.firstChild) {
          return null;
        }
        if (node.firstChild.nodeType !== this.textnodetype) {
          return node.firstChild.tagName.toLowerCase() === childtype;
        }
        return this.hasNextSiblingNonTextOfType(node.firstChild, childtype);
      };

      upndown.prototype.isFirstChildNonTextOfParentType = function(node, parenttype) {
        return this.hasParentOfType(node, parenttype) && this.firstChildNonText(node.parentNode) === node;
      };

      upndown.prototype.isLastChild = function(node) {
        return !(!!node.nextSibling);
      };

      upndown.prototype.isLastChildNonText = function(node) {
        return this.isLastChild(node) || this.lastChildNonText(node.parentNode) === node;
      };

      upndown.prototype.isLastChildNonTextUntilDepth0 = function(node) {
        if (!!!node) {
          return false;
        }
        if ((node.parentNode && this.isFirstNodeNonText(node.parentNode)) || this.isFirstNodeNonText(node)) {
          return true;
        }
        if (!this.isLastChildNonText(node)) {
          return false;
        }
        return this.isLastChildNonTextUntilDepth0(node.parentNode);
      };

      upndown.prototype.isFirstNode = function(node) {
        return !!node && this.isFirstChild(node) && this.isWrappingRootNode(node.parentNode);
      };

      upndown.prototype.isFirstNodeNonText = function(node) {
        return !!node && this.isFirstChildNonText(node) && this.isWrappingRootNode(node.parentNode);
      };

      upndown.prototype.isWrappingRootNode = function(node) {
        return node && node.nodeType !== this.textnodetype && node.tagName.toLowerCase() === 'div' && this.attrOrFalse('id', node) === 'hello';
      };

      upndown.prototype.hasLastChildOfType = function(node, lastchildtype) {
        return node && node.lastChild && node.lastChild.tagName.toLowerCase() === lastchildtype;
      };

      upndown.prototype.hasLastChildNonTextOfType = function(node, lastchildtype) {
        if (!node || !node.lastChild) {
          return null;
        }
        if (node.lastChild.nodeType !== this.textnodetype) {
          return node.lastChild.tagName.toLowerCase() === lastchildtype;
        }
        return this.hasPreviousSiblingNonTextOfType(node.lastChild, lastchildtype);
      };

      upndown.prototype.lastChildNonText = function(node) {
        if (!node || !node.lastChild) {
          return null;
        }
        if (node.lastChild.nodeType !== this.textnodetype) {
          return node.lastChild;
        }
        return this.previoussiblingnontext(node.lastChild);
      };

      upndown.prototype.unescape = function(html) {
        var e;
        if (this.document) {
          e = this.document.createElement('div');
        } else {
          e = document.createElement('div');
        }
        e.innerHTML = html;
        if (e.childNodes.length === 0) {
          return '';
        } else {
          return e.childNodes[0].nodeValue;
        }
      };


      /* Static methods under this line */

      upndown.prototype.attrOrFalse = function(attr, node) {
        var i;
        i = 0;
        while (i < node.attributes.length) {
          if (node.attributes[i].name === attr) {
            return node.attributes[i].nodeValue;
          }
          i++;
        }
        return false;
      };

      return upndown;

    })();
    return upndown;
  });

}).call(this);
