$(function(){
    jQuery('body').off('getusersolutiondata')
        .on('getusersolutiondata',
            function(e,assignment){
                var data = getSolutionData(assignment);
                jQuery(e.target).trigger('usersolutiondata',[data]);
            });
    jQuery('body').off('setusersolutiondata')
        .on('setusersolutiondata',
            function(e,assignment,solutiondata){
                var solutionid = setSolutionData(assignment,solutiondata);
                jQuery(e.target).trigger('usersolutiondataset',[solutionid]);
            });
            
    checkLocalstorageSolutions = function(){
        if(typeof(Solutions) === "undefined"){
            if(typeof(localStorage.solutions) !== "undefined"){
                Solutions = JSON.parse(localStorage.solutions);
            }else{
                Solutions = {};
            }
        }
    }
    createSolution = function(assignment){
        var i=0;
        while(typeof(Solutions["solution"+i]) !== "undefined"){
            i = i +1;
        }
        return "solution"+i;
    }
    getSolutionData = function(assignment){
        var data = [];
        checkLocalstorageSolutions();
        for(var solutionid in Solutions){
            if(Solutions[solutionid].solutionto && Solutions[solutionid].solutionto === assignment){
                data.push(Solutions[solutionid]);
            }
        }
        return data;
    }
    setSolutionData = function(assignment,solutiondata){
        try{
            checkLocalstorageSolutions();
            if(typeof(solutiondata.solutionid) ==="undefined"){
                var solutionid = createSolution(assignment);
            }else{
                var solutionid = solutiondata.solutionid;
            }
            Solutions[solutionid] = solutiondata;
            localStorage.solutions = JSON.stringify(Solutions);    
            return solutionid;
        }catch (e){
            return e+"fail";
        }
    }
});