// Useful extra tests that are not present in Modernizr by default.

Modernizr.removeTest = function(feature){
    delete Modernizr[feature];
    var re = new RegExp("\\b(no-)?" + feature + "\\b");
    var docElement = document.documentElement;
    docElement.className = docElement.className.replace( re, '' );
};

Modernizr.updateTest = function(feature, f) {
    if (typeof(Modernizr[feature]) !== 'undefined') Modernizr.removeTest(feature);
    Modernizr.addTest(feature, f);
}

Modernizr.addTest('chromeextension', function () {
    return window.location.origin.indexOf('chrome-extension://') === 0;
});

Modernizr.addTest('ipad', function () {
    return !!navigator.userAgent.match(/iPad/i);
});
 
Modernizr.addTest('iphone', function () {
    return !!navigator.userAgent.match(/iPhone/i);
});
 
Modernizr.addTest('ipod', function () {
    return !!navigator.userAgent.match(/iPod/i);
});

Modernizr.addTest('linux', function () {
    return !!navigator.platform.match(/Linux/i);
});

Modernizr.addTest('mswindows', function () {
    return !!navigator.platform.match(/Win32|Win64/i);
});

Modernizr.addTest('appleosx', function () {
    return !!navigator.platform.match(/MacIntel/i);
});

Modernizr.addTest('android', function () {
    return !!navigator.userAgent.match(/Android/i);
//    return !!navigator.platform.match(/Android/i);
});

Modernizr.addTest('blackberry', function () {
    return !!navigator.platform.match(/BlackBerry/i);
});

Modernizr.addTest('windowsmobile', function () {
    return !!navigator.platform.match(/IEMobile/i);
});

Modernizr.addTest('chromeapp', function () {
    return window.location.origin.indexOf('chrome-extension://') === 0;
});

Modernizr.addTest('appleios', function () {
    return (Modernizr.ipad || Modernizr.ipod || Modernizr.iphone);
});

Modernizr.addTest('java', function () {
    return navigator.javaEnabled();
});

Modernizr.addTest('persistentstorage', function () {
    return (
        ( navigator && navigator.webkitPersistentStorage && window.webkitRequestFileSystem ) ||
        ( navigator && navigator.persistentStorage && window.requestFileSystem )
    );
});

Modernizr.addTest('appjs', function () {
    return (window.location.host === 'appjs');
});

Modernizr.addTest('localfilesystem', function () {
    return (window.requestFileSystem || window.webkitRequestFileSystem) ? true : false;
});

Modernizr.addTest('activexfilesystem', function () {
    var activeXSupport = function(o) {
        try {
            var temp = new ActiveXObject(o);
            return (temp ? true : false);
        }
        catch(e) { return false; } 
    };
    
    return (activeXSupport("Scripting.FileSystemObject"));
});

Modernizr.addTest('firefoxplugin', function () {
    return "maybe";
});

Modernizr.addTest('backendconnection', function () {
    return "maybe";
});

Modernizr.addTest('localnodefileserver', function () {
    return ("maybe");
});