/******
@name Reflink
@version 0.1
@author Petri Salmela <petri.salmela@abo.fi>
@type plugin
@requires jQuery x.x.x or newer
@class Reflink
@description A dummy placeholder that is used as an anchor for linked content elements.
*******/

/**
 * Requirements:
 * - jQuery
 */

try {
    typeof(jQuery) === 'undefined' && jQuery;
} catch (err) {
    throw new Error('Missing dependency in ' + err.fileName + '\n' + err);
}

/**
 * Optional requirements
 * - ElementSet
 * - ElementPanel
 */

if (typeof(checkOptionalRequirements) !== 'undefined' && checkOptionalRequirements) {
    try {
        typeof(jQuery.fn.elementset) === 'undefined' && jQuery.fn.elementset.apply;
        typeof(jQuery.fn.elementpanel) === 'undefined' && jQuery.fn.elementpanel.apply;
    } catch (err) {
        throw new Error('Missing optional dependency in ' + err.fileName + '\n' + err);
    }
}

;(function($){
    /**** jQuery-plugin *****/
    var methods = {
        'init': function(params){
            return this.each(function(){
                var reflink = new Reflink(this, params);
            });
        },
        'getdata': function(){
            var $place = $(this).eq(0);
            $place.trigger('getdata');
            var data = $place.data('[[elementdata]]');
            return data;
        }
    };
    
    $.fn.reflinkelement = function(method){
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof(method) === 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Method ' + method + ' does not exist in reflinkelement.');
            return false;
        }
    };
    
    /******
     * Reflink class
     * @class Reflink
     * @constructor
     * @param {jQuery} place - Place for reflink
     * @param {Object} options - options for reflink
     ******/
    var Reflink = function(place, options){
        options = $.extend(true, {}, Reflink.defaults, options);
        this.place = $(place);
        this.init(options);
    };
    
    /******
     * Init the reflink.
     ******/
    Reflink.prototype.init = function(options){
        this.place.empty();
        this.name = this.place.attr('data-element-name');
        this.initHandlers();
    }
    
    Reflink.prototype.initHandlers = function(){
        var reflink = this;
        this.place.on('getdata', function(event){
            var data = reflink.getData();
            reflink.place.data('[[elementdata]]', data);
        });
    }
    
    Reflink.prototype.getData = function(){
        var result = $.extend(true, {}, Reflink.defaults);
        result.data.title = this.title;
        return result;
    }
    
    Reflink.defaults = {
        type: 'reflinkelement',
        metadata: {},
        data: {
            title: ''
        }
    };

    Reflink.elementinfo = {
        type: 'reflinkelement',
        elementtype: 'refs',
        jquery: 'reflinkelement',
        name: 'ReferenceLinkElement',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="30" height="30" viewBox="0 0 30 30" class="ebook-icon ebook-icon-placeholder"><path stroke="none" d="M7 15 a9 9 0 1 1 16 0 l-8 13z m8 2 a6 6 0 0 0 0 -12 a6 6 0 0 0 0 12 z" /></svg>',
        description: {
            en: 'Anchor for linked content',
            fi: 'Paikanpitäjä linkitetylle sisällölle',
            sv: 'Platshållare för redigerbart innehåll'
        },
        roles: ['author'],
        classes: ['reference'],
        cancontain: []
    }
    
    $.fn.elementset('addelementtype', Reflink.elementinfo);   
    
})(jQuery);