/***
 * MenuBar
 * Petri Salmela <pesasa@iki.fi>
 ***/
//{{{

/**
 * Requirements:
 * - jQuery
 */

try {
    typeof(jQuery) !== 'undefined';
} catch (err) {
    throw new Error('Missing dependency in ' + err.fileName + '\n' + err);
}

(function ($) {
    { /*** jQuery plugin ***/
        $.fn.menubar = function(options){
            if (methods[options]){
                return methods[options].apply( this, Array.prototype.slice.call( arguments, 1));
            } else if (typeof(options) === 'object' || !options) {
                return methods.init.apply(this, arguments);
            } else {
                $.error( 'Method ' +  method + ' does not exist on Menubar' );
                return this;
            }
        }
        
        var methods = {
            init: function(params){
                params = $.extend(true, {
                }, params);
                var menu = new Menubar(this, params);
            },
            getdata: function(params){
                var $place = $(this);
                $place.trigger('getdata');
                var data = $place.data('[[menubardata]]');
                return data;
            }
        }
    }
    
    /******
     * Class for Menu bar
     * @constructor
     * @param {jQuery} place - place for navbar
     * @param {Object} options - settings for navbar
     ******/
    var Menubar = function(place, options){
        this.place = $(place);
        options = $.extend(true, {}, Menubar.defaults, options);
        this.setStyles();
        this.initData(options);
        this.setAttrs();
        this.initHandlers();
        this.show();
    };
    
    /******
     * Set attributes
     ******/
    Menubar.prototype.setAttrs = function(){
        this.place.addClass('menubar-wrapper');
        if (this.ffbackground) {
            this.place.addClass('ffwidget-background');
        };
        this.place.attr('data-menustyle', this.menustyle)
            .attr('data-valign', this.valign)
            .attr('data-halign', this.halign);
    }
    
    /******
     * Set stylesheets
     ******/
    Menubar.prototype.setStyles = function(){
        if ($('head style#menubar-style').length === 0) {
            $('head').append('<style id="menubar-style" type="text/css">'+Menubar.styles+'</style>')
        };
    };
    
    /******
     * Init menudata
     ******/
    Menubar.prototype.initData = function(options){
        this.menustyle = options.menustyle;
        this.ffbackground = options.ffbackground;
        this.valign = options.valign;
        this.halign = options.halign;
        this.menu = [];
        var item;
        var menuitem;
        var linear = [];
        for (var i = 0, len = options.menu.length; i < len; i++){
            item = options.menu[i];
            menuitem = new Menuitem(item);
            this.menu.push(menuitem);
            linear = linear.concat(menuitem.getLinear());
        };
        this.menuLinear = linear;
        this.menuByName = {};
        for (var i = 0, len = this.menuLinear.length; i < len; i++) {
            menuitem = this.menuLinear[i];
            this.menuByName[menuitem.name] = menuitem;
        }
    };
    
    /******
     * Init handlers
     ******/
    Menubar.prototype.initHandlers = function(){
        var menu = this;
        this.place.off();
        this.place.on('click', 'li.menubar-menuitem[data-menutype="toggle"] > .menubar-menuitemicon, li.menubar-menuitem[data-menutype="toggle"] > .menubar-dropmenuitemicon', function(event){
            event.stopPropagation();
            event.preventDefault();
            var item = $(this);
            var liitem = item.parent();
            var parent = liitem.parent();
            var grandparent = parent.closest('li');
            if (menu.menustyle === 'dropmenu') {
                // Close sibling menus
                parent.find('> .menuopen > .menubar-menuicon-off').not(item).click();
            };
            if (liitem.hasClass('menuopen')) {
                // Close this menu and submenus
                var eventname = liitem.attr('data-event-off');
                liitem.removeClass('menuopen');
                var submenus = liitem.find('.menuopen');
                submenus.children('.menubar-menuicon-off').click();
                parent.removeClass('onemenuopen');
                grandparent.removeClass('submenuopen');
            } else {
                var eventname = liitem.attr('data-event');
                liitem.addClass('menuopen');
                parent.addClass('onemenuopen');
                grandparent.addClass('submenuopen');
            };
            item.trigger('menubarevent', {eventname: eventname});
        });
        $('html').on('click.menubarclose', function(event, data){
            if (menu.menustyle === 'dropmenu') {
                menu.place.find('.menubar-menulist-toplevel.onemenuopen').trigger('closeallmenus');
            };
        });
        this.place.on('closeallmenus', function(event, data){
            menu.place.find('.menuopen > .menubar-menuicon-off').click();
        });
        this.place.on('click', 'li.menubar-menuitem[data-menutype="toggleclick"] > .menubar-menuitemicon, li.menubar-menuitem[data-menutype="toggleclick"] > .menubar-dropmenuitemicon', function(event){
            event.stopPropagation();
            event.preventDefault();
            var item = $(this);
            var liitem = item.parent();
            var parent = liitem.parent();
            var grandparent = parent.closest('li');
            if (liitem.hasClass('menutoggleon')) {
                var eventname = liitem.attr('data-event-off');
                liitem.removeClass('menutoggleon');
                var submenus = liitem.find('.menuopen');
                submenus.children('.menubar-menuicon-off').click();
                        //submenus.removeClass('menuopen');
                parent.removeClass('onemenuopen');
                //parent.find('.onemenuopen').removeClass('onemenuopen');
                grandparent.removeClass('submenuopen');
            } else {
                var eventname = liitem.attr('data-event');
                liitem.addClass('menutoggleon');
                parent.addClass('onemenuopen');
                grandparent.addClass('submenuopen');
            };
            item.trigger('menubarevent', {eventname: eventname});
        });
        this.place.on('click', 'li.menubar-menuitem[data-menutype="click"] > .menubar-menuitemicon, li.menubar-menuitem[data-menutype="click"] > .menubar-dropmenuitemicon', function(event){
            event.preventDefault();
            event.stopPropagation();
            var item = $(this);
            var liitem = item.parent();
            if (menu.menustyle === 'dropmenu') {
                menu.place.find('.menuopen > .menubar-menuicon-off').not(item).click();
            };
            var menuname = liitem.attr('data-menuname');
            var eventname = liitem.attr('data-event');
            var data = menu.menuByName[menuname].data;
            var eventdata = {eventname: eventname};
            if (typeof(data) !== 'undefined') {
                eventdata.data = data;
            };
            item.trigger('menubarevent', eventdata);
        });
        this.place.on('dragstart', 'li.menubar-menuitem[data-menutype="drag"] > .menubar-menuitemicon, li.menubar-menuitem[data-menutype="drag"] > .menubar-dropmenuitemicon', function(event){
            event.stopPropagation();
            var item = $(this);
            var liitem = item.parent();
            var menuname = liitem.attr('data-menuname');
            var data = menu.menuByName[menuname].data;
            var ev = event.originalEvent;
            ev.dataTransfer.setData('text', data);
        });
        this.place.on('click', 'li.menubar-menuitem[data-menutype="drag"] > .menubar-menuitemicon, li.menubar-menuitem[data-menutype="drag"] > .menubar-dropmenuitemicon', function(event){
            event.stopPropagation();
            var item = $(this);
            var liitem = item.parent();
            var menuname = liitem.attr('data-menuname');
            var eventname = liitem.attr('data-event');
            var data = menu.menuByName[menuname].data;
            item.trigger('menubarevent', {eventname: eventname, data: data});
        });
    }
    
    /******
     * Show the menubar
     ******/
    Menubar.prototype.show = function(){
        this.place.html(Menubar.templates.menuhtml);
        var menulist = this.place.find('ul.menubar-menulist-toplevel');
        menulist.html(this.getHtml());
    };
    
    /******
     * Get the html for the menu.
     ******/
    Menubar.prototype.getHtml = function(){
        var html = [];
        for (var i = 0, len = this.menu.length; i < len; i++) {
            html.push(this.menu[i].getHtml(0, this.menustyle));
        }
        return html;
    }
    
    /******
     * Default settings for menubar
     ******/
    Menubar.defaults = {
        menu: [
        ],
        menustyle: 'menubar', // 'menubar' | 'dropmenu'
        ffbackground: true,
        valign: 'left', // 'left' | 'right'
        halign: 'top' // 'top' | 'bottom'
    };
    
    Menubar.templates = {
        menuhtml: [
            '<div class="menubar-container">',
            '    <ul class="menubar-menulist menubar-menulist-toplevel"></ul>',
            '</div>'
        ].join('\n')
    };

    Menubar.styles = [
        '.menubar-wrapper {padding: 0 10px;}',
        '.menubar-wrapper ul.menubar-menulist {list-style: none; margin: 0 0 0 0px; padding: 0 ; display: inline-block; vertical-align: middle; border-radius: 5px;}',
        //'    box-shadow: inset 2px 2px 2px rgba(0,0,0,0.3); border: 1px solid #999; background: -moz-linear-gradient(top,  rgba(255,255,255,0) 0%, rgba(255,255,255,1) 100%);',
        //    'background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,rgba(255,255,255,0)), color-stop(100%,rgba(255,255,255,1)));',
        //    'background: -webkit-linear-gradient(top,  rgba(255,255,255,0) 0%,rgba(255,255,255,1) 100%);',
        //    'background: -o-linear-gradient(top,  rgba(255,255,255,0) 0%,rgba(255,255,255,1) 100%);',
        //    'background: -ms-linear-gradient(top,  rgba(255,255,255,0) 0%,rgba(255,255,255,1) 100%);',
        //    'background: linear-gradient(to bottom,  rgba(255,255,255,0) 0%,rgba(255,255,255,1) 100%);',
        //    'filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="#00ffffff", endColorstr="#ffffff",GradientType=0 );}',
        '.menubar-wrapper[data-menustyle="menubar"] ul.menubar-menulist.onemenuopen {box-shadow: none; border: none; background: transparent; margin-left: 0;}',
        '.menubar-wrapper[data-menustyle="menubar"] ul.menubar-menulist.onemenuopen > li {display: none;}',
        '.menubar-wrapper ul.menubar-menulist.onemenuopen > li.menuopen {display: inline-block;}',
        '.menubar-wrapper li.menubar-menuitem {display: inline-block;  margin: 0 0 0 0; cursor: pointer;}',
        '.menubar-wrapper li.menubar-menuitem svg {width: 30px; height: 30px;}',
        '.menubar-wrapper li.menubar-menuitem .menubar-menuidentifier-icon {display: none; margin: 0 4px; vertical-align: middle; height: 30px; width: 30px;}',
        '.menubar-wrapper ul.menubar-menulist.onemenuopen > li.menuopen > .menubar-menuidentifier-icon {display: inline-block;}',
        '.menubar-wrapper ul.menubar-menulist.onemenuopen > li.submenuopen > .menubar-menuidentifier-icon {display: none;}',
        '.menubar-wrapper li.menubar-menuitem .menubar-menuitemicon {border-radius: 4px; border: 1px solid transparent; transition: all 0.4s, background-color 0.1s; position: relative; box-shadow: -1px -1px 1px rgba(0, 0, 0, 0.3), 1px 1px 1px rgba(255, 255, 255, 0.5) inset, -1px -1px 1px rgba(0, 0, 0, 0.3) inset, 1px 1px 1px rgba(255, 255, 255, 0.5); border: 1px solid #666; margin: 2px;}',
        '.menubar-wrapper li.menubar-menuitem .menubar-menuitemicon:hover {border: 1px solid black; background-color: rgba(255,255,255,0.5);}',
        '.menubar-wrapper li.menubar-menuitem .menubar-menuitemicon:active {background-color: rgba(255,255,255,0.5);  box-shadow: -1px -1px 1px rgba(0, 0, 0, 0.3), 1px 1px 1px rgba(0, 0, 0, 0.3) inset, -1px -1px 1px rgba(255, 255, 255, 0.5) inset, 1px 1px 1px rgba(255, 255, 255, 0.5);}',
        '.menubar-wrapper li.menubar-menuitem .menubar-menuicon-off {display: none;}',
        '.menubar-wrapper li.menubar-menuitem > ul.menubar-menulist {display: none;}',
        '.menubar-wrapper li.menubar-menuitem.menuopen > ul.menubar-menulist {display: inline-block;}',
        '.menubar-wrapper[data-menustyle="menubar"] li.menubar-menuitem.menuopen > .menubar-menuicon, .menubar-wrapper[data-menustyle="menubar"] li.menubar-menuitem.menutoggleon > .menubar-menuicon {display: none;}',
        '.menubar-wrapper li.menubar-menuitem.menuopen > .menubar-menuicon-off, .menubar-wrapper li.menubar-menuitem.menutoggleon > .menubar-menuicon-off {display: inline-block; vertical-align: middle; position: relative;}',
        '.menubar-wrapper li.menubar-menuitem.menuopen > .menubar-menuicon, .menubar-wrapper li.menubar-menuitem.menutoggleon > .menubar-menuicon {display: none;}',
        '.menubar-wrapper li.menubar-menuitem.menuopen > .menubar-menuicon-off svg.mini-icon-back, .menubar-wrapper li.menubar-menuitem.menutoggleon > .menubar-menuicon-off svg.mini-icon-back {width: 30px; height: 30px;}',
        '.menubar-wrapper li.menubar-menuitem > .menubar-menuicon svg.mini-icon-down {display: none;}',
        '.menubar-wrapper li.menubar-menuitem > .menubar-menuicon svg.mini-icon-right {display: none;}',
        '.menubar-wrapper li.menubar-menuitem[data-menutype="toggle"] > .menubar-menuicon svg.mini-icon-down {display: block; position: absolute; right: 2px; bottom: 2px; top: auto; width: 10px; height: 10px;}',
        '.menubar-wrapper li.menubar-menuitem[data-menutype="toggle"] > .menubar-menuicon svg.mini-icon-right {display: block; position: absolute; right: 2px; bottom: 2px; top: auto; width: 10px; height: 10px;}',
        '.menubar-wrapper li.menubar-menuitem[data-menutype="drag"] > .menubar-menuicon {cursor: move; border: none; border-radius: 50%; padding: 5px;}',
        '.menubar-wrapper .menubar-menuicon, .menubar-wrapper .menubar-menuicon-off {display: inline-block; vertical-align: middle;}',
        '.menubar-wrapper li.menubar-menuitem.submenuopen > .menubar-menuitemicon {display: none;}',
        '.menubar-wrapper li.menubar-menuitem.submenuopen > .menubar-menuidentifier-icon {display: none;}',
        // Dropmenu
        '.menubar-wrapper[data-menustyle="dropmenu"] ul.menubar-menulist-toplevel {display: flex; flex-direction: row;}',
        '.menubar-wrapper li.menubar-dropmenuitem {position: relative; display: block;}',
        '.menubar-wrapper li.menubar-dropmenuitem svg {width: 30px; height: 30px;}',
        '.menubar-wrapper li.menubar-dropmenuitem[data-menulevel="0"] > ul {position: absolute; top: 100%; left: -4px; margin-top: 3px; padding: 2px;}',
        '.menubar-wrapper[data-valign="bottom"] li.menubar-dropmenuitem[data-menulevel="0"] > ul {top: auto; bottom: 100%;}',
        '.menubar-wrapper[data-halign="right"] li.menubar-dropmenuitem[data-menulevel="0"] > ul {left: auto; right: -2px;}',
        '.menubar-wrapper li.menubar-dropmenuitem ul {position: absolute; top: -3px; left: 100%; margin-left: 2px; border: 1px solid #aaa; border-radius: 0; background-color: #eee; box-shadow: 2px 2px 5px rgba(0,0,0,0.4);}',
        '.menubar-wrapper[data-valign="bottom"] li.menubar-dropmenuitem ul {top: auto; bottom: -3px;}',
        '.menubar-wrapper[data-halign="right"] li.menubar-dropmenuitem ul {left: auto; right: 100%; margin-left: 0; margin-right: 2px;}',
        '.menubar-wrapper li.menubar-dropmenuitem > ul.menubar-menulist {display: none;}',
        '.menubar-wrapper li.menubar-dropmenuitem.menuopen > ul.menubar-menulist {display: block;}',
   ].join('\n');
    
    
    /********************************************************************************************************/
    /********************************************************************************************************/
    /******
     * Class for menu item
     * @constructor
     ******/
    var Menuitem = function(options){
        options = $.extend(true, {}, Menuitem.defaults, options);
        this.name = options.name;
        this.type = options.type;
        this.icon = options.icon;
        this.icon_off = options.icon_off || this.icon;
        this.label = options.label;
        this.label_off = options.label_off || this.label;
        this.event = options.event;
        this.event_off = options.event_off || this.event;
        this.data = options.data || {};
        this.menu = [];
        var item, menuitem;
        for (var i = 0, len = options.menu.length; i < len; i++) {
            item = options.menu[i];
            menuitem = new Menuitem(item);
            this.menu.push(menuitem);
        }
    };
    
    /******
     * Get html for this menuitem.
     ******/
    Menuitem.prototype.getHtml = function(level, menustyle){
        level = level || 0;
        var draggable = (this.type === 'drag' ? ' draggable="true"' : '');
        var html = [];
        switch (menustyle) {
            case 'menubar':
                html.push('<li class="menubar-menuitem" data-menulevel="'+level+'" data-menuname="'+this.name+'" data-event="'+this.event+'" data-event-off="'+this.event_off+'" data-menutype="'+this.type+'">');
                html.push('    <div class="menubar-menuitemicon menubar-menuicon ffwidget-menubutton" title="'+this.label+'"'+draggable+'>' + this.icon + Menuitem.icons.right + '</div>');
                break;
            case 'dropmenu':
                html.push('<li class="menubar-menuitem menubar-dropmenuitem" data-menulevel="'+level+'" data-menuname="'+this.name+'" data-event="'+this.event+'" data-event-off="'+this.event_off+'" data-menutype="'+this.type+'">');
                html.push('    <div class="menubar-dropmenuitemicon menubar-menuicon ffwidget-hoverhighlight" title="'+this.label+'"'+draggable+'>' + this.icon + '</div>');
                html.push('    <div class="menubar-dropmenuitemicon menubar-menuicon-off ffwidget-hoverhighlight" title="'+this.label_off+'"'+draggable+'>' + this.icon_off + '</div>');
                break;
            default:
                break;
        };
        if (this.menu.length > 0) {
            if (menustyle === 'menubar') {
                html.push('    <div class="menubar-menuitemicon menubar-menuicon-off menuactive" title="'+this.label_off+'">' + Menuitem.icons.back + '</div>');
                html.push('    <div class="menubar-menuidentifier-icon">' + this.icon + '</div>');
            };
            html.push('    <ul class="menubar-menulist ffwidget-background">');
            for (var i = 0, len = this.menu.length; i < len; i++){
                html.push(this.menu[i].getHtml(level + 1, menustyle));
            };
            html.push('    </ul>');
        };
        html.push('</li>');
        return html.join('\n');
    };
    
    Menuitem.prototype.getLinear = function(){
        var result = [this];
        for (var i = 0, len = this.menu.length; i < len; i++) {
            result = result.concat(this.menu[i].getLinear());
        }
        return result;
    }
    
    Menuitem.icons = {
        back1: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="30" height="30" viewBox="0 0 30 30" class="mini-icon mini-icon-back"><path style="stroke: black; fill: black;" d="M20 3 l0 8 l5 0 l0 8 l-5 0 l0 8 l-20 -12 z"></path></svg>',
        back: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="30" height="30" viewBox="0 0 30 30" class="mini-icon mini-icon-back"><path style="stroke: none; fill: black;" d="M10 5 l0 4 l10 0 a7 7 0 0 1 0 14 l-5 0 l0 -4 l4 0 a3 3 0 0 0 0 -6 l-9 0 l0 4 l-8 -6z"></path></svg>',
        down: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="30" height="30" viewBox="0 0 30 30" class="mini-icon mini-icon-down"><path style="stroke: black; fill: #a00;" d="M3 5 l12 3 l12 -3 l-12 25 z"></path></svg>',
        right: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="30" height="30" viewBox="0 0 30 30" class="mini-icon mini-icon-right"><path style="stroke: black; fill: #a00;" d="M5 3 l25 12 l-25 12 l3 -12 z"></path></svg>'
    }
    
    Menuitem.defaults = {
        name: 'default',
        type: 'click',
        icon: '',
        label: 'default',
        event: '',
        menu: []
    }
    
})(jQuery);
//}}}