/**
 * Requirements:
 * - jQuery
 */

try {
    typeof(jQuery) === 'undefined' && jQuery;
} catch (err) {
    throw new Error('Missing dependency in ' + err.fileName + '\n' + err);
}

/**
 * Optional requirements
 * - EbookLocalizer
 * - ElementSet
 * - ElementPanel
 * - DOMPurify
 */

if (typeof(checkOptionalRequirements) !== 'undefined' && checkOptionalRequirements) {
    try {
        typeof(EbookLocalizer) === 'undefined' && EbookLocalizer.apply;
        typeof(jQuery.fn.elementset) === 'undefined' && jQuery.fn.elementset.apply;
        typeof(jQuery.fn.elementpanel) === 'undefined' && jQuery.fn.elementpanel.apply;
        typeof(DOMPurify) === 'undefined' && DOMPurify.apply;
    } catch (err) {
        throw new Error('Missing optional dependency in ' + err.fileName + '\n' + err);
    }
}

/**
 * Runtime requirements
 * - JSXgraph
 */

if (typeof(checkRuntimeRequirements) !== 'undefined' && checkRuntimeRequirements) {
    try {
        typeof(JXG) === 'undefined' && JXG.apply;
    } catch (err) {
        throw new Error('Missing runtime dependency in ' + err.fileName + '\n' + err);
    }
}

(function($){
    //TODO:edit functionality
    
    var ineqgraph = function(place, options){
        this.place = $(place);
        // this.constr(place, options);
        this.initSpecial(options);
        this.showContentSpecial();
    }
    // ineqgraph.inheritsFrom(ElementSet);
    
    ineqgraph.prototype.initSpecial = function(options){
        this.eqtype = options.data.eqtype || '=';
        this.asign = options.data.asign || '+';
        this.roots = options.data.roots || '210';
        this.fname = options.data.fname || '';
        var idnum = -1;
        while (jQuery('#emathineqgraph_'+(++idnum)).length > 0){};
        this.idnum = idnum;
    }
    ineqgraph.prototype.showContentSpecial = function(){
        var emieqtext = '<div class="emathineqgraphwrapper" style="position: relative;"><div id="emathineqgraph_'+this.idnum+'"></div><div class="emathineqgraphshield" style="position: absolute; top: 0; bottom: 0; left: 0; right: 0; z-index: 11;"></div>';
        this.place.empty().append(emieqtext);
        this.ineq2ordGraphs('emathineqgraph_'+this.idnum, this.eqtype, this.asign, this.roots, this.fname);
    }
    ineqgraph.prototype.ineq2ordGraphs = function (position, eqtype, asign, roots, fname)
    {
        var eqtypes = {'=': false, '<': false, '<=': false, '>': false, '>=': false, '!=': false};
        if (!(eqtype in eqtypes)){
            return false;
        }
        if (typeof(roots) === 'undefined'){
            roots = '210';
        }
        if (typeof(asign) === 'undefined'){
            asign = '+';
        }
        var $box = jQuery('#'+position);
        $box.css({height: '250px', width: $box.width() + 'px', padding: '5px', position: 'relative'});
        var boxwidth = 2+5*(roots.length);
        var graphs = {
            '+': {
                '2': 'A2(1,0) invisible; B2(5,0) invisible; axis2=[A2 B2] nolabel; f2:(x-3)^2-1; P21(2,0) nolabel; P22(4,0) nolabel;',
                '1': 'A1(1,0) invisible; B1(5,0) invisible; axis1=[A1 B1] nolabel; f1:(x-3)^2; P1(3,0) nolabel;',
                '0': 'A0(1,0) invisible; B0(5,0) invisible; axis0=[A0 B0] nolabel; f0:(x-3)^2+1;',
                '210': 'A2(1,0) invisible; B2(5,0) invisible; axis2=[A2 B2] nolabel; A1(6,0) invisible; B1(10,0) invisible; axis1=[A1 B1] nolabel;  A0(11,0) invisible; B0(15,0) invisible; axis0=[A0 B0] nolabel; f2:(x-3)^2-1; f1:(x-8)^2; f0:(x-13)^2+1; P21(2,0) nolabel; P22(4,0) nolabel; P1(8,0) nolabel;'
            },
            '-': {
                '2': 'A2(1,0) invisible; B2(5,0) invisible; axis2=[A2 B2] nolabel; f2:-(x-3)^2+1; P21(2,0) nolabel; P22(4,0) nolabel;',
                '1': 'A1(1,0) invisible; B1(5,0) invisible; axis1=[A1 B1] nolabel; f1:-(x-3)^2; P1(3,0) nolabel;',
                '0': 'A0(1,0) invisible; B0(5,0) invisible; axis0=[A0 B0] nolabel; f0:-(x-3)^2-1;',
                '210': 'A2(1,0) invisible; B2(5,0) invisible; axis2=[A2 B2] nolabel; A1(6,0) invisible; B1(10,0) invisible; axis1=[A1 B1] nolabel;  A0(11,0) invisible; B0(15,0) invisible; axis0=[A0 B0] nolabel; f2:-(x-3)^2+1; f1:-(x-8)^2; f0:-(x-13)^2-1; P21(2,0) nolabel; P22(4,0) nolabel; P1(8,0) nolabel;'
            }
        }
        // Upwards opening
        var intervals = {
            '+': {
                '>': {
                    '2': 'interv21=[A2 P21] nolabel; interv22=[P22 B2] nolabel;',
                    '1': 'interv11=[A1 P1] nolabel; interv12=[P1 B1] nolabel;',
                    '0': 'interv0=[A0 B0] nolabel;',
                    '210': 'interv21=[A2 P21] nolabel; interv22=[P22 B2] nolabel; interv11=[A1 P1] nolabel; interv12=[P1 B1] nolabel; interv0=[A0 B0] nolabel;'
                },
                '<': {
                    '2': 'interv21=[P21 P22] nolabel;',
                    '1': '',
                    '0': '',
                    '210': 'interv21=[P21 P22] nolabel;'
                },
                '=': {
                    '2': '',
                    '1': '',
                    '0': '',
                    '210': ''
                },
                '!=': {
                    '2': 'interv20=[A2 P21] nolabel; interv21=[P21 P22] nolabel; interv22=[P22 B2] nolabel;',
                    '1': 'interv11=[A1 P1] nolabel; interv12=[P1 B1] nolabel;',
                    '0': 'interv0=[A0 B0] nolabel;',
                    '210': 'interv20=[A2 P21] nolabel; interv22=[P22 B2] nolabel; interv11=[A1 P1] nolabel; interv12=[P1 B1] nolabel; interv0=[A0 B0] nolabel; interv21=[P21 P22] nolabel;'
                }
            }
        }
        intervals['+']['<='] = intervals['+']['<'];
        intervals['+']['>='] = intervals['+']['>'];
        // Downwards opening
        intervals['-'] = {};
        intervals['-']['>'] = intervals['+']['<'];
        intervals['-']['<'] = intervals['+']['>'];
        intervals['-']['='] = intervals['+']['='];
        intervals['-']['!='] = intervals['+']['!=']
        intervals['-']['<='] = intervals['-']['<'];
        intervals['-']['>='] = intervals['-']['>'];

        var oldoptions = JXG.Options;
        JXG.Options = JXG.deepCopy(JXG.Options, {
            elements: {fixed: true},
            point: {showInfobox: false}
        });
        var board, construction = [];
        board = JXG.JSXGraph.initBoard(position, {grid: false, boundingbox: [0,2,boxwidth,-2], keepaspectratio: true, axis: false, showNavigation: false, showCopyright: false});

        construction.push(board.construct(graphs[asign][roots]));

        construction.push(board.construct(intervals[asign][eqtype][roots]));
        
        var allaxis = ['axis2', 'axis1', 'axis0'];
        for (var i = 0; i < 3; i++){
            try {
                construction[0][allaxis[i]].setProperty({strokeColor: 'black'});
            } catch (err) {}
        }
        switch (eqtype){
            case '<':
            case '>':
            case '!=':
                var dots = ['P21','P22','P1'];
                for (var i = 0; i < 3; i++){
                    try {
                        construction[0][dots[i]].setProperty({fillColor: 'white'});
                    } catch (err) {}
                }
                break;
            default:
                break;
        }
        var intervalnames = ['interv0','interv11','interv12', 'interv20', 'interv21','interv22']
        for (var i = 0; i < 6; i++){
            try {
                construction[1][intervalnames[i]].setProperty({strokeColor: 'red'});
            } catch (err) {}
        }
        JXG.Options = oldoptions;
        $box.append('<div class="emathieq_shield"></div>').find('.emathieq_shield').css({position: 'absolute', top: '0', bottom: '0', left: '0', right: '0', 'z-index': '11'});
        return board;
    }
    /**** jQuery-plugin *****/
    var methods = {
        'init': function(params){
            return this.each(function(){
                var ineqgraphelement = new ineqgraph(this, params);
            });
        },
        'get': function(){
            var $place = $(this).eq(0);
            $place.trigger('getdata');
            var data = $place.data('[[ineqgraphdata]]');
            return data;
        },
        'set': function(params){
            var $place = $(this);
            $place.trigger('setdata', [params]);
        }
    }
    
    $.fn.ineqgraph = function(method){
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof(method) === 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Method ' + method + ' does not exist in ineqgraph.');
            return false;
        }
    }
    /******
     * Elementinfo for elementsets
     ******/
    ineqgraph.elementinfo = {
        type: 'ineqgraph',
        elementtype: ['jsexample'],
        jquery: 'ineqgraph',
        name: 'Emathineqgraph',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="20" height="20" viewBox="0 0 30 30" class="mini-icon mini-icon-ineqgraph mini-icon-ineqgraph"></svg>',
        description: {
            en: 'ineqgraph',
            fi: 'ineqgraph'
        },
        classes: ['viewonly']
    }
    // Register multichoice as an element to the elementset and to the elementpanel.
    if (typeof($.fn.elementset) === 'function') {
        $.fn.elementset('addelementtype', ineqgraph.elementinfo);
    }
    if ($.fn.elementpanel) {
        $.fn.elementpanel('addelementtype', ineqgraph.elementinfo);
    }
    
})(jQuery);