//{{{
/*********************************************************
 * jquery.graphimage.js
 * jQuery-plugin for creating graph images with jsxgraph
 * Petri Salmela
 * Petri Sallasmaa
 * 07.04.2014
 * v.0.1
 * Copyright: Four Ferries oy
 *   http://fourferries.fi
 ********************************************************/

 /**
 * Requirements:
 * - jQuery
 */
try {
    typeof(jQuery) === 'undefined' && jQuery;
} catch (err) {
    throw new Error('Dependency problem in ' + err.fileName + '\n' + err);
}

/**
 * Optional requirements
 * - ElementSet
 * - ElementPanel
 */

if (typeof(checkOptionalRequirements) !== 'undefined' && checkOptionalRequirements) {
    try {
        typeof(jQuery.fn.elementset) === 'undefined' && jQuery.fn.elementset.apply;
        typeof(jQuery.fn.elementpanel) === 'undefined' && jQuery.fn.elementpanel.apply;
    } catch (err) {
        throw new Error('Missing optional dependency in ' + err.fileName + '\n' + err);
    }
}

/**
 * Runtime requirements
 * - JSXgraph
 */

if (typeof(checkRuntimeRequirements) !== 'undefined' && checkRuntimeRequirements) {
    try {
        typeof(JXG) === 'undefined' && JXG.apply;
    } catch (err) {
        throw new Error('Missing runtime dependency in ' + err.fileName + '\n' + err);
    }
}

(function($){
    
   // jQuery plugin
    /**** jQuery-plugin for graphimage. *****/
    var methods = {
        'init': function(params){
            var settings = params.data;
            return this.each(function(){
                var graphim = new Graphimage(this, settings);
                //graphim.init();
            });
        }
    }
    
    $.fn.graphimage = function(method){
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof(method) === 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Method ' + method + ' does not exist in graphimage.');
            return false;
        }
    }

    var Graphimage = function(place, options){
        options = $.extend({
            caption: '',
            axis: true,
            grid: true,
            area: [0,10,10,0],
            sizex: "auto",
            sizey: "auto",
            sliders: [],
            data: []
        }, options);
        this.place = $(place);
        this.caption = options.caption;
        this.axis = options.axis;
        this.grid = options.grid;
        this.area = options.area;
        this.sizex = options.sizex;
        this.sizey = options.sizey;
        this.sliders = options.sliders;
        this.data = options.data;
        
        var graphimg = this;

        if ($('head style#ebookgraphimagestyle').length === 0){
            $('head').prepend('<style id="ebookgraphimagestyle" type="text/css">'+Graphimage.strings.css+'</style>');
        }
        
        var elementid = 'graphimage_graph_';
        var num = 0;
        while ($('#'+elementid + num).length > 0){
            num++;
        }
        this.elemid = elementid + num;
        //this.place.attr('id', this.elemid);
        var sliderid = 'graphimage_slider_';
        this.sliderids = [];
        var offset = 0;
        for (var i = 0; i < this.sliders.length; i++){
            while (jQuery('#'+sliderid+offset).length > 0){
                offset++;
            }
            this.sliderids.push(sliderid+(i+offset));
        }
        var funclist = '<ul>\n';
        for (var i = 0; i < this.data.length; i++){
            var returnfunction = 'graphimg.data['+i+'].func = function(x){return Math.round(100*(' + this.data[i].formula_js + '))/100}';
            returnfunction = returnfunction.replace(/s([0-4])/g, 'graphimg.sliders[$1].value');
            eval(returnfunction);
            funclist += '<li class="color_'+this.data[i].color+'">\\('+this.data[i].label+'\\)</li>\n';
        }
        funclist += '</ul>\n';
        var slidertext='';
        if (this.sliderids.length > 0){
            slidertext = slidertext+'<div class="graph_sliders">';
        }
        for (var i = 0; i < this.sliderids.length; i++){
            //slidertext = slidertext+'<div class="slider_element"><div class="slider_data"><span class="slider_label">'+this.sliders[i].label+'=</span><span class="graph_slider_value" id="'+this.sliderids[i]+'_value"></span></div><div class="graph_slider" style="display:block;" id="'+this.sliderids[i]+'"></div></div>';
            var sliderops = {
                min: parseFloat(graphimg.sliders[i].min),
                max: parseFloat(graphimg.sliders[i].max),
                step: (typeof this.sliders[i].step ? parseFloat(this.sliders[i].step) : 1),
                value: parseFloat(graphimg.sliders[i].value)
            }
            slidertext = slidertext+'<div class="slider_element" data-sliderindex="'+i+'"><div class="slider_data"><span class="slider_label">'+this.sliders[i].label+'=</span><span class="graph_slider_value" id="'+this.sliderids[i]+'_value"></span></div><input type="range" min="'+sliderops.min+'" max="'+sliderops.max+'" step="'+sliderops.step+'" value="'+sliderops.value+'" class="graph_slider ffwidget-range" style="display:block; width: 100%;" id="'+this.sliderids[i]+'"></input></div>';
        }
        if (this.sliderids.length > 0){
            slidertext = slidertext+'</div>';
        }
        var xyscale = (this.area[3]-this.area[1])/(this.area[0]-this.area[2]);
        var width = this.sizex +'px';
        var height = (xyscale * this.sizex) +'px';
        var caption = '';
        if (this.caption != ''){
            caption = '<div class="graphcaption"><p>'+this.caption+'</p></div>';
        }
        var htmltext = '<div class="functiongraph"><div class="jsxgfunclist">'+funclist+'</div><div id="'+this.elemid+'" class="jxgbox" style="width:'+width+';height:'+height+'; position: relative; margin-left: auto; margin-right: auto;"></div>'+slidertext+caption+'</div>';
        htmltext = htmltext.replace(/\\\((.+?)\\\)/g, '<span class="mathquill-embedded-latex">$1</span>')
            .replace(/\$(.+?)\$/g, '<span class="mathquill-embedded-latex">$1</span>');
        this.place.html(htmltext);
        this.place.find('.mathquill-embedded-latex').mathquill();
        for (var i = 0; i < this.sliderids.length; i++){
            $('#'+this.sliderids[i]+'_value').html(this.sliders[i].value);
        }
        this.drawgraph();
    }
    
    Graphimage.prototype.drawgraph = function(){
        var graphimg = this;
        for (var i = 0; i < this.sliderids.length; i++) {
            //var sliderops = {
            //    orientation: "horizontal",
            //    range: "min",
            //    min: parseFloat(graphimg.sliders[i].min),
            //    max: parseFloat(graphimg.sliders[i].max),
            //    value: parseFloat(graphimg.sliders[i].value)
            //}
            //try{
            //    eval('sliderops.slide = function(event, ui){graphimg.sliders['+i+'].value = ui.value; jQuery("#'+graphimg.sliderids[i]+'_value").empty().html(ui.value); graphimg.board.updateQuality = graphimg.board.BOARD_QUALITY_HIGH; graphimg.board.update();}');
            //} catch (e){
            //    console.log(e, 'slidereval');
            //}

            $('#' + this.sliderids[i]).on('input', function(e){
                /*alert($(this).attr('id') + ': ' + this.value);*/
                //sliderops.slide(e, this);
                var $slider = $(this);
                var $sliderelem = $slider.closest('.slider_element');
                var $valplace = $sliderelem.find('.graph_slider_value');
                var index = $sliderelem.attr('data-sliderindex') | 0;
                var value = parseFloat($slider.val());
                $valplace.html(value);
                graphimg.sliders[index].value = value;
                graphimg.board.updateQuality = graphimg.board.BOARD_QUALITY_HIGH;
                graphimg.board.update();
            });
            //$('#' + this.sliderids[i]).slider(sliderops);
            //if (typeof(this.sliders[i].step) !== 'undefined') {
            //    $('#'+this.sliderids[i]).slider('option', 'step', parseFloat(this.sliders[i].step));
            //}
        }
        this.board = JXG.JSXGraph.initBoard(this.elemid, {boundingbox:this.area, axis:this.axis, grid: this.grid, keepaspectratio: true, showCopyright: false});
        JXG.removeEvent(this.board.containerObj, "mousewheel", this.board.mouseWheelListener, this.board);
        JXG.removeEvent(this.board.containerObj, "DOMMouseScroll", this.board.mouseWheelListener, this.board);
        for (var i = 0; i < this.data.length; i++) {
            switch (this.data[i].type){
                case 'function':
                    this.board.create('functiongraph',[this.data[i].func],{strokeColor: this.data[i].color, strokeWidth: 3*(Math.pow(0.9,i))});
                    break;
                case 'point':
                    this.board.create('point', [this.data[i].xcoord, this.data[i].ycoord], {fillColor: this.data[i].color, face: 'o', name: '', strokeWidth: 0, fixed: true});
                    break;
                default:
                    break;
            }
        }
    }
    
    Graphimage.strings = {
        css: [
            '.functiongraph {margin: 1em;}',
            '.functiongraph .jsxgfunclist {float: left; border: 1px solid #555; border-radius: 0.3em;}',
            '.functiongraph .jsxgfunclist ul {list-style: none; margin: 0; padding: 0;}',
            '.functiongraph .jsxgfunclist li {margin: 0; padding: 0.2em 1em;}',
            '.functiongraph .graph_sliders {max-width: 30em; margin: 0.2em auto;}'
        ].join('\n')
    };
    
    Graphimage.elementinfo = {
        type: 'graphimage',
        elementtype: 'elements',
        jquery: 'graphimage',
        name: 'Graphimage',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="20" height="20" viewBox="0 0 30 30" class="mini-icon mini-icon-functiongraph"><path style="stroke: none;" d="M1 17 l26 0 l0 -2 l3 2.5 l-3 2.5 l0 -2 l-26 0z M13 29 l0 -26 l-2 0 l2.5 -3 l2.5 3 l-2 0 l0 26z M1 29 q5 -28 14 -17 q7 7 12 -10 l1 0 q-5 19 -14 10 q-8 -8 -12 17z" /></svg>',
        description: {
            en: 'Images of graphs',
            fi: 'Graafeja ja kuvaajia'
        },
        classes: ['viewonly']
    }
    
    // Register graphimage as an element to the elementset and to the elementpanel.
    if (typeof($.fn.elementset) === 'function') {
        $.fn.elementset('addelementtype', Graphimage.elementinfo);
    }
    if ($.fn.elementpanel) {
        $.fn.elementpanel('addelementtype', Graphimage.elementinfo);
    }

    
})(jQuery);
