/***
|Name|GeoEditor|
|Version|0.10|
|Author|Rolf Lindén (rolind@utu.fi)|
|Type|plugin|
|Requires|jQuery 1.4.3 or newer, jQuery UI 1.8.16 or newer, JSXGraph 0.95 or newer, MathQuill, calculator.js.|
|Description|Creates and shows geometric scenes constructed from geometric primitives.|
!!!!!Revisions
<<<
20160930.1043 ''Version 0.11 author alpha''
* Added event handler for 'getdata' event. Puts the data in $(this).data('[[elementdata]]').

20130425.1003 ''Version 0.10 author alpha''
* Added selection for intersection point visibility.

20130424.1416 ''Version 0.09 author alpha''
* Fixed glider dynamic naming update.
* Added stroke width parameter to line.

20130424.1046 ''Version 0.08 author alpha''
* Added dynamic naming support for point, glider, line and circle.
* Added slope and length property for line.
* Added radius, area and circumference properties for circle.
* Added 'Draw tick labels' to axis properties.

20130404.0902 ''Version 0.07 author alpha''
* Added 'addElement' and 'update' methods to the API. Allows external interaction with the editor.

20130313.1600 ''Version 0.06d author alpha''
* Viewport control is now always visible when editing.

20130312.1632 ''Version 0.06c author alpha''
* Fixed viewport control bug that prevented it's use in edit mode.
* Fixed viewport control bug that allowed clicks to pass the button elements.

20130213.1605 ''Version 0.06b author alpha''
* Gets updated information from text fields even without explicit update.

20130212.1527 ''Version 0.06 author alpha''
* Added setSceneOptions and getSceneOptions to jQuery interface.

20130211.1120 ''Version 0.05 author alpha''
* Added scene controls (no proper GeoScene object support yet).

20130204.1509 ''Version 0.04 author alpha''
* Added GeoAxis object.
* GeoTriangle can now be filled.
* Sped up removal of objects from the scene.
* Changed look for element property view.

20130108.1521 ''Version 0.03b author alpha''
* Fixed a bug related to right angles and naming.
* Fixed multiple bugs related to image captions.

20121219.1133 ''Version 0.03 author alpha''
* 'tabless' mode for captions.
* Image object.
* ParametricCurve -object.
* Point and glider size can be set.
* Angle fill opacity can be set.
*Requires calculator.js and Mathquill from this version onwards.

20121214.1053 ''Version 0.021c author alpha''
*Fixes parallelogram and square naming issues.

20121212.0842 ''Version 0.021 author alpha''
*Adds fill, coloring and dashing for Parallelograms.
<<<
!!!!!Code
***/

//{{{

/**
 * Requirements:
 * - jQuery
 */

try {
    typeof(jQuery) === 'undefined' && jQuery;
} catch (err) {
    throw new Error('Missing dependency in ' + err.fileName + '\n' + err);
}

/**
 * Optional requirements
 * - ElementSet
 * - ElementPanel
 */

if (typeof(checkOptionalRequirements) !== 'undefined' && checkOptionalRequirements) {
    try {
        typeof(jQuery.fn.elementset) === 'undefined' && jQuery.fn.elementset.apply;
        typeof(jQuery.fn.elementpanel) === 'undefined' && jQuery.fn.elementpanel.apply;
    } catch (err) {
        throw new Error('Missing optional dependency in ' + err.fileName + '\n' + err);
    }
}


/**
 * Geometry editor (jQuery plugin).
 * 
 * Creates and shows geometric scenes constructed from geometric
 * Creates and shows geometric scenes constructed from geometric
 * primitives.
 * 
 * Copyright 2012 Rolf Lindén (rolind@utu.fi), all rights reserved.
 * No copying for any purposes allowed without written and signed
 * authorization.
 * 
 * @version 0.03 author alpha
 * @author Rolf Lindén (rolind@utu.fi)
 **/
(function ($) {
    { /** CSS & glyphs            **/
        /** Images needed for editor given in string format **/
        var editorImages = {
            "controls.png":"url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIAAAAEACAYAAAB7+X6nAAAAAXNSR0IArs4c6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB90BHgsMBqZRqZUAACAASURBVHjazJ13eFRl9sc/585kklAChBaK9I50FVAXRRBZy7oqYm9YFwHLqqvY+7ru2gCVte9asKzlZwWsoIAgXYEQek9oKaTOzD2/P+7cmTt37kwm2LjPk2cyd2593/Oefr5H+J23oqIizcrKqv1A07T+AAzD+ku9aeRTvH4UEWpqagAIBAKo6kFd5+dsVVVV+Hy+3/X+/t+bALKysmjYsKH7hSXu5VUFcb2/Ko59zkHSJIOVcExVVVX0GRznpRrwdI5JNXkJz5aRkfG73t/g0NnU8cDqmHxrorduVW66SbnySmXBAkXE+i31i3t91yT3THWc1/dkz69JztU63vM3ub+fQ30TgXAY7r0XXnjB2rd0KcyciTZtisRzgrpRnAcBqSoiP4vbShqTFXe/yHNIiuv9kvs4VDmAqKqoqkQePPq/7t2LLlwoau//6Sdh40ZrpCODFzmX6DmR746BcF8/uj8yEWKpBpJwvvOZnN8dvzvvYT8Pyd7HNTHyew56nThA/s59+Pw+I1hT01CQeqZpNgY1xPDtB8r9gYwyMxQ2u7fKPVgRELcKRcQSWi1aCGedpbpypXXQ6NFo375icwhVVbE+IzSh7lWuHqvcLUvVgyPYE6ouYlLnRNsHuDiHiIg6VribwySVy4ccAfy4eRcImcGa6gGV5cGTDxw4cHRVVWWHqoqKBghkZdc7kJWVtalBw5x5fr//kx8371oKVB/ePq9OE28PoD1oYst5EeWWW5DOnaGkBD3zTAgEVFTRyDHOiXZeB7CJA9d94uSt+5jIcQlEGZ15EbyIxkEE0d+czyOJiuuvKz4TFebYPtCUlLekYDNfz53LyOEn9AzWVE/csX3bGcuXLG65dvVPsmPbNioqKgDIrlePVq3b0L1nL+036IjCNocd9l4gkDl1567CVc2a5jKwa/uk9ygtLTUbNmyYbAUSUfYEx2REzELbMtBa5K8kI4LKykrr+bOz4ybHvdprkfGSZEKT6gI2BygrK1O/309WVpakPXG2SVybnmL/Hg6Dz2f9v2oVBIPQrx8AB8rKkhPA4oLNVFVVS8MG9U8q3r//oTlfzh7w9exZbN+2DVWTevXrk5GRAUAwGKSivBwRoXXbwxg+chR/OGHE8iZNm91WWlL6WXa9bB2UhAhKS0vVNgO9FLA4ThAKWfzS54vzAyQ5LyoWXKtO7OOTEIC6z4kteqntnu59cfdz/15WVkaEALy0Q+sdf/oJGTcOFi5EBw9GXnkFundPg4kImEEwMmD/XjjnPHT2bOunI46A//2PA02aeMuexWs3EcjIQGH0rp07nn13xuvtv/3mK9Q06dK1G0cOGUq37t1p3KQJAMX797M2P59F389n3dq1iGFw9B+GMea8Cze3yMub0L9zu49mfzufE48dWisBOGWi2INvGDGBHQ5b1G0TgFpjLBIlZjVNxDCsy0UEcZSlOyfXTQAOtu9UIJP5GNQmCierd3ExdegDNiVF75+UAEIhyMiAwkI4+2yYOzd28xEj4L23oWETamqUYBCqq62FXVPj+Kw2qTZ9BIPQ/N3n6fTP8RjhoPVAjRrBVVdx4M47vXUAEQNFehbv3/fQuzNeb//NF7PJycnh5NNOZ/Qpp9CyZR6hUIiC/DUADBp0BEcNGcKoP/6RmZ98zEcfvM+cL78AaH/eJeMe+27pj7sbNW3+/b/+8Xf+esutKbiWJEgpEYEff4RPP0VOOw169HDKsCir27JFdMsWZPBgyMiwJz9R5jvkurgmyK0TSJq+hLjnTmJCqpuDJHF8xb9bRQWsWwdADQEC1LDmi3X0yqlAaRJvzhmQmWnRTSAAWQEgE+pnmFy6v5Sbwhoz+VShuNhbCVy8dhOBrMxAdUXFxDlfzh7w7TdfkZOTw2VXXs2IUSeRGQjg8xl8N+drnpk6BYCrx1/LCSNPJK9lHuddeDHNW7TkpeemM2/uHA5r36HriBNPmlyw/IdLew4asj+Vdyth1dky+aWX4PPPlUWLoHVruOkmaNs2wiWUTZvg/feFTp3gww+V006zBiJGI6KpFDz7fm4lLWJVxMlVUbUpKW7CnPdwWCReBKQOKyCVjoDWq4d07QI7dxKgBhPoMaoL5sx6aWiABhCypnj1cTCyMezYY/3k88HppwOo4Xlz0+y/Y/u2P389exZqmpx82umRyc/AEMjw+9mxbRv79u5l/769rFn1E6jiM4RARgYjR53Eqaf/GTVNvpw1k8LCwpGNm7U4uc/QYUx/5ulUzgpx79MtWyA/H155BbnlFsEwhPPPF/7zn+ihFeWwZrXy44/Kzp0x6eBQ6mpzkojbVLPPSSbn4xwJsQkX97WcSp/L/EvqA1C/HzNsIi1bUvrIM/zUcAgHAGPYUJjyNEoTy52nyf9ACId8gFLScRCvXfkdX3S+Cj3/QuSrz+CUUwDE7179+/YU0bxlq1NWLl3Savu2bXTp2pWTTj6F7KxMDBEMAb9h4DMMDCPm0/AZBmJYyrphBBh98qn8sHAha9esZuWypfWGjxhxzqw3Xvy/Rs1bltUqApz8e8kSi2IjrF8efBC++Qb++U902TL41z/p2dvgkUeUyiohN1cjSq9ARBmIXtNWrDysDfdEe7J1+/yaGnj7bdi4ET3jDKR374jSIrUqh7V5GS3Hp+DzCWZYeXpOb5acM59/TYUGmRGWkYYVoKqETcEHrF2pTJndjTumT8cYES9mEjhA2/YdG5aVlh61ZtVPqJoMPvpomjVvzto1a1i3di1qmmT4fRiGIFiWmCFCht+HABvXr6dgzRpyc3MZPGQoqsqaVT9SEwz2z23RqmuDnEZJYwAOHhqdIv3mGzj+eCUYRPftUy0vV4YNU50+Xdm6VfXyK1VQGjUW8vJUAwFBEdQ0UcNAQXXfPlURNDL56uEH8BhAe4spqBb7V330UbjwQuTOO1XGjlXdvFkjZqo6XiPOCaSJHiVNJgLCYeungnXwxWzl9OOVwzIjh6fh+raYOAQCSjCofP459OmlHHm4dQ2nqDU8JHKDqsrKrtu3baVe/fr06NmLlcuW8uC9d3P3Hbfx/rvvEg6F8Pl8iFgU7TMMQPl81izuvuM27r/nLpYu/oEevXpRv359du7YQSgUbgp0FTFqVQJV1VpRJSXIsmXoH/6AhkLW78Ggtb9ZM2TKFKT8ADrpusijWxq/mCYYBrJ/P/z1r8gJJyCTJ0N5ORqR46lWju2FtP+ict1i/SKffx47YdUq5Icf7JlP4BzOa6SzWRNn/f/VV9CwIRxzTLxumM4WDlufa9fC55/DiSdCy5a1xAIiEspnmuHM6uoqMjIyaNS4Mbt27aSoqIjdRbt55eUXefd/7xCsqYnKQtMMM+uzz5j+zNPs2rmLosJCdu7YTm7TpgQyM6mqrKCysiIrIxBokZPbjBdffNF926hIjWiEloY2fz60bIm0bi2Ew5ZqLiIqIlpRIdSrJ/rII0J+Pjp9unUB00TDYUvDevlleOwx0eXLRR9+GN54wxpIa3QSdACnvW778eNcubYCePTR9hIWOnWSiFtaIianJNE7xBX0cccEELEsQIDNm2H2bGviOnSomwPQTUTNmsGQIZ5EJEbtFzMZMvRohh59NIYhVJSX89KLL/D1119hGAaGYbBk8WKmP/MM+/fvQwT69R/A4KFHY9oJHPa1wuGGZw/qW2vUK+pn/+gj9KijoF49JByW6ATYK628HPLykFtugTfeQNauBZ8PMU2LlnfvjhtpKSyMGA6aQHyRlSpe8jqq5EUIXm+/HZ54Aq69Fn39daRrV6c72mn3xymUToXQ672dEzdvHpSWwvDhdVj9IhEisl5r40bh88+FkSOhXbs0ooERN0zYMHzVmZlZBINBSoqLad6iJddcO5GhRx+LIJSWlrJ58+bIDYVt27azv9iy8Pr068/4iZNo3aYt+/bupaa6mqzsemRnZYdrqqv3vzp3vtYSEkQMAzlwAAoKkIED0cxMNKL4SEQ8RC9SXAwjRiCjR8PTEQsjM9N6n3PPhcGDURH0uONg7FjrHrZrNEl42LGK48VTRLhKvXroddfB1KnW9Z3L2tvvn1oURAgrHDEkth8QPv5SGDFS6NolTZ9/xFtqqkSJ6LNvoKQGjh8uEdmfTjhYOJCVnV3Qpu1hVJSXszY/n1AoRMu8PP4ycSJDIgLJpnBT1XbZ0advPyZedwMdOnUmHA6zds1qysvLyWvdGsNnlIVCwT0l+/Ywbty42oXX55+rtG6Ntm9vubpAxeH8ERE0EECaNEH37EF374ZvvkE3bbJUJdNE+vaF995DPvvM0tq7dgXTVI25kZ0KqJet7pxQdcQmSHBZxU+8uly/mjIYZok3jF074YarkOad+eOsyVx0ViU+v3haizEnV4SNhYKICEZVJXrFlSDCNZcJHzS9lg7tzKSR/4S92zdvLGuYk7OwR6/eiGGwaMF8Cgt3ETaVFi3zGD9xEkOOPibC2qx3N02TPn37MeH6G+jQqROmaVJUVMTCBQsQEXr2OhwD3VFRVppfUVaaOpPFnoivv4b27ZHWrZHqatsoVwIBpV49JTtbpbBQefhhlXPOsTjGAw8grVpZAxLR+KVVK2XUKJXmza3vhmEPZ0I00KW0qdNZFLX97dUWcVVL7Di11ZMkRKRJM3d8PqSoCN/556JPPEfrqg1csOVh2jw+CaiKW+SO2zuMgTD4rbiM+dLL8NKLUa6U895LZMx4NdF55WUFDOrWgSbNWuDz+T7uM2DgzjZt2rKuYC2fffwxNTU1hMImzVu0ZPyEiQwZegymGSYcDnN4335MuO56OnTsRCgUpiYYZOYnH1GwNp+81m3o079/6EBJ8Q/lpSUbaqqrUhmvlh+3uBh274Y+fWL2e3Y25OZagvKHH9A770SvuQYtKYG777bY/ymnqGZmWsdEzD01TQiHLbPQ9tXXYgVo6t/rFMZN93DdtQv96ScrFBBx0C56+geaS0nC5Cf+aeSzmluv3WaJKX+EwoJhy5mWbj6A5UQ3lrVu2/Z/x48cNWHGq6/wyYcf0DIvj5GjTkICAZq1yOPqayfQtl07TNNk1OjRtGvfMTr5n8+ayYcfvI8YBieMOomchg13bF+f/167br0O7N21PbnyZ5rg8ynffScaDMKgQUpVFTRrJuzYAZ9+aqm1BQWWdvTCC9C1K+oM2MQyMzTCmiVq99vKpbVyxWNuxSESnAGcuGCQa1+tuQ4OJTB5TCAnx/rbuxc/linQ9/gW5L8QQDpBVqWlIHqrL/Y6zoTPBsGfMjCDQevhAgEYNKi2oHH8trRgCz6/v0fJ/n2vvfbyCwOjwaA/nc7ok0+lZcuW+P2+qJZvGD7C4RBFRbuZ+clHfPjB+5QUFzNs+AjGXnBhZXHRzpd3b996WyAru+Tyyy9PGg2MbjffDA0aoHffbYVDP/4Y/eEHpKICTjoJLrsMGjRwx1zjXsmdjOGlmDmjge4VmyRBxHNVp7Lz3XkGnuFg+/6vv26Ffqur0TZtkDdnwDHHpgz9RiJm8XH/116Du+6yvJYPPhhVft2c78CBA94U/MPaTWQFApgwateO7dPfnfF6B2c4+KghQ+navTuNGllevZKSEgry81n0/QIK1uZb4eBjh3HG2HNrQpUHvircuvmmjMzMH0PBGi6//IrkBDB/PtxxB3z/PVxyCbRqBd9+q7RrJ4wYAWPGRF9SYwl6tg9IkmTcSLLIWxICcEcC4zhCslh/MnHhcS1Jmg9gH1pWZnmA6uL9cWZJe2f/JGxJCcBOCPEHsiVcU3FyWUnJo3O//rLnV7NnsWP7NtSsJSHkxFEMGXpMRWVZ8Zyi7VvvL1i2cF7nvoO48sqrEvMBSkq0YU6O9ZzDhiFz58Z+vOIKuPTSqCtMAQmHwTBsr5zninUngHikdaXMCHId76C11BwhXU7gyQG8Jk9/3ayxlAQA8M0PS1lT8BN9eg44Api8Z8+eUSuWLa2fv/onrJSwcgDq2SlhvXrTt//AUIP69XbsL9r50f7dhdO2FaxZ1bpTV66+5i/eGUEOAqBfP1ixIqKd+GH5crRXr+hES3Kp5aV4JWQEuRMyknEAp3Pol8gISvZ7yoyg32CrlQAA/nb9tfz98an83yczmzRskjs6IxAYWxMMDQiHQ82qKquyADKzMk3DMEoMdGdZ8f5Fpfv2vF9eWjI3r13H4s1rV3H9X29OKyeQ11+H225D9+5FbrgB7r8fB/v1zOx1ZuM6j0uWhuXcvAjAS3t3Z/vaRGF79TwygtN5luQ5gb8dAWjaN77t+mt5a+o0bv/3Cw0bN2vZSUS6odpEQdQMmzU1NXsry0rXVhwo21ReWnwgM7se1990S63XTVAC16yBAwfQI46wqNM0NRJ39pwgh40trknz1AGSpYSlqwO4nDuSiv3XWQc4FDnAr71FCcBmvZFQsDg8bI7VJPH6X7ynzb3qnOleHtq4VFZWaoQAxOUR9FzdSeoJEvQFh6hRD4KNvkOEAPR3vf/vTQDiStxD1SIBw4h53OIDKOLBmsV9nEtkiHPV2ucZ8ZzFeZ7nPdz388r6IdHQlyRixHLdxp7hd7n/704AwWBQg8Fgco+ZsyQ8DXqi9qJKjUx+tDzc5/O5I5eazKlDHWv/SJH3Z7/373n/350AwuGwuAhAoyHbQECx5KNEc5+TZ9YmIwTxGkARkXAk8FRTU+PU/lOel8yLWcvgJ5SBiQjhcJiKigo1TTMhdF7XCa3jwhDTNLWmpubQwAeoV69eMnsuGrvXQACJhHlT5RLUZfNFnEqZya/7S22e9X+maRIOh6VBgwYaTkxScZ+XoAPVkWDixEooFBJV/f0JwJEr56UXxBdWupwjXu5aj1XiKQJERJ2rzqOINJ36/INhxep8dsMw8Pl8UWJMuKal3SVeo/bcwFR1DWIvgEOhPDyaTiUigosVxiVaJMnWcf/vCutGL+063qUoSaQEMXpc9Dyv/EA7gyjJhvNcx/WcDyMpJ8nOJhKB7dvhqqvgyCNh4kSrQDZSOZ0i4hhnAXgco6qqhwJARBxrE5/PStqwx8mRxOl2pjgdLM7JdJpOThPQZUK58gGssGqMCKxMF/c9XN5A287XZA4nj6piT50i4Xz7/x07rJT4AwcigZofYMYMKCpKcB2ncnol238o4ANIgoPHTt92WgERluecjClTrMqkiRMnJqwEl0hJqD5229P79qFFRdCjhzrd8MnwBpzEluAd9CoLTzJJQnxJe+yZIpnNPPNMbPLtbc8e5N//hquv9iLKOA7nVfXs/P1QwQdIrI2zgz1O889mZSJMeeop5syZE/1p0qRJsYF2FnKQXlJGebly/fVw8cVw/vlEwSmij5ZuYofHZNeCAOZdbm7HM7ZtS1ACTRBxIKSkCkI57u+Zh5CSAJYUbGbf/v2YptkrWFM9IQU+QMtWrdt07t6z1wn9Bh1xpY0PMGvB0lrxATxZlS3/kryMe/Lt/20iiCZ7xAAmalOK9LDDhLvugjvuUDash9vvdPmQRaL1Bumw3Doc4614Ru6jxx6r8vLL9o+WDwOU00ejeFcwed3T7RiLcp5kT7W4YDOVlVWS07DB6OL9+x+e8+Xsfr8SPkAsGBQvvyXZgJ599tme13rnnXdinALHKnZyFAfCR3wswBqfnTuFiTdB72b7ubf1VCF/neq5F8CoUTHTNAkohWu1ewJTOFlwWVmZVlVV0bx5c+/oon38BefC629G9z/IBE5bP4W+naJJThFa90YksTOdHDqUBINBLSsr+3n4AI0aN8EwhJLiYvJXr2bhz8QH8IqjJGOjIsKYMWMAePvtt+OVRLci5SACJzuNzwcggjEgWgF81/8mGb78X/hBqZcNS5cK3brbV0kaInbJZHVELRPcvGVlZUQIIDFwFSlDExGZ+Q1ce/wKXffWKuGofvrnW3vKBzOssoh69WKv5iYiR1g8QR8IBoMkjQWkgw/g8/tYX1DAiuXL6NX7cM6/+GJO/Jn4AI4Hl2RyNZX9n6CEuZVBx/U9yv/tYIHUA05sMc+mFJGKSti7FegusfPBthK8FLEkcQtJw5egbntw8l+FQef3hbP7KsD7b6B9f1K6d4etWyUZZKK4sZJcASUi4sRj9WdlBoI11Qn4AOdffAmtWrXG7/exasUKHv/H35k+bQrPP/s0leXltMprxXkXXsxlV15No8aNmTd3Dt9+/WVXEZlcsPyHJj0HDalVFjqTObxs+2R6Q8Lv8bXS8TPtSN12moWqopGx1PCp59taly6jt772XS8lBqqkdtDNS8O26wIcaeJ2oajW4kCKT0MXCyRkyWIYd3G8LrpiBezbByecEDvNIxnFc5yc715nfAC/z2D1jyuZNuUJNqxfFw3b+g0DQzgYfAA32kaC3HSUWMU5Y955552Y3E/0LEWhZMTbDvaoCyBa9OGbNEGZOROen0aLRbN4+4fWTJwIoZBGXKmxBe2ebCdBOKFnJEVVspuj2V+//NL6POmkRGrZuNFKkp4wAWqrP0m2eAz36t+3p4hwOBzFB+jUuQsnnXwKmYEAfp+Pn1auYOqTT7Bx/QZEhDZt2nLxJZfQpEljfIaBTyAzI4PRJ59Cl27d2bVjOyuXLa3nz8g4Z9YbLzZs1LxlMj9AlL3aLPqpp56Kyvl0K2yj2DARHWHKU09FK3e9wBvdfxHvjyiIjBqFXj5eWh/RWma8ggSDKmefLWzdquL3W/PtYDJxYJBOLySpgSo9RYRdIPX3v1upkU41xrqn0KKFsGgRTJsmTJtmxxfU+TwJfgA3eGbt+ABDjyYvLw/DkOjkb1i/HsMQ2rVrx8233MLxxx9PZmYmmYEMAoEAPsOgeYsWHDVkSF3wAdTJpp5ymXoJcnbTJvTMM9GePdFNm+L1A8c5c+bMYcqUKU4x4VypCX/RKh/HPlU0K1P12WfRoUPRCy8UnTvXEgOR29lsXiOeRxtYILrf/s3jnuLFwAwD2bcPVqwQueWWaDpk9NMukzziCJV33kEmTEC++CJa+CRufUlt36prJfk9pFAcPkC3Hj3wRVb+tKeeYNP6Dfh8BiJCs2bNWLN6NatXrSKsJqZp1Qr2PrwPvfv2p3uPnl74AEtqi+S5J99p9tksXx94AHnvPWuyH3gAef55gCjHwEUEtsdQamclbledxsBGRG+5xSoGvvVW0SuuULnsMqcSJu5BV4cLOllU0AOryHIDTJ0KrVujXbsmCygppimcdRbceSeMHCls2AAdOyq2Hu3It/E0Xf0JM+HGB2jUmPLyA8x47VU2rFuHzxc7ZdmyZSxZsiTiuAFFMU2lS9eu3PvQ31PiAzgKRA8uzLl3b2zk9u5N28nkQvpM5jr2iFDaJh2ccQbapYtw442iBQUqDz0kKqKEwoLPiJqh4ohmam2JHfH6jbXv1Vfh7LNTI+YbhjVs990Ha9YonTpBeblgRdjV4Vj0TpL9WcEgiXk7In6qREDPuPh3BB/goRdf1FQyfNKkSXEr95133kmARpHHH7e+r14Njz8exyHsl7S5wbBhw6LXrEuwxBUviJPDffrAm2/CpEnC+ecjTz0l2qxZZCHEBHWMbyeP3AnxyGGAFQAsKECvu06i8ENeC8UmDFV46y3o00ci5mGcQyUat3Cnlfk9DNAoPkBFeTklJcXUr9+bcy+4kL1797Bp/QbEZ6Ewdu7Umb59+6KAqSZhU8nIyOCoIUNp2qw569evp6a6mpzGTcjOyg6X7S3b/+rc+bqlYHVSEWC7gu0Az5w5c2IqsYMIpEMHePfdpL54+3PYsGFMnDjRy9MmpJlmlehgsT5zc5FXX4U771DOO1d55F8GA/u5nFA2oJM3SJQXgakITJumtG4NHTuiwaAFe+dwLKmXrwtg5UrIyoJRo5BZsxxhEYd/wVkX6fdY1jY+QOftW7ewNj+fowYPoXefvky87oaIBbAeMYQD5eUcMXgwxxxzLGHTJBQOYyqYCiEHPkC3Xr3TwQcQdyh00qRJTJo4sU6ywZn8+c4773ilhqfquCHJMmjimB3EBezufwCe/68hd90aYkrHx+i46l308CORfzwCsWynWsVcDL8KHn5YePppS0/0+739/YkOMIn01oAWLdDrJpjy5FQf4Yi5JzZ6lBVnUETSxwcwTaV3n75MuO4GOnbujJrKzp07eOqJJ5g3b15EKzEwVeuKD5Cw2qKIXC6fvrqOGzNmDGPGjKm1pDuJCVRriNrJTbzCwIZhmV0gXHERPH7ybHKf+Rt88z0ybSq88GzUa5SO+WpP/oIF1ufo0d6rPJX+qgrNmyvz5ylPTfPx/RkP4ztyANK/P7z0UnxybWYmdcIHCIdNevfpw4Trrqdj506oKtu3b+M/r7zMvv3FhE3LEqgjPoCnGejl3Ytq1x5RMIeCp16exXiPn3qZY7a9htOMc4FIO8+PyNeI/gvatflWbUTsOwVrLU4RwXdzPYu6PX92GOPVV6FTJ+jYMTWn88YetCyAIUNFSs68jMHvT8b8YZlVZjdunFVxbRO535/oB3DhAyCGwScffsDns2ZSHSGCXof3ZfzE6+nUuUtELBsW+49Mvhc+QMne3e+169brQBIlTDxluEueRwM9HiveFflKiLwlH7D4811/nqlk7mOiFxl6EgwYgACVTVrLnfmXsWID+KJGgXhxoWj8PxwMA2GZNk3lvvvtVxUvx1HEsYSEwyrBIBIMxj86ZUXk/N/LUW+fNU2GyH33xUwN0+Tg8AHyWuL3+VlXsJaVy5fRs/fhdOnajd27fz4+QKokCnt/snDw22+/nTQjJ51+AV5WgVeyasKxDjWdbduQRQugWzcen9OXd9+EOyerI5ocu04kGqjNmzePXuuzefDHY6CqGgIZTi+elziIVymWL7cq7Od8B3t/2MLMNe1jAS1QMjKs1HpVCYbDmjQaGFaTDGFNo9zc28489/zpQIdvv/mKt15/jSWLFkXxARo3bkLP3odTXFzMa/95JQ4fYNjwEZwx9tyaytLiPr005AAAIABJREFUOcW7i56u1zCnJBSsSVeJS2mnDxs2LMFLOGzYMK/kiGjMNklDiOSexhhHUFf6lzcXsYmubVu07RgEuKG3Sc+Own33CevWwfjxdt6hYyIjKW/69tvI6y+TPTPM1KEXkhm4EA0rGoHfdd5vyxYLRHzNGvj6a2XuXGHXLut18/KgcxfhmFPbUlnaiewdG2KkEgyi/frZNZfJOYCdEPKb4AMkJoQkXX3O71OmTIkSgcPOj4N5caZDOR1ONit31ga6HUSOeL87YOOsNXT3IojyBFUVC6kW8vOF669XevUSHn3UqnU1TaS8vEyrMjOl+bRpyo03EkcXk2/HfPABLdmr8v33wuzZ6MyZyObNaITlEwgoo0YJw4fDiBHQtq2SkyNkZERedeli9Jg/qFRWWquhVSvk22+hU6doPsDvjw/gIQKIr6DRZG3VnEmhdqW4I7rnieWTBkCEOpHC1T3rrjrDJIkgdq2rDU8kFRUwcSJaUoJMmSK0agXFxWUEq8q1+eGH295MG7+IEurRPXsHhZVW7OSooyyA0sMPV/r0Efr2hawst1UZ8xWpYgNbqs6cKfj9yogRNiuTYChUOwHAb4IP4JUR9LO2dLABIDU+QIosH2rJtnWhlsTL7Ycegpkz4cknoV+/Mvas2KDNjz8+2sDB3mqMTL6dtoKBl3ajcVby1AGb4Xm+Z6TXktqcz6GEpEwJ89p+C3yAJIqfuqFWPQY8rubO5X935XZKyp5BbhQRV0s69/XFSzy5j4n5X6xrvviiZeINH17G7kq/Nu/bF123Lr4GrEULKCzEBMxQrFg6lvCcWCuRzNvpAbBRdwL4tTZbB6gFfy9VYWZaXcO8FL5UVkAdrpd21zA7ymc/QWlpmVarSfMdOywoN0tWWx6m+fMtvn/wnVG9agqdBMChgg/gVdOe2lWcen/aLVQNh1csxe1/sdat7luIiFBVDT17KuXlFjx4OCyceKKFkRTP2w+2ONTzWQzDiOt88rtte/bsUVd1sKZYZdSSS5cup0BEpLq6Wi2PaKYXB0pnZaf7XAmxABGhoqKCiooKzcrKsjiQXaVsYSP/ousMj/LwUCh0SHAANeweb94DBz+vy6YmWf3qQApRj/p8Pdhr13KsOlegz+fD7/db72/ngVmrX/hluouKB/FrKBTikCgPDwQCv2R9/kHh+AZsfPVf4R6pNiu+Epb69evHKbIk71VY1+f06kugEe7HIQEQ4dTwU3noanMRp3mvOBbsgQ+QMHBuP0QttX4pPYxe5qLP5yPD8tyk4nz6MxaElyjTcDgs4XCYQ6o8PAXkatSM8QBKSneFaG3Y/clhZm34eBK8g0TSBh2NxuPyB9LBG0wWc4gF5wTZvt0qBerWLS4wprUEt1L4Quw6w0Ni0xTyy9lvzwtYIe1ckXRWqTfTiC/DT3x2icLx284fXJ3M03nnOE5hNWKwJv+cc6yJ79ED7dULzc9PyDBKJx/Cazuk8AFSReQkfYjYlCZdbdeK9/DFgnyAbNmizJkjrFgBu3YpwaCQkwOdOytHHy1YbWs12vDcSTi1rMiEJNSo12fCBPStt2KrYfVqGDAAKiqs5lcu/PhkY+gxlpL26rHxAVAdEArWjg8AkjY+wK/hCk6XSJI4gqKd5SKOG921S5gyReW774TDD1eOPBJatRL1+5HSUqWgwOplmZUlXHSR3ZUVwmFVn8+KxDra2EafpaysjGAwSG5uboISKHb5Ua9eqgUFsbN8PsxwGGPJPBgwFFBqagSfzwoyOYpEFZs1maaVPy4CPp8KSFVVFdXV1YcEPkBdodd+ttlZmwiwoQkMA2bPVh56SBk8WHTGDMjLE5dvz/p+881W3+KpU+Hrr4WHH7aSM61rSbq6nLpsVVVrhUf9yqZpJZicflqAtmPg4vOEwYM1Th1yVElbypNhgGE4M2Vqz437nfABfnUCwJHmlaxhhE0MH36IPPyw6t13CyedFN/V3ktJtHw4yoQJQkUF8sorqN9v4w7Z8Icahw/g4ABeHlLVhx5Cbr/dYkWRTCijYzuuO38zX78XZMUqaw5OPRXOO08ZMsRqoh2FW9y/X+T221W/+w46dEDuuQcGDKCqspLqmpqDwwc4ashQuvfoSaMmjVFVivfvZ21+Pot+OXyA38TycBGAwwOprFwpcvXVVovio4+GcBhxtimIWSdg41paHW+sG1xxBeTkoI895u0JTEcEhIMmvgxDPzribvnD4n/SyF8Fw45D33obadoUUPbtE+bPh+nTlQ8/tG6TkwNjx6KXX4EMuaQT5G90RhSUZcukql8/qktKvAlgScEW/H5/z+L9+157/eUXBnjhA6xfV8BPK1fQs1dvuvfsZWUC7y6K4gOUFBcz7IQRnHfJuIKA339Ro6bNv58546UEfAAnB3DXrv8Sjha3kycZQkg8HB+ccw6MHIlceSUaClkT6+gY55FnYO2z9bIDB5AxY6z2gn/8Yywb25ESZnMAyc3N1cRootWpvrpaqVdPeG8W/PnEyKqOSB8PUHO+/x7mzIE33hX8Cz5mIacKLswBuegiqv7zH6nev7/u+ACtW7emorycF//9LNOnTeXRhx9k4fx5+H0GrVrmHQw+QEIr1SQJmnXuw9u/f/907ue4r/X58cdQU4NceWVU74qh1TkBqGxHUmzCxFL6kAYNLBAvq6OtYBjW+Y5q4ZTu3khlO7ffDnl5yp9PjEkfr0oju+h48GDh5puFJfNh4fNb41KPoze288dU644PYHcK9xlW8+idO7Yz/ekpLFwwH8MQMuuOD+CpADkxAby+p7OtXr26tvs40tGjNj1vvgnnnivqxJqysnscYJWGEU8Z0fxBjVSXw/HHQ/36MG+epZBb3ewUUgA4u025Z5+FG2+MmaWa1GkUhzGJCYT/MDJWvue8kZ2hahh1wwcwRPAZQuNGjbj8iivo2rUbIsKunbt4ZqqDCAJ1wgdQt4aeapWXlpZy1lln0bhxY8444wzKysoAOPnkk/k80tX7008/TZpc6mwM6fZIW+2IlT17BIt5xLzAtnMmet2FC5H//U+lpAREVKwKEWLgZkKTJtCzp2Dnr1p+HdFk/no3cf/vf1BZCTffrIRC3pA47kVhlzyIKr5uXSh/6Im48KqefTbcdBPU1Agi6eMD+AyDQCBAICNAZiCDI486ir/ddhs9evTEZxgU7tzJ01Oe4vv58xCgRYuW6eID1Gm76667uOeee9i1axdjx47l/khbmX/961/cfPPNVFVVceutt7J27dq0PGTOVQNCfr6Vr9e4cRzTjNYsAlblxsknw5gx6GWXWVgtkdyCKNJIhAiaN4fNm2sVWxLv+YwqkjJ5ssV+DCOGNOvwkMZ9xu+zrvfP7Ovo2qwYvvpCZMsmwXIqiR15TAsfQERYvnQJq35aiYFgGGKBHBsGTZs2tYCOBQp37eSZqU8hIhwxeGi6+AB12t5//33++c9/4vf7GTt2LHfccQf/+Mc/6NmzJ8ceeywjR45kxIgRdHUU1adPAFZqXv36RFDqXXgT9sy8/HK0JF3eew8uuUQ4/XSPKmKlQQMIBu1EH0nWWMrphAJg7lwoLkbHjbMYi6VAeuL/xRfOONBURdAn7lWZNDEHjj9Bo/0V7VajpIMP0LgxpSUlTH9mGgX5a6w4dgSXDhEMEatPL1aF0M4dO3nrjTfo0as3ublp4QNIXez/Xbt2Rf0P7lDupEmT6NatG6+++upBxgSUjAzLAWeH5nFBtyECnToJX3xh7WvYEG3bNlZxq/GNSkJhh02eukIZpxVx//1WFnDnzt7YAMkAImOPKXz8sVJcLNxzL4TDVqaZ+0J1CwbZnCYy+d7gS5EeTx5y3MYHSBHyrJVfN2vWzG7wgKpS7cieeeqppzj22GN58skna/MBaKISqAqibdpYzcgrK4kodJpYQ3jHHcr48crIkej06TBokF3554SaAdDtJWj9VhY0jGnG1SU6dYConPH5RLZXCLNnwzPPRHtmx+EMOT/d+3H0uR4/HrnqqmhYwQkPEz22dnyA4mJ69uzJVX8Zz8IF8wnVBB0iQFizZk1U21Y1adW6NWPOOY8GDRqyb9+PdcUHqJULnHrqqaxatYoePXrw8ssv88orrzBv3jxWr17NvHnzmDdvHkcddRT5+flkZGRQWFhIy5Yt047Zd+oEpaVWhVebNi7AC6scGGnXDqZNs1K3MjOd7sBo4yvWrII77+CMWTvQv/0NOEP8hqqI4d2VRARZvVqZO5MP/tOCI445n759o2VE6pVL4B1Yso5bvBi2bEFvuMFqk2wYcdeIKp9p4wP0HzCQAQMGYojg9xn4/T5WLl/O0qXLMC3SJi+vFddMmMiRgwcTNs064wOkE/V76KGHGDduHF988QXdunXjv//9LwB//etfeeSRR8jMzOTRRx/lxhtv5Mwzz6RTp06Ul5e7E1ASEDkiQRQRQYcPFz76SBk8OLY4ozkJzuQUe/Ltwv4IrxaQ8M23IR/9Hz0B/nOdmGf2wujRPZHQbQp78EG44w4UGA+Mb30dlBagOY2TRjid0UX7d1uEPPywMmCA0KNHrBTNS/dIIIDtmzeWNWvZamGPXr1HL/p+PosWzOfEk06iVavW+IRogvqK5St4/LF/sX79OlDIa9WKv0ycxOAhRxNWk6KiQk98gIxA3dO/nJp8bm4u77//fsIxn3zyicPMHcUo29ZNHQzy6OkjXHABXHCBUFAAXbtGWxeqJutb4PLzmoCvaGPst4JtKnv3CHRPXLWZmVah3x13RB/ExEB37MF37bXIf1+LQd9RW/taS1eoqLBMSBtnwAtG1lMHqBUfQCFsmhQXl/D8889RsHYtqkrLVnlcM2GiNfmmSU1NkJmffJwuPkCdU7t+ZiRIvLyPjgAMbdsiZ56pTJ6sDs4fl7omTjYcHxdUDGDN0PFsx2ftu/JKkYEDvRUcv19YsyZOIRFMDCA462uqouOicWkCCX4AsXQzw4Ab/wrt2sHgwcSbsVA7TmAqfICamhpMhWA4TDgcRoFWrdtwzbUTOSqy8g8SH8Clxf56TZOd9X5epqD903XXCfXrw4QJMSJwenHj9akIJ4/sm/MtXJ9/DWUvzIFvPoZ//AOysy24+QTN2ISWLZ0XjbZInlvUVbIFjhqMvPiiyM6d2NMvIkg4LBIOI5YGgcje3VK5dqs8/wJy690CmGK/kwOkMl70eQ1EOvgAG9at48cVK+jZqxc9evXCNJWiokJmfvLxQeMDpJv58+tGA2OgIJWVcM01osEg3HefSpcu4tXFK/pvMKi8+qrw3HPKTTcJZ54ZDcKImCZqGIoDqLqsrIxgOKy5jRujp5wCDjEmIIWfLtbFvoG8/Tr85z+WKOrYURg6VDn/fDjlFIeFeu21yIsvYFZVM5/eHLHkTQIDeiOWXzrBw2onhHiO9g9rN5EVCGDCqF07tk9/d8brHRLCwT170rhxY0xVivcXU5C/Jg4f4Ohjh3HG2HNrQpUHvircuvmmjMzMH0PBGi6//AqvaOBvlhDi7CeUrDg0lg1kTewjj8CsWRYw87BhSIcOaJMm4PcrFRUiu3ahP/5oJYSUlgr33gt2HMqZbOzVPj4aDgYLGfLTT6FpU7j3XpGOHdVJZ5s2KS+/LMyapXz/vdVfa8Bx8GqT2+n1/kPxfuVmueiWbUikLa3bikhJAHZCyG+ED5CQD+BWtry8Xsny61Jl17piAJ69g+Otkqh/gPXr4dlnlQ0bRJo1Q+vVsyy3YFAoLrbyA884wwoj2xNuB4VstyyuftJxBBAKOeHArMYFFjypmqZKOGzX/dvjBmvXCv98Du78dzt6+7ai4ThlVHXxYpGBA3HdV3GkhB1K+ADqVLCSwbuko0Mkq5i1c+XSax4di/07+zlVV4usWKFaWCjU1Kjk5ECXLkKHDtGsPwcohcV9kzV1chCAOvsd2eBAODqeOaEOXHQMXTqg6zcnDsiyZdCvn4hHY+qqqiqplQDgN8EHcKeE/ZriIO4e6eADRPVyC1EFv9/tvrX8CqYpOHte2/PmJmJnXUOylDCvuoJk+AQKyGOPwV//at3cMCAUQjt2RAoKiGalura0OIBz+y3wAbxCpL+G8pdMCXQ4iSSJr8BTCayt+IIkRSwRDqA2Abg4nWc/wqQi7uGHkcmTrS9Dh6LvvIO0bh11YLmvU2cC+LU2D4AIZ6XQL/p8zgbRERHgTAlLt3n0z64O9tABNJ1AUdIwZrJhiuWfeXEAqTUt/DfavErDNMnge4kITXfQXEqgJkMV8xIXJO8dnK748nwnR0z/4IpDU1UexVNUHBey3ce/OwEEg0Gqqqq0FgeQprk/bQ+SYRjRSKK7ULQuekQdni2B2ILBIJWVlRoOh5Oliv0qxaF2ebhpmocGQojP5yNNiJhk7Lc2gAivOjwxLEMfw0q3SYfDUIdnSMm1bBRSn8+nfr/fDVDxS2EDQPIaRAmFQr9/82i/368ZGRlyEC+jaQ5U0hUajmR9ZDgN7LpxFK9nSPt5/H6/qqo0aNAA0zTThrZJR8FNoVCriBDBB5BDQQdINyPo52AE/VrPXNdnS/jdRgghNSSO1nGBaApFFIBwJJ5zKBBAMgp2V1TGU3M8eG6dMYKwG/8dxHlpWAHqAPCLPy8R2C8hM9grbp+uOVjLbwk6hsGhRAFe0UARq2XGs8+iV1wBkdTvaLuuJKqDd7p04v+1PUs6v3vVK8QVG8yfj9q54bVYtnVFQaltf23vfSjgA3iyvagDA6zqiEmTrN/feAMKFiKte2Oq5X3z+aKu12hrVNv54Yx/u+rvcK28pHLThTcc10soHkDCYlrhsIj4xYKJv+9uuPs+6+crrkCfe85d/ia1TKon0kiaLePx4npOb+QhhQ/g8NVHtXIFOO88kRkzAAgBn5z5Ern3XMqxfaLcVh3mrXpMHB7esASwaI+BTyo6Yo2YbARwR15A5PSilbu03tB+NCgvikK26759Ik2aRB1BpmnSqFEjr1hBHHi2lwjwYO8SF/WJuQET4G/ScgQtKdjM13PnYppmz2BN9cRfCR8ggfJd+Xoqf/wjRAhAmjanoM3xfPUAtGwAl10mHHusYw3GZ2rFTbi7ezce2UApHC/ifNJIt/FoDod99r59wsyZ8Nm3kF1cn/tadZYG64qsHw87DEmMOyiJLeijc5iqwsmLCFww+Ul1CGcgw3NbXLCZqqpqadig/knF+/c/NOfL2QN+JXwATw4QGfGIEhWWN877iNy9BZz4wHAODBhEwY8w81Pl88+FgQNV77hDxKrmQU3TjpPEo3vhQgJ3B4OijavjiwLt/jAu93S0kStFRcJ33ykffijs2KF07Sr0HwD9j0AXP72EIbPvk779azDH36wyYnh0GiIcQBs1aiQOTOK4OECKyU4ag0jZ18B2BVdWSnVNjR4UPsCRQ4bSrXt3ciKsq7Sk5OfgA5gecPGxUixRyqoNxv8NRgyHc06H0iJoWF/JCFhY/NOmKfn5wgMPqBx9tI2KYiV0uKFZnIOWFCDCAeobr+5bYsY00fXrlcWLhe++g59+srp1nniiMHAgdOigBAKw8AfhjgfhjRegaa6JSaQYM0I7EQKQRo0aeYataxMBrglWEnMOov+78yGqQH4WPoDP58OMdJwwfAahUPhn4wM4JyiW5aosW4r86wnRSddDl45QXWnhrvh80KABhEKib72lPPcccuON6DnnOIt04htIOLloMh0gEiqE118XtmxRzjwd7TeQpcth0QKVNWvQ9euhUSNk9GgYPhxat45mXgFQUYGcdRZ6zV+E0/9kZQobJOQDqBkKSaMmTdyeUBEPxULjtcK4heKEi4uTKXY5eUy0xAhg//5EHcDGB6iuqEjAB7BKxAMYhlC0axcff/gBpmly4ug/0r59B/Ii+ADNW7TkpeemM2/uHA5r36HriBNPmlyw/IdLew4asj+VI8hN7bYOt2EjVFciXTtaKc9GpAtSOCyUlFgd4i++WDjsMLj7bpVwGM4/P4bWZVXWpG5WJW4AwsceQ++4wzItXnqO+09awIpwO3L9wpAhyE03QZs27mtJtCbwkUegfXvk9D9FJsr7EaKUnhQRTUR57z30hhuQHTvglFPgueegWbNo86xohdbq1RY0ycKFaO/e8MILyKBBsXY2Tnd3JFvU76mIpcAH8PsMigp38ey0Kcz/7ltUlfw1a5hw3fV06NgJsPABdhcVMuPV//LlrJkc3rf/yMbNWpzcpd+g16Y/8zRX/2V8KvMlGsC2dcEtW1SaNkVzcpCyMnEVOSiq6J49MHw44vdblVvNmgmjRjlhXBJMqTiHjhMQUAA++ih2g607ObppPmP/2o4ezW2MIME0NU53DIctmN+lS9G5c5Hnn7cHXCMwApqoYBpGcuVOxOouceaZ1kmGgb7/Prp0OcamfJBYjST7t2P26mWJGJ8PWb4cPeIItKAA6dLFm7jqig/g9/nYXVjIM1On8P28eRiGD5/Pz4/LlzPtySfYvGkjGT6DzIyDwgdw9eOTiIKp7Ngh9O4NVVWoYag6FLzIIrIqlvfsEYYNgxtvhPvus+DbDEMIhaTOgRU95RQVIAgEW7Rh5F1d6NEcQiGr2jdSLBIptLUe2++3fFMPPQRjxwqdOmnUN+DoJB5fG+ihpcXtuuuuqOBWW+Ru3sh7V8zi/ifgkUfggSfgu3FvRCdTIin7ADzxhNuEtcOw1AkfwDCEosJdPD31KRbM+w4xJFqkYPgMVq5YztQnHmfTxg0YhkHzFi3qjA/ghIGx2f/u3cKWLdCvn1BdLdEWqfa7xKqyrGcpKRHOOEM47jjhoYewJyaaG5EMICJ6f3uAbr0NXvi3BsffxK19P2FNYcdIAMfqvhbp/qERAlTbHPz3v63Pa66JEWea0DbOIs/Ygx04gMbqQaJFne++USUPPIA88ghy//3It5+VWRMcc/BY/LO01IY6ieudaJc/Gx5e7AR8AL/fT9GuXTw95SkWfPddHDuRSMaZiLByxXKmPPk4mzasx+/zJ8MHSBUMEruIwa6ILSyE3buhWzekulqjc2gNlDqcMdZ1gkGkpAS59looKlJmzIhVzGoMtC/hz07MUNsr6PeJOe5KqTftUeqN6MuTj1qwe069KlJsEVE0VTZuVJkxA7nlFrszm/WbOik2vhpJXAEcdfa6UlDOP99+UTtbXcOg/y06Sqv3oPv2odV70b99PyrSoTTaKNrSfseOVUioSo6auEbCTHjgA+wuKuTZaVNYMO87FCWnYQ7t27ePPlKbtm1o0tjybq1cvpynpzzFju3byG2aHB+gNmeQva1fD3l5FmiDs1W6W5Q68ykqK6FZM2XMGOGN92B/KPbSksLHH1UDXLN060TYuEH57DOvZ5Xo52OPCUOHwpFHWpNfF1ArN8iDTdly++0s73shpfYz5ebi++ADqH9YvLu37zEYTzyBZGQgQClQdtM9yKmnJinjJwkH8MicWTB/HvPnzcM0lXr163PZ5Zdz/PHDMU0T0zQZNGgQV//lLzRpkosqLF+2lO/nz4tryQLp4wNYctJajKtXw+GHW7CrdnffSENVtf0lEf4YrfP3+dG9e5Q/jYV6oRpd/uQSpWaPSvx9PP8iypdqlMUo9evDtdeKPv64aCgkiKBWAlEMtumTT9D8fHTyZPs6TuCp+P7EJOID4OREFhe0vlVUIv1X/FcWvbRZKFglbN4s/OlPouGwOErJLMiX664Tdm5Hf/pJhuTulGc63Y1VHqbiqomM0rCRGHeM4QMEg0FKiovJy2tFixYtaN6iBZdeOo4zzxpDRiAQbeRsGD5Gjf4jV/9lPHmt8mjRsiWtWrdh39691FRXk5Vdj+ys7HBNdfX+V+fO19pXgnVIKKSsWKH07RuDQXNabjbsmrPeMRwWQjUmZBpk7tnDs9tOlSE3DYKuA+HbudbMWPJP3MqRlz5mi+TTTrM6fT36qEZFqGWvWKigjz8O112n1K8f772rQxDH7lkd16L+L9coh7VDR1zaTkNdeqo2aKCRRgPqGKwopKw2bY706qXHnZunLz4JYFjyVLz7ctWKD5C/ejXnXnAht99zL36fj65duuDz+wmb4SjbNdXKpxs5ahTtO3aiJlhDuw6dePP119LBB4hLCIkFg2DfPtHCQqVzZ2eXU42mBzig2TFNyzFUvz40yAxLoc/QXf/6gC4LZ1sTuWUrvPyKyrF/ELzbyDtbhEu8mWmV/d9wAzp+vHDqqUifPqqhkGX2Pfyw0KOHyimnxEx752Q7I43OyiA8MoWdZd7bt8N//iP68cfWc/ijUBQS11g7rvlTBCL6jsnw7NOwYYMNHeuJk5yYD7B988ayhjk5C3v06o0YBgsXzGfPnj10696DLl27IYYv2ilcIyaOaSqhcBhF6NS5C92692T/vn0sXDA/AR+goqw07bDwjz8ibdqI1K8fhc7HWZ3r81nl9dnZSOPG1pjMmYPcNlkYdzHy6YIm4kz1lMaNJY1AlLiyhaNsp3t3ZNSJypNTrF/8fmHeQisOcOON9uTH+5fcPiZJIx8gHLbm6e9/t/w9J5/svHZqnUnEsvDatBHat4epU9Xp90mtAyTHB/iIqqpqQmGTcDhsfZqmRQRqoli4AaFwmFA4TFV1NZ998lG6+ADxOoBqVP4v+gnt2AXNylJMU9UwVLOzVXNyVLOyLMLbs0f55BP0hhtUL7pImTFDtUEjn447Cz3tudNVHngQunRRLrpIueEG6x6RZNAksjmqMUdYuNrcHNAbboTCYvTD90NK5T6e/jecfb7QsSPqUNTVkeXrvJ6m0AGiE2UYQmmpVSv65pvO9rQa5wJORkxWiaFy553w+OMOu1DiG2DjxgiK3iiGDzBhxquv8MmHH9AyL4+Ro04iEAgQDIVo0+YwmuQ2AYSevQ8HMTDDyfEBtq/Pf69dt14H9u7anjyXzR7liBG7apHJcX8yyG0mKqZSWSXs3Gl1z161SnXpUgvFo1MnGDonC6EqAAAgAElEQVRUGDfOKp9u0cK+pA9un6x69VVITg4EAjHQ3hSJnA5u4HAQKuGQEggY3D/ie3Ivv4aq4rU66biJ9HzsYZxuYCd6uEeY2zs9yzQtPNnIIZddA906hzjhBL87oplGPoDllj7jdFOvuMKQGZ/DuSNBEcSMbzKRQACDunVgacGWmoyMzGnHjTjx6G1btwz85ovZvPTcdAoLd0XwAfIYfMwxNGzcCBGDnr16EQyFKSoqYuYnH8XhAww95tjK/UU7Py4vLfkmWFODGx8gLivHjoFv2SI88iCXvr1FO/W/glUbzpIVC4WCfNi8WdmxAw47DEaOVO65B9q2jaJ4R0WqnSQiIkKzZqjL8ybJTbGkTaN8hsWF+3/7D2HfMgXkqIX/gKUjMY8biUTTGNU9yQlFGQn5AIahbNkCj/0Ts7Rc9r1xHg/MHqlgRp1JdckHUFVymxmM+0OBNr32CRhdA2dfQiR5Inq8Z0JIWE0yhDWNcnNvO/Pc86cDHb795iveev01lixaxFFDhtKtRw8aRwLwSxYvZu2aeHyAYcNHcMbYc2sqS4vnFO8uerpew5ySULAmPeH/wP3oc88zHCR02xx9duFA1gY60jlPGTPGir7F95qMY6ESj5urngdRR/s8bgkfCMX2lSvUqHcGiaPncG3xef3iC2TkSMuqAr7iRZh3O+bIBxzRP/F8Fc+dhqDvvscLc8+0dq0Feep5C63k5ptrT1v+PfAB1IqRKqedJvrNNypADbDh2a+l09XHEXAsztgcxlLCXAGeXz4lLNIBWufPVxk/3irQv/569J57kMhYuOL0mpDj6MIHsFPCtEcPJD8/equQtTqlZO0uzOYtIzOdrA7FFQUOBUUbZZDbua2Gt20Xw2luZGQoBw5QZZpyqOEDxIANnntO5KqrrO/HD1O++lwgg2BQIxiFGofajkcnbycOQFy2j2OWk/cMEnF9j6JJR3LBkKIipaREtEMHyMiIdfiKxybwEifeBCCi+P1WtMlONQIR1gDdNXHSUxUe1wABFKGGDAIE7SOs6+7bR1V29iGDDxAFiHBkAossWmQJ+xEj0AYN4obOI1UqYWRcZdZxEcZUABGuFZuorNnADUQxU2O9/eKdOrHE1miPComrfXCmhNG/v7J8OY7rKn6/6M6dasf+vTmAByMPhSDDj3Tpgq5fH/9r/fpQUkJVMCjV1dV6KOEDuIsmNG7QI/tTtV3DG1QhaXZvbRAxjsnEw3mTSoQma4CdnAC+/14ZMiR+pT76qIRuukkJJTeckqiz4Bf8X3yOjjwxnkdMnw5XXWVnBeshhQ/wW29VVZZPIisCDf5bb660cKW4GJ55BsrLhTFjlP79JSJalLpCJdhKUlER/PvfUFMD550n9OwZlxZ+KBBAKogYr1WXan+dqmoPkgDSvWet71RWVqaqKjk5Oam4SNpTTprFoQDV1dWHBkBEKBSSmpqatAcN767YdSYeEZFgMKhWBpVPkpSnp3NtL00srecJBoNSWVlJdna2Fz6BeFX4pADMssWjM7fSK9tIVJX9Vj/I358ATNOMlmlTG9hCNE4axcZMJhhr24eIaCScLcFg0HOwUghZSZMgJLnLXyLxDB+R+/+m4+73+wmFQr8/AQQCgVpQuuruvKnLFgwGCQQCdUEI+UU2K+hjIYP8HvdXVWpqajiU8AESQKLirADDgE2b4NFHYd8+5MYbrdSbcNiCYPXWtL2sAHHa+oFAwK7P9/Sxp4NP+HOUUJ/PF/1Ld7Oyj4XCwjCTJ5fSqpXB7bc3JDvbSJuTmKZ5yOEDuN2lsXIp28a+7VaY8aY1k9u2whf/g0BLu5WiqIrlj8fV7MdR3eueSK+V5570FF2/E85LVb71S2Ah2+Fivx/27jVYtqyKgQPDZGfXp64NYDioM34FbuTwuDmLG6OTZQJUFivrlkQzMPd8u0LfvmsbXyxGyw7YhZRWJDksouHYctdIZYi6UcI8nD9xEx9dTR419sn6GTq/1wZle3A6kxIICBBi4cIiIJPjjmsL+A/q2gfFAVZv2217KxqHzXB/VR0YDIVyUCUjI6NUYaVhGEvMsLlPBD28fauDkFG2bwh8BmyrbMzy4NmM5CEyARl+kizb1461D4TkrWaGNm9lMGgQHHuC0DxjCzw+FTbtRc+5UOSE4XaZUEwOeODnuWHj4uBbXRPqLkVOxQVqCwTVdVwMA2pqDNav99O1a4gmTcJYPcX59Qngpy07Mc1QtsApxcUlV2/euPGIDesKckqK9xsKNGrc2OzYucuBw9p1WJ7TqNF04P3lG7aV9+vUtg6mlIWVbCv6u/cIV16ODB8xiVMmtYfycnJGncqD3X3s3Oln8ay9LF6Rwcz3A7z5Xhb111cx4tvlnMEsst98HXPJapFOHdSJ4ZqKjduTZYuRCGiz0zWYdEJTxex/rgiw4OwUnw8KC01WrqymTx9ftN3Ar04Aq7bsRERyzXD41tWrfrrms4/+r+HK5cspKy0hZAUx8Pl8RoOcnJwevQ7/w0mn/mlAj169B/v9/vuXrtuye0CXdqRjptm19wA7dgmXXowe26eEi25qKWazS1XVx569PmGndfwfTsuSk88v1cI9OexYXsSqS6bzIX+igCO5u+RBNTYUoJ06pLxvMlRymwMkgjancV6S373SuNLj3hptV7xvn4+tW+tz3nlh/P6DFytp6wCrN+8gw+fLQvXWH75fcN3TTzzW8Ntvvqa0pNiqEo6sGFOVspISFs77ln9PfaLB4kXfj6+urnpw/+7CRnN+WJ6MA4izGbNG0vDWrxcuukAZeWSJXHlTIwEo3BOQor2+uBGsqK5P4Z5WAjBodAYX3RziNp4mn7as6nee0LsDHjnRkmyVxU2SPTv2H7HebF46gzv7JxnAQ7yoc5T+SHJr1zQhM9OS/19+uRWRA/Tr1xjw1V3+R45PiwOs2bIjInuMU9f+uPLq/774XGDnju0YhkFmZoBOnbvSsVMnFNi4fj3r162juqaawh07eO2l533169e/uGPHjvmz3njp8fc/+cz888mjvT0zIui8BWrsWCcFDYZy7VOd9fTjirngL9nUhNJ7r507mwgXPEnfvOc0694erJ58Jb1aGc6wXBzESzIvm5f/IQ6DLUnzJje7d4M0ea1+EatV7bhxcPbZMGRIPBHYsTA7m6283M/OnU0YNMgKFB7Ulp0NNTXpcQCfYdCwYYPGB8pKr/70o//L2bF9O4YITZo04fKrruGWybfTqk0b8vJacd1NN3PpFVfSuHFjxDAo3LGDmR99mFlVVX31kSP+eHh2/QbJb/TFF+iJJ8LZF7H/j6cycfBiLplQT2pCBxGsuXAszU4dzMZCH2CZhxKvAKaUtQlcwD1reCdmxrVvdROW121Nk4ICC+39449h6FDrsJ49razgzZslGguykj1DbNu2nebNtzJ69AFyc3+GYmma6RGAYbHB/ls2bTxi5fJlGCJkZmVx4cX/X955h7lRXvv/8466trr3tl7jjheDsSgG2wkBQi+XhMSmOoAr3EDg0ksKKYQkGIghYExJgFBDQiAEMNgEhAv2Yhtsr3uv21erXUnz/v6YGWk0mpG09hrv/d15Hj0aTdXMe97Tz/dcyaX/dRkFgQB/e/VVXn35RRLxOBdecimXT7kCv8+HEIK1a1axa+fOMn+w8OwzTz/VuTRswQJckUYkcCJr5Xm9FhJPHJqrYvfuEnFceSN7t6pooQYhJTbVudmUN6P23jSoAgFSRVpS7FXUtCtKCWgNxdHaxoNUNSdOmutBSsrLta5xa9dqx33yCZx5pkYAA3Xd9ayzBAsWNPPFF2tobd3OpEkNlJXtoa6u9tAsDF2k5UcAioIixNjNmzaWNtTXATDkmCGcdPLJ1FZXU1N9MFmzX1N9kNrqg4w7cTyDhxwDQGNDA1s3b3K5PZ6TfvOLnxU6ajwVFagpvixaiwbSGncdMoEfXxFn906VvfvSwglC2heGWLqF6BnKOu+QqtQ+etaeIgU75U6+kl/pkRgdcFqAVLWzjORgIaReTa1p8GkVc4qC1d1wyilaVXdtrbbtxRcFnTpJPv20lrq6OF6vAriIxVSi0TrDU9J2T7mi5KcDaGlYoqg5EiERjyOEYMiQY/j0k8X89aUXAairq0NKye9+/SuEonDmd8+hbPBgVn9Ziaqq1FRXo6pqvy49ewd9gWCjHU2Km24UorGG1XM/QbnkItlp4qWHZTgXlXUXkboo27a5Zb++RkhdyLROTmmdv1Iv0dybz5SfhVH5s5hF3MiP2ckOpsvp3CfuQAhvyr8kBLEWSWMjRCKSpgg0NUlqasDr1bCEzDcyE4EVhur739c+9fUKGzZojcsLC7Ui2IcfVli6FM49F66+Wus3Zadk2gRBIF+4eEUo+idVn6cIgUtR0Mq9penFGfXwqS7G0oBRk9IrhCgG9lnMMR3x0S2592e80Qu5bzXM7bVH7t7d87CIYMgQyfrNcMrJim1QyVhtbRVJ9qzqrLqlBZqatIFraoKGBmhuhHgt3HXuPXzd7QsA7ud+vn7oHLp8No79iqCxUYOv8XrA55N4fQKvV+D1au9p8GAYMUIrU8hmGZgdYkIIfL5SAoFqoJlIJIbf72HWrBJWrFCYPz+V7Hv++XDttRpRWOpzU9fWI7B5cgAQimgoLCzE43GTSKhs3LCBK6ZO5ZxzzmHf3r3ccvPNtLS2cOvtd1BWXk4k0syvH/wFCIHLpdC5SxekVJuaGuobrNUpSStA73lf0UeItxY1s3t3Tw53OWFMjFX/2iNk762ISadKKdwC3bEDCK9Xeyk33yzZvVvTuCMRbdaCoKBAEghAMCgIBiUFfujkESS+5Um/z1iF0CCIdZIEgwK/X8sV9XiE/i3xeBQ8Hq2cLRiExsb8nD9SShKJBD6fDyklr7/+OhdddBEVFRobGTAALrxQe6d79sDrr8P998MFF2j3ueIK7WMomGbKz4sABAouIb4YMmRITUlJaaeammqq1q/ns88+4/LLv5/sKi+Bbt260a1bN1579VU2VK1HCEFRUTGDygbLaFPTxkQ83mTjkDF154Lhw5B/c3s4uHY/XYZ1O2QO0KN+tTzlpYfEy++fLxv/fDVFd89A3PdgWnpVLKYRwWWXaYWepaVQUCApLNQGyugYavRjcilaTfVkeT83ylp2sYsbmM5PJo/JDEgm0bsUslSD5QwwacXAmi60aNEidu3aRXet/CklonTG1rMnzJihfUCDsHv5Ze35duzQWspOm5biFkq+OoCUcuOQocN2HaejTrW0RJk//2lefuklWqJRLv/BD5g69Qq8Ph+vv/oqf352AS0tLUgpGTlqND179myor63+z8M/vrkpG6mpKpQPBlVxs2atQpfSfYfk5vJ7EyiL3yP44T/kPtkZVa2Hl17U3oKJAIyi0wkTBCedpKXM9e8v6NxZax3r92sfr1cjEKFHnk8Rp/AhH/I5n3M3d+lzSU1CBmhfmohMwnuQr8cP24jl/v37qaqqYvjw4UkCsOoP1m0jR8IDD8D27dq2557Toup5u4K3H6ghAcWtzc2zN1StL5sw4TSq1q1j+/ZtVB+s5g+PPMI77/6LweXlSCn59YO/oGr9eqItUZCS3n368N3zL5AtkcYvG+tqFj7w3HPyyiuucKT2eFyTlT17Czbv8tHc7DokDtCpU6OMFJYzPfErTuHvlAAMKodu3ewT5bJ2bLFWCGnrxaKYYopNM1FBkjIh0z194pCideZ2NgcOHGDt2rWcdtpp+Hy+vPQHq0J5+unaR0+HzE4AG3cfIJaQxcRa71ry2aez5z85z3/smDH8YOpUXnzhebZt20a0OUpl5UpWrlxhubmkV58+XDntOrp367p9a9W6pw7s3rWuW68+jgkhGqvVhuf4ibD4xQSRlkKCvlYiLd62+QH2loiZr50vB3x/j3gw9jdJ56nIWbeAz4dIJMDlsvb/cwxPZOTl6fLOsP0FIm2A2zO9y8z+t2zZQiwWY/DgwXnfx44gzNscCeDrbbuJJRLFxGN3LQt/NvuZJ+f59+zezb69exFCMPWqq1n88cd8+WUldbV1JBJxQOJyuSkqLmbk6NF897wL1K5duuzYvnnjvPra6te69uytXjttWtaooKJ5bcXxy1+SLzwTwLX0EVny84tFPHQ9rfHcKktpUbWs3+sR11znkceG/Dz4807Q/GehBoqkokX2hHS5jARAkc0LmK0XgYY6JTJmdz7nt5X9G3mD69atY/jw4XTr1u2wwsk5o4GVm3YQU9Vi4om7li/5bPZzTz3p37tnDy5FIZFI8O4//0m0Ocr1M2bJfXv3sH7dOlFTW4OqSkpKSxlUNlh27dq1obGhfuWWqrVP11VXv+7xehun/ehHTtHAFJyrAnJlpRz426tR5GM8t6qUK372Dok3Z9Krx265e28vR5HgdbdQs76Vq28ulCdP9nLv3QA+EgGfVFLxe7v2bba5APlmAmULCFnPb4vHzkxE+/fvZ926dYwcOfKwCCBnOHj5+i0IIbzxWPwnyz8Pz3lh/p98+/buQVGUZGy8Z69enDpxIrFY606vx/2vUydMKFGlLEskEt5YLNbYWF+/afumDZ/W1VR/UFt9oMofCCauu/76nPkAyZq+1lZBfVTezQP8nDsIr+nP4J81UD4wII4btZ8+Fd3o1XMnu/do4iTYtE+WyK1s2tNLTLuzJ2ed7+bWW4zwqcClSCHT3D/2haTmAbNzDbelj7ETi25rToBZAVy7di2XXHJJBvhWuxKA/mCnbN64YfqLzz3j27NnNy79hqqaoEfPXky7YQaDBw/etWHtV/N279zxaPXBg7F+AwYWCiGK6utq69VEorm5qSnicrvU2++6J3eQ25KvJ04YK+UdD1Dx0L280venfHXTiywMFMlln8B/vozjej5C/15F4vTvNHPatj+jPHkPa1xnMV38kcumupk1I5VNpJv70g5V3WnAnAbOuk86RASz5QS0lf17dW9RVVUVJSUl9OvXr131DLd19jc2NlBcUjpp5fJlXXbt3JGc+aqq0qNnT66+7gYGlZXt2rj268cP7NvzaLCgsO7Gm/4bIGLx8LVJNCVnh5RIxYW48w7k+edDQQEjhpTLEQBTYdt2N5+F3Xz1NfL5v8R45JW+9GyeySb6cHXfn8urL5kCHGPUcCaRRPPN5JFtTPNqS0bQoSiAAJFIhPXr1zNs2LB2Zf+2HOC040bxRdVWze+fSOByuZCqSveevbhy2vWUDSrbtWX92scP7t/3qNfnr/uRvVxvk6WT9vKEQKiqBnhcMQYJUk1oCOCKC/r3g/79tIDMgS1R1v37Kb5sjsqprBEniTpovAK1h4aPoKNtZZRnZ1Ps8gkPZ9MP7Gb/oRCFYf65XK6k/D/99NPp3LlzuxJAhjD5omorHo/ni2PHjm0uKx9CSWknRo6p4OrrZ8hBgwbt2r6p6vHqA/se9fp87TH4tl4vacbYk1IIBdwejZ3rmwDoOrCIU+4cw/TuC8VJJdvhv+9ADi5Py92zNo7Kxj6dMnut27Mdm/W52sC2zcfv2bOHTZs2MXToUNp7SeMAxx8zkOXrt6Cq6ptDh48Yc+NPbruuOdJcUFhUGCUer9q1qeqZhtqaBV6vr25a+w2+POSZJgRi5t0w+SIQLuSw4clsXVMDBZmNTVutgHxmdVvYej7tW5zOM+T/unXr6N+/P7169Wp3P4MtSNQ7H37c4HK57iMW+49XyOF1e3ZVNzXUL29uavjS5XK3TGvnmY+laZLNC8tM4dYjiFIIKYaPSm6TKTSGtP47+bxwC7hjTtluR6B2PoBDKQxRVRVFUaitraWqqoqhQ4e2u/x3tALOnnw6QKOU8o0LJ5385p6DNbIoGOD9z1dwBJY0MxBz/7fMhsrpufraBmFp3pdGMNaef1haq9nZ3HZ2vJ0Caef9c3IA2YFB52v/G+bfkcBRcOeh0R7RslUzfKm1t531tx0bFelptGZAaKf/n3QEKYqClFI0NjZSWFhoy33ssnpzOXby3ea03UxAO3fuZO/evQwZMqS933s6xOzRWg4ePKgWFBS0l1zLGyBCURSi0Sher1dEIhHa8T/kvUQiEZqbm+nevbttjWIb8QEcHVZOFs2BAwc6RnWw5eGd8HXyUiSziBhpkbFCVVVpIIWZ/0M2OZ5L2XMaNDu9QlVVAoFAMmye49nafbJ6PJ6jTwA+n8+KDyAO4YFFHsTiCPRwtDCCVFXF7XYb93cqa882OfKdGI6QMUe9OljV+qqkkJTtF7v92JxHnufqYQ1V6vdv031tfud9X/Ofz2jjki0mbfm9e+dHTL/+dJ7+03Ti0T3G/rTmFJZzbauijzoBGNq4MC2YeviYGj0ll/r6evHss8+yfv36JLy79ToWZUeYjxPmThumTh1CNw6SRxt1Aan/ad5v/k7tNxo2pVq/GTcUlmc0Wz55xQ2MfStXPCFGHTtZnDB2Oe++8zTdevUmFtnJoYiKjoAPYHq+NDh1aWlwkNyeSCTkp59+yubNm221ezsrwmHWpdYNPHopkatWSbl3n9QSApPmpbldncy8hNbpSisjEFIoCnLbNsTatYY/U0pVlTazPtmAykz45voF877mhg1MmjydqtUlXHbZd5n/1Hc48wwPV117odD0qUSSsCytYtLW8zIDnZYjhA+Q6haeQrqSVsQrIQSBQIBgMEhLS4uZeoRl3eoHsGunnjpHUQRNTXDnnZLnnhMMHQq//x2MD2GqCpApa9NMnDYA5G+9Cf9zJxzYj7jpJsHtt5NMd3KQ6zazX6TTLfzilz8WP77Rj8d/hn6EnyceH0PZ0GXUVX8pizuNNjNXaXVBW5+9zZrlmm27AQICzqmryw8fAHDEB2hoaFALCwvbBPUmpeTmm28W48eP53vf+55V2ZF5moYiouV+EwwGtWP++U+tNau+VI26SDx/3esy2KAmK5adlTCN6lQhcHlhyu/Giz47lmjHBQKweDEcf3za/RsaGqTb7bZ2L3f0PiZa9tGtVy+xeV1/XJ4TELj0SiWVp59+B8V1AXP++y/SyQVtdUI1NDR0CHyADHno4BwRZqeMy+WiqakpY5+D2efYFCptXW/9aWx0Bb2UlEBAg9tO8zHZQBYKJKgC3D5w+TwpzuNyaw2NshC21Z1s5WQANfVbmXy6G8U1VKtPJI4QPqRUuXJqKZO+8wGzZrQivB47b6gdB5B5E8DXW3fhdrn88UTif5Z9Hr7xuaf/5N21c0eGL9yMD7B1y6bCH149bUbF2OP9jbU1P1m0rLLutBPGtCmIYnW3JolAUYhEIqm3mDnAwsnf7+SOlaedhrjnLrY9sIAuJw+n7E+3c/MIhHOvRzMRWCytsnupnX4XkS376f3Lm5AVFcafyPU/M5pKGGLs3Xf+zKUXexGiQB/4Zv0KCi73MfTo8R+ise0i6BuMHfHbvaN2wAfwUTa4nP4DBiCBrVs2s2nDxrbgA2RkBNm4W7U3baLkWCBAtapaRYPI7IxlwM3kyMtTVa0A4P6f8ovPr+VH/9OF40cUJRtFW+JQ6fAhadxG/znpDPHZXcfJzz6M8sDMvsZI2MUrksWByQhmazNx2aSzHRcCL80te5hz01w2rukBwo0kYdLjEwhRwDVXeHniibu4ceaTmmgQcfT3Jlz+LmY1iDYpgS5FIRAMlh48cCANH6C0Uycu/+EUTps0mYLCQqSU1Nc38PHCD3j5L3+mtrY2iQ9w1Y+uv37ct87+t9vr+zKbJy9FpekcHNLH4cyvvsbd1CiZPh30bpmp8gvrtVPbDFBSl6XcQCpKsp/Q1sBAIj6Nn4GSBi6Vyz5PxaRU2VDYlV0BfQxUQEnDKEorFRKKIqv3L+e+B34ili6tYlCfelxuBbdwCTUh2F1Ty8O/DuLxjzMoVj85BjIOIsiZZw5i6lWv8dH7f6dLcQDcivC6BIuWxigv78WUH54pLr3wboS/NMlV8ywOdcYHuOCii1EUBVVKLYetq4/zL7oERXHxzJ+eIBqNJvEBevXofva3Thn/5fz58829A0Wqj1OyA6hIDby2kkgIWtGKWoO33MhZr/xVew3f+jZVj78vG4RHxBsEra3ISESK5mYho1FobkY0N0uamyESEbK+XopTTxVceKHWO8kgCAFSCkUA0icRippq/iTtZmxmbyGLIidwJZAe1aQz2Pd9kYBcs3q+OO30aTzy2yAP3N0NoejBH9kKuBHiGITSBYRXV/5UEO7UOuB2j+DPz/dFqjVAPDW8MkpT01Zm3jiXaT96mIN7d0hPsE/+OkA2fIC6mmpU3dRQVam1k0My7sTxLPpoIWtWfZnEB+jXt4+BD9Bo5ryKApWVsHy5lsUbjUJrKzIel8RigtZW7btJAV9thJufeBWjCb26eBFz79jN5oL+0hVBJOKSQEBQVKS1fNU+gqIiKXv0kAwcKCgr0/t7SWdGlK7oZQyytAsXp4sWYSfmbHhfHCmlGH3stVQuK2HgoG8DCgJXcpbrPES/qrBsT5i2KwhRhOIqTp0jW0F4KSo5hmfn72fWnE957Y3fiu//8GGQUrQLPoCiuJK4OVJqRJAvPoAxCOvWId9/H0pKJIoiZCAgkgPYqZOgoADpL4XSoiAFO06Hv70oAFxDh/GzP3XH3wP8Jr+KZRCk3bqqWs25DMeTMLp42mnrlnCx1flkrT2xAlWatDxtEPv29iDwACqSmE4EmAbYkPmqzvbdIHVLgISuiorkMQKBNsSqpkso3bn4Qi97DzS2TQfIjg+grWvYGSkQxXzxAVwa7YjLLtMqWPOCvD/hcdbeIOTeqvViwtNPydIe/uSxml5oH/8wT1AzkiwZkHHOk9ZiU+eAh890SVgISIKCUNzy2qtPFo8/uYI5s+pAFOqsPaF9yxhCeEyyX0mxf62eyvS0CYttq11HkiAeq+LaG5pY+cUlyQSaw8YH+O7ZZ2vAw6pKXFWTXUWj0ZZ88QHSXrwG0mB0iJfN95oAAB5uSURBVLEqVhqJuYpL+WrqFBYvXMj4Y8fgR4Nl0Zo2mZVIwwNqFycXOYJnIk3852oCnSkK7Ac/k6I05WfuH56XvfqVi9EjFzNx0qkIUayBColM/4FUo1qKtJQa91Bc5p3Jc8yEoya2cMllX3HxRWPpN+DMtsUCLPgACEESH6Bnjx707tObnr160bNHT3r17Em3bt1YtnRJvvgAae3TXS6JxyOFx4PQwBUEbrfErflShMulHRf0eEQsFqOlrs5gO0bEJWlxmaxIYTJ/bINBOrsXKW9fqt26qemTGcg6479brmXeZe4hLGxC3sJXMIitmyrlldOauGHGhyQSGyFZbewxEVpMO01NmMY8pm+3vlk3Eklr80LKh33BqNEn8sQTS8zvXRw+PsDLL3PwwEFisRixeIyD1dW88dprbcEHyAhjGu3OLaxWx2zS1gv9fkksJltaWqRJBkuTsYvJj25un54WcHIIo5p+Jwc9rR+waZv5+vo5UmbqHcnmU9b7JWMcxZ1Gi/279sqSkvGUDf2C+tqPdSuAtBktFI8+63VOqXgyZrxEItW9vPiXtzlmdA3/fu9x/vDIJ1JxKbQpGJQLH+CRuY/w7r/eZeCgQaiqZNOmTW3FB0gLAlmTHsxuS/P+YDCIqqpGQEiaHUEWrVzYNI10culZ9YaMbGWLs8naadzSt8dwItm3jbPzVLr8XXl83sfMmvUMx54wjbWV/8EfnABCQQiPPtMNH0Acofj0e3uQsiVlGcg4v/jlEl5/08f2zSsIFh+DlGrGbdsJH6CSlStXHio+gLTx30sH6PbkzAsGgyIej6dFBJ0ydh0qc2yUQKtbN7Ut27WkbdVxRvKOtByHZWfa848cfY14680aPv7kPs4606MpcmnKIMkBT4kG8/uvYd36BGsqV0t3oI/+1zMZfkfABxAWv3WGa9gufFtQUEAikUh2/rJTyKyzNlv/P+2+aQxIWInB+n+y+PSlDQi6UzcTiU0jC0CWlnYS69fKpHKnDb6S8gDqapwRExAikIoP6I5HUv9T2pkmHQEfID2obsqWsYuNG7sNAtA5gLDLC7AMnHCKiWc6+NO9tGQGo4RjBo/mYxKpqKHZkpc58x3NnOaKK29n/jy/7tdXtFkulDT/gEEI5sEXIgDECQQFO3cvZ2BZH8eX3hHwAewyg4TFeZIR0QoEAmYCsOsHJC2t08y/pY2rTmpeFCEbvRAvIOX2E8JcdSTSnYEmEWUUt+qXbw0iI/40P45tTYrluSVAY+1XYsvW/QwYeLx+sguEJ80LmO4KVpOxPUkMRJA5Mwq55po54oOF5zlGGjsUPoBFmbLO4DRlTO+1JwwrwHqs1UNnc21pYS9ak4LKZcz6/HnK3hgtqZhmHlDTNdM8jpZIpr5JjYiKN+bRZeke2DJNioHHIBOqZufaxxaEmWC/XP0uM6/34fIMMEX+EklPYUoUyKQxZ3YeARwzZCArKlfQ2rQNX+EAbIivw+AD5IzZp+UcaHVzIh6PE41GBZn9fa3No6XdPazeLrFmDfLCy7ho+2Z4ABrVg2LXnNukUistCVTCzochjfEUxdD79lsZPv8xhgPyB/9BvPYq9OqVx/MnpKK4xV/+8g9mT/dZ2H0iqeHHWleye081hQWC0k6DUVxlGlgVrqQr2OUZwOTTV7H34Ff0LxxgtlKcOcDRxAfIRRSGsmYUTkopk1aAU22fHWE5moFr1sCWzck9a//wLvfvuo3iiFFzljWlDwEkBMKtIO958QOOMQ757FNYvx7Zq5dj04qUYqlt+yy8hjtuFclZrg2uB1XdxUsvLeP2e5r57W+m8/bbn/DRx1+wfvVm3L5J6UEkoXDZpV4aGnabC2Wz6wBmfIBVlSsCtTU19OnXj3MvvEQOGjhg9/ZNVY/XHCF8AKfBM/vOzdsDgUCGFeDUoSNX5w4AKioQ/fvDtm0AjLjtPB6/EZRaskBxi8zsriLoVngmzFur7TnpJBgxIiulp3QJrWdSaWkBdXUtFJWYchnia5hy1Vr+/UGMg/vWU1A8hKuugaVLHqV85Bz++uf3GDduPIrSORlp/OTTOMeN8zq3q7FTAl0uV1FLS/Teg/v3peEDHNi1/ZmG2poFbo+n3fABsiWFWvPXjO3xeBy32820adPE+PHjpYkQ29Q82kgpCwaDWmhQURDLliHfeguGHIO4/DJwe60BPGGx9e2dSHW1Qv7lJSkO7NeiXEOHavcwuZOtSaHmZ37nn3eIX/3yN7zxShmKEiAc3sIPrqrn6isn8ZsH35Z4fWlc8eD+pZQNHi++NdnDk48V4fMPY9fOjZw0cR87t62XwaJyKwFo97e+lKOAD2DXCFo42MZpG3r37o1ba6PR5trADBGgaFBinHAC4oQTkrFhmZBZWrdbTVbDAahKUVKKmH6DOeVMu0ee5V9nfeenvPrqewwdtZJYXHLqKcP4avU/6N7zFLNek4xJdO1+InUHG/n3wocYd8pDDB+2lCXLJEs+f45gUbmweCozHsBR9l446WRxJPEB9Pbxba7M1XvvCimlNLVdzZsDCCHSOIAZdwBrsoIz4WS/pxmn1eb+DQ0N6BwgI4PXmN0tTVulIlx4gn3NQSlpp0MYJrAajcrW+B7hdZdKxZT+ZVGKRc608G8IH8AK1Jh3dbA+8CLn7M6M9cocfnwjvgi5aw6yKbLSYjdmpJGZMP9sZ6mvYAA2cYeszi7F7xd+BtqdZ73X0a8ObmlpSWr0OWZae4iaNKAJw4KwAXBq71Js2wGLRqMYHMymRD5bskJb3ot0mtyxWOzoE4ABh+bQx0dYw6Z56hFOg5i2z1Amo9GowYYzvI6kg0g5XtsBH8AKQJVxXiwWEzlwhWWWZzysJR6PH30CCAaDR7U+3uPx/J/GB+gICCHSQVOXNnHZtrA6p3PTXooJnyAfhY8s+km+NYlJwSzNOeRH6fnzIYBsD3LYcvoIyN62/qcUm9Zy1FMv3mgnYmhnmX4JkRGtNNvzmhtdiFSUEJsIp9VNLewUO6tYsoGdsS0ns4igDMXenecMLQSuATrpfsYosADY314KkjVQYZGp1n3CJiff/KJEjhdgz4GU9HQp6+9ctYc23kszUkVezy+E4MNlq9qVxU46fpTV0dRmfIA+wCmAkaDmAha2EwG0qT7ecqwZREFmQv/lro83z7AMe10cJkOS0vFadmavmWgnHT8qK1BVPqDWHy5bxeQTRie/LRxATyi3lxvDgV8Ac4HfAzOBbcAOYKf+PVXfNxf4NTD2MNi4dMDWk0IIKisrzTNZVlZWGrNFVlZWgj2OYFpamU0swJqImuwKLhRF+5g6PYmMfsHC1CPRdP0URWnbjGtBxrGm/y1z4QWazVUnvGJhwlg275t0/KgkV5HpTTMzXMESKAdeB/oD1SZ5ZwWyU0yDHQQuAC4HvjhUXcDMqufOnZv2RhYtWuT427pv9uzZkjzr483yXhoNdVatgu49ED176LPYPBPNRcopdUPKNM8PQhHIrVsRkQhy2DDMOoVwQDS1C4DlgxOYT0cSgxOYxIFjbWA5sAR4pw2zWQJdgX6HQAC28dU5c+YAsHLlSsaMGSMrKytFhV5jr2/LxgIzlTOH+vjkuVpfdrjzTq23mg4RI1IQMTaOPSxOQ9OkfutN5G06RMx/3wS3364Fm/JwElkHvud5/dLt99YY0UgUNZE+J/1FATxuD1qNK7x43zssXL462zt3FHKDgSv1WR/XZT4mLmCIjoS+z4MGBbOMtkfkZCAQMFO1BMQjjzySNwXNnj3bzgmTZvKYsIeTOlBDQwMul0sGg0ENePqddxDnnpu8xoZRF/H8da8RbJBmiBjHOZCCiJFM+V2I3ju0IgwRCCAXL0aMHZv2yvVooLA8v3WmphGAGosTbW4hHotn/AO3x43b7cbt9aC4tSHa8/ftyf0Ll69O6hbG87sdTKgyXesHrebSaFFdoA94nf5dDBiJ6msPhQBMfvk0W3XOnDnCmO0VFRVSXxcAFRUV0rTuqInb3CObSxLhdmM25TSIGEFAsdZ4OFiCSYgYgcvnSZmEBkSMEHbEKZ0CPBkPEUsQi7YyLuJhpwvqhEqrkMT0rMBELK57VcGreDTdw0GU5LICJNAMrACeAW4DegGPAnuBW4ED+vbTgXN1QjjU4JGdHJSPPPKIyEP+J7cbYsPhYa0KV8YIOkDEcIQgYoRFGc0q76WUqM2tjIm4+K+mQronXHjJBHu+t+QgG9QWVL9byw1SVTsdQZIHRlAA2KrrArfqs3+xbgX8GqgBXtXlfvHh+gLMdp5hDhmsvbKykjFjxqReoKJoekBFRfKFZuvIYfIlSAvwUnoPWZ8P7n+An+sQMSeMKDIpfWYl1fzb2icArXpt0hl8etdxfPZhlJ/O7KPXCMm8nt9OD4i1xOgdhf9qKuLqj8O8f+qpGRcZ/fBvmX7vHdwkt6A2RfEGfLlMxaz4AFLnEB6d3UvAp2v8xlKgb2uXoJD1t1kPMM90u22zZ8/OpxrI0RGUhIgRCtv8A2n2GiqPgtDhGXKheqb/Vmks6Mpuw80vZRIiJtvz2xFxS3MLrc0tjGstZOZXG9n28suUjBxJ3Zo1acftfOllrl32JTUjB/FYcR2NQZGzgWW+rmDzeluCEW0SAZaXKXUOIAwuADBmzBiNIxx7bEqPtW/3Ji3mn1EXIO1Kw7QUJE1x8kpQpESvrZGk4+pbs5AddB4hXKqUHunooxY4VOtYRUBLRMt7vDRSyNuWvkH9v/c9+n/ve3xy8cVUL1nC20OHMhwvMami1kWyYQ/KjhIMyurN0n0CGbN+0aJFSZlvEEK27h75ZRwdBXyAHEqxQWSvHLRPKe9z7rl4S0o46fnnWT93LgeXLGHE7bez46qr6P2t3pirrEl1S+lQ0cA0GWiNw5vZu2H/GzqB8UKN35WVlUmrwAYyLq2yx557mRUkaeUkaZq6pcRHOMekhDkmYW1bZ87ty6hCNu4/RPj5uCTOr5dszOAAn02dyugHHmDVPakCnJIRIwCobW60tf3Nf6xDNIwwU7q5tt/4duIAdvrAokWLMvQBm4COsLFARHpRaPpfM8CXrcEnex0jaRmk2YjW05ye3yoC9nX185zayqDRQ5i+riqDCIzBly4X8aIgH9x9G7O9GyjuUpIxmazP7+5o7N9M/cbv2Tqrr1y5kooxY5JvLs06cBAlefb5tTBtmW7S5QHhnhYAchABguyhb+tgGb/HTKjg4O6DvD42yN8eOp/my/vj8Xp4/45/AtAUbeLb93+XokAAL4KC2hbKC4ZQWFKYcR+riO0wCSHW+ngzYrjhD8g2883LnDlzpMUFnCulTLPS9MnR6IF4QWqPNMCubPoGZy0ODUDEl0Kck+l+gDQuILMhUwFdenUh3hqnubGZbRu2pe0r8BewZ/seIkXFqEKlW+9uFPq9Tt7RNlsB3wgR2JlnutwX+oCycuVKUVFRkeYdzOea2erjTRqa9u6/XMbMJc8z6I3RmItDk1XfOUOzyeJQxrw5j85acSgMGAKqagWNzsAHsCqb5t97d+ylqVFD2Jk/64m0B5g/6wmueVSrwI61xnC5XXTv293JCsgrIcRAJIyZYgBx/bfxtK16PKDdxYDuBxBOnj9jm0Ec+VoV2XQQ+VVGcSi75tyGVhyaRXe0ZHQ5FYeKnj0P6V0Yl25tadXQ0IBJoYlpx04KTdT8tEBLtIVAQQC3223rZ8hHBBiOnyLd0xfQB7+nvs8Y9EFAF51AXIejBGKpj5dSitNOO40xY8bY+V3NrFPk4WIWuWICEmDNGti6RfctGMWht5qKQzMkF5nFoQK3IrnnxQ8YYjxa+DOtOLRnz2xo4dKaDpZGAAK69u5Kzb4aopEoC8MfpRHBwvBHAPj8Prr36Y7L7cLldjlNgpxK4AF9UCcAr+mh3hhwC+AFGoES4HmdAKJouQOH6QxM1ccbmr8x03XNXlgGNJeCJyx5BsLBE6gBQFRUIPr1Q6YVhwoTB3CyqtK4ObJIpBeHhk5C6qaZEI4QssKuE6l5KSopQhEK1fuquebR6xn/8bjkvs9XLQWg96DeWs9hkdf7we3gCVkO/BE4Q3cFf63v8+uh4G36dwANF+Bz4L3DCAZZZXdaPoAR/TPJf6vy6MRCpaWBVBbMXglDhiBffRX04tDA5ZfR1607vI3af5HqXm7EA2zxH395H3L0UMSB/cjLLkN07Wptap3TNW4827u3vJVUMhWz48v03+3Sx4xik2xiMNc/6arP+GyDquoRwkNazPkA5j+ZKx/AsPXtNPJ8dYG0fAA9IGRo/MYLVuMyYzbZlRGaJ7RUVRS3kkSr1Ck1IyHEVBuYZrYuXL46mcOXi9Pl0nHM+43cwLT755DNB74xb1A6EreYPXu24dmTUkrMGUHZAilOLDZbpxAryzUDX+sI8qTwhmWGA8GagyIUjQjMxaHS/I0zfoHTtrY0n26L+ztXNPCb8gNkmClOFkCa/98S6LFLHccGPsYuGCO0EvE0Nu0E/269lP14iFRyidFNMLM2QDpx5fZODbdwBDMW3tFdDBHgJLezsLQ0HcCBPVqvlaYDWESAtAyQEz5AlmioCR/ApQhzQMHABzCbDmYRYGcG59uDOF8RcNhdw46kJxBL9MWJCKyODDv4dkvun13dfUbZlV0+hpZ8kpUZ2pSyS2O2S2nGBxBCmnDorehltiFlM9yd6Rkd8QFsnt/OwdSxgkGKolgjL041cVmrY9OaIdrwbjs72NJytkPiA6QbMaLdn/+oE0Bra+tRrY+PxWLi/zQ+wEcffWTdNx64CpgIDANagM3AR2j1gJ+355spLi52hqxfaPg523bNcDhcGAqFGvM59uDBg1LHJ8inbX1bW9uLbL+llNmf/xtYrBzgj8ANlm0+nRCG6fvmAdOP+D9baFmflPfg34qWxNo1n+OPNj7BURfBpvX9psFfqnMBAXTT15fq+24gR1Go3+8f5/f7F/j9fun3+/fr6+MOUUGUbGnTObOBLuFweE04HP5BOBx25zlI2dbzMYvtGk9Y9+Gw/6gTwB/1GRNHKwj5HK3wU+qD/Xt92zX6MV31c6wD7/b7/fPRSsuuNHkTrwSW+P3++X6/392GwT8Un8RcXWyNAB4GLguHw53zdZa0Fa3sELyrdDQOMN40868DZgCzgFLTcaX6thn6MQYnGG+53pPA1Vnud7V+zJFcHgXuRatb6AE8DZwUDoeLsw2YrgMk+wlJKYUlQ0lYj7UEbszbDMVSmM+1XqejEMBVJrY/Fjghy/En6McY4uAqM9vPMfhJIjhEcZDXEgqFIsBjOidoQgtgvYZWwZSN00jzYvEfWHZhXjE7EjJ6H5nPJb1fUYchgIn6+mPAlDzOmaIfi+lc0DAE8l1mZih82kcmP+ZloGnfM0iesSiJmUTQGAqF7gXeMCmyj4XD4VuciCAbPoFdZpGBT2CV6YeAT3DUCWCQvv62he07LaX6sZjOBTinDfc9x0bbz+9lDARqkKzITgT6cqVpvS/ws3A4fF42l6k1nmADyJBMWDWzfvM2u+ROmzi/6Cgc4H/X0gaLIBQKqUCt6YXHbYjc2vPPcKYJC0GYtwnrMZZttttJ71nYIYhA0Z08xqyszeOcWtMM3mza/nYb7ps6dlJyYAVb9AHeYjPoK/RPjf7ijsvtGwiHw/9GT+dAC23fFQqFns9lEdhBrZgUAay4RU4QLfpHpt9Cdqj55NY9fMN0ufyCru1nW14wyXCzG/ExC8vNtjyW9muSjQll1gNqgB+3bbaEw+FJwLf1ny3AglAo9Hsn544Vn8AmGOVoluYB0ZIbn+AocoAF+vo4NHiXZVmOX6YfY2jxxrlEo9GlaFgCuZZn9GOP2BIOh09DQywBLZcxGAqFfpLL52BXXJr20bYm15Mfi6Vge26Ke1idQkedAD5Hc+8advzjui1da2H7j+r7DDt+HplxgetyEMEzJj9CfrJ+yyE911/QMAvqgGt1XYAsrD9po2/cuFF8/vnnorW11bYvsKlaNE2Y29j7ACKRSAgd1j6pA3QkRdBQAqfrMtINzNcdPDeZXME36dvm68ccwCYeEI1G49Fo9BrgROBZk+x9FjgxGo1eE41G43l71MwyP//Zf0B3AFUDD2WT+Wa2bcjwVatW8d5779HS0pIJA2eyFMzyPgMqzpSQ6XZruD2KDtfSlpSub0oHMJZupIJB43T2vsDmnJzBIJ3FX2V2FLV50cw97U0d16YzF+h6zFWhUOjv+ZxgNKEC8Hq9yY+xxGIxPB5PcuDi8Tgulyuti5kB/Gxse+qpp3jzzTcZPXo0xx13HCeeeCKDBw+2KwvrMARgcIIFfIPhYMdlEocUDg6FQreg1S/kvfztb3/j/PPPx+Vy0draSiKRoLm5GZ/PR1VVFa+88grnnXceo0ePpqGhgfnz51NWVsZ552kuhddee40DBw5w5ZVXEgwG2bFjB/PmzWPlypW8++67eDweysrKGDx4MGeffTaXX345Xbp06RAcIIMXTXgwnDUfYPHtoTQCsMknaNMyceLEI/qA4XDYGwqFWp32RyIR9cwzzxRDhw7F4/GwdetW6uvrKS8vp6CggD179rBmzRqGDh1Kv379aGhoYMWKFXTq1Inhw4cjpWT16tVEIhHGjBlDQUEBe/fu5cMPP6S6ujojH09Kic/no0uXLqxdu5bi4mLRYTjAhAfDOfMBJjwYnrf49tB0/vcsfw+Hw78JhULvO02C448/nsmTJxMIBPjkk0/YuXMnZ5xxBt27d+frr78mFosxceJEKioq2LdvHy0tLfTt25dvf1uzMn0+HzU1NZx77rl06tSJqqoqVqxYQXV1dZplUVBQwMiRI+nUqRMDBgzoWDrAhAfD+9GTKEZFlyz1N+187HcP/erZGTNmdPUFi86JFvSZudp/4jidCC5dfHuom6Oj4IUXxum+git1JfBt4LEpU6Ys/SYeKhwOK0CFbnF8R7cGnAiAmTNnUl5eDkAikWDVqlVccskluFwuTjzxREaPHs3o0aMpKSnR1JOBA+natStlZWWaP3zQIBobGxk7VoNLnjx5Mn//+9/ZuHEjffv2ZcKECfTr14+TTz6ZCy64IHnfhoaGjiECjJlfotbGy6s/vK61uXEsWtCn1GQGvuANFH6xofPkJ+uUUjcwb/HtoelmEfDCCy+4yR4Sfga4bsqUKfEjJQLC4XAADez6PuAsoAq40YkDRCIRNRAICEMRfOutt1izZg2zZs2iqKjIUVm0eg6Nxei2unr1alasWMGwYcOoqKjA4/Fk3LuhoeHoiwBd5t8AoA/+DDJDwqXArNbmxmXl1R9et7zrxfN1TrAAomadIJ98AEihkLb34Pt0++FZYBTwIfBL4ONcVoAxiIWFhXTq1Ck50FLK5MAbza2M45VkU201SQgul4t4PM6oUaMYNSoF99ra2oqiKLhcLpkLtOGb9gNcZbB9feZnzQdobW4cOyq6JCMfQGf7eeUD6MceiWUw8Io++EuB3wEfh0KhWNaXoCjSCO1OmjRJXn/99bKgoMAAbpD6oCUdfy6XSypakYcEpKIo0nwNt9ttchJqnj+v1yvdbrfMq4XtN6wDTATwN+18rEVL/cq1TPE37bwJPws4vHyADB/Bp8cdl3NabIpGmfL118Jm9n9Ll/kj9Zf/VCgU+kcbLKEMfAITvIxxXBqiF3kmheaDT3A0OcAggJZIQ975APqx0B75AG0YfIAyv5+55eXSMvgjgD8AZ5te9J/aqg+ZiiuEBa4uWXBhPsbsSXT4JK+Vqj/pWAGhDgcUmQ8HsFmCaODWRWjl6otCodChCllp6WZqncW2tYm2F2oLPsFR5ACbAXzBorzzAfRjoT3yAfTl5BUrxKZoFPNneUNDxqcmFmP2hg3C4v1bBvwE+Jf+TH3C4fCdbRr1lEZvhWnDzBFMn7Syc2nfHzgD8q2jTahkPkC0oM9MEVmbVz5AtKBP++YDGMqFjWxvgwv4o3A43AUt9WskcHc4HH4pFAptzJP/J2ctmd3GMmS3XTOnw8EnOJocYAHAav+J47yBwpz5AN5A4Re6QwhMwSLdyZNXPsCRcgiFQqHXgNHARjRomwXhcHhQHopa8mNO9jRi+JYEUOs5yRi/2VJIR7/PyBjuOPkAum9/HsCGzpOf9AYKHfMBvIHCxzd0npzMB7DGBWjPfIBDJwIJfB/4D1oc8Td5WAHmWL5J3xPCgt0rLI0bhUVRFHZKpFkZJLP7xNH3BLbRFQxwwHAF2wWD2uIKPlLBoHA4fBZaVLAcWB8Khb6TzROIPY6AbX0+NrWBTvX5DjpGEiDiaHsC027uEAyyLmnBoI4cDdTNw78C94VCoVftjolGo9Ln89nKbQubPqR+iNnOa2xspKioqOMQgE4E/1+Fg3Mt9fX1aiAQsNbn53pnh19AKASNjY107tz5qKbm/z9HqDOp/DmCKgAAAABJRU5ErkJggg==);"};
        /** CSS needed by editor, given in string format **/
        var editorCSS = '.ebookjessiebox {'
                        +'    width: 100%;'
                        +'    height: 500px;'
                        +'    border-bottom: 1px solid black;'
                        +'    background-color: #fff;'
                        +'}'
                        +'.ebookjessiebox .nogeocaption {'
                        +'    border-bottom: none !important;'
                        +'    border-radius: 0 !important;'
                        +'}'
                        +'.geoItemCaption {'
                        +'    width: 12em;'
                        +'    height: 25px;'
                        +'    margin: 1px;'
                        +'    text-align: right;'
                        +'    padding-right: 4px;'
                        +'    padding-top: 4px;'
                        +'    display: inline-block;'
                        +'    background-color: #f8f8f8;'
                        +'    color: #444;'
                        +'    border: solid 1px gray;'
                        +'    vertical-align: top;'
                        +'    border-radius: 2px;'
                        +'}'
                        +'.geoProperty {'
                        +'    min-width: 10em;'
                        +'    min-height: 25px;'
                        +'    margin: 1px;'
                        +'    text-align: left;'
                        +'    padding-right: 4px;'
                        +'    padding-left: 4px;'
                        +'    padding-top: 4px;'
                        +'    display: inline-block;'
                        +'    background-color: #fff;'
                        +'    border: solid 1px gray;'
                        +'    vertical-align: top;'
                        +'    border-radius: 2px;'
                        +'    min-height: 25px;'
                        +'}'
                        +'.geoProperty .mathquill-rendered-math {'
                        +'    width: 100%;'
                        +'    height: 100%;'
                        +'    border: none;'
                        +'    margin-right: 10px;'
                        +'}'
                        +'  .geoProperty .mathquill-editable.hasCursor, .geoProperty .mathquill-editable .hasCursor {'
                        +'    -webkit-box-shadow: none;'
                        +'    -moz-box-shadow: none;'
                        +'    box-shadow: none;'
                        +'  }'
                        +'.geoProperty input {'
                        +'    width: 100%;'
                        +'    height: 100%;'
                        +'    border: none;'
                        +'    margin-left: 0px;'
                        +'    margin-top: -4px;'
                        +'}'
                        +'.geoProperty input[type="checkbox"] {'
                        //+'    width: 100%;'
                        +'    height: 100%;'
                        +'    border: none;'
                        +'    margin-top: 4px;'
                        +'    min-height: 15px;'
                        +'    text-align: left;'
                        +'    display: block;'
                        +'}'
                        +'.nogeocaption {'
                        +'    border-bottom: none !important;'
                        +'    border-radius: 0 !important;'
                        +'}'
                        +'.ebookjessiebox svg {'
                        +'    width: 100%;'
                        +'    height: 100%;'
                        +'    cursor: crosshair;'
                        +'}'
                        +'.invisible {'
                        +'    display: none;'
                        +'}'
                        +'.centered {'
                        +'    text-align: center;'
                        +'}'
                        +'.geocaption {'
                        +'    display: block;'
                        +'    font-style: italic;'
                        +'    padding: 0.5em 0.8em;'
                        +'    text-align: center;'
                        +'    min-height: 20px;'
                        +'    background-color: #eee;'
                        +'    border-radius: 0 0 0.5em 0.5em;'
                        +'}'
                        +'ul.jessiebuttons {'
                        +'    margin: 0;'
                        +'    padding: 0;'
                        +'    background-color: #fefefe;'
                        +'    vertical-align:text-top;'
                        +'}'
                        +'ul.jessiebuttons li.jessiebutton.smallBall {'
                        +'  width: 16px;'
                        +'  height: 16px;'
                        +'  margin: 10px 5px 5px 0;'
                        +'  padding: 0;'
                        +'  background-color: inherit;'
                        +'  border: none;'
                        +'  border-radius: 0;'
                        +'  background-position: -16px -224px;'
                        +'}'
                        +'ul.jessiebuttons li.jessiebutton.currentjessiebutton.smallBall {'
                        +'  width: 16px;'
                        +'  height: 16px;'
                        +'  background-color: inherit;'
                        +'  margin: 10px 5px 5px 0;'
                        +'  padding: 0;'
                        +'  border-radius: 0;'
                        +'  background-position: -0px -240px;'
                        +'}'
                        +'ul.jessiebuttons li.jessiebutton {'
                        +'  display: inline-block;'
                        +'  margin: 0px;'
                        +'  margin-right: -1px;'
                        +'  margin-top: -1px;'
                        //+'    top:-100px;'
                        +'  padding: 0.5em;'
                        +'  padding-top: 0.17em;'
                        +'  padding-bottom: 0.9em;'
                        +'  background-color: #efefef;'
                        +'  color: black;'
                        +'  border: 1px solid black;'
                        +'  border-top: none;'
                        +'  height: 0.5em;'
                        +'  border-radius: 0 0 2px 2px;'
                        +'  cursor: pointer;'
                        +'  text-align: left;'
                        +'  vertical-align:text-top;'
                        +'}'
                        +'ul.jessiebuttons li.jessiebutton.currentjessiebutton {'
                        +'  background-color: white;'
                        +'  padding-bottom: 10px;'
                        +'  padding-left:0.8em;'
                        +'  padding-right:0.8em;'
                        +'  padding-bottom:1.2em;'
                        +'}'
                        +'.disabled {'
                        +'  color: #ccc !important;'
                        +'  background-color: #ddd !important;'
                        +'}'
                        +'.previewBox {'
                        +'    position: relative;'
                        +'    border: 1px solid black;'
                        +'    border-radius: 0 0 0.5em 0.5em;'
                        +'}'
                        +'.addTab {'
                        +'  background-color: #2e2;'
                        +'}'
                        +'.typeInfoBlock {'
                        +'  display: none;'
                        +'}'
                        +'.dataBox {'
                        +'  background-color: #fcc;'
                        +'  overflow: scroll;'
                        +'  height: 300px;'
                        +'  display: none;'
                        +'  font-family: Courier New;'
                        +'  font-size: 10.5pt;'
                        +'}'
                        +'.viewportControl {'
                        +'  width: 104px;'
                        +'  height: 80px;'
                        +'  position: absolute;'
                        +'  z-index: 99;'
                        +'  right: 5px;'
                        +'  bottom: 5px;'
                        +'}'
                        +'.usesGlyphGraphic {'
                        +'  background-image: '+ editorImages["controls.png"] +';'
                        +'}'
                        +'.viewportControlBtn {'
                        +'  width: 32px;'
                        +'  height: 32px;'
                        +'  display: block;'
                        +'  repeat: no-repeat;'
                        +'  position: absolute;'
                        +'  float:left;'
                        +'  cursor: pointer;'
                        +'}'
                        +'.toolBtn {'
                        +'  border : solid 1px silver;'
                        +'  margin : 4px;'
                        +'  margin-top: 20px;'
                        +'  border-radius: 2px;'
                        +'  width: 32px;'
                        +'  height: 32px;'
                        +'  display: inline-block;'
                        +'  repeat: no-repeat;'
                        +'  cursor: pointer;'
                        +'}'
                        +'.selectedToolBtn {'
                        +'  margin-bottom: 16px !important;'
                        +'  margin-top: 4px !important;'
                        +'  box-shadow: 0px 16px 10px rgba(0, 0, 0, 0.1) !important;'
                        +'}'
                        +'.toolBtn:hover {'
                        +'  margin-bottom: 6px;'
                        +'  margin-top: 18px;'
                        +'  box-shadow: 0px 2px 6px rgba(0, 0, 0, 0.2);'
                        +'}'
                        +'.leftBtn { background-position: 0px -32px; left: 0px; top: 24px; }'
                        +'.rightBtn { background-position: 0px -64px; left: 48px; top: 24px;}'
                        +'.upBtn { background-position: 0px -96px; left: 24px; top: 0px; }'
                        +'.downBtn { background-position: 0px 0px; left: 24px; top: 48px; }'
                        +'.zoomInBtn { background-position: 0px -128px; left: 72px; top: 0px; }'
                        +'.zoomOutBtn { background-position: 0px -160px; left: 72px; top: 48px; }'
                        +'.angleBtn { background-position: -32px 0px;}'
                        +'.moveBtn { background-position: -32px -32px;}'
                        +'.labelBtn { background-position: -32px -64px;}'
                        +'.sectorBtn { background-position: -32px -96px;}'
                        +'.regularpolygonBtn { background-position: -32px -128px;}'
                        +'.associatedlineBtn { background-position: -32px -160px;}'
                        +'.scriptableBtn { background-position: -32px -192px;}'
                        +'.pointBtn { background-position: -64px 0px;}'
                        +'.lineBtn { background-position: -64px -32px;}'
                        +'.circleBtn { background-position: -64px -64px;}'
                        +'.triangleBtn { background-position: -64px -96px;}'
                        +'.gliderBtn { background-position: -64px -128px;}'
                        +'.squareBtn { background-position: -64px -160px;}'
                        +'.rectangleBtn { background-position: -64px -192px;}'
                        +'.parallelogramBtn { background-position: -96px 0px;}'
                        +'.restrictedtriangleBtn { background-position: -96px -32px;}'
                        +'.rhombusBtn { background-position: -96px -64px;}'
                        +'.trapezoidBtn { background-position: -96px -96px;}'
                        +'.intersectionBtn { background-position: -96px -128px;}'
                        +'.parametriccurveBtn { background-position: -96px -160px;}'
                        +'.imageBtn { background-position: -96px -192px;}'
                        +'.addTabBtn { background-position: -32px -224px !important;}'
                        +'.nextTabBtn { background-position: -48px -224px !important;}'
                        +'.prevTabBtn { background-position: -48px -240px !important;}'
                        +'.axisBtn { background-position: -64px -224px;}'
                        +'.trashCanBtn {'
                        +'  position: absolute;'
                        +'  right: 3px;'
                        +'  top: -2px;'
                        +'  left: inherit !important;'
                        +'  width: 24px;'
                        +'  height: 24px;'
                        +'  display: block;'
                        +'  repeat: no-repeat;'
                        +'  background-position: 0px -192px;'
                        +'}';
    }
    { /** Editor                  **/
        /**
         * Initializes the board to given place with given parameters.
         * 
         * place: Location of the editor.
         * params:
         *    0: editor mode toggle; true/false.
         *    1: Scenes shown in the editor window.
         */
        var init = function(place, params) {
            // Checks if editor's CSS information is already written to document's head.
            if ($('head style#geoeditorstyle').length == 0){
                $('head').append('<style id="geoeditorstyle" type="text/css">'+editorCSS+'</style>');
            }
            var editable = params['editable'];
            var dataObj = params['scenes'];
            var boxWid = params['width'];
            var boxHei = params['height'];
            var browsingMode = params['browsingMode'];
            var $this = $(place);
            $this.data('editable', editable);
            { // Generate the box ID.
                // Find the first free box number and create a wrapper for the content.
                var boxnum = 0;
                while ($('div#ebookjessiebox-' + boxnum).length > 0) boxnum++;
                
                $this.data('boxnum', boxnum);
                clearAll(boxnum); // Remove all remains of the old boards that might exist in JSXGraph's memory.
            }

            { // Initialize.
                var dialog = $(place)
                
                dialog.empty();
                dialog.css('max-width', '100%');
                dialog.css('width', boxWid);
                //dialog.css('height', boxHei);
                if (boxWid.substr(-2) === 'px') {
                    boxHei = parseInt(boxHei, 10) * dialog.width() / parseInt(boxWid, 10) + 'px';
                }
                dialog.append('<div id="previewBox-' + boxnum + '" class="previewBox" style="max-width: ' + boxWid + ';"></div>');
                
                if (editable) {
                    dialog.append('<div id="contentBox-' + boxnum + '"></div>');
                    var contentBox = $('div#contentBox-' + boxnum);
                    
                    { // Construct part.
                        contentBox.append('<span title="Move points" class="usesGlyphGraphic toolBtn moveBtn selectedToolBtn"></span>').find(".moveBtn").click(
                            function() {
                                $('div#contentBox-' + boxnum).find('span.toolBtn').removeClass('selectedToolBtn');
                                $(this).addClass('selectedToolBtn');
                                setTool(boxnum, 'Move');
                            }
                        );
                        for (var i = 0; i < objTypes.length - 2; ++i) {
                            contentBox.append('<span title="' + objTypes[i] + '" id="createBtn' + i + '" class="usesGlyphGraphic toolBtn ' + objClasses[objTypes[i]].prototype.iconCSS + '"></span>').find('span#createBtn' + i).data('objType', objTypes[i]).click(
                                function() {
                                    $('div#contentBox-' + boxnum).find('span.selectedToolBtn').removeClass('selectedToolBtn');
                                    $(this).addClass('selectedToolBtn');
                                    setTool(boxnum, $(this).data('objType'));
                                }
                            );
                        }
                        contentBox.append('<span title="ParametricCurve" class="usesGlyphGraphic toolBtn parametriccurveBtn"></span>').find('span.parametriccurveBtn').click( function() { insertConstruct(boxnum, initNew(boxnum, 'ParametricCurve', null), editable, true); } );
                        contentBox.append('<span title="Scriptable" class="usesGlyphGraphic toolBtn scriptableBtn"></span>').find('span.scriptableBtn').click( function() { insertConstruct(boxnum, initNew(boxnum, 'Scriptable', null), editable, true); } );
                        
                        contentBox.append('<p /><div id="constructAccordion"></div>');
                        contentBox.append('<p /><div id="sceneAccordion"></div>');
                    }
                }
                dialog.append('<div id="dataBox-' + boxnum + '" class="dataBox"></div>');
                dialog.append('<div id="toolBox-' + boxnum + '" class="dataBox"></div>');
            }
            
            $('div#previewBox-' + boxnum).append('<div id="ebookjessiebox-' + boxnum + '" class="ebookjessiebox" style="width: ' + '100%' + '; height: ' + boxHei + ';"></div>').css('width: ' + boxWid);
            
            var sceneArr = new Array();
            
            sceneArr = generateSceneArr(dataObj);
            setGeoSceneData(boxnum, sceneArr);
            
            addTabs(boxnum, editable, browsingMode);
            
            // Get data binding
            $this.unbind('getdata').bind('getdata', function(event) {
                event.stopPropagation();
                var sdata = $(this).geoeditor('getContent') || [[]];
                var data = {
                    type: 'geoimage',
                    metadata: {},
                    data: {
                        editable: false,
                        scenes: sdata[0]
                    }
                }
                $(this).data('[[elementdata]]', data);
            });
            
            $(window).resize(function() { updateScene(boxnum, editable); });
        }
        
        var tabClick = function(button, boxnum, editable, browsingMode) { // Tab-click functionality.
            // Choose the current tab.
            var sceneArr = generateSceneArr(getGeoSceneData(boxnum));
            var sceneNum = parseInt($('div#previewBox-' + boxnum).find('.currentjessiebutton').eq(0).attr('tab'));
            
            if (editable) {
                
                //var idNum = 's' + sceneNum;
                //var elements = $('div#contentBox-' + boxnum).find('div#sceneAccordion').eq(0);
                //content = elements.find('div#geoScene-' + idNum);
                //var s_description = content.find('input#description-' + idNum).val();
                
                //var originalDescription = sceneArr[sceneNum].description;
                
                var caption = $('div#previewBox-' + boxnum).find('#caption-' + boxnum);
                
                if (caption) {
                    //if (caption.text() == originalDescription) caption.text(s_description);
 
                    sceneArr[sceneNum].description = caption.html();
                    if (browsingMode != 'tabless') $('div#previewBox-' + boxnum).find('.currentjessiebutton').html(caption.text()).attr('title', caption.text());
                    else $('div#previewBox-' + boxnum).find('.currentjessiebutton').attr('title', caption.text());
                    setGeoSceneData(boxnum, sceneArr);
                }
            }
            
            // Update the bounding box.
            var bb = getFixedBoundingBox(boxnum);
            if (bb != null) sceneArr[sceneNum].boundingBox = bb;
            
            setGeoSceneData(boxnum, sceneArr);
            
            // Get the update the 'current chosen tab' info.
            button.parents('div#previewBox-' + boxnum).find('.jessiebutton').removeClass('currentjessiebutton');
            button.parents('div#previewBox-' + boxnum).find('.jessiebutton').addClass('disabled');
            button.addClass('currentjessiebutton');
            
            var newSceneNum = parseInt($('div#previewBox-' + boxnum).find('.currentjessiebutton').eq(0).attr('tab'));   
            var parents = button.parents('div#previewBox-' + boxnum);
            parents
                .find('span#caption-' + boxnum)
                .removeClass('invisible geocaption')
                .addClass(((sceneArr[0].description.trim() == '') && (!editable)) ? ' invisible' : ' geocaption')
                .html(sceneArr[newSceneNum].description);
            
            if ((sceneArr[sceneNum].description.trim() == '') && (!editable))
                parents.addClass('nogeocaption');
            else
                parents.removeClass('nogeocaption');
                
            $('div#contentBox-' + boxnum).find("div#constructAccordion").empty();
            setScene(boxnum, parseInt(button.attr('tab')), editable);
        }
        
        var addTabs = function(boxnum, editable, browsingMode) { // Add the tab buttons and choose the first tab.
            
            // Generate buttons for the different states below the graph window.
            $('div#previewBox-' + boxnum).find('ul.jessiebuttons').remove(); // Remove the old tabs.
            if (!editable) $('div#contentBox-' + boxnum).empty();
            var jessiebuttons = $('div#ebookjessiebox-' + boxnum).after('<ul class="jessiebuttons' + (browsingMode == 'tabless' ? ' centered' : '') + '"></ul>').empty().next();
            
            var sceneArr = generateSceneArr(getGeoSceneData(boxnum));
        
            if (editable || sceneArr.length > 1) {
                if (browsingMode == 'tabless') {
                    jessiebuttons.append('<li class="jessiebutton usesGlyphGraphic smallBall prevTabBtn" tab="<" title="Previous figure.">&nbsp;</li>');
                    jessiebuttons.find('li.jessiebutton[tab="<"]').click(function() {
                        var sceneArr = getGeoSceneData(boxnum);
                        var sceneNum = parseInt($('div#previewBox-' + boxnum).find('.currentjessiebutton').eq(0).attr('tab'));
                        var nextTab = (sceneNum - 1 + sceneArr.length) % sceneArr.length;
                        $('div#previewBox-' + boxnum).find('li.jessiebutton[tab="' + nextTab + '"]').click();
                    });
                }
                
                for (var i = 0; i <= sceneArr.length; i++) {
                    if ( editable && (i == sceneArr.length) ) {
                        if (browsingMode == 'tabless') {
                            jessiebuttons.append('<li class="jessiebutton usesGlyphGraphic smallBall addTabBtn addtab" tab="+" title="Add a new tab.">&nbsp;</li>');
                        }
                        else {
                            jessiebuttons.append('<li class="jessiebutton" tab="+" id="addTab" tab="+" title="Add a new tab.">+</li>');
                        }   
                        // Adds click function for each tab.
                        jessiebuttons.find('li.jessiebutton[tab="+"]').click(function() {
                            
                            // Choose the current tab.
                            var button = jessiebuttons.find('li.jessiebutton[tab="+"]');
                            
                            // Add a new tab, copy content from the previous tab.
                            
                            var sceneData = getGeoSceneData(boxnum);
                            
                            var newObject = jQuery.extend(true, {}, sceneData[sceneData.length - 1]);
                            sceneData[sceneData.length] = newObject;
                            sceneData[sceneData.length - 1].description = '' + sceneData.length;

                            var sceneArr = generateSceneArr(sceneData);
                            
                            if (browsingMode == 'tabless')
                                button.before('<li class="jessiebutton usesGlyphGraphic smallBall" tab="' + (sceneArr.length - 1) + '" title="' + sceneArr[sceneArr.length - 1].description + '">&nbsp;</li>');
                            else 
                                button.before('<li class="jessiebutton" tab="' + (sceneArr.length - 1) + '">' + sceneArr[sceneArr.length - 1].description + '</li>');
                            
                            setGeoSceneData(boxnum, sceneArr);
                            
                            var newBtn = jessiebuttons.find('li.jessiebutton[tab="' + (sceneArr.length - 1) + '"]');

                            newBtn.click( function () { tabClick($(this), boxnum, editable, browsingMode); });
                            newBtn.click();
                            
                        });
                    } else if (i < sceneArr.length)  {
                        if (browsingMode == 'tabless')
                            jessiebuttons.append('<li class="jessiebutton' + (i == 0 ? ' currentjessiebutton' : '') + ' usesGlyphGraphic smallBall" tab="' + i + '" title="' + sceneArr[i].description + '">&nbsp;</li>');
                        else 
                            jessiebuttons.append('<li class="jessiebutton' + (i == 0 ? ' currentjessiebutton' : '') + '" tab="' + i + '">' + sceneArr[i].description + '</li>');
                        
                        // Adds click function for each tab.
                        jessiebuttons.find('li.jessiebutton[tab="' + i + '"]').click( function () { tabClick($(this), boxnum, editable, browsingMode); });
                    }
                    if ((i == sceneArr.length) && (browsingMode == 'tabless')) {
                        jessiebuttons.append('<li class="jessiebutton usesGlyphGraphic smallBall nextTabBtn" tab=">" title="Next figure.">&nbsp;</li>');
                        jessiebuttons.find('li.jessiebutton[tab=">"]').click(function() {
                            var sceneArr = getGeoSceneData(boxnum);
                            var sceneNum = parseInt($('div#previewBox-' + boxnum).find('.currentjessiebutton').eq(0).attr('tab'));
                            var nextTab = (sceneNum + 1) % sceneArr.length;
                            $('div#previewBox-' + boxnum).find('ul.jessiebuttons').find('li.jessiebutton[tab="' + nextTab + '"]').click();
                        });
                    }
                }
            }
            
            if (editable || (browsingMode == 'tabless') || sceneArr.length == 1) {
                jessiebuttons.after('<span class="currentjessiebutton' + (sceneArr[0].description.trim() == '' ? ' invisible' : ' geocaption') + '" contenteditable="' + editable + '" id="caption-' + boxnum + '" tab="0">' + sceneArr[0].description + '</span>');
                
                if (!editable && sceneArr.length == 1) $('div#previewBox-' + boxnum).find('span.currentjessiebutton').click( function () { tabClick($(this), boxnum, editable, browsingMode); });
                $('div#previewBox-' + boxnum).find('span#caption-' + boxnum).bind('keypress.geoeditor', function(event) {
                    var keycode = (event.keyCode ? event.keyCode : event.which);
            
                    if ((keycode == '13')) {
                        $('div#previewBox-' + boxnum).find('.currentjessiebutton').eq(0).click();
                        event.preventDefault();
                        
                        // Set cursor position.
                        var el = document.getElementById("caption-" + boxnum);
                        if (el.innerHTML.trim() != '') {
                            var range = document.createRange();
                            var sel = window.getSelection();
                            
                            range.setStart(el.childNodes[0], el.childNodes[0].length);
                            range.collapse(true);
                            sel.removeAllRanges();
                            sel.addRange(range);
                        }   
                    }
                });
            }
            $('div#previewBox-' + boxnum).find('.currentjessiebutton').eq(0).click();
        }

        /**
         * As the function name implies, throws the old board away.
         * 
         * boxnum: Index / ID number of the editor.
         */
        var clearAll = function(boxnum) {
            
            // Removing the renderer causes an error when freeBoard() is
            // used. The renderer has no clear reference in the code.
            // Contents of the freeBoard() function is copied below to
            // fix the problem.
            
            // Go through the boards and find the right one.
            for (var f in JXG.JSXGraph.boards) {
                if (JXG.JSXGraph.boards[f].container == 'ebookjessiebox-' + boxnum) {
                    
                    //JXG.JSXGraph.freeBoard(JXG.JSXGraph.boards[f]);
                    
                    if (typeof (f) == "string") {
                        f = JXG.JSXGraph.boards[f]
                    }
                    
                    f.removeEventHandlers();
                    //for (var e in f.objects) {
                    //   f.removeObject(f.objects[e])
                    //}
                    for (var d = 0; d < f.containerObj.childNodes.length; d++) {
                        f.containerObj.removeChild(f.containerObj.childNodes[d])
                    }
                    //for (var e in f.objects) {
                    //  delete(f.objects[e])
                    //}
                    f.objects = new Object();
                    //delete(f.renderer);
                    delete(f.algebra);
                    delete(JXG.JSXGraph.boards[f.id])
                }
            }
            
        }

        /**
         * Occasionally the bounding box is malformed. This function orders the items to correctly.
         * 
         * boxnum : Identifier for the current plot window.
         */
        var getFixedBoundingBox = function(boxnum) {
            
            var a;
            var board;
            for (var p in JXG.JSXGraph.boards)
                if (JXG.JSXGraph.boards[p].container == 'ebookjessiebox-' + boxnum) {
                    board = JXG.JSXGraph.boards[p];
                    a = board.getBoundingBox();
                }
            if (typeof a != 'undefined') {      
                var temp;
                
                if (a[0] > a[2]) {
                    temp = a[0];
                    a[0] = a[2];
                    a[2] = temp;
                }
                // These need to be inverted as screen coordinates
                // increase from top to bottom.
                if (a[1] < a[3]) {
                    temp = a[1];
                    a[1] = a[3];
                    a[3] = temp;
                }
                
                return a;
            } else return null; // No matching board found.
        }

        /**
         * Move the current editor location and update.
         * 
         * boxnum: Index / ID number of the editor.
         * dx, dy: Movement difference from current location
         * in percentage of respective bounding box dimensions.
         */
        var moveOrigin = function(boxnum, dx, dy, editable) {
            var sceneArr = generateSceneArr(getGeoSceneData(boxnum));
            var sceneNum = parseInt($('div#previewBox-' + boxnum).find('.currentjessiebutton').eq(0).attr('tab'));
            var board;
            for (var p in JXG.JSXGraph.boards)
                if (JXG.JSXGraph.boards[p].container == 'ebookjessiebox-' + boxnum) board = JXG.JSXGraph.boards[p];
            
            var a = getFixedBoundingBox(boxnum);
            var jx = Math.abs(a[0] - a[2]) * dx;
            var jy = Math.abs(a[1] - a[3]) * dy;
            
            sceneArr[sceneNum].boundingBox[0] += jx;
            sceneArr[sceneNum].boundingBox[1] += jy;
            sceneArr[sceneNum].boundingBox[2] += jx;
            sceneArr[sceneNum].boundingBox[3] += jy;
            
            setGeoSceneData(boxnum, sceneArr);
            
            board.setBoundingBox(sceneArr[sceneNum].boundingBox, true);
            
            if (editable) updateScene(boxnum, editable, true);
        }

        /**
         * Zoom the editor and update.
         * 
         * boxnum: Index / ID number of the editor.
         * factor: Zoom factor, in the interval (0, \infty). 1 for no zoom.
         * editable: Flag indicating if the editor is in edit mode or not.
         */
        var zoom = function(boxnum, factor, editable) {
            var sceneArr = generateSceneArr(getGeoSceneData(boxnum));
            var sceneNum = parseInt($('div#previewBox-' + boxnum).find('.currentjessiebutton').eq(0).attr('tab'));
            var board;
            for (var p in JXG.JSXGraph.boards)
                if (JXG.JSXGraph.boards[p].container == 'ebookjessiebox-' + boxnum) board = JXG.JSXGraph.boards[p];
            
            var a = getFixedBoundingBox(boxnum);
            var jx = Math.abs(a[0] - a[2]) * 0.5;
            var jy = Math.abs(a[1] - a[3]) * 0.5;
            sceneArr[sceneNum].boundingBox[0] += jx * (1 - factor);
            sceneArr[sceneNum].boundingBox[1] += jy * (factor - 1);
            sceneArr[sceneNum].boundingBox[2] += jx * (factor - 1);
            sceneArr[sceneNum].boundingBox[3] += jy * (1 - factor);
            setGeoSceneData(boxnum, sceneArr);
            
            board.setBoundingBox(sceneArr[sceneNum].boundingBox, true);
            
            if (editable) updateScene(boxnum, editable, true);
        }

        /**
         * Selects one of the scenes and shows it in the editor.
         * 
         * boxnum: Index / ID number of the editor.
         * sceneNum: Index of the scene that needs to be shown.
         * editable: Flag indicating if the editor is in edit mode or not.
         */
        var setScene = function(boxnum, sceneNum, editable, refreshFromData) {
            if (editable) {
                var sceneArr = generateSceneArr(getGeoSceneData(boxnum));
                for (var i = 0; i < sceneArr[sceneNum].objects.length; ++i) {
                    insertConstruct(boxnum, sceneArr[sceneNum].objects[i], editable, false, sceneNum, i);
                }
                
                var idNum = 's' + sceneNum;
                var contentBox = $('div#contentBox-' + boxnum);
                
                
                var sceneAccordion = contentBox.find('div#sceneAccordion').empty();
                sceneAccordion.append(
                    '<h3 id="' + 'geoSceneHeader' + idNum + '" style="padding-left:40px; height:26px">' +
                    '<span class="geoObjName">Scene options</span>' +
                    '</h3>' + 
                    '<div id="' + 'geoScene-' + idNum + '"></div>'
                );
                
                var place = sceneAccordion.find('div#geoScene-' + idNum);
                //place.append('<span class="geoItemCaption">Name: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" type="text" value="' + sceneArr[sceneNum].name + '" /></span><br/>');
                //place.append('<span class="geoItemCaption">Description: </span>' + '<span class="geoProperty"><input id="description-' + idNum + '" size="5" type="text" value="' + sceneArr[sceneNum].description + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Show grid: </span>' + '<span class="geoProperty"><input id="showGrid-' + idNum + '" type="checkbox"' + (sceneArr[sceneNum].showGrid ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Static: </span>' + '<span class="geoProperty"><input id="isStatic-' + idNum + '" type="checkbox"' + (sceneArr[sceneNum].isStatic ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Allow controls: </span>' + '<span class="geoProperty"><input id="allowControls-' + idNum + '" type="checkbox"' + (sceneArr[sceneNum].allowControls ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Left bound: </span>' + '<span class="geoProperty"><input id="bboxLeft-' + idNum + '" type="text" size="5" value="' + sceneArr[sceneNum].boundingBox[0] + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Top bound: </span>' + '<span class="geoProperty"><input id="bboxTop-' + idNum + '" type="text" size="5" value="' + sceneArr[sceneNum].boundingBox[1] + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Right bound: </span>' + '<span class="geoProperty"><input id="bboxRight-' + idNum + '" type="text" size="5" value="' + sceneArr[sceneNum].boundingBox[2] + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Bottom bound: </span>' + '<span class="geoProperty"><input id="bboxBottom-' + idNum + '" type="text" size="5" value="' + sceneArr[sceneNum].boundingBox[3] + '"/></span><br/>');
                
                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                    .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
                
                sceneAccordion.accordion('destroy').accordion({active:"h3:last", collapsible: true});
            }   
            
            updateScene(boxnum, editable, refreshFromData);
        }

        /**
         * Loads the scene data from it's container.
         * 
         * boxnum: Index / ID number of the editor.
         */
        var getGeoSceneData = function(boxnum) {
            
            var dataObj = $('div#previewBox-' + boxnum).parent().data('sceneData');
            
            //if ($('div#dataBox-' + boxnum).text().trim() == "") return null;
            //return JSON.parse($('div#dataBox-' + boxnum).text());
            
            if (dataObj === undefined) return null;
            return dataObj;
        }
        
        /**
         * Saves the scene data to it's container.
         * 
         * boxnum: Index / ID number of the editor.
         * data: The scene object to be saved.
         */
        var setGeoSceneData = function(boxnum, data) {
            var parent = $('div#previewBox-' + boxnum).parent();
            var sendUpdateTrigger = parent.data('sendUpdateTrigger');
            var old = parent.data('sceneData');
            
            //var dataObj = $('div#dataBox-' + boxnum).text( JSON.stringify(data) );
            
            if ( sendUpdateTrigger ) {
                if (JSON.stringify(old) != JSON.stringify(data)) {
                    parent.data('sceneData', data);
                    parent.trigger('geoeditor_changed');
                }
            }
        }

        /**
         * Event handler function for enter key inside the editor.
         * 
         * event: The key press event.
         * boxnum: Index / ID number of the editor.
         * editable: Flag indicating if the editor is in edit mode or not.
         */
        var enterKeyUpdate = function(event, boxnum, editable) {

            var keycode = (event.keyCode ? event.keyCode : event.which);
            
            if ((keycode == '13') || (keycode == '32')) updateScene(boxnum, editable);
         
        }

        /**
         * Removes a construct from the current scene and
         * then updates the view.
         *
         * boxnum: Index of the applied view.
         * objNum: Index of the to-be-removed object.
         **/
        var removeConstruct = function(boxnum, objNum) {
            
            var tabButton = $('div#previewBox-' + boxnum).find('.currentjessiebutton').eq(0);
            var sceneNum = parseInt(tabButton.attr('tab'));
            var sceneArr = generateSceneArr(getGeoSceneData(boxnum));
            sceneArr[sceneNum].objects.splice(objNum, 1);
            setGeoSceneData(boxnum, sceneArr);
            tabButton.click();
        }

        /**
         * Adds the given object to the construct accordion.
         * 
         * 
         */ 
        var insertConstruct = function(boxnum, obj, editable, update, sceneNum, idNum) {
            var contentBox = $('div#contentBox-' + boxnum);
            if (sceneNum == null) sceneNum = parseInt($('div#previewBox-' + boxnum).find('.currentjessiebutton').eq(0).attr('tab'));
            if (idNum == null) idNum = getGeoSceneData(boxnum)[sceneNum].objects.length;
            
            var accordion
            contentBox.find("#constructAccordion").append(
                '<h3 id="' + 'geoConstructHeader' + idNum + '" style="padding-left:40px; height:26px">' +
                '<span class="geoObjName">' + obj.name + " (" + obj.type + ')</span>' + 
                '<span class="typeInfoBlock">' + obj.type + '</span>' +
                '<span class="usesGlyphGraphic viewportControlBtn trashCanBtn"></span>' +
                '</h3>' + 
                '<div id="' + 'geoConstruct' + idNum + '"></div>'
            );
            contentBox.find('h3#' + 'geoConstructHeader' + idNum).find(".trashCanBtn").click(function() { removeConstruct(boxnum, idNum); });
                            
                
                    
            obj.addOptionsDialog(contentBox.find("#constructAccordion").find('div#geoConstruct' + idNum), idNum, boxnum, editable);
            
            if (editable) contentBox.find("#constructAccordion").accordion('destroy').accordion({active:"h3:last", collapsible: true});
            if (update) updateScene(boxnum, editable);
        }

        /**
         * Collects object properties from the current scene.
         * 
         * boxnum: Index / ID number of the editor.
         */
        var collectScene = function(boxnum) {
                
            var elements = $('div#contentBox-' + boxnum).find('div#constructAccordion').eq(0);
            var types = elements.find('h3.ui-accordion-header').find('span.typeInfoBlock');
            
            // Initialize objects.
            var objects = [];
            
            for (var i = 0; i < types.length; i++) {
                var objType = types.eq(i).text();
                content = elements.find('div#geoConstruct' + i);
                objects[i] = objClasses[objType].prototype.createFromDialog(content, i);
            }
            
            var sceneNum = parseInt($('div#previewBox-' + boxnum).find('.currentjessiebutton').eq(0).attr('tab'));
            var idNum = 's' + sceneNum;
            
            var elements = $('div#contentBox-' + boxnum).find('div#sceneAccordion').eq(0);
            var types = elements.find('h3.ui-accordion-header').find('span.typeInfoBlock');
            
            var caption = $('div#previewBox-' + boxnum).find('#caption-' + boxnum);
            
            var s_description;
            if (caption) {
            
                s_description = caption.html();
            }
            
            content = elements.find('div#geoScene-' + idNum);
            //var s_name = content.find('input#name-' + idNum).val();
            //var s_description = content.find('input#description-' + idNum).val();
            var b_showGrid = content.find('input#showGrid-' + idNum).is(':checked');
            var b_isStatic = content.find('input#isStatic-' + idNum).is(':checked');
            var b_allowControls = content.find('input#allowControls-' + idNum).is(':checked');
            var f_bboxLeft = parseFloat(content.find('input#bboxLeft-' + idNum).val());
            var f_bboxTop = parseFloat(content.find('input#bboxTop-' + idNum).val());
            var f_bboxRight = parseFloat(content.find('input#bboxRight-' + idNum).val());
            var f_bboxBottom = parseFloat(content.find('input#bboxBottom-' + idNum).val());
            
            var scene = new GeoScene( {
                //'name' : s_name,
                'description' : s_description,
                'showGrid' : b_showGrid,
                'isStatic' : b_isStatic,
                'allowControls' : b_allowControls,
                'boundingBox' : [f_bboxLeft, f_bboxTop, f_bboxRight, f_bboxBottom],
                'objects' : objects

            } );
            
            return scene;
        }

        /**
         * Goes through the given GeoScene[] 'sceneArr' and
         * returns a script array corresponding to the scenes.
         * 
         * sceneArr: A scene array containing the scripts.
         */
        var getScripts = function(sceneArr) {
            
            // Initialize the result.
            var result = [];
            
            var s;
            // Go through each scene.
            for (var i = 0; i < sceneArr.length; i++) {
                s = '';
                // Go through each object in the scene.
                
                s += sceneArr[i].asJessieScript();
                
                // Add the corresponding script snippet to the scene script.
                result[i] = s;
            }
            
            return result;
        }

        /**
         * Converts a scene array data object to a scene array.
         * 
         * sceneData: Object to be converted.
         */
        var generateSceneArr = function(sceneData) {
            
            var sceneArr = [];
            
            if (sceneData != null) {
                
                for (var i = 0; i < sceneData.length; ++i)
                    sceneArr[i] = new GeoScene(sceneData[i]);   
            }
            
            return sceneArr;
        }

        /**
         * Collects the current point data from the editor view and updates
         * the new values to the stored scene array.
         * 
         * boxnum: Index / ID number of the editor.
         */
        var updateSceneData = function(board, construction, boxnum) {
            
            // Load the scene and determine the current scene number.
            var sceneArr = generateSceneArr(getGeoSceneData(boxnum));
            var sceneNum = parseInt($('div#previewBox-' + boxnum).find('.currentjessiebutton').eq(0).attr('tab'));
            var elements = $('div#contentBox-' + boxnum).find('div#constructAccordion').eq(0);
            
            // Go through each object and update it's information if necessary.
            for (var i = 0; i < sceneArr[sceneNum].objects.length; ++i) {
                sceneArr[sceneNum].objects[i].updateSceneData(
                    i,
                    construction,
                    elements.find('div#geoConstruct' + i)
                );
            }
            
            sceneArr[sceneNum].boundingBox = getFixedBoundingBox(boxnum);
            
            setGeoSceneData(boxnum, sceneArr);
        }

        /**
         * Merges the given const
         **/
        var mergeConstructions = function(c1, c2) {
            c1.angles = c1.angles.concat(c2.angles);
            c1.circles = c1.circles.concat(c2.circles);
            c1.functions = c1.functions.concat(c2.functions);
            c1.intersections = c1.intersections.concat(c2.intersections);
            c1.macros = c1.macros.concat(c2.macros);
            c1.points = c1.points.concat(c2.points);
            c1.lines = c1.lines.concat(c2.lines);
            c1.polygons = c1.polygons.concat(c2.polygons);
            c1.texts = c1.texts.concat(c2.texts);
            if ((typeof c1.axes != "undefined") && (typeof c2.axes != "undefined")) c1.axes.concat(c2.axes);
            return c1;
        }

        /**
         * Updates all of the visible editor components to match the current
         * state of the data object.
         * 
         * boxnum: Index / ID number of the editor.
         */
        var updateScene = function(boxnum, editable, refreshFromData) {
            var sceneArr = generateSceneArr(getGeoSceneData(boxnum));
            var sceneNum = parseInt($('div#previewBox-' + boxnum).find('.currentjessiebutton').eq(0).attr('tab'));
            
            var getMouseCoords = function(e) {
                var cPos = board.getCoordsTopLeftCorner(e),
                    absPos = JXG.getPosition(e),
                    dx = absPos[0]-cPos[0],
                    dy = absPos[1]-cPos[1];
         
                return new JXG.Coords(JXG.COORDS_BY_SCREEN, [dx, dy], board);
            },
            down = function(e) {
                
                e = e || window.event;
                var targ = e.target || e.srcElement; // For IE.
                if (targ.nodeType == 3) targ = targ.parentNode; // For Safari 3.
                
                if (!$(e.target).hasClass('viewportControlBtn')) { // Only for the editor window.
                    
                    var coords = getMouseCoords(e);
                    
                    var tool = generateTool(getGeoToolData(boxnum));
                    tool.mDown(board, coords, boxnum, editable);
                    setGeoToolData(boxnum, tool);
                }
            },
            up = function(e) {
                
                e = e || window.event;
                var targ = e.target || e.srcElement; // For IE.
                if (targ.nodeType == 3) targ = targ.parentNode; // For Safari 3.
                
                if (!$(e.target).hasClass('viewportControlBtn')) { // Only for the editor window.
                    
                    var coords = getMouseCoords(e);
                    updateSceneData(board, construction, boxnum);
                            
                    var tool = generateTool(getGeoToolData(boxnum));
                    tool.mUp(board, coords, boxnum, editable);
                    setGeoToolData(boxnum, tool);
                }
            },
            wheel = function (e) {
                
                /*
                e = e || window.event;
                
                var dz = e.detail ? e.detail * (-1) : e.wheelDelta / 40;
                if (dz > 0) {
                    zoom(boxnum, Math.pow(1.025, dz), editable)
                } else {
                    zoom(boxnum, Math.pow(0.98, dz), editable)
                }
                
                e.preventDefault();

                sceneArr[sceneNum].boundingBox = getFixedBoundingBox(boxnum);
                
                setGeoSceneData(boxnum, sceneArr);*/
                return false;
            };
            
            if (editable) { // Update values from the forms.
                //var objects = collectObjects(boxnum);
                //sceneArr[sceneNum].objects = objects;
                //var originalDescription = sceneArr[sceneNum].description;
                
                if (!refreshFromData) sceneArr[sceneNum] = collectScene(boxnum);
                
                // Update the accordion headings.
                var headings = $('div#contentBox-' + boxnum).find('div#constructAccordion').find('h3');
                
                for (var i = 0; i < headings.length; ++i)
                headings.eq(i).find('span.geoObjName').text(sceneArr[sceneNum].objects[i].name + " (" + sceneArr[sceneNum].objects[i].type + ")");
                
            }
            
            // Clear the board and redraw the content.
            clearAll(boxnum);
            var container = $('div#previewBox-' + boxnum).find('div#ebookjessiebox-' + boxnum);
            container.empty();
            var board = JXG.JSXGraph.initBoard(
                'ebookjessiebox-' + boxnum,
                {
                    keepaspectratio:true,
                    grid:false,
                    showCopyright:false,
                    showNavigation:false,
                    zoom:false/*sceneArr[sceneNum].allowControls && (!sceneArr[sceneNum].isStatic)*/,
                    pan: (editable || (sceneArr[sceneNum].allowControls && (!sceneArr[sceneNum].isStatic)))
                }
            );
            
            if (!editable && sceneArr[sceneNum].isStatic) board.removeEventHandlers();
            board.suspendUpdate();

            { // View control part.
                container.append('<div id="controlBox-' + boxnum + '" class="viewportControl"></div>');
                var controlBox = container.find('div#controlBox-' + boxnum);
                
                controlBox.append('<span class="usesGlyphGraphic viewportControlBtn leftBtn" />').find(".leftBtn").click(function() { moveOrigin(boxnum, -0.1, 0, editable); });
                controlBox.append('<span class="usesGlyphGraphic viewportControlBtn rightBtn" />').find(".rightBtn").click(function() { moveOrigin(boxnum,  0.1, 0, editable); });
                controlBox.append('<span class="usesGlyphGraphic viewportControlBtn upBtn" />').find(".upBtn").click(function() { moveOrigin(boxnum, 0, 0.1, editable); });
                controlBox.append('<span class="usesGlyphGraphic viewportControlBtn downBtn" />').find(".downBtn").click(function() { moveOrigin(boxnum, 0, -0.1, editable); });
                controlBox.append('<span class="usesGlyphGraphic viewportControlBtn zoomInBtn" />').find(".zoomInBtn").click(function() { zoom(boxnum, 0.8, editable); });
                controlBox.append('<span class="usesGlyphGraphic viewportControlBtn zoomOutBtn" />').find(".zoomOutBtn").click(function() { zoom(boxnum, 1.25, editable); });
            }

            { // Set the bounding box.
                var a = sceneArr[sceneNum].boundingBox;
                var temp;
                
                if (a[0] > a[2]) {
                    temp = a[0];
                    a[0] = a[2];
                    a[2] = temp;
                }
                // These need to be inverted as screen coordinates
                // increase from top to bottom.
                if (a[1] < a[3]) {
                    temp = a[1];
                    a[1] = a[3];
                    a[3] = temp;
                }
                board.setBoundingBox(a, true);
                
                // Update the bounding box.
                var idNum = 's' + sceneNum;
                var contentBox = $('div#contentBox-' + boxnum);
                var sceneAccordion = contentBox.find('div#sceneAccordion');
                var place = sceneAccordion.find('div#geoScene-' + idNum);
                place.find('input#bboxLeft-' + idNum).val(sceneArr[sceneNum].boundingBox[0]);
                place.find('input#bboxTop-' + idNum).val(sceneArr[sceneNum].boundingBox[1]);
                place.find('input#bboxRight-' + idNum).val(sceneArr[sceneNum].boundingBox[2]);
                place.find('input#bboxBottom-' + idNum).val(sceneArr[sceneNum].boundingBox[3]);
            }
            
            if (!editable && (sceneArr[sceneNum].isStatic || (!sceneArr[sceneNum].allowControls))) $('div#controlBox-' + boxnum).hide();
            else $('div#controlBox-' + boxnum).show();
            
            if (editable || !sceneArr[sceneNum].isStatic) {
                board.addHook(up, 'mouseup');
                board.addHook(down, 'mousedown');
            }
            if ( /* Is new (incomplete) zoom mode on? */ false ) {
                JXG.removeEvent(board.containerObj, 'mousewheel', board.mouseWheelListener, board);
                JXG.removeEvent(board.containerObj, 'DOMMouseScroll', board.mouseWheelListener, board);
                JXG.addEvent(board.containerObj, 'mousewheel', wheel, board);
                JXG.addEvent(board.containerObj, 'DOMMouseScroll', wheel, board);
            }
            
            if (sceneArr[sceneNum].showGrid) board.create('grid', [], {dash : 1}); // According to JXG reference, dash causes lag on iPad, and therefore should not be used there.
            var construction = board.construct("");
            
            for (var i = 0; i < sceneArr[sceneNum].objects.length; ++i) {
                
                var obj = sceneArr[sceneNum].objects[i];
                var objScript = obj.asJessieScript();
                
                if (objScript.trim() != '') {
                    var tConstruction = board.construct(objScript);
                    construction = mergeConstructions(construction, tConstruction);
                }
                else obj.asConstruct(board, construction);
                
                // Regular polygon point data needs to be updated on the fly, as it is not governed by the editor.
                if (obj.type == 'RegularPolygon') {
                    sceneArr[sceneNum].objects[i] = obj;
                    
                    var elements = $('div#contentBox-' + boxnum).find('div#constructAccordion').eq(0);
                    elements.find('div#geoConstruct' + i).find('input#pArr-' + i).val(obj.pArr);
                }
            }
            board.unsuspendUpdate();
            if (editable) setGeoSceneData(boxnum, sceneArr);
            $('div#previewBox-' + boxnum).find('.jessiebutton').removeClass('disabled');
        }
    }   
    { /** Tools                   **/
        /**
         * Constructor
         */
        var GeoTool = function(toolData, toolType, state) {
            if (toolData == null) {
                this.state = state;
                this.toolType = toolType;
                this.dx = null;
                this.dy = null;
                this.ux = null;
                this.uy = null;
                this.temp = null;
            } else {
                this.state = toolData.state;
                this.toolType = toolData.toolType;
                this.dx = toolData.dx;
                this.dy = toolData.dy;
                this.ux = toolData.ux;
                this.uy = toolData.uy;
                this.temp = toolData.temp;
            }
        }

        /**
         * Fetches the current mouse coordinates from the board and stores them
         * to the tool memory.
         * 
         * board: The current board.
         * coords: Current mouse coordinates.
         * boxnum: ID number of the box containing the board.
         * editable: Flag that tells if the board is editable or not.
         **/
        GeoTool.prototype.mDown = function(board, coords, boxnum, editable) {
            this.dx = coords.scrCoords[1];
            this.dy = coords.scrCoords[2];
        }

        // Functional copy of GeoTool.prototype.mUp (to be re-written in more efficient way).
        GeoTool.prototype.mUp = function(board, coords, boxnum, editable) {
            
            
            var ready = false;
            var bbox = getFixedBoundingBox(boxnum);
            var pX = parseInt(coords.usrCoords[1] * 100) / 100;
            var pY = parseInt(coords.usrCoords[2] * 100) / 100;
            this.ux = coords.scrCoords[1];
            this.uy = coords.scrCoords[2];

            if ( // point is still in the graph, then create it.
                ((Math.min(bbox[0], bbox[2]) <= pX) && (pX <= Math.max(bbox[0], bbox[2]))) &&
                ((Math.min(bbox[1], bbox[3]) <= pY) && (pY <= Math.max(bbox[1], bbox[3]))) &&
                (Math.pow(this.dx - this.ux, 2) + Math.pow(this.dy - this.uy, 2) <= 9)
               ) {
            
                var obj;
                if (
                    (this.toolType == GeoTool.TT_CREATE_SELECT) ||
                    (this.toolType == GeoTool.TT_CREATE_MOVE)
                    ) {
                    for (el in board.objects) {
                        if (
                            (board.objects[el].hasPoint(coords.scrCoords[1], coords.scrCoords[2])) &&
                            (board.objects[el].name.trim() != "")
                        ) {
                            /* TODO open the proper accordion tab. */
                        }
                    }
                }
                if (
                    (this.toolType == GeoTool.TT_CREATE_TRIANGLE) ||
                    (this.toolType == GeoTool.TT_CREATE_SECTOR) ||
                    (this.toolType == GeoTool.TT_CREATE_PARALLELOGRAM) ||
                    (this.toolType == GeoTool.TT_CREATE_TRAPEZOID) ||
                    (this.toolType == GeoTool.TT_CREATE_ANGLE)
                    ) {
                    for (el in board.objects) {
                        if(
                            JXG.isPoint(board.objects[el]) &&
                            board.objects[el].hasPoint(coords.scrCoords[1], coords.scrCoords[2]) &&
                            (board.objects[el].name.trim() != "") &&
                            (board.objects[el].visProp.visible)
                          ) {
                            
                            // We are over an existing point, use it as part of the new object.
                            if (this.state == 0) {
                                this.temp = new Array();
                                this.temp[0] = board.objects[el].name;
                            }
                            else if (this.state == 1) this.temp[1] = board.objects[el].name;
                            else {
                                this.temp[2] = board.objects[el].name;
                                
                                if (this.toolType == GeoTool.TT_CREATE_TRIANGLE) obj = initNew(boxnum, 'Triangle', this);
                                else if (this.toolType == GeoTool.TT_CREATE_PARALLELOGRAM) obj = initNew(boxnum, 'Parallelogram', this);
                                else if (this.toolType == GeoTool.TT_CREATE_SECTOR) obj = initNew(boxnum, 'Sector', this);
                                else if (this.toolType == GeoTool.TT_CREATE_TRAPEZOID) obj = initNew(boxnum, 'Trapezoid', this);
                                else if (this.toolType == GeoTool.TT_CREATE_ANGLE) obj = initNew(boxnum, 'Angle', this);
                                ready = true;
                            }
                        }
                    }
                    
                    
                    // Check that creation went smoothly and move on.
                    if (typeof this.temp[this.state] != 'undefined') {
                        ++this.state;
                        this.state = this.state % 3;
                    }
                }
                else if (
                    (this.toolType == GeoTool.TT_CREATE_LINE) ||
                    (this.toolType == GeoTool.TT_CREATE_AXIS) ||
                    (this.toolType == GeoTool.TT_CREATE_REGULAR_POLYGON) ||
                    (this.toolType == GeoTool.TT_CREATE_ASSOCIATED_LINE) ||
                    (this.toolType == GeoTool.TT_CREATE_CIRCLE) ||
                    (this.toolType == GeoTool.TT_CREATE_RHOMBUS) ||
                    (this.toolType == GeoTool.TT_CREATE_RESTRICTED_TRIANGLE) ||
                    (this.toolType == GeoTool.TT_CREATE_SQUARE) ||
                    (this.toolType == GeoTool.TT_CREATE_INTERSECTION) ||
                    (this.toolType == GeoTool.TT_CREATE_RECTANGLE)
                ) {
                    
                    for (el in board.objects) {
                        if (
                            (
                                (
                                    JXG.isPoint(board.objects[el]) &&
                                    (
                                        (this.toolType != GeoTool.TT_CREATE_ASSOCIATED_LINE) ||
                                        (this.state == 0)
                                    )
                                ) ||
                                (
                                    (!JXG.isPoint(board.objects[el])) &&
                                    (
                                        (
                                            (this.toolType == GeoTool.TT_CREATE_INTERSECTION) &&
                                            (
                                                (board.objects[el].elType == 'line') ||
                                                (board.objects[el].elType == 'axis') ||
                                                (board.objects[el].elType == 'parallel') ||
                                                (board.objects[el].elType == 'normal') ||
                                                (board.objects[el].elType == 'circle')
                                            )
                                        ) ||
                                        (
                                            (this.toolType == GeoTool.TT_CREATE_ASSOCIATED_LINE) &&
                                            (this.state == 1)
                                        )
                                    )
                                )
                            ) &&
                            board.objects[el].hasPoint(coords.scrCoords[1], coords.scrCoords[2]) &&
                            (board.objects[el].name.trim() != "") &&
                            (board.objects[el].visProp.visible)
                          ) {
                            // We are over an existing point, use it as part of the new object.
                            if (this.state == 0) {
                                this.temp = new Array();
                                this.temp[0] = board.objects[el].name;
                            }
                            else {
                                this.temp[1] = board.objects[el].name;
                                if (this.toolType == GeoTool.TT_CREATE_ASSOCIATED_LINE) {
                                    if (board.objects[el].elType == 'line') this.temp[2] = 'Line';
                                    else if (board.objects[el].elType == 'parallel') this.temp[2] = 'Line';
                                    else if (board.objects[el].elType == 'normal') this.temp[2] = 'Line';
                                    else if (board.objects[el].elType == 'axis') this.temp[2] = 'Line';
                                    else if (board.objects[el].elType == 'circle') this.temp[2] = 'Circle';
                                }

                                if (this.toolType == GeoTool.TT_CREATE_LINE) obj = initNew(boxnum, 'Line', this);
                                else if (this.toolType == GeoTool.TT_CREATE_AXIS) obj = initNew(boxnum, 'Axis', this);
                                else if (this.toolType == GeoTool.TT_CREATE_INTERSECTION) obj = initNew(boxnum, 'Intersection', this);
                                else if (this.toolType == GeoTool.TT_CREATE_REGULAR_POLYGON) obj = initNew(boxnum, 'RegularPolygon', this);
                                else if (this.toolType == GeoTool.TT_CREATE_ASSOCIATED_LINE) obj = initNew(boxnum, 'AssociatedLine', this);
                                else if (this.toolType == GeoTool.TT_CREATE_CIRCLE) obj = initNew(boxnum, 'Circle', this);
                                else if (this.toolType == GeoTool.TT_CREATE_RHOMBUS) obj = initNew(boxnum, 'Rhombus', this);
                                else if (this.toolType == GeoTool.TT_CREATE_RESTRICTED_TRIANGLE) obj = initNew(boxnum, 'RestrictedTriangle', this);
                                else if (this.toolType == GeoTool.TT_CREATE_SQUARE) obj = initNew(boxnum, 'Square', this);
                                else if (this.toolType == GeoTool.TT_CREATE_RECTANGLE) obj = initNew(boxnum, 'Rectangle', this);
                                ready = true;
                            }
                        }
                    }
                    // Check that creation went smoothly and move on.
                    if (typeof this.temp[this.state] != 'undefined') {
                        ++this.state;
                        this.state = this.state % 2;
                    }                   
                }
                else if (
                    (this.toolType == GeoTool.TT_CREATE_POINT) ||
                    (this.toolType == GeoTool.TT_CREATE_GLIDER) ||
                    (this.toolType == GeoTool.TT_CREATE_IMAGE) ||
                    (this.toolType == GeoTool.TT_CREATE_LABEL)
                ) {
                    var canCreate = (this.toolType != GeoTool.TT_CREATE_GLIDER) && (this.toolType != GeoTool.TT_CREATE_IMAGE);
                    var el;
                    var parent = null;
                    
                    for (el in board.objects) {
                        if (this.toolType == GeoTool.TT_CREATE_GLIDER) {
                            if (
                                !JXG.isPoint(board.objects[el]) &&
                                (board.objects[el].hasPoint(coords.scrCoords[1], coords.scrCoords[2])) &&
                                (board.objects[el].name.trim() != "") &&
                                /* TODO: Bisector and angle should not be interchangable modes due to glider associations. */
                                ((board.objects[el].elType == "curve") || (board.objects[el].elType == "arc") || (board.objects[el].elType == "sector") || (board.objects[el].elType == "normal") || (board.objects[el].elType == "parallel") || (board.objects[el].elType == "axis") || (board.objects[el].elType == "line") || (board.objects[el].elType == "circle") || (board.objects[el].elType == "bisector"))
                            ) {
                                parent = board.objects[el].name;
                                canCreate = true;
                            }
                        } 
                        else if (this.toolType == GeoTool.TT_CREATE_IMAGE) {
                            if (JXG.isPoint(board.objects[el]) &&
                                (board.objects[el].hasPoint(coords.scrCoords[1], coords.scrCoords[2])) &&
                                (board.objects[el].name.trim() != "")
                            ) {
                                parent = board.objects[el].name;
                                canCreate = true;
                            }
                        } else if (
                            JXG.isPoint(board.objects[el]) &&
                            board.objects[el].hasPoint(coords.scrCoords[1], coords.scrCoords[2])
                          ) {
                            canCreate = false;
                            break;
                        }
                    }
                    
                    if (canCreate) {
                        
                        this.temp = new Array();
                        this.temp[0] = pX;
                        this.temp[1] = pY;
                        this.temp[2] = parent;
                        
                        if (this.toolType == GeoTool.TT_CREATE_POINT) obj = initNew(boxnum, 'Point', this);
                        else if (this.toolType == GeoTool.TT_CREATE_LABEL) obj = initNew(boxnum, 'Label', this);
                        else if (this.toolType == GeoTool.TT_CREATE_GLIDER) obj = initNew(boxnum, 'Glider', this);
                        else if (this.toolType == GeoTool.TT_CREATE_IMAGE) obj = initNew(boxnum, 'Image', this);
                        ready = true;
                    };
                    this.state = 0;
                }
                
                if (ready) {
                    insertConstruct(boxnum, obj, editable, true);
                    
                    // Added to enable tutorial mode.
                    $('div#' + board.container).trigger('geoeditor_objectCreated', obj);
                }
            }
        }

        GeoTool.prototype.toolTypeStr = function(toolType) {
            switch (toolType) {
                case 0 : return 'TT_NONE';
                case 1 : return 'TT_SELECT';
                case 2 : return 'TT_MOVE_POINTS';
                case 3 : return 'TT_CREATE_POINT';
                case 4 : return 'TT_CREATE_LINE';
                case 5 : return 'TT_CREATE_CIRCLE';
                case 6 : return 'TT_CREATE_TRIANGLE';
                case 7 : return 'TT_CREATE_SCRIPTABLE';
                case 8 : return 'TT_CREATE_ANGLE';
                case 9 : return 'TT_CREATE_PARALLELOGRAM';
                case 10 : return 'TT_CREATE_LABEL';
                case 11 : return 'TT_CREATE_RHOMBUS';
                case 12 : return 'TT_CREATE_TRAPEZOID';
                case 13 : return 'TT_CREATE_RECTANGLE';
                case 14 : return 'TT_CREATE_GLIDER';
                case 15 : return 'TT_CREATE_ASSOCIATED_LINE';
                case 16 : return 'TT_CREATE_REGULAR_POLYGON';
                case 17 : return 'TT_CREATE_POLYGON';
                case 18 : return 'TT_CREATE_SQUARE';
                case 19 : return 'TT_CREATE_RESTRICTED_TRIANGLE';
                case 20 : return 'TT_CREATE_SECTOR';
                case 21 : return 'TT_CREATE_INTERSECTION';
                case 22 : return 'TT_CREATE_PARAMETRIC_CURVE';
                case 23 : return 'TT_CREATE_IMAGE';
                case 24 : return 'TT_CREATE_AXIS';
                default : return 'Unknown tool type';
            }
        }

        { // Constants for tool types.
            GeoTool.TT_NONE = 0;
            GeoTool.TT_SELECT = 1;
            GeoTool.TT_MOVE_POINTS = 2;
            GeoTool.TT_CREATE_POINT = 3;
            GeoTool.TT_CREATE_LINE  = 4;
            GeoTool.TT_CREATE_CIRCLE = 5;
            GeoTool.TT_CREATE_TRIANGLE = 6;
            GeoTool.TT_CREATE_SCRIPTABLE = 7;
            GeoTool.TT_CREATE_ANGLE = 8;
            GeoTool.TT_CREATE_PARALLELOGRAM = 9;
            GeoTool.TT_CREATE_LABEL = 10;
            GeoTool.TT_CREATE_RHOMBUS = 11;
            GeoTool.TT_CREATE_TRAPEZOID = 12;
            GeoTool.TT_CREATE_RECTANGLE = 13;
            GeoTool.TT_CREATE_GLIDER = 14;
            GeoTool.TT_CREATE_ASSOCIATED_LINE = 15;
            GeoTool.TT_CREATE_REGULAR_POLYGON = 16;
            GeoTool.TT_CREATE_POLYGON = 17;
            GeoTool.TT_CREATE_SQUARE = 18;
            GeoTool.TT_CREATE_RESTRICTED_TRIANGLE = 19;
            GeoTool.TT_CREATE_SECTOR = 20;
            GeoTool.TT_CREATE_INTERSECTION = 21;
            GeoTool.TT_CREATE_PARAMETRIC_CURVE = 22;
            GeoTool.TT_CREATE_IMAGE = 23;
            GeoTool.TT_CREATE_AXIS = 24;
        }

        var generateTool = function(toolData) {
            return new GeoTool(toolData, GeoTool.TT_NONE, 0);   
        }

        var setTool = function(boxnum, type) {
            var tool = generateTool(getGeoToolData(boxnum));
            tool.state = 0;
            
            switch (type) {
                case 'None' : tool.toolType = GeoTool.TT_NONE; break;
                case 'Move' : tool.toolType = GeoTool.TT_MOVE_POINTS; break;
                case 'Point' : tool.toolType = GeoTool.TT_CREATE_POINT; break;
                case 'Line' : tool.toolType = GeoTool.TT_CREATE_LINE; break;
                case 'Axis' : tool.toolType = GeoTool.TT_CREATE_AXIS; break;
                case 'Circle' : tool.toolType = GeoTool.TT_CREATE_CIRCLE; break;
                case 'Triangle' : tool.toolType = GeoTool.TT_CREATE_TRIANGLE; break;
                case 'Angle' : tool.toolType = GeoTool.TT_CREATE_ANGLE; break;
                case 'Parallelogram' : tool.toolType = GeoTool.TT_CREATE_PARALLELOGRAM; break;
                case 'Label' : tool.toolType = GeoTool.TT_CREATE_LABEL; break;
                case 'Rhombus' : tool.toolType = GeoTool.TT_CREATE_RHOMBUS; break;
                case 'Trapezoid' : tool.toolType = GeoTool.TT_CREATE_TRAPEZOID; break;
                case 'Rectangle' : tool.toolType = GeoTool.TT_CREATE_RECTANGLE; break;
                case 'Glider' : tool.toolType = GeoTool.TT_CREATE_GLIDER; break;
                case 'AssociatedLine' : tool.toolType = GeoTool.TT_CREATE_ASSOCIATED_LINE; break;
                case 'RegularPolygon' : tool.toolType = GeoTool.TT_CREATE_REGULAR_POLYGON; break;
                case 'Polygon' : tool.toolType = GeoTool.TT_CREATE_POLYGON; break;
                case 'Square' : tool.toolType = GeoTool.TT_CREATE_SQUARE; break;
                case 'RestrictedTriangle' : tool.toolType = GeoTool.TT_CREATE_RESTRICTED_TRIANGLE; break;
                case 'Sector' : tool.toolType = GeoTool.TT_CREATE_SECTOR; break;
                case 'Intersection' : tool.toolType = GeoTool.TT_CREATE_INTERSECTION; break;
                case 'Image' : tool.toolType = GeoTool.TT_CREATE_IMAGE; break;
                case 'ParametricCurve' : tool.toolType = GeoTool.TT_CREATE_PARAMETRIC_CURVE; break;
                case 'Scriptable' : tool.toolType = GeoTool.TT_CREATE_SCRIPTABLE; break;
            }
            setGeoToolData(boxnum, tool);
            
        }

        /**
         * Loads the tool data from it's container.
         * 
         * boxnum: Index / ID number of the editor.
         */
        var getGeoToolData = function(boxnum) {
            if ($('div#toolBox-' + boxnum).text().trim() == "") return null;
            return JSON.parse($('div#toolBox-' + boxnum).text());
        }

        /**
         * Saves the tool data to it's container.
         * 
         * boxnum: Index / ID number of the editor.
         * data: The tool object to be saved.
         */
        var setGeoToolData = function(boxnum, data) {
            $('div#toolBox-' + boxnum).text(JSON.stringify(data));
        }

        var fetchNext = function(nextID) {
            if (nextID.substring(nextID.length - 1, nextID.length) == "Z")
                nextID = nextID.substring(0, nextID.length - 1) + 'AA';
            else
                nextID = nextID.substring(0, nextID.length - 1) +
                    String.fromCharCode(nextID.charCodeAt(nextID.length - 1) + 1);
            return nextID;
        }

        var getNextFreePointId = function(sceneArr, sceneNum, initialValue) {
            
            var nextID = initialValue;
                    
            var i = 0;
            var startOver = false;
            while (i < sceneArr[sceneNum].objects.length) {
                if ( (sceneArr[sceneNum].objects[i].type == 'Point') ||
                     (sceneArr[sceneNum].objects[i].type == 'Glider') ) {
                    if (sceneArr[sceneNum].objects[i].name == nextID) {
                        nextID = fetchNext(nextID);
                        startOver = true;
                    }
                }
                else if (sceneArr[sceneNum].objects[i].type == 'RegularPolygon') {
                    
                    // Only the points in the middle are interresting.
                    for (var j = 2; j < sceneArr[sceneNum].objects[i].pArr.length - 1; ++j )
                        if (sceneArr[sceneNum].objects[i].pArr[j] == nextID) {
                            nextID = fetchNext(nextID);
                            startOver = true;
                        }
                }
                
                if (startOver) {
                    i = 0;
                    startOver = false;
                }
                else ++i;
                
            }
            return nextID;
        }

        /**
         * Creates a new element of defined type with default values.
         *
         * boxnum: Index / ID number of the editor.
         * typeStr: Type of the object. Possible values are
         *          Point, Line, Circle, Triangle and Scriptable.
         */
        var initNew = function(boxnum, typeStr, initParams) {
            var sceneNum = parseInt($('#previewBox-' + boxnum).find('.currentjessiebutton').eq(0).attr('tab'));
            var sceneArr = generateSceneArr(getGeoSceneData(boxnum));
            
            switch (typeStr) {
                case 'Glider' :
                case 'Point' : {
                    
                    var nextID = getNextFreePointId(sceneArr, sceneNum, 'A');
                    
                    if (typeStr == 'Point') return new GeoPoint({ 'x': initParams.temp[0], 'y': initParams.temp[1], 'name': nextID});
                    else if (typeStr == 'Glider') return new GeoGlider({ 'parent' : initParams.temp[2], 'x' : initParams.temp[0], 'y' : initParams.temp[1], 'name' : nextID });
                }
                default : {
                    var count = 0;      
                    var angleNames = ["alpha", "beta", "gamma", "delta",
                        "epsilon", "zeta", "eta", "theta", "iota", "kappa",
                        "lambda", "mu", "nu", "xi", "omicron", "pi", "rho",
                        "sigmaf", "sigma", "tau", "upsilon", "phi", "chi",
                        "psi", "omega"];
                            
                    for (var i = 0; i < sceneArr[sceneNum].objects.length; ++i )
                        if (sceneArr[sceneNum].objects[i].type == typeStr) ++count;
                    
                    if (typeStr == 'Line') return new GeoLine({ 'p1' : initParams.temp[0], 'p2' : initParams.temp[1], 'name' : 'l' + initParams.temp[0] + initParams.temp[1] });
                    else if (typeStr == 'Axis') return new GeoAxis({ 'p1' : initParams.temp[0], 'p2' : initParams.temp[1], 'name' : 'axis' + (count + 1) });
                    else if (typeStr == 'Image') return new GeoImage({ 'p1' : initParams.temp[2], 'name' : 'img' + (count + 1) });
                    else if (typeStr == 'Intersection') return new GeoIntersection({ 'o1' : initParams.temp[0], 'o2' : initParams.temp[1], 'name' : 'i' + (count + 1) });
                    else if (typeStr == 'RegularPolygon') return new GeoRegularPolygon({ 'p1' : initParams.temp[0], 'p2' : initParams.temp[1], 'name' : 'v' + (count + 1) });
                    else if (typeStr == 'Square') return new GeoSquare({ 'p1' : initParams.temp[0], 'p2' : initParams.temp[1], 'name' : 'sqr' + (count + 1) });
                    else if (typeStr == 'AssociatedLine') return new GeoAssociatedLine({'p1' : initParams.temp[0], 'p2' : initParams.temp[1], 'name' : 'a' + (count + 1), 'p2Type' : initParams.temp[2] });
                    else if (typeStr == 'Circle') return new GeoCircle({ 'p1' : initParams.temp[0], 'p2' : initParams.temp[1], 'name' : 'c' + (count + 1) });
                    else if (typeStr == 'Triangle') return new GeoTriangle({ 'p1' : initParams.temp[0], 'p2' : initParams.temp[1], 'p3' : initParams.temp[2], 'name' : 't' + (count + 1) });
                    else if (typeStr == 'Sector') return new GeoSector({ 'p1' : initParams.temp[0], 'p2' : initParams.temp[1], 'p3' : initParams.temp[2], 'name' : 'se' + (count + 1) });
                    else if (typeStr == 'RestrictedTriangle') return new GeoRestrictedTriangle({'p1' : initParams.temp[0], 'p2' : initParams.temp[1], 'name' : 'rt' + (count + 1) });
                    else if (typeStr == 'Angle') return new GeoAngle({ 'p1' : initParams.temp[0], 'p2' : initParams.temp[1], 'p3' : initParams.temp[2], 'name' : '&' + angleNames[count] + ';' });
                    else if (typeStr == 'Parallelogram') return new GeoParallelogram({ 'p1' : initParams.temp[0], 'p2' : initParams.temp[1], 'p3' : initParams.temp[2], 'name' : 'q' + (count + 1) });
                    else if (typeStr == 'Label') return new GeoLabel({ 'x' : initParams.temp[0], 'y' : initParams.temp[1], 'name' : 'Label ' + (count + 1) });
                    else if (typeStr == 'Rhombus') return new GeoRhombus({ 'p1' : initParams.temp[0], 'p2' : initParams.temp[1], 'name' : 'r' + (count + 1) });
                    else if (typeStr == 'Trapezoid') return new GeoTrapezoid({ 'p1' : initParams.temp[0], 'p2' : initParams.temp[1], 'p3' : initParams.temp[2], 'name' : 'u' + (count + 1) });
                    else if (typeStr == 'Rectangle') return new GeoRectangle({ 'p1' : initParams.temp[0], 'p2' : initParams.temp[1], 'name' : 'o' + (count + 1) });
                    else if (typeStr == 'ParametricCurve') return new GeoParametricCurve({ 'name' : 'Curve ' + (count + 1) });
                    else if (typeStr == 'Scriptable') return new GeoScriptable({ 'name' : 'Script ' + (count + 1) });
                    else return null;
                }
            }
        }

    }
    { /** Data objects            **/
        { // GeoPoint
            /**
             * Constructor for geometric point object.
             */ 
            var GeoPoint = function(params) {
                params = $.extend( {
                    'x' : null,
                    'y' : null,
                    'name' : null,
                    'showName' : true,
                    'visible' : true,
                    'fixed' : false,
                    'size' : 3,
                    'color' : '#f00'
                }, params);
                
                this.type = 'Point';
                this.size = params.size;
                this.x = params.x;
                this.y = params.y;
                this.name = params.name;
                this.showName = params.showName;
                this.visible = params.visible;
                this.fixed = params.fixed;
                this.color = params.color;
            }
            
            GeoPoint.prototype.nameStr = function(construction) {
                if (this.showName) {
                    
                    var result = this.name;
                    for (var property in this) {
                        result = result.replace(new RegExp('%' + property + '%', 'g'), this[property]);
                    }
                    return result;
                    
                } else return '';
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoPoint.prototype.iconCSS = 'pointBtn';
            
            GeoPoint.prototype.updateSceneData = function(index, construction, content) {

                // Update values to scene array.
                var p = findPointByName(this.name, construction);
                
                // Two decimal precision.
                var newX = parseInt(p.coords.usrCoords[1] * 100) / 100;
                var newY = parseInt(p.coords.usrCoords[2] * 100) / 100;
                
                this.x = (typeof(this.x == 'number') ? newX : this.x);
                this.y = (typeof(this.y == 'number') ? newY : this.y);

                if (this.showName) p.label.content.setText(this.nameStr(construction));
                // Update values to construct accordion.
                content.find('input#xCoordinate-' + index).val(newX);
                content.find('input#yCoordinate-' + index).val(newY);
            }

            /**
             * Convert a GeoPoint to JessieScript.
             */
            GeoPoint.prototype.asJessieScript = function() { /* Not used. */ return ""; }
            
            GeoPoint.prototype.asConstruct = function(board, construction) {
                var obj = this;
                var p = board.create(
                    'point',
                    [this.x, this.y],
                    {
                        name : this.name,
                        size : this.size,
                        withLabel : this.showName,
                        visible : this.visible,
                        fixed : this.fixed,
                        strokeColor: (!this.fixed ? this.color : '#000'),
                        fillColor: (!this.fixed ? this.color : '#000')
                    }
                );
                p.obj = obj;
                construction.points.push(p);
                construction[this.name] = p;
                if (this.showName) p.label.content.setText(this.nameStr(construction));
            }
            
            GeoPoint.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                var s = 
                '<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" type="text" size="5" value="' + this.name + '"/></span><br/>' +
                '<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + '/></span><br/>' +
                '<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + '/></span><br/>' +
                '<span class="geoItemCaption">Fixed: </span>' + '<span class="geoProperty"><input id="fixed-' + idNum + '" type="checkbox"' + (this.fixed ? ' checked="checked" ': '') + '/></span><br/>' +
                '<span class="geoItemCaption">Size: </span>' + '<span class="geoProperty"><input id="size-' + idNum + '" type="text" size="5" value="' + this.size + '"/></span><br/>' +
                '<span class="geoItemCaption">x-coordinate: </span>' + '<span class="geoProperty"><input id="xCoordinate-' + idNum + '" type="text" size="5" value="' + this.x + '"/></span><br/>' +
                '<span class="geoItemCaption">y-coordinate: </span>' + '<span class="geoProperty"><input id="yCoordinate-' + idNum + '" type="text" size="5" value="' + this.y + '"/></span><br/>';
                place.append(s);
                place.append('<span class="geoItemCaption">Color: </span>' + '<span class="geoProperty"><input id="color-' + idNum + '" type="text" size="8" value="' + this.color + '" /></span><br/>');
                place.find('input').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                
                //enterKeyUpdate = function(event, boxnum, editable) {
            }
            
            GeoPoint.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var fixed = content.find('input#fixed-' + idNum).is(':checked');
                var size = parseFloat(content.find('input#size-' + idNum).val());
                var x = parseFloat(content.find('input#xCoordinate-' + idNum).val());
                var y = parseFloat(content.find('input#yCoordinate-' + idNum).val());
                
                if (isNaN(x)) x = content.find('input#xCoordinate-' + idNum).val();
                if (isNaN(y)) y = content.find('input#yCoordinate-' + idNum).val();
                
                var color = content.find('input#color-' + idNum).val();
                
                return new GeoPoint({'x' : x, 'y' : y, 'size' : size, 'name' : name_Str, 'showName' : showName, 'visible' : visible, 'fixed' : fixed, 'color' : color});
            }
        }
        { // GeoImage
            /**
             * Constructor for geometric point object.
             */ 
            var GeoImage = function(params) {
                
                params = $.extend( {
                    'p1' : null,
                    'p2' : null,
                    'offsetX' : 0,
                    'offsetY' : 0,
                    'width' : 1,
                    'height' : 1,
                    'name' : null,
                    'showName' : true,
                    'visible' : true,
                    'fixed' : false,
                    'path' : '',
                    'opacity' : 1.0
                }, params);
                
                this.type = 'Image';
                this.p1 = params.p1;
                this.p2 = params.p2;
                this.width = params.width;
                this.height = params.height;
                this.name = params.name;
                this.showName = params.showName;
                this.visible = params.visible;
                this.fixed = params.fixed;
                this.path = params.path;
                this.offsetX = params.offsetX;
                this.offsetY = params.offsetY;
                this.opacity = params.opacity;
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoImage.prototype.iconCSS = 'imageBtn';
            
            GeoImage.prototype.updateSceneData = function(index, construction, content) { /* Not used. */ }

            /**
             * Convert a GeoPoint to JessieScript.
             */
            GeoImage.prototype.asJessieScript = function() { /* Not used. */ return ""; }
            
            GeoImage.prototype.asConstruct = function(board, construction) {
                
                var p = findPointByName(this.p1, construction);
                var parent = this;
                
                var img = board.create(
                    'image',
                    [this.path, [function(){return p.X() + parent.offsetX;},function(){return p.Y() + parent.offsetY;}], [this.width, this.height]],
                    {
                        name : this.name,
                        withLabel : this.showName,
                        visible : this.visible,
                        fixed : this.fixed,
                        fillOpacity : this.opacity,
                        strokeOpacity : this.opacity,
                        layer : 4
                    }
                );
                //construction.images.push(p);
                //construction[this.name] = p;
            }
            
            GeoImage.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                var s = 
                '<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" type="text" size="5" value="' + this.name + '"/></span><br/>' +
                '<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + '/></span><br/>' +
                '<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + '/></span><br/>' +
                '<span class="geoItemCaption">Fixed: </span>' + '<span class="geoProperty"><input id="fixed-' + idNum + '" type="checkbox"' + (this.fixed ? ' checked="checked" ': '') + '/></span><br/>' +
                '<span class="geoItemCaption">Image origin: </span>' + '<span class="geoProperty"><input id="p1-' + idNum + '" type="text" size="5" value="' + this.p1 + '"/></span><br/>' +
                '<span class="geoItemCaption">Width: </span>' + '<span class="geoProperty"><input id="width-' + idNum + '" type="text" size="5" value="' + this.width + '"/></span><br/>' +
                '<span class="geoItemCaption">Height: </span>' + '<span class="geoProperty"><input id="height-' + idNum + '" type="text" size="5" value="' + this.height + '"/></span><br/>' + 
                '<span class="geoItemCaption">x-offset: </span>' + '<span class="geoProperty"><input id="offsetX-' + idNum + '" type="text" size="5" value="' + this.offsetX + '"/></span><br/>' +
                '<span class="geoItemCaption">y-offset: </span>' + '<span class="geoProperty"><input id="offsetY-' + idNum + '" type="text" size="5" value="' + this.offsetY + '"/></span><br/>' + 
                '<span class="geoItemCaption">Opacity: </span>' + '<span class="geoProperty"><input id="opacity-' + idNum + '" type="text" size="5" value="' + this.opacity + '"/></span><br/>' +
                '<span class="geoItemCaption">Path: </span>' + '<span class="geoProperty"><input id="path-' + idNum + '" type="text" size="8" value="' + this.path + '"/></span><br/>';
                place.append(s);
                place.find('input').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                
                //enterKeyUpdate = function(event, boxnum, editable) {
            }
            
            GeoImage.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var fixed = content.find('input#fixed-' + idNum).is(':checked');
                var p1 = content.find('input#p1-' + idNum).val();
                var offsetX = parseFloat(content.find('input#offsetX-' + idNum).val());
                var offsetY = parseFloat(content.find('input#offsetY-' + idNum).val());
                var width = parseFloat(content.find('input#width-' + idNum).val());
                var height = parseFloat(content.find('input#height-' + idNum).val());
                var opacity = parseFloat(content.find('input#opacity-' + idNum).val());
                
                var path = content.find('input#path-' + idNum).val();
                
                return new GeoImage({'p1' : p1, 'width' : width, 'height' : height, 'offsetX' : offsetX, 'offsetY' : offsetY, 'opacity' : opacity, 'name' : name_Str, 'showName' : showName, 'visible' : visible, 'fixed' : fixed, 'path' : path});
            }
        }
        { // GeoLine
            /**
             * Constructor for geometric line object.
             */
            var GeoLine = function(params) {
                params = $.extend( {
                    'p1' : null,
                    'p2' : null,
                    'firstArrow' : false,
                    'lastArrow' : false,
                    'name' : null,
                    'dash' : 0,
                    'lineType' : 'lineSegment',
                    'showName' : true,
                    'visible' : true,
                    'color' : '#00f',
                    'strokeWidth' : 2,
                    'labelOffset' : [10, 10]
                }, params);
                
                this.type = 'Line';
                this.p1 = params.p1;
                this.p2 = params.p2;
                this.strokeWidth = params.strokeWidth;
                this.firstArrow = params.firstArrow;
                this.lastArrow = params.lastArrow;
                this.name = params.name;
                this.dash = params.dash;
                this.lineType = params.lineType;
                this.showName = params.showName;
                this.visible = params.visible;
                this.color = params.color;
                this.labelOffset = params.labelOffset;
            }
            
            GeoLine.prototype.nameStr = function(construction) {
                if (this.showName) {
                    
                    var result = this.name;
                    for (var property in this) {
                        result = result.replace(new RegExp('%' + property + '%', 'g'), this[property]);
                    }
                    return result;
                    
                } else return '';
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoLine.prototype.iconCSS = 'lineBtn';
            
            GeoLine.prototype.updateSceneData = function(index, construction, content) {
                
                var point1 = findPointByName(this.p1, construction);
                var point2 = findPointByName(this.p2, construction);
                
                this.length = Math.round(Math.sqrt( Math.pow(point1.X() - point2.X(), 2) + Math.pow(point1.Y() - point2.Y(), 2) ) * 100) / 100;
                
                if (Math.abs(point1.X() - point2.X()) >= 0.00001)
                    this.slope = Math.round(( ( point2.Y() - point1.Y() ) / (point2.X() - point1.X()) ) * 100) / 100;
                else this.slope = '?';
                
                var p = findPointByName('labelOf' + this.name, construction);
                if (this.showName) p.label.content.setText(this.nameStr(construction));
            }
            
            /**
             * Convert a GeoLine to JessieScript.
             */
            GeoLine.prototype.asJessieScript = function() { return ""; /* Not used. */ }
            
            GeoLine.prototype.asConstruct = function(board, construction) {
                var line = board.create(
                    'line',
                    [this.p1, this.p2],
                    {
                        // Options here.
                        visible : this.visible,
                        name : this.name,
                        withLabel : false,
                        straightFirst : ((this.lineType == 'line') || (this.lineType == 'startingLine')),
                        straightLast : ((this.lineType == 'line') || (this.lineType == 'endingLine')),
                        firstArrow : this.firstArrow,
                        lastArrow : this.lastArrow,
                        dash : this.dash,
                        strokeWidth : this.strokeWidth,
                        color : this.color,
                        label : {
                            fixed : false
                        }
                    }
                );
                var labelPoint = board.create(
                    'point',
                    [
                        function (){ return ((line.point1.X() + line.point2.X()) / 2); },
                        function (){ return ((line.point1.Y() + line.point2.Y()) / 2); }
                    ],
                    {
                        // Options here.
                        visible : this.visible,
                        fixed : true,
                        name : 'labelOf' + this.name,
                        withLabel : this.showName,
                        isLabel : true,
                        size : -1,
                        label : {
                            offset : this.labelOffset,
                            fixed : false
                        }
                    }
                );
                
                construction.points.push(labelPoint);
                construction['labelOf' + this.name] = labelPoint;
                construction.lines.push(line);
                
                if (typeof labelPoint.label.content != 'undefined') {
                    this.updateSceneData(null, construction, null);
                }
            }
            
            GeoLine.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" type="text" size="5" value="' + this.name + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Arrow at start: </span>' + '<span class="geoProperty"><input id="firstArrow-' + idNum + '" type="checkbox"' + (this.firstArrow ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Arrow at end: </span>' + '<span class="geoProperty"><input id="lastArrow-' + idNum + '" type="checkbox"' + (this.lastArrow ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">First point label: </span>' + '<span class="geoProperty"><input id="firstPoint-' + idNum + '" type="text" size="5" value="' + this.p1 + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Second point label: </span>' + '<span class="geoProperty"><input id="secondPoint-' + idNum + '" type="text" size="5" value="' + this.p2 + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Stroke width: </span>' + '<span class="geoProperty"><input id="strokeWidth-' + idNum + '" type="text" size="5" value="' + this.strokeWidth + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Color: </span>' + '<span class="geoProperty"><input id="color-' + idNum + '" type="text" size="8" value="' + this.color + '" /></span><br/>');
                place.append('<input id="labelOffset-' + idNum + '" type="hidden" value="' + JSON.stringify(this.labelOffset) + '"/>');
                
                place.append('<span class="geoItemCaption">Line type: </span><select id="' + 'lineSelect-' + idNum + '"></select><br/>');
                var lineSelect = place.find('select#lineSelect-' + idNum);
                    lineSelect.append('<option value="line"' + (this.lineType == 'line' ? ' selected="selected" ': '') + '>Line</option>');
                    lineSelect.append('<option value="lineSegment"' + (this.lineType == 'lineSegment' ? ' selected="selected" ': '') + '>Line segment</option>');
                    lineSelect.append('<option value="endingLine"' + (this.lineType == 'endingLine' ? ' selected="selected" ': '') + '>Starting line segment</option>');
                    lineSelect.append('<option value="startingLine"' + (this.lineType == 'startingLine' ? ' selected="selected" ': '') + '>Ending line segment</option>');
                
                place.append('<span class="geoItemCaption">Line style: </span><select id="' + 'dashSelect-' + idNum + '"></select>');
                var dashSelect = place.find('select#dashSelect-' + idNum);
                for (var i = 0; i < 7; ++i)
                    dashSelect.append('<option value="' + i + '"' + (this.dash == i ? ' selected="selected" ': '') + '>' + dashStr[i] + '</option>');

                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
                

            }

            GeoLine.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var firstArrow = content.find('input#firstArrow-' + idNum).is(':checked');
                var lastArrow = content.find('input#lastArrow-' + idNum).is(':checked');
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var p1 = content.find('input#firstPoint-' + idNum).val();
                var p2 = content.find('input#secondPoint-' + idNum).val();
                var lineType = content.find('select#lineSelect-' + idNum).val();
                var strokeWidth = parseFloat(content.find('input#strokeWidth-' + idNum).val());
                var dash = parseInt(content.find('select#dashSelect-' + idNum).val());
                var color = content.find('input#color-' + idNum).val();
                var labelOffset = JSON.parse(content.find('input#labelOffset-' + idNum).val());

                return new GeoLine({'p1' : p1, 'p2' : p2, 'lineType' : lineType, 'name' : name_Str, 'strokeWidth' : strokeWidth, 'showName' : showName, 'visible' : visible, 'firstArrow' : firstArrow, 'lastArrow' : lastArrow, 'dash' : dash, 'color' : color, 'labelOffset' : labelOffset});
            }
        }
        { // GeoAxis
            /**
             * Constructor for geometric line object.
             */
            var GeoAxis = function(params) {
                params = $.extend( {
                    'p1' : null,
                    'p2' : null,
                    'name' : null,
                    'lineType' : 'line',
                    'visible' : true,
                    'color' : '#000',
                    'majorTickDistance' : 1,
                    'minorTicks' : 9,
                    'majorTickHeight' : 20,
                    'minorTickHeight' : 8,
                    'drawLabels' : true
                }, params);
                
                this.type = 'Axis';
                this.p1 = params.p1;
                this.p2 = params.p2;
                this.name = params.name;
                this.lineType = params.lineType;
                this.drawLabels = params.drawLabels;
                this.visible = params.visible;
                this.color = params.color;
                this.majorTickDistance = params.majorTickDistance;
                this.minorTicks = params.minorTicks;
                this.majorTickHeight = params.majorTickHeight;
                this.minorTickHeight = params.minorTickHeight;
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoAxis.prototype.iconCSS = 'axisBtn';
            
            GeoAxis.prototype.updateSceneData = function(index, construction, content) { /* Not used. */ }
            
            /**
             * Convert a GeoLine to JessieScript.
             */
            GeoAxis.prototype.asJessieScript = function() { return ""; /* Not used. */ }
            
            GeoAxis.prototype.asConstruct = function(board, construction) {
                var axis = board.create(
                    'axis',
                    [this.p1, this.p2],
                    {
                        // Options here.
                        visible : this.visible,
                        name : this.name,
                        straightFirst : ((this.lineType == 'line') || (this.lineType == 'startingLine')),
                        straightLast : ((this.lineType == 'line') || (this.lineType == 'endingLine')),
                        color : this.color
                    }
                );
                axis.removeAllTicks();
                var ticks = board.create(
                    'ticks',
                    [axis, this.majorTickDistance],
                    {
                        drawLabels : this.drawLabels,
                        minorTicks : this.minorTicks,
                        majorTickHeight : this.majorTickHeight,
                        minorTickHeight : this.minorTickHeight,
                    }
                );
                if (construction.axes === undefined) construction.axes = new Array();
                construction.axes.push(axis);
            }
            
            GeoAxis.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" type="text" size="5" value="' + this.name + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Draw tick labels: </span>' + '<span class="geoProperty"><input id="drawLabels-' + idNum + '" type="checkbox"' + (this.drawLabels? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">First point label: </span>' + '<span class="geoProperty"><input id="firstPoint-' + idNum + '" type="text" size="5" value="' + this.p1 + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Second point label: </span>' + '<span class="geoProperty"><input id="secondPoint-' + idNum + '" type="text" size="5" value="' + this.p2 + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Major tick distance: </span>' + '<span class="geoProperty"><input id="matd-' + idNum + '" type="text" size="5" value="' + this.majorTickDistance + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Major tick height: </span>' + '<span class="geoProperty"><input id="math-' + idNum + '" type="text" size="5" value="' + this.majorTickHeight + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Minor ticks: </span>' + '<span class="geoProperty"><input id="mit-' + idNum + '" type="text" size="5" value="' + this.minorTicks + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Minor tick height: </span>' + '<span class="geoProperty"><input id="mith-' + idNum + '" type="text" size="5" value="' + this.minorTickHeight + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Color: </span>' + '<span class="geoProperty"><input id="color-' + idNum + '" type="text" size="8" value="' + this.color + '" /></span><br/>');
                
                place.append('<span class="geoItemCaption">Line type: </span><select id="' + 'lineSelect-' + idNum + '"></select><br/>');
                var lineSelect = place.find('select#lineSelect-' + idNum);
                    lineSelect.append('<option value="line"' + (this.lineType == 'line' ? ' selected="selected" ': '') + '>Line</option>');
                    lineSelect.append('<option value="lineSegment"' + (this.lineType == 'lineSegment' ? ' selected="selected" ': '') + '>Line segment</option>');
                    lineSelect.append('<option value="endingLine"' + (this.lineType == 'endingLine' ? ' selected="selected" ': '') + '>Starting line segment</option>');
                    lineSelect.append('<option value="startingLine"' + (this.lineType == 'startingLine' ? ' selected="selected" ': '') + '>Ending line segment</option>');
                
                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
                

            }

            GeoAxis.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var drawLabels = content.find('input#drawLabels-' + idNum).is(':checked');
                var p1 = content.find('input#firstPoint-' + idNum).val();
                var p2 = content.find('input#secondPoint-' + idNum).val();
                var matd = parseFloat(content.find('input#matd-' + idNum).val());
                var math = parseInt(content.find('input#math-' + idNum).val());
                var mit = parseInt(content.find('input#mit-' + idNum).val());
                var mith = parseInt(content.find('input#mith-' + idNum).val());
                var lineType = content.find('select#lineSelect-' + idNum).val();
                var color = content.find('input#color-' + idNum).val();
                
                return new GeoAxis({'p1' : p1, 'p2' : p2, 'lineType' : lineType, 'name' : name_Str, 'visible' : visible, 'drawLabels' : drawLabels, 'color' : color, 'majorTickDistance' : matd, 'majorTickHeight' : math, 'minorTicks' : mit, 'minorTickHeight' : mith});
            }
        }
        { // GeoIntersection
            /**
             * Constructor for geometric intersection object.
             */
            var GeoIntersection = function(params) {
                params = $.extend( {
                    'o1' : null,
                    'o2' : null,
                    'name' : null,
                    'showName' : true,
                    'visible' : true,
                    'color' : '#000',
                    'showPoints' : 'both'
                }, params);
                
                this.type = 'Intersection';
                this.o1 = params.o1;
                this.o2 = params.o2;
                this.name = params.name;
                this.showName = params.showName;
                this.visible = params.visible;
                this.color = params.color;
                this.showPoints = params.showPoints;
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoIntersection.prototype.iconCSS = 'intersectionBtn';
            
            GeoIntersection.prototype.updateSceneData = function(index, construction, content) { /* Not used. */ }
            
            /**
             * Convert a GeoLine to JessieScript.
             */
            GeoIntersection.prototype.asJessieScript = function() { /* Not used. */ return ""; }
            
            GeoIntersection.prototype.asConstruct = function(board, construction) {
                
                var doubleIntersection = (
                    (board.getElement(this.o1).elType == 'circle') ||
                    (board.getElement(this.o2).elType == 'circle')
                )
                
                construction.points.push(
                    board.create(
                        'intersection',
                        [this.o1, this.o2, 0],
                        {
                            visible : this.visible && ((this.showPoints === 'both') || (this.showPoints === 'first')),
                            name : this.name + "_1",
                            withLabel : this.showName,
                            strokeColor: this.color,
                            fillColor: this.color
                        }
                    )
                );
                construction.points.push(
                    board.create(
                        'intersection',
                        [this.o1, this.o2, 1],
                        {
                            visible : this.visible && doubleIntersection && ((this.showPoints === 'both') || (this.showPoints === 'second')),
                            name : this.name + "_2",
                            withLabel : this.showName,
                            strokeColor: this.color,
                            fillColor: this.color
                        }
                    )
                );
            }
            
            GeoIntersection.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" value="' + this.name + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">First line/circle label: </span>' + '<span class="geoProperty"><input id="firstObj-' + idNum + '" size="5" value="' + this.o1 + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Second line/circle label: </span>' + '<span class="geoProperty"><input id="secondObj-' + idNum + '" size="5" value="' + this.o2 + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Color: </span>' + '<span class="geoProperty"><input id="color-' + idNum + '" type="text" size="8" value="' + this.color + '" /></span><br/>');
                
                place.append('<span class="geoItemCaption">Show points: </span><select id="' + 'showSelect-' + idNum + '"></select><br/>');
                var showSelect = place.find('select#showSelect-' + idNum);
                    showSelect.append('<option value="both"' + (this.showPoints == 'both' ? ' selected="selected" ': '') + '>Both intersections</option>');
                    showSelect.append('<option value="first"' + (this.showPoints == 'first' ? ' selected="selected" ': '') + '>First intersection</option>');
                    showSelect.append('<option value="second"' + (this.showPoints == 'second' ? ' selected="selected" ': '') + '>Second intersection</option>');
                
                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
                
            }

            GeoIntersection.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var o1 = content.find('input#firstObj-' + idNum).val();
                var o2 = content.find('input#secondObj-' + idNum).val();
                var color = content.find('input#color-' + idNum).val();
                var showPoints = content.find('select#showSelect-' + idNum).val();
                
                return new GeoIntersection({'o1' : o1, 'o2' : o2, 'name' : name_Str, 'showPoints' : showPoints, 'showName' : showName, 'visible' : visible, 'color' : color});
            }
        }
        { // GeoPolygon             // TODO incomplete.
            /**
             * Constructor for regular polygon object.
             */
            var GeoPolygon = function(params) {
                params = $.extend( {
                    'pArr' : null,
                    'name' : null,
                    'dash' : 0,
                    'showName' : true,
                    'visible' : true,
                    'strokeColor' : '#00f',
                    'fillColor' : '#0000FF50'
                }, params);
                
                this.type = 'Polygon';
                this.pArr = params.pArr;
                this.name = params.name;
                this.dash = params.dash;
                this.showName = params.showName;
                this.visible = params.visible;
                this.strokeColor = params.strokeColor;
                this.fillColor = params.fillColor;
            }
            
            GeoPolygon.prototype.updateSceneData = function(index, construction, content) { /* Not used. */ }
            
            /**
             * Convert a GeoPolygon to JessieScript.
             */
            GeoPolygon.prototype.asJessieScript = function() { return ""; }
            
            GeoPolygon.prototype.asConstruct = function(board, construction) {
                for (var i = 0; i < this.pArr.length; ++i) {
                    construction.lines.push(
                        board.create(
                            'line',
                            [this.pArr[i], this.pArr[(i + 1) % this.pArr.length]],
                            {
                                // Options here.
                                visible : this.visible,
                                name : this.name,
                                withLabel : false,
                                dash : this.dash
                            }
                        )
                    );
                    
                    board.create(
                        'polygon',
                        this.pArr,
                        {
                            // Options here.
                            visible : this.visible,
                            name : this.name,
                            withLabel : false,
                            dash : this.dash
                        }
                    )
                }
            }
            
            GeoPolygon.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" value="' + this.name + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Stroke color: </span>' + '<span class="geoProperty"><input id="strokeColor-' + idNum + '" type="text" size="8" value="' + this.strokeColor + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Fill color: </span>' + '<span class="geoProperty"><input id="fillColor-' + idNum + '" type="text" size="8" value="' + this.fillColor + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Points: </span>' + '<textarea id="points-' + idNum + '" rows="5" cols="50">' + this.pArr + '</textarea><br/>');

                place.append('<span class="geoItemCaption">Line style: </span><select id="' + 'dashSelect-' + idNum + '" onchange="updateScene(' + boxnum + ', ' + editable + ');"></select>');
                var dashSelect = place.find('select#dashSelect-' + idNum);
                for (var i = 0; i < 7; ++i)
                    dashSelect.append('<option value="' + i + '"' + (this.dash == i ? ' selected="selected" ': '') + '>' + dashStr[i] + '</option>');
                    
                place.find('input, select, textarea').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
                

            }

            GeoPolygon.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var pArr = content.find('input#points-' + idNum).val().split(',');
                var dash = parseInt(content.find('select#dashSelect-' + idNum).val());
                var strokeColor = content.find('input#strokeColor-' + idNum).val();
                var fillColor = content.find('input#fillColor-' + idNum).val();
                
                return new GeoPolygon({'pArr' : pArr, 'name' : name_Str, 'showName' : showName, 'visible' : visible, 'dash' : dash, 'strokeColor' : strokeColor, 'fillColor' : fillColor});
            }
        }
        { // GeoRegularPolygon
            /**
             * Constructor for regular polygon object.
             */
            var GeoRegularPolygon = function(params) {
                
                params = $.extend( {
                    'p1' : null,
                    'p2' : null,
                    'n' : 6,
                    'name' : null,
                    'dash' : 0,
                    'showName' : true,
                    'filled' : true,
                    'strokeColor' : '#00f',
                    'fillColor' : '#0000FF50',
                    'pArr' : null,
                    'visible' : true,
                    'showGeneratedPoints' : true
                }, params);
                
                
                this.type = 'RegularPolygon';
                this.p1 = params.p1;
                this.p2 = params.p2;
                this.n = parseInt(params.n);
                this.name = params.name;
                this.dash = params.dash;
                this.showName = params.showName;
                this.filled = params.filled;
                this.strokeColor = params.strokeColor;
                this.fillColor = params.fillColor;
                this.showGeneratedPoints = params.showGeneratedPoints;
                this.pArr = (params.pArr == 'null' ? null : params.pArr);
                // Check validity.
                if (this.n < 3) this.n = 3;
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoRegularPolygon.prototype.iconCSS = 'regularpolygonBtn';
            
            GeoRegularPolygon.prototype.updateSceneData = function(index, construction, content) { /* Not used. */ }
            
            /**
             * Convert a GeoRegularPolygon to JessieScript.
             */
            GeoRegularPolygon.prototype.asJessieScript = function() {   return ""; }
            
            GeoRegularPolygon.prototype.asConstruct = function(board, construction) {
                var poly1 = board.create(
                    'regularpolygon',
                    [this.p1, this.p2, this.n],
                    {
                        // Options here.
                        visible : this.filled,
                        strokeColor : this.strokeColor,
                        borders : {
                            strokeWidth : 2,
                            highlightStrokeWidth : 2,
                            dash : this.dash
                        },
                        vertices: {
                            strokeColor : '#000',
                            fillColor : '#000',
                            layer: 6,
                            visible: this.showGeneratedPoints
                        },
                        fillColor : this.fillColor,
                        highlightFillColor : this.fillColor,
                        withLines : true,
                        orthoSensitivity : 0.5,
                        name : this.name,
                        withLabel : this.showName
                    }
                );
                
                this.pArr = new Array();
                for (var i = 0; i < poly1.vertices.length; ++i) {           
                    construction.points.push(poly1.vertices[i]);
                    this.pArr[i] = poly1.vertices[i].name;
                }       
            }
            
            GeoRegularPolygon.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" value="' + this.name + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Filled: </span>' + '<span class="geoProperty"><input id="filled-' + idNum + '" type="checkbox"' + (this.filled ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Show generated points: </span>' + '<span class="geoProperty"><input id="showGeneratedPoints-' + idNum + '" type="checkbox"' + (this.showGeneratedPoints ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">First point label: </span>' + '<span class="geoProperty"><input id="firstPoint-' + idNum + '" size="5" value="' + this.p1 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Second point label: </span>' + '<span class="geoProperty"><input id="secondPoint-' + idNum + '" size="5" value="' + this.p2 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">N: </span>' + '<span class="geoProperty"><input id="n-' + idNum + '" size="5" value="' + this.n + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Stroke color: </span>' + '<span class="geoProperty"><input id="strokeColor-' + idNum + '" type="text" size="8" value="' + this.strokeColor + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Fill color: </span>' + '<span class="geoProperty"><input id="fillColor-' + idNum + '" type="text" size="8" value="' + this.fillColor + '" /></span><br/>');
                place.append('<input id="pArr-' + idNum + '" type="hidden" value="' + this.pArr + '"/>');

                place.append('<span class="geoItemCaption">Line style: </span><select id="' + 'dashSelect-' + idNum + '"></select>');
                var dashSelect = place.find('select#dashSelect-' + idNum);
                for (var i = 0; i < 7; ++i)
                    dashSelect.append('<option value="' + i + '"' + (this.dash == i ? ' selected="selected" ': '') + '>' + dashStr[i] + '</option>');

                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
            }

            GeoRegularPolygon.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var filled = content.find('input#filled-' + idNum).is(':checked');
                var p1 = content.find('input#firstPoint-' + idNum).val();
                var p2 = content.find('input#secondPoint-' + idNum).val();
                var n = content.find('input#n-' + idNum).val();
                var pArr = (content.find('input#pArr-' + idNum).val()).split(',');
                var dash = parseInt(content.find('select#dashSelect-' + idNum).val());
                var strokeColor = content.find('input#strokeColor-' + idNum).val();
                var fillColor = content.find('input#fillColor-' + idNum).val();
                var showGeneratedPoints = content.find('input#showGeneratedPoints-' + idNum).is(':checked');
                
                return new GeoRegularPolygon({'p1' : p1, 'p2' : p2, 'n' : n, 'name' : name_Str, 'showName' : showName, 'filled' : filled, 'dash' : dash, 'pArr' : pArr, 'strokeColor' : strokeColor, 'fillColor' : fillColor, 'showGeneratedPoints' : showGeneratedPoints });
            }
        }
        { // GeoAssociatedLine
            /**
             * Constructor for geometric line object.
             */
            var GeoAssociatedLine = function(params) {
                
                params = $.extend( {
                    'p1' : null,
                    'p2' : null,
                    'name' : null,
                    'dash' : 0,
                    'showName' : true,
                    'visible' : true,
                    'associationType' : 'normal',
                    'p2Type' : null,
                    'color' : '#00f'
                }, params);
                
                this.type = 'AssociatedLine';
                this.p1 = params.p1;
                this.p2 = params.p2;
                this.name = params.name;
                this.dash = params.dash;
                this.showName = params.showName;
                this.visible = params.visible;
                this.associationType = params.associationType;
                this.p2Type = params.p2Type;
                this.color = params.color;
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoAssociatedLine.prototype.iconCSS = 'associatedlineBtn';
            
            GeoAssociatedLine.prototype.updateSceneData = function(index, construction, content) { /* Not used. */ }
            
            /**
             * Convert a GeoLine to JessieScript.
             */
            GeoAssociatedLine.prototype.asJessieScript = function() {   return ""; /* Not used. */  }
            
            GeoAssociatedLine.prototype.asConstruct = function(board, construction) {
                if ((this.p2Type == 'Line') || (this.associationType == 'normal')) {
                    construction.lines.push(
                        board.create(
                            this.associationType,
                            [this.p1, this.p2],
                            {
                                visible : this.visible,
                                name : this.name,
                                withLabel : this.showName,
                                dash : this.dash,
                                color: this.color
                            }
                        )
                    );
                    
                }
                else if (this.p2Type == 'Circle')
                    construction.lines.push(
                        board.create(
                            'tangent',
                            [this.p1, this.p2],
                            {
                                visible : this.visible,
                                name : this.name,
                                withLabel : this.showName,
                                dash : this.dash,
                                color : this.color
                            }
                        )
                    );
            }
            
            GeoAssociatedLine.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" value="' + this.name + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Associated point label: </span>' + '<span class="geoProperty"><input id="firstPoint-' + idNum + '" size="5" value="' + this.p1 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Associated line / circle label:  </span>' + '<span class="geoProperty"><input id="secondPoint-' + idNum + '" size="5" value="' + this.p2 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Color: </span>' + '<span class="geoProperty"><input id="color-' + idNum + '" type="text" size="8" value="' + this.color + '" /></span><br/>');
                place.append('<input id="p2Type-' + idNum + '" type="hidden" value="' + this.p2Type + '"/>');
                
                place.append('<span class="geoItemCaption">Association type:  </span><select id="associationSelect-' + idNum + '"></select><br/>');
                var associationSelect = place.find('select#associationSelect-' + idNum);
                    associationSelect.append('<option value="normal"' + (this.associationType == 'normal' ? ' selected="selected" ': '') + '>Normal</option>');
                    associationSelect.append('<option value="parallel"' + (this.associationType == 'parallel' ? ' selected="selected" ': '') + '>Parallel</option>');

                place.append('<span class="geoItemCaption">Line style: </span><select id="' + 'dashSelect-' + idNum + '"></select>');
                var dashSelect = place.find('select#dashSelect-' + idNum);
                for (var i = 0; i < 7; ++i)
                    dashSelect.append('<option value="' + i + '"' + (this.dash == i ? ' selected="selected" ': '') + '>' + dashStr[i] + '</option>');

                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
            }

            GeoAssociatedLine.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var p1 = content.find('input#firstPoint-' + idNum).val();
                var p2 = content.find('input#secondPoint-' + idNum).val();
                var associationType = content.find('select#associationSelect-' + idNum).val();
                var dash = parseInt(content.find('select#dashSelect-' + idNum).val());
                var p2Type = content.find('input#p2Type-' + idNum).val();
                var color = content.find('input#color-' + idNum).val();
                
                return new GeoAssociatedLine({'p1' : p1, 'p2' : p2, 'name' : name_Str, 'showName' : showName, 'visible' : visible, 'dash' : dash, 'associationType' : associationType, 'p2Type' : p2Type, 'color' : color});
            }
        }
        { // GeoCircle
            /**
             * Constructor for geometric circle object.
             */
            var GeoCircle = function(params) {
                
                params = $.extend( {
                    'p1' : null,
                    'p2' : null,
                    'name' : null,
                    'dash' : 0,
                    'showName' : true,
                    'visible' : true,
                    'strokeColor' : '#00f',
                    'fillColor' : 'none'
                }, params);
                
                this.type = 'Circle';
                this.p1 = params.p1;
                this.p2 = params.p2;
                this.name = params.name;
                this.showName = params.showName;
                this.visible = params.visible;
                this.dash = params.dash;
                this.strokeColor = params.strokeColor;
                this.fillColor = params.fillColor;
                
                // Fallback for the older versions.
                if (typeof params.color != 'undefined') this.strokeColor = params.color;
            }
            
            GeoCircle.prototype.nameStr = function(construction) {
                if (this.showName) {
                    
                    var result = this.name;
                    for (var property in this) {
                        result = result.replace(new RegExp('%' + property + '%', 'g'), this[property]);
                    }
                    return result;
                    
                } else return '';
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoCircle.prototype.iconCSS = 'circleBtn';
            
            GeoCircle.prototype.updateSceneData = function(index, construction, content) {
                
                var point1 = findPointByName(this.p1, construction);
                if (isNaN(this.p2)) {
                    var point2 = findPointByName(this.p2, construction);
                    this.radius = Math.round(Math.sqrt( Math.pow(point1.X() - point2.X(), 2) + Math.pow(point1.Y() - point2.Y(), 2) ) * 100) / 100;
                } else this.radius = parseFloat(this.p2);
                
                this.area = Math.round(Math.PI * Math.pow(this.radius, 2)* 100) / 100;
                this.circumference = Math.round(2 * Math.PI * this.radius * 100) / 100;
                
                var c = findTypeByName('circles', this.name, construction);
                if (this.showName) c.label.content.setText(this.nameStr(construction));
            }
            /**
             * Convert a GeoCircle to JessieScript.
             */
            GeoCircle.prototype.asJessieScript = function() {   return ""; /* Not used. */ }
            
            GeoCircle.prototype.asConstruct = function(board, construction) {
                var c1 = board.create(
                    'circle',
                    [this.p1, this.p2],
                    {
                        visible : this.visible,
                        withLabel : this.showName,
                        name : this.name,
                        dash : this.dash,
                        strokeColor : this.strokeColor,
                        fillColor : this.fillColor,
                        highlightFillColor : this.fillColor
                    }
                );
                construction.circles.push(c1);
                construction[this.name] = c1;
                
                this.updateSceneData(null, construction, null);
            }
            
            GeoCircle.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" value="' + this.name + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Center point label: </span>'+ '<span class="geoProperty"><input id="firstPoint-' + idNum + '" size="5" value="' + this.p1 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Circle point label or radius: </span>' + '<span class="geoProperty"><input id="secondPoint-' + idNum + '" size="5" value="' + this.p2 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Stroke color: </span>' + '<span class="geoProperty"><input id="strokeColor-' + idNum + '" type="text" size="8" value="' + this.strokeColor + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Fill color: </span>' + '<span class="geoProperty"><input id="fillColor-' + idNum + '" type="text" size="8" value="' + this.fillColor + '" /></span><br/>');

                place.append('<span class="geoItemCaption">Line style: </span><span class="geoProperty"><select id="' + 'dashSelect-' + idNum + '"></select></span>');
                var dashSelect = place.find('select#dashSelect-' + idNum);
                for (var i = 0; i < 7; ++i)
                    dashSelect.append('<option value="' + i + '"' + (this.dash == i ? ' selected="selected" ': '') + '>' + dashStr[i] + '</option>');

                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
                
            }   
            
            GeoCircle.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var p1 = content.find('input#firstPoint-' + idNum).val();
                var p2 = content.find('input#secondPoint-' + idNum).val();
                var dash = parseInt(content.find('select#dashSelect-' + idNum).val());
                var strokeColor = content.find('input#strokeColor-' + idNum).val();
                var fillColor = content.find('input#fillColor-' + idNum).val();
                
                return new GeoCircle({'p1' : p1, 'p2' : p2, 'name' : name_Str, 'showName' : showName, 'visible' : visible, 'dash' : dash, 'strokeColor' : strokeColor, 'fillColor' : fillColor});
            }
        }
        { // GeoParametricCurve
            /**
             * Constructor for geometric circle object.
             */
            var GeoParametricCurve = function(params) {
                
                params = $.extend( {
                    'fx' : 't',
                    'fy' : 't',
                    'tMin' : -10,
                    'tMax' : 10,
                    'name' : null,
                    'dash' : 0,
                    'showName' : true,
                    'visible' : true,
                    'strokeColor' : '#00f',
                    'fillColor' : 'none'
                }, params);
                
                this.type = 'ParametricCurve';
                this.fx = params.fx;
                this.fy = params.fy;
                this.tMin = params.tMin;
                this.tMax = params.tMax;
                this.name = params.name;
                this.showName = params.showName;
                this.visible = params.visible;
                this.dash = params.dash;
                this.strokeColor = params.strokeColor;
                this.fillColor = params.fillColor;
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoParametricCurve.prototype.iconCSS = 'parametriccurveBtn';
            
            GeoParametricCurve.prototype.updateSceneData = function(index, construction, content) { /* Not used. */ }
            
            /**
             * Convert a GeoParametricCurve to JessieScript.
             */
            GeoParametricCurve.prototype.asJessieScript = function() { return ""; /* Not used. */ }
            
            GeoParametricCurve.prototype.asConstruct = function(board, construction) {
                eval('function x(t) {return ' + $().calculator('parse', this.fx) + '};');
                eval('function y(t) {return ' + $().calculator('parse', this.fy) + '};');
                construction.functions.push(board.create(
                    'curve',
                    [
                        x,
                        y,
                        this.tMin, 
                        this.tMax
                    ],
                    {
                        visible : this.visible,
                        withLabel : this.showName,
                        name : this.name,
                        dash : this.dash,
                        strokeWidth : 2,
                        strokeColor : this.strokeColor,
                        fillColor : this.fillColor,
                        highlightFillColor : this.fillColor
                    }
                ));
            }
            
            GeoParametricCurve.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" value="' + this.name + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Function x(t): </span>'+ '<span class="geoProperty"><div id="fx"></div></span><br/>');//'<input id="fx-' + idNum + '" size="30" value="' + this.fx + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Function y(t): </span>'+ '<span class="geoProperty"><div id="fy"></div></span><br/>');//'<input id="fy-' + idNum + '" size="30" value="' + this.fy + '"/></span><br/>');
                
                place.find('div#fx').mathquill('editable').mathquill('write', this.fx);
                place.find('div#fy').mathquill('editable').mathquill('write', this.fy);
                
                place.append('<span class="geoItemCaption">Range minimum for t: </span>'+ '<span class="geoProperty"><input id="tMin-' + idNum + '" size="5" value="' + this.tMin + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Range maximum for t: </span>'+ '<span class="geoProperty"><input id="tMax-' + idNum + '" size="5" value="' + this.tMax + '"/></span><br/>');
                
                place.append('<span class="geoItemCaption">Stroke color: </span>' + '<span class="geoProperty"><input id="strokeColor-' + idNum + '" type="text" size="8" value="' + this.strokeColor + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Fill color: </span>' + '<span class="geoProperty"><input id="fillColor-' + idNum + '" type="text" size="8" value="' + this.fillColor + '" /></span><br/>');
                
                place.append('<span class="geoItemCaption">Line style: </span><select id="' + 'dashSelect-' + idNum + '"></select>');
                var dashSelect = place.find('select#dashSelect-' + idNum);
                for (var i = 0; i < 7; ++i)
                    dashSelect.append('<option value="' + i + '"' + (this.dash == i ? ' selected="selected" ': '') + '>' + dashStr[i] + '</option>');

                place.find('input, select, div#fx, div#fy').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
                
            }   
            
            GeoParametricCurve.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var fx = content.find('div#fx').mathquill('latex');//content.find('input#fx-' + idNum).val();
                var fy = content.find('div#fy').mathquill('latex');//content.find('input#fy-' + idNum).val();
                var tMin = content.find('input#tMin-' + idNum).val();
                var tMax = content.find('input#tMax-' + idNum).val();
                var dash = parseInt(content.find('select#dashSelect-' + idNum).val());
                var strokeColor = content.find('input#strokeColor-' + idNum).val();
                var fillColor = content.find('input#fillColor-' + idNum).val();
                
                return new GeoParametricCurve({'fx' : fx, 'fy' : fy, 'tMin' : tMin, 'tMax' : tMax, 'name' : name_Str, 'showName' : showName, 'visible' : visible, 'dash' : dash, 'strokeColor' : strokeColor, 'fillColor' : fillColor});
            }
        }       
        { // GeoSquare
            
            /**
             * Constructor for geometric square object.
             */
            var GeoSquare = function(params) {
                
                params = $.extend( {
                    'p1' : null,
                    'p2' : null,
                    'name' : null,
                    'dash' : 0,
                    'showName' : false,
                    'visible' : true,
                    'strokeColor' : '#00f',
                    'fillColor' : 'none',
                    'p3' : null,
                    'showGeneratedPoints' : true
                }, params);
                if (typeof params.color != 'undefined') params.strokeColor = params.color;
                
                this.type = 'Square';
                this.p1 = params.p1;
                this.p2 = params.p2;
                this.p3 = params.p3;
                this.name = params.name;
                this.dash = params.dash;
                this.showName = params.showName;
                this.visible = params.visible;
                this.strokeColor = params.strokeColor;
                this.showGeneratedPoints = params.showGeneratedPoints;
                this.fillColor = params.fillColor;
                
                var n;
                if (params.p3 != null) n = parseInt(params.p3);
                else n = popNewGlobalIndex(2);
                this.p3 = n;
                this.p4 = n + 1;
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoSquare.prototype.iconCSS = 'squareBtn';
            
            GeoSquare.prototype.updateSceneData = function(index, construction, content) { /* Not used. */ }
            
            /**
             * Convert a GeoLine to JessieScript.
             */
            GeoSquare.prototype.asJessieScript = function() { return ""; /* Not used. */    }
            
            GeoSquare.prototype.asConstruct = function(board, construction) {
                var p1 = findPointByName(this.p1, construction);
                
                var p2 = findPointByName(this.p2, construction);
                
                var lAB = board.create(
                    'line',
                    [p1, p2],
                    {
                        visible : this.visible,
                        name : '',
                        withLabel : false,
                        straightFirst : false,
                        straightLast : false,
                        dash : this.dash,
                        color : this.color
                    }
                );
                var n1 = board.create('normal', [p1, lAB], { visible : false } );
                var n2 = board.create('normal', [p2, lAB], { visible : false } );
                var c1 = board.create('circle', [p1, p2], { visible : false } );
                var c2 = board.create('circle', [p2, p1], { visible : false } );
                var i1 = board.create(
                    'intersection',
                    [c1, n1, 0],
                    {
                        visible : this.visible && this.showGeneratedPoints,
                        strokeColor : '#000',
                        fillColor : '#000',
                        name : 'P' + this.p3
                    }
                );
                var i2 = board.create(
                    'intersection',
                    [c2, n2, 0],
                    {
                        visible:this.visible && this.showGeneratedPoints,
                        strokeColor : '#000',
                        fillColor : '#000',
                        name : 'P' + this.p4
                    }
                );
                var lAC = board.create(
                    'line',
                    [p1, i1],
                    {
                        visible : this.visible,
                        name : '',
                        withLabel : false,
                        straightFirst : false,
                        straightLast : false,
                        dash : this.dash,
                        color : this.color
                    }
                );
                var lAD = board.create(
                    'line',
                    [p2, i2],
                    {
                        visible : this.visible,
                        name : '',
                        withLabel : false,
                        straightFirst : false,
                        straightLast : false,
                        dash : this.dash,
                        color : this.color
                    }
                );
                var lCD = board.create(
                    'line',
                    [i1, i2],
                    {
                        visible : this.visible,
                        name : '',
                        withLabel : false,
                        straightFirst : false,
                        straightLast : false,
                        dash : this.dash,
                        color : this.color
                    }
                );
                
                construction.lines.push(lAB);
                construction.lines.push(lAC);
                construction.lines.push(lAD);
                construction.lines.push(lCD);
                construction.intersections.push(i1);
                construction.intersections.push(i2);
                
                construction.polygons.push(board.create(
                    'polygon',
                    [p1, p2, i2, i1],
                    {
                        visible : this.visible,
                        name : this.name,
                        withLines : false,
                        withLabel : this.showName,
                        dash : this.dash,
                        strokeColor : 'none',
                        fillColor : this.fillColor,
                        fillOpacity : 1.0,
                        highlightFillOpacity : 1.0,
                        highlightStrokeColor : 'none',
                        highlightFillColor : this.fillColor,
                    }
                ));
            }
            
            GeoSquare.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" value="' + this.name + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">First point label: </span>' + '<span class="geoProperty"><input id="firstPoint-' + idNum + '" size="5" value="' + this.p1 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Second point label: </span>' + '<span class="geoProperty"><input id="secondPoint-' + idNum + '" size="5" value="' + this.p2 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Show generated points: </span>' + '<span class="geoProperty"><input id="showGeneratedPoints-' + idNum + '" type="checkbox"' + (this.showGeneratedPoints ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Stroke color: </span>' + '<span class="geoProperty"><input id="strokeColor-' + idNum + '" type="text" size="8" value="' + this.strokeColor + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Fill color: </span>' + '<span class="geoProperty"><input id="fillColor-' + idNum + '" type="text" size="8" value="' + this.fillColor + '" /></span><br/>');
                place.append('<input id="nParam-' + idNum + '" type="hidden" value="' + this.p3 + '"/>');
                
                place.append('<span class="geoItemCaption">Line style: </span><select id="' + 'dashSelect-' + idNum + '"></select>');
                var dashSelect = place.find('select#dashSelect-' + idNum);
                for (var i = 0; i < 7; ++i)
                    dashSelect.append('<option value="' + i + '"' + (this.dash == i ? ' selected="selected" ': '') + '>' + dashStr[i] + '</option>');

                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
            }

            GeoSquare.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var p1 = content.find('input#firstPoint-' + idNum).val();
                var p2 = content.find('input#secondPoint-' + idNum).val();
                var showGeneratedPoints = content.find('input#showGeneratedPoints-' + idNum).is(':checked');
                var dash = parseInt(content.find('select#dashSelect-' + idNum).val());
                var n = content.find('input#nParam-' + idNum).val();
                var strokeColor = content.find('input#strokeColor-' + idNum).val();
                var fillColor = content.find('input#fillColor-' + idNum).val();
                
                return new GeoSquare({ 'p1' : p1, 'p2' : p2, 'name' : name_Str, 'showName' : showName, 'visible' : visible, 'dash' : dash, 'p3' : n, 'strokeColor' : strokeColor, 'fillColor' : fillColor, 'showGeneratedPoints' : showGeneratedPoints });
            }
        }
        { // GeoTriangle
            /**
             * Constructor for geometric triangle object.
             */
            var GeoTriangle = function(params) {
                
                params = $.extend( {
                    'p1' : null,
                    'p2' : null,
                    'p3' : null,
                    'name' : null,
                    'dash' : 0,
                    'showName' : false,
                    'visible' : true,
                    'strokeColor' : '#00f',
                    'fillColor' : 'none'
                }, params);
                
                this.type = 'Triangle';
                this.p1 = params.p1;
                this.p2 = params.p2;
                this.p3 = params.p3;
                this.name = params.name;
                this.showName = params.showName;
                this.visible = params.visible;
                this.dash = params.dash;
                this.strokeColor = params.strokeColor;
                this.fillColor = params.fillColor;
                
                // Fallback for the older versions.
                if (typeof params.color != 'undefined') this.strokeColor = params.color;
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoTriangle.prototype.iconCSS = 'triangleBtn';
            
            GeoTriangle.prototype.updateSceneData = function(index, construction, content) { /* Not used. */ }
            
            /**
             * Convert a GeoTriangle to JessieScript.
             */
            GeoTriangle.prototype.asJessieScript = function() { return ""; /* Not used. */ }
            
            GeoTriangle.prototype.asConstruct = function(board, construction) {
                construction.lines.push(
                    board.create(
                        'line',
                        [this.p1, this.p2],
                        {
                            visible : this.visible,
                            name : '',
                            withLabel : false,
                            straightFirst : false,
                            straightLast : false,
                            dash : this.dash,
                            color : this.strokeColor
                        }
                    )
                );
                
                construction.lines.push(
                    board.create(
                        'line',
                        [this.p2, this.p3],
                        {
                            visible : this.visible,
                            name : '',
                            withLabel : false,
                            straightFirst : false,
                            straightLast : false,
                            dash : this.dash,
                            color : this.strokeColor
                        }
                    )
                );
                
                construction.lines.push(
                    board.create(
                        'line',
                        [this.p1, this.p3],
                        {
                            visible : this.visible,
                            name : '',
                            withLabel : false,
                            straightFirst : false,
                            straightLast : false,
                            dash : this.dash,
                            color : this.strokeColor
                        }
                    )
                );
                
                construction.polygons.push(
                    board.create(
                        'polygon',
                        [this.p1, this.p2, this.p3],
                        {
                            visible : this.visible,
                            name : this.name,
                            withLabel : this.showName,
                            withLines : false,
                            straightFirst : false,
                            straightLast : false,
                            fillColor : this.fillColor,
                            fillOpacity : 1.0,
                            borders : {
                                strokeColor : this.strokeColor
                            }
                        }
                    )
                );
            }
            
            GeoTriangle.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" value="' + this.name + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">First corner point label: </span>'+ '<span class="geoProperty"><input id="firstPoint-' + idNum + '" size="5" value="' + this.p1 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Second corner point label: </span>'+ '<span class="geoProperty"><input id="secondPoint-' + idNum + '" size="5" value="' + this.p2 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Third corner point label: </span>'+ '<span class="geoProperty"><input id="thirdPoint-' + idNum + '" size="5" value="' + this.p3 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Stroke color: </span>' + '<span class="geoProperty"><input id="strokeColor-' + idNum + '" type="text" size="8" value="' + this.strokeColor + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Fill color: </span>' + '<span class="geoProperty"><input id="fillColor-' + idNum + '" type="text" size="8" value="' + this.fillColor + '" /></span><br/>');

                place.append('<span class="geoItemCaption">Line style: </span><select id="' + 'dashSelect-' + idNum + '"></select>');
                var dashSelect = place.find('select#dashSelect-' + idNum);
                for (var i = 0; i < 7; ++i)
                    dashSelect.append('<option value="' + i + '"' + (this.dash == i ? ' selected="selected" ': '') + '>' + dashStr[i] + '</option>');
                    
                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
                

            }
            
            GeoTriangle.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var p1 = content.find('input#firstPoint-' + idNum).val();
                var p2 = content.find('input#secondPoint-' + idNum).val();
                var p3 = content.find('input#thirdPoint-' + idNum).val();
                var dash = parseInt(content.find('select#dashSelect-' + idNum).val());
                var strokeColor = content.find('input#strokeColor-' + idNum).val();
                var fillColor = content.find('input#fillColor-' + idNum).val();
                
                return new GeoTriangle({ 'p1' : p1, 'p2' : p2, 'p3' : p3, 'name' : name_Str, 'showName' : showName, 'visible' : visible, 'dash' : dash, 'strokeColor' : strokeColor, 'fillColor' : fillColor});
            }
        }
        { // GeoSector
            /**
             * Constructor for geometric sector object.
             */
            var GeoSector = function(params) {
                
                params = $.extend( {
                    'p1' : null,
                    'p2' : null,
                    'p3' : null,
                    'l1' : null,
                    'name' : null,
                    'dash' : 0,
                    'showName' : true,
                    'visible' : true,
                    'mode' : 'sector',
                    'strokeColor' : '#00f',
                    'fillColor' : '#0000FF50',
                    'fillOpacity': 0.3
                }, params);
                
                this.type = 'Sector';
                this.p1 = params.p1;
                this.p2 = params.p2;
                this.p3 = params.p3;
                this.name = params.name;
                this.showName = params.showName;
                this.visible = params.visible;
                this.dash = params.dash;
                this.mode = params.mode;
                this.strokeColor = params.strokeColor;
                this.fillColor = params.fillColor;
                this.fillOpacity = params.fillOpacity;
                
                var n;
                if (params.l1 != null) n = parseInt(params.l1);
                else n = popNewGlobalIndex(1);
                this.l1 = n;
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoSector.prototype.iconCSS = 'sectorBtn';
            
            GeoSector.prototype.updateSceneData = function(index, construction, content) { /* Not used. */ }
            
            /**
             * Convert a GeoSector to JessieScript.
             */
            GeoSector.prototype.asJessieScript = function() {
                return "";
            }
            
            GeoSector.prototype.asConstruct = function(board, construction) {
                if (this.mode == 'sector') {
                    board.create(
                        'sector',
                        [this.p1, this.p2, this.p3],
                        {
                            visible : this.visible,
                            strokeColor : this.strokeColor,
                            fillColor : this.fillColor,
                            highlightFillColor : this.fillColor,
                            fillOpacity : this.fillOpacity,
                            highlightFillOpacity : this.fillOpacity,
                            withLines : true,
                            name : this.name,
                            withLabel : this.showName,
                            strokeWidth : 2,
                            highlightStrokeWidth : 2,
                            dash : this.dash
                        }
                    );
                } else if (this.mode == 'arc') {
                    board.create(
                        'arc',
                        [this.p1, this.p2, this.p3],
                        {
                            visible : this.visible,
                            strokeColor : this.strokeColor,
                            withLines : true,
                            name : this.name,
                            withLabel : this.showName,
                            strokeWidth : 2,
                            highlightStrokeWidth : 2,
                            dash : this.dash
                        }
                    );
                }
                else /* if (this.mode == 'segment') */ {
                    var l1 = board.create('line', [this.p1, this.p3], { visible : false });
                    var arc1 = board.create(
                        'arc',
                        [this.p1, this.p2, this.p3],
                        {
                            visible : this.visible,
                            strokeColor : this.strokeColor,
                            fillColor : this.fillColor,
                            highlightFillColor : this.fillColor,
                            fillOpacity : this.fillOpacity,
                            highlightFillOpacity : this.fillOpacity,
                            withLines : true,
                            name : this.name,
                            withLabel : this.showName,
                            strokeWidth : 2,
                            highlightStrokeWidth : 2,
                            dash : this.dash
                        }
                    );
                    var i1 = board.create('intersection', [l1, arc1], { visible : false });
                    construction.lines.push(
                        board.create(
                            'line',
                            [this.p2, i1],
                            {
                                visible : this.visible,
                                strokeColor : this.strokeColor,
                                withLines : true,
                                name : 'l' + this.l1,
                                straightFirst : false,
                                straightLast : false,
                                withLabel : false,
                                strokeWidth : 2,
                                highlightStrokeWidth : 2,
                                dash : this.dash
                            }
                        )
                    );
                }
            }
            
            GeoSector.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" value="' + this.name + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Third corner point label: </span>' + '<span class="geoProperty"><input id="firstPoint-' + idNum + '" size="5" value="' + this.p1 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Radius point label: </span>' + '<span class="geoProperty"><input id="secondPoint-' + idNum + '" size="5" value="' + this.p2 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Angle point label: </span>' + '<span class="geoProperty"><input id="thirdPoint-' + idNum + '" size="5" value="' + this.p3 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Stroke color: </span>' + '<span class="geoProperty"><input id="strokeColor-' + idNum + '" type="text" size="8" value="' + this.strokeColor + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Fill color: </span>' + '<span class="geoProperty"><input id="fillColor-' + idNum + '" type="text" size="8" value="' + this.fillColor + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Fill opacity: </span>' + '<span class="geoProperty"><input id="fill-' + idNum + '" type="text" size="8" value="' + this.fillOpacity + '" /></span><br/>');
                place.append('<input id="nParam-' + idNum + '" type="hidden" value="' + this.l1 + '"/>');
                
                place.append('<span class="geoItemCaption">Mode: </span><select id="' + 'modeSelect-' + idNum + '"></select><br/>');
                var modeSelect = place.find('select#modeSelect-' + idNum);
                    modeSelect.append('<option value="sector"' + (this.mode == 'sector' ? ' selected="selected" ': '') + '>Sector</option>');
                    modeSelect.append('<option value="arc"' + (this.mode == 'arc' ? ' selected="selected" ': '') + '>Arc</option>');
                    modeSelect.append('<option value="segment"' + (this.mode == 'segment' ? ' selected="selected" ': '') + '>Segment</option>');

                place.append('<span class="geoItemCaption">Line style: </span><select id="' + 'dashSelect-' + idNum + '"></select>');
                var dashSelect = place.find('select#dashSelect-' + idNum);
                for (var i = 0; i < 7; ++i)
                    dashSelect.append('<option value="' + i + '"' + (this.dash == i ? ' selected="selected" ': '') + '>' + dashStr[i] + '</option>');
                    
                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
            }
            
            GeoSector.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var p1 = content.find('input#firstPoint-' + idNum).val();
                var p2 = content.find('input#secondPoint-' + idNum).val();
                var p3 = content.find('input#thirdPoint-' + idNum).val();
                var dash = parseInt(content.find('select#dashSelect-' + idNum).val());
                var mode = content.find('select#modeSelect-' + idNum).val();
                var nParam = content.find('input#nParam-' + idNum).val();
                var strokeColor = content.find('input#strokeColor-' + idNum).val();
                var fillColor = content.find('input#fillColor-' + idNum).val();
                var fillOpacity = content.find('input#fillOpacity-' + idNum).val();
                
                return new GeoSector({ 'p1' : p1, 'p2' : p2, 'p3' : p3, 'name' : name_Str, 'mode' : mode, 'showName' : showName, 'visible' : visible, 'dash' : dash, 'l1' : nParam, 'strokeColor' : strokeColor, 'fillColor' : fillColor, 'fillOpacity' : fillOpacity });
            }
        }
        { // GeoAngle
            /**
             * Constructor for geometric angle object.
             */
            var GeoAngle = function(params) {
                
                params = $.extend( {
                    'p1' : null,
                    'p2' : null,
                    'p3' : null,
                    'name' : null,
                    'showName' : true,
                    'visible' : true,
                    'mode' : 'angle',
                    'strokeColor' : 'red',
                    'fillColor' : 'red',
                    'radius' : 1.0,
                    'fillOpacity': 0.3,
                    'label' : {
                        'fixed' : false
                    }
                }, params);
                
                this.type = 'Angle';
                this.p1 = params.p1;
                this.p2 = params.p2;
                this.p3 = params.p3;
                this.name = params.name;
                this.showName = params.showName;
                this.fillOpacity = params.fillOpacity;
                this.visible = params.visible;
                this.mode = params.mode;
                this.strokeColor = params.strokeColor;
                this.fillColor = params.fillColor;
                this.radius = params.radius;
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoAngle.prototype.iconCSS = 'angleBtn';
            
            GeoAngle.prototype.updateSceneData = function(index, construction, content) {
                 /* Not used. */
            }
            
            GeoAngle.prototype.angleVal = function(construction) {
                
                var p1 = findPointByName(this.p1, construction);
                
                var p2 = findPointByName(this.p2, construction);
                
                var p3 = findPointByName(this.p3, construction);
                                    
                return JXG.Math.Geometry.trueAngle(p1, p2, p3).toFixed(0);
            }
            
            GeoAngle.prototype.angleStr = function(construction) {
                if (this.showName) {
                    var angle = this.angleVal(construction);
                    if (((this.mode == 'angleSmall') && (angle > 180)) || ((this.mode == 'angleLarge') && (angle <= 180))) angle = 360 - angle;
                    var angleStr = angle + '&deg;';
                    
                    if (this.name == '') {
                        var angleValue = this.angleVal(construction);
                        if ((angleValue == 90) || ((angleValue == 270) && (this.mode == 'angleSmall'))) return ' ';
                        else return angleStr;
                    } else return  this.name.replace(/%1|%angle%/g, angleStr);
                } else return '';
            }
            
            /**
             * Convert a GeoAngle to JessieScript.
             */
            GeoAngle.prototype.asJessieScript = function() {
                return "";//this.name + " = <(" + this.p1 + ", " + this.p2 + ", " + this.p3 + ")" + (this.visible ? (this.showName ? "" : " nolabel") : " invisible") + ";\n";
            }
            
            GeoAngle.prototype.asConstruct = function(board, construction) {
                var obj = this;
                if ((this.mode == 'angle') || (this.mode == 'angleSmall') || (this.mode == 'angleLarge')) {
                    construction.angles.push(
                        board.create(
                            'angle',
                            [this.p1, this.p2, this.p3],
                            {
                                strokeColor : this.strokeColor,
                                visible : this.visible && (
                                    (this.mode == 'angle') || 
                                    (
                                        (this.mode == 'angleSmall') &&
                                        this.angleVal(construction) <= 180
                                    ) ||
                                    (
                                        (this.mode == 'angleLarge') &&
                                        this.angleVal(construction) >= 180
                                    )
                                ),
                                strokeWidth : 2,
                                needsRegularUpdate : true,
                                fillColor : this.fillColor,
                                fillOpacity : this.fillOpacity,
                                highlightFillOpacity : this.fillOpacity,
                                orthoSensitivity : 0.5,
                                label : { strokeColor : 'black' },
                                point : { visible : false },
                                radius : this.radius,
                                withLabel : true,
                                name : function() {
                                    if (this.obj === undefined) this.obj = obj; 
                                    
                                    if ((this.obj.mode == 'angleSmall') || (this.obj.mode == 'angleLarge')) {
                                        var ang = this.obj.angleVal(construction);
                                            
                                        if ((ang > 180) && ((typeof this.oldAngle == 'undefined') || (this.oldAngle <= 180))) {
                                            
                                            for (el in this.ancestors)
                                                if (this.ancestors[el].elType == 'angle') {
                                                    if (this.obj.mode == 'angleSmall') this.ancestors[el].hideElement();
                                                    else if (this.obj.mode == 'angleLarge') this.ancestors[el].showElement();
                                                }
                                            
                                            this.oldAngle = ang; 
                                            if (typeof this.rendNode != 'undefined') this.update();
                                        } else if ((ang <= 180) && ((typeof this.oldAngle == 'undefined') || (this.oldAngle > 180))) {
                                            
                                            for (el in this.ancestors)
                                                if (this.ancestors[el].elType == 'angle') {
                                                    if (this.obj.mode == 'angleSmall') this.ancestors[el].showElement();
                                                    else if (this.obj.mode == 'angleLarge') this.ancestors[el].hideElement();
                                                }
                                            
                                            this.oldAngle = ang;
                                            if (typeof this.rendNode != 'undefined') this.update();
                                        }
                                    }
                                    
                                    return this.obj.angleStr(construction);
                                }
                            }
                        )
                    );
                    if ((this.mode == 'angleSmall') || (this.mode == 'angleLarge'))
                        construction.angles.push(
                            board.create(
                                'angle',
                                [this.p3, this.p2, this.p1],
                                {
                                    strokeColor : this.strokeColor,
                                    visible : !(this.visible && (
                                        (this.mode == 'angle') || 
                                        (
                                            (this.mode == 'angleSmall') &&
                                            this.angleVal(construction) <= 180
                                        ) ||
                                        (
                                            (this.mode == 'angleLarge') &&
                                            this.angleVal(construction) >= 180
                                        )
                                    )),
                                    strokeWidth : 2,
                                    needsRegularUpdate : true,
                                    fillColor : this.fillColor,
                                    fillOpacity : this.fillOpacity,
                                    highlightFillOpacity : this.fillOpacity,
                                    orthoSensitivity : 0.5,
                                    label : { strokeColor : 'black' },
                                    point : { visible : false },
                                    radius : this.radius,
                                    withLabel : true,
                                    name : function() {
                                        if (this.obj === undefined) this.obj = obj; 
                                        
                                        if ((this.obj.mode == 'angleSmall') || (this.obj.mode == 'angleLarge')) {
                                            var ang = this.obj.angleVal(construction);
                                            
                                            if ((ang <= 180) && ((typeof this.oldAngle == 'undefined') || (this.oldAngle > 180))) {
                                                
                                                for (el in this.ancestors)
                                                    if (this.ancestors[el].elType == 'angle') {
                                                        if (this.obj.mode == 'angleSmall') this.ancestors[el].hideElement();
                                                        else if (this.obj.mode == 'angleLarge') this.ancestors[el].showElement();
                                                }
                                                this.hideElement();
                                                
                                                this.oldAngle = ang;
                                                if (typeof this.rendNode != 'undefined') this.update();
                                                
                                            } else if ((ang > 180) && ((typeof this.oldAngle == 'undefined') || (this.oldAngle <= 180))) {
                                                
                                                for (el in this.ancestors)
                                                    if (this.ancestors[el].elType == 'angle') {
                                                        if (this.obj.mode == 'angleSmall') this.ancestors[el].showElement();
                                                        else if (this.obj.mode == 'angleLarge') this.ancestors[el].hideElement();
                                                    }
                                                    
                                                this.showElement();
                                                
                                                this.oldAngle = ang;
                                                if (typeof this.rendNode != 'undefined') this.update();
                                            }
                                        }
                                        
                                        return this.obj.angleStr(construction);
                                        
                                    }
                                }
                            )
                        );
                }
                if (this.mode == 'bisector') {
                    construction.lines.push(
                        board.create(
                            'bisector',
                            [this.p1, this.p2, this.p3],
                            {
                                visible : this.visible,
                                strokeWidth : 2,
                                needsRegularUpdate : true,
                                name : this.name,
                                withLabel : this.showName,
                                color : this.strokeColor
                            }
                        )
                    );
                }
            }
            
            GeoAngle.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" value="' + this.name + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Point on the right hand side: </span>' + '<span class="geoProperty"><input id="firstPoint-' + idNum + '" size="5" value="' + this.p1 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Corner point: </span>' + '<span class="geoProperty"><input id="secondPoint-' + idNum + '" size="5" value="' + this.p2 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Point on the left hand side: </span>' + '<span class="geoProperty"><input id="thirdPoint-' + idNum + '" size="5" value="' + this.p3 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Radius: </span>' + '<span class="geoProperty"><input id="radius-' + idNum + '" type="text" size="5" value="' + this.radius + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Stroke color: </span>' + '<span class="geoProperty"><input id="strokeColor-' + idNum + '" type="text" size="8" value="' + this.strokeColor + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Fill color: </span>' + '<span class="geoProperty"><input id="fillColor-' + idNum + '" type="text" size="8" value="' + this.fillColor + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Fill opacity: </span>' + '<span class="geoProperty"><input id="fillOpacity-' + idNum + '" type="text" size="8" value="' + this.fillOpacity + '" /></span><br/>');
                
                place.append('<span class="geoItemCaption">Mode: </span><select id="' + 'modeSelect-' + idNum + '"></select><p />');
                var modeSelect = place.find('select#modeSelect-' + idNum);
                    modeSelect.append('<option value="angle"' + (this.mode == 'angle' ? ' selected="selected" ': '') + '>Angle</option>');
                    modeSelect.append('<option value="angleSmall"' + (this.mode == 'angleSmall' ? ' selected="selected" ': '') + '>Small angle</option>');
                    modeSelect.append('<option value="angleLarge"' + (this.mode == 'angleLarge' ? ' selected="selected" ': '') + '>Large angle</option>');
                    modeSelect.append('<option value="bisector"' + (this.mode == 'bisector' ? ' selected="selected" ': '') + '>Bisector</option>');
                
                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
            }
            
            GeoAngle.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var p1 = content.find('input#firstPoint-' + idNum).val();
                var p2 = content.find('input#secondPoint-' + idNum).val();
                var p3 = content.find('input#thirdPoint-' + idNum).val();
                var radius = parseFloat(content.find('input#radius-' + idNum).val());
                var mode = content.find('select#modeSelect-' + idNum).val();
                var strokeColor = content.find('input#strokeColor-' + idNum).val();
                var fillColor = content.find('input#fillColor-' + idNum).val();
                var fillOpacity = content.find('input#fillOpacity-' + idNum).val();
                
                return new GeoAngle({ 'p1' : p1, 'p2' : p2, 'p3' : p3, 'name' : name_Str, 'showName' : showName, 'visible' : visible, 'mode' : mode, 'strokeColor' : strokeColor, 'fillColor' : fillColor, 'fillOpacity' : fillOpacity, 'radius' : radius });
            }
        }
        { // GeoParallelogram
            /**
             * Constructor for geometric parallelogram object.
             */
            var GeoParallelogram = function(params) {
                
                params = $.extend( {
                    'p1' : null,
                    'p2' : null,
                    'p3' : null,
                    'l1' : null,
                    'name' : null,
                    'dash' : 0,
                    'showName' : false,
                    'visible' : true,
                    'strokeColor' : 'blue',
                    'fillColor' : 'none',
                    'showGeneratedPoints' : true
                }, params);
                // Fallback for the older versions.
                if (typeof params.color != 'undefined') params.strokeColor = params.color;
                
                this.type = 'Parallelogram';
                this.p1 = params.p1;
                this.p2 = params.p2;
                this.p3 = params.p3;
                this.dash = params.dash;
                this.strokeColor = params.strokeColor;
                this.fillColor = params.fillColor;
                
                

                var n;
                if (params.l1 != null) n = parseInt(params.l1);
                else n = popNewGlobalIndex(5);
                
                this.l1 = n;
                this.l2 = n + 1;
                this.l3 = n + 2;
                this.l4 = n + 3;
                this.p4 = n + 4;

                this.name = params.name;
                this.showName = params.showName;
                this.visible = params.visible;
                this.showGeneratedPoints = params.showGeneratedPoints;
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoParallelogram.prototype.iconCSS = 'parallelogramBtn';
            
            GeoParallelogram.prototype.updateSceneData = function(index, construction, content) { /* Not used. */ }
            
            /**
             * Convert a GeoParallelogram to JessieScript.
             */
            GeoParallelogram.prototype.asJessieScript = function() {    return ''; /* Not used. */ }
            
            GeoParallelogram.prototype.asConstruct = function(board, construction) {
                
                var p1 = findPointByName(this.p1, construction);
                var p2 = findPointByName(this.p2, construction);
                var p3 = findPointByName(this.p3, construction);
                
                var l1 = board.create(
                    'line',
                    [p1, p2],
                    {
                        visible : this.visible,
                        name : 'l' + this.l1,
                        withLabel : false,
                        straightFirst : false,
                        straightLast : false,
                        dash : this.dash,
                        color : this.strokeColor
                    }
                );
                var l2 = board.create(
                    'line',
                    [p2, p3],
                    {
                        visible : this.visible,
                        name : 'l' + this.l2,
                        withLabel : false,
                        straightFirst : false,
                        straightLast : false,
                        dash : this.dash,
                        color : this.strokeColor
                    }
                );
                
                var l3 = board.create('parallel', [p1, l2], { name : 'l' + this.l3, visible : false } );
                var l4 = board.create('parallel', [p3, l1], { name : 'l' + this.l4, visible : false } );
                var p4 = board.create(
                    'intersection',
                    [l3, l4, 0],
                    {
                        visible : this.visible && this.showGeneratedPoints,
                        strokeColor : '#000',
                        fillColor : '#000',
                        name : 'P' + this.p4
                    }
                );
                
                construction.points.push(p1);
                construction.points.push(p2);
                construction.points.push(p3);
                construction.points.push(p4);
                
                construction.lines.push(board.create(
                    'line',
                    [p1, p4],
                    {
                        visible : this.visible,
                        withLabel : false,
                        straightFirst : false,
                        straightLast : false,
                        dash : this.dash,
                        color : this.strokeColor
                    }
                ));
                construction.lines.push(board.create(
                    'line',
                    [p3, p4],
                    {
                        visible : this.visible,
                        withLabel : false,
                        straightFirst : false,
                        straightLast : false,
                        dash : this.dash,
                        color : this.strokeColor
                    }
                ));
                constr = construction;
                
                construction.lines.push(l1);
                construction.lines.push(l2);
                
                construction.polygons.push(board.create(
                    'polygon',
                    [p1, p2, p3, p4],
                    {
                        visible : this.visible,
                        name : this.name,
                        withLines : false,
                        withLabel : this.showName,
                        dash : this.dash,
                        strokeColor : 'none',
                        fillColor : this.fillColor,
                        fillOpacity : 1.0,
                        highlightFillOpacity : 1.0,
                        highlightStrokeColor : 'none',
                        highlightFillColor : this.fillColor,
                    }
                ));
            }
            
            GeoParallelogram.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" value="' + this.name + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Show generated point: </span>' + '<span class="geoProperty"><input id="showGeneratedPoints-' + idNum + '" type="checkbox"' + (this.showGeneratedPoints ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">First point: </span>' + '<span class="geoProperty"><input id="firstPoint-' + idNum + '" size="5" value="' + this.p1 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Second point: </span>' + '<span class="geoProperty"><input id="secondPoint-' + idNum + '" size="5" value="' + this.p2 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Third point: </span>' + '<span class="geoProperty"><input id="thirdPoint-' + idNum + '" size="5" value="' + this.p3 + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Stroke color: </span>' + '<span class="geoProperty"><input id="strokeColor-' + idNum + '" type="text" size="8" value="' + this.strokeColor + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Fill color: </span>' + '<span class="geoProperty"><input id="fillColor-' + idNum + '" type="text" size="8" value="' + this.fillColor + '" /></span><br/>');
                place.append('<input id="nParam-' + idNum + '" type="hidden" value="' + this.l1 + '"/>');
                
                place.append('<span class="geoItemCaption">Line style: </span><select id="' + 'dashSelect-' + idNum + '"></select>');
                var dashSelect = place.find('select#dashSelect-' + idNum);
                for (var i = 0; i < 7; ++i)
                    dashSelect.append('<option value="' + i + '"' + (this.dash == i ? ' selected="selected" ': '') + '>' + dashStr[i] + '</option>');
                
                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
            }
            
            GeoParallelogram.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var showGeneratedPoints = content.find('input#showGeneratedPoints-' + idNum).is(':checked');
                var p1 = content.find('input#firstPoint-' + idNum).val();
                var p2 = content.find('input#secondPoint-' + idNum).val();
                var p3 = content.find('input#thirdPoint-' + idNum).val();
                var nParam = content.find('input#nParam-' + idNum).val();
                var dash = parseInt(content.find('select#dashSelect-' + idNum).val());
                var strokeColor = content.find('input#strokeColor-' + idNum).val();
                var fillColor = content.find('input#fillColor-' + idNum).val();
                
                return new GeoParallelogram({ 'p1' : p1, 'p2' : p2, 'p3' : p3, 'name' : name_Str, 'showName' : showName, 'visible' : visible, 'l1' : nParam, 'dash' : dash, 'fillColor' : fillColor, 'strokeColor' : strokeColor, 'showGeneratedPoints' : showGeneratedPoints});
            }
        }
        { // GeoLabel
            /**
             * Constructor for geometric label object.
             */ 
            var GeoLabel = function(params) {
                
                params = $.extend( {
                    'x' : null,
                    'y' : null,
                    'name' : null,
                    'value' : 'Label caption',
                    'visible' : true,
                    'color' : '#000',
                    'fixed' : true
                }, params);
                
                this.type = 'Label';
                this.x = params.x;
                this.y = params.y;
                this.name = params.name;
                this.value = params.value;
                this.visible = params.visible;
                this.color = params.color;
                this.fixed = params.fixed;
            }

            /**
             * CSS style defining the icon representing this type.
             **/
            GeoLabel.prototype.iconCSS = 'labelBtn';

            GeoLabel.prototype.updateSceneData = function(index, construction, content) {
                // Update values to scene array.
                var j = -1;
                do ++j; while (this.name != construction.texts[j].name);
                
                // Two decimal precision.
                var newX = parseInt(construction.texts[j].coords.usrCoords[1] * 100) / 100;
                var newY = parseInt(construction.texts[j].coords.usrCoords[2] * 100) / 100;
                
                this.x = newX;
                this.y = newY;
                
                // Update values to construct accordion.
                content.find('input#xCoordinate-' + index).val(newX);
                content.find('input#yCoordinate-' + index).val(newY);   
            }

            /**
             * Convert a GeoLabel to JessieScript.
             */
            GeoLabel.prototype.asJessieScript = function() { return ""; /* Not used. */ }
            
            GeoLabel.prototype.asConstruct = function(board, construction) {
                construction.texts.push(
                    board.create(
                        'text',
                        [this.x, this.y, this.value],
                        {
                            name : this.name,
                            visible : this.visible,
                            color : this.color,
                            fixed : this.fixed
                        }
                    )
                );
            }
            
            GeoLabel.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="15" value="' + this.name + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Caption: </span>' + '<span class="geoProperty"><input id="value-' + idNum + '" size="15" value="' + this.value + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Fixed: </span>' + '<span class="geoProperty"><input id="fixed-' + idNum + '" type="checkbox"' + (this.fixed ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">x-coordinate: </span>' + '<span class="geoProperty"><input id="xCoordinate-' + idNum + '" size="5" value="' + this.x + '"/></span><br/>');
                place.append('<span class="geoItemCaption">y-coordinate: </span>' + '<span class="geoProperty"><input id="yCoordinate-' + idNum + '" size="5" value="' + this.y + '"/></span><br/>');
                place.append('<span class="geoItemCaption">Color: </span>' + '<span class="geoProperty"><input id="color-' + idNum + '" type="text" size="8" value="' + this.color + '" /></span><br/>');
                
                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
            }
            
            GeoLabel.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var valueStr = content.find('input#value-' + idNum).val();
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var fixed = content.find('input#fixed-' + idNum).is(':checked');
                var x = parseFloat(content.find('input#xCoordinate-' + idNum).val());
                var y = parseFloat(content.find('input#yCoordinate-' + idNum).val());
                var color = content.find('input#color-' + idNum).val();
                
                return new GeoLabel({ 'x' : x, 'y' : y, 'name' : name_Str, 'value' : valueStr, 'visible' : visible, 'color' : color, 'fixed' : fixed });
            }
        }
        { // GeoRhombus             // TODO to JXG.
            /**
             * Constructor for geometric rhombus object.
             */
            var GeoRhombus = function(params) {
                
                params = $.extend( {
                    'p1' : null,
                    'p2' : null,
                    'p3x' : null,
                    'p3y' : null,
                    'l1' : null,
                    'dash' : 0,
                    'name' : null,
                    'showName' : true,
                    'visible' : true,
                    'color' : '#00f',
                    'showGeneratedPoints' : true
                }, params);
                
                this.type = 'Rhombus';
                this.p1 = params.p1;
                this.p2 = params.p2;
                this.p3x = (params.p3x == 'null' ? null : params.p3x);
                this.p3y = (params.p3y == 'null' ? null : params.p3y);
                this.dash = params.dash;
                this.color = params.color;

                var n;
                if (params.l1 != null) n = parseInt(params.l1);
                else n = popNewGlobalIndex(7);
                
                this.l1 = n;
                this.l2 = n + 1;
                this.l3 = n + 2;
                this.l4 = n + 3;
                this.p3 = n + 4;
                this.p4 = n + 5;
                this.c1 = n + 6;

                this.name = params.name;
                this.showName = params.showName;
                this.visible = params.visible;
                this.showGeneratedPoints = params.showGeneratedPoints;
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoRhombus.prototype.iconCSS = 'rhombusBtn';
            
            GeoRhombus.prototype.updateSceneData = function(index, construction, content) {
                // Update values to scene array.
                var p3 = findPointByName('P' + this.p3, construction);
                
                // Two decimal precision.
                var newX = parseInt(p3.coords.usrCoords[1] * 100) / 100;
                var newY = parseInt(p3.coords.usrCoords[2] * 100) / 100;
                
                this.p3x = newX;
                this.p3y = newY;
                
                // Update values to construct accordion.
                content.find('input#thirdPointX-' + index).val(newX);
                content.find('input#thirdPointY-' + index).val(newY);
            }
            
            /**
             * Convert a GeoRhombus to JessieScript.
             */
            GeoRhombus.prototype.asJessieScript = function() {
                
                var s = "c" + this.c1 + " = k(" + this.p1 + ", " + this.p2 + ") invisible;\n";
                s += "P" + this.p3 + "(" + "c" + this.c1 + ((this.p3x != null) && (this.p3y != null) ? ', ' + this.p3x + ', ' + this.p3y : "") + ")" + (this.showGeneratedPoints ? '' : ' invisible') + ";\n";
                s += "l" + this.l1 + " = [" + this.p1 + " " + this.p2 + "] nolabel;\n";
                s += "l" + this.l2 + " = [" + this.p1 + " P" + this.p3 + "] nolabel;\n";
                s += "l" + this.l3 + " = ||(" + this.p2 + ", l" + this.l2 + ") invisible;\n";
                s += "l" + this.l4 + " = ||(P" + this.p3 + ", l" + this.l1 + ") invisible;\n";
                s += "P" + this.p4 + " = l" + this.l3 + "&l" + this.l4 + (this.showGeneratedPoints ? '' : ' invisible') + ";\n";
                s += "[P" + this.p3 + " P" + this.p4 + "];\n";
                s += "[" + this.p2 + " P" + this.p4 + "];\n";
                
                return s;
            }
            
            GeoRhombus.prototype.asConstruct = function(board, construction) { /* Not used. */ }
            
            GeoRhombus.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" value="' + this.name + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Show generated points: </span>' + '<span class="geoProperty"><input id="showGeneratedPoints-' + idNum + '" type="checkbox"' + (this.showGeneratedPoints ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">First point: </span>' + '<span class="geoProperty"><input id="firstPoint-' + idNum + '" size="5" value="' + this.p1 + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Second point: </span>' + '<span class="geoProperty"><input id="secondPoint-' + idNum + '" size="5" value="' + this.p2 + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Third point x: </span>' + '<span class="geoProperty"><input id="thirdPointX-' + idNum + '" size="5" value="' + this.p3x + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Third point y: </span>' + '<span class="geoProperty"><input id="thirdPointY-' + idNum + '" size="5" value="' + this.p3y + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Color: </span>' + '<span class="geoProperty"><input id="color-' + idNum + '" type="text" size="8" value="' + this.color + '" /></span><br/>');
                place.append('<input id="nParam-' + idNum + '" type="hidden" value="' + this.l1 + '"/>');
                
                place.append('<span class="geoItemCaption">Line style: </span><select id="' + 'dashSelect-' + idNum + '"></select>');
                var dashSelect = place.find('select#dashSelect-' + idNum);
                for (var i = 0; i < 7; ++i)
                    dashSelect.append('<option value="' + i + '"' + (this.dash == i ? ' selected="selected" ': '') + '>' + dashStr[i] + '</option>');
                
                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
            }
            
            GeoRhombus.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var p1 = content.find('input#firstPoint-' + idNum).val();
                var p2 = content.find('input#secondPoint-' + idNum).val();
                var p3x = content.find('input#thirdPointX-' + idNum).val();
                var p3y = content.find('input#thirdPointY-' + idNum).val();
                var nParam = content.find('input#nParam-' + idNum).val();
                var showGeneratedPoints = content.find('input#showGeneratedPoints-' + idNum).is(':checked');
                var dash = parseInt(content.find('select#dashSelect-' + idNum).val());
                var color = content.find('input#color-' + idNum).val();
                
                return new GeoRhombus( {'p1' : p1, 'p2' : p2, 'p3x' : p3x, 'p3y' : p3y, 'name' : name_Str, 'showName' : showName, 'visible' : visible, 'l1' : nParam, 'dash' : dash, 'color' : color, 'showGeneratedPoints' : showGeneratedPoints});
            }
        }
        { // GeoRestrictedTriangle
            /**
             * Constructor for restricted triangle object.
             */
            var GeoRestrictedTriangle = function(params) {
                
                params = $.extend( {
                    'p1' : null,
                    'p2' : null,
                    'p3x' : null,
                    'p3y' : null,
                    'l1' : null,
                    'name' : null,
                    'showName' : true,
                    'visible' : true,
                    'color' : '#00f',
                    'dash' : 0,
                    'restriction' : 'rightangle',
                    'showGeneratedPoints' : true
                }, params);
                
                this.type = 'RestrictedTriangle';
                this.p1 = params.p1;
                this.p2 = params.p2;
                this.p3x = (params.p3x == 'null' ? null : params.p3x);
                this.p3y = (params.p3y == 'null' ? null : params.p3y);
                this.color = params.color;

                var n;
                if (params.l1 != null) n = parseInt(params.l1);
                else n = popNewGlobalIndex(4);
                
                this.l1 = n;
                this.l2 = n + 1;
                this.l3 = n + 2;
                this.p3 = n + 3;

                this.name = params.name;
                this.showName = params.showName;
                this.visible = params.visible;
                this.dash = params.dash;
                this.restriction = params.restriction;
                this.showGeneratedPoints = params.showGeneratedPoints;
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoRestrictedTriangle.prototype.iconCSS = 'restrictedtriangleBtn';
            
            GeoRestrictedTriangle.prototype.updateSceneData = function(index, construction, content) {

                // Update values to scene array.
                var p3 = findPointByName('P' + this.p3, construction);
                
                // Two decimal precision.
                var newX = parseInt(p3.coords.usrCoords[1] * 100) / 100;
                var newY = parseInt(p3.coords.usrCoords[2] * 100) / 100;
                
                this.p3x = newX;
                this.p3y = newY;
                
                // Update values to construct accordion.
                content.find('input#thirdPointX-' + index).val(newX);
                content.find('input#thirdPointY-' + index).val(newY);
            }
            
            /**
             * Convert a GeoRestrictedTriangle to JessieScript.
             */
            GeoRestrictedTriangle.prototype.asJessieScript = function() {   return ""; }
            
            GeoRestrictedTriangle.prototype.asConstruct = function(board, construction) {

                // Construct the assisting circle(s).
                var c1, c2;
                if (this.restriction == 'rightangle') {
                    var mp1 = board.create('midpoint', [this.p1, this.p2], { visible : false });
                    c1 = board.create('circle', [mp1, this.p1], { visible : false } );
                } else /* if ((this.restriction == 'isosceles'), (this.restriction == 'equilateral')) */ {
                    c1 = board.create('circle', [this.p2, this.p1], { visible : false } );
                    if (this.restriction == 'equilateral')
                        c2 = board.create('circle', [this.p1, this.p2], { visible : false } );
                }
                
                // Construct the third (restricted) point of the triangle.
                var g1;
                if (this.restriction == 'equilateral') {
                    g1 = board.create('intersection', [c1, c2, 0], { visible : this.visible && this.showGeneratedPoints, name : "P" + this.p3, strokeColor : '#000',
                            fillColor : '#000', withLabel : this.showName } );
                } else /* if ((this.restriction == 'rightangle') || (this.restriction == 'isosceles')) */ {
                    if ((this.p3x != null) && (this.p3y != null))
                        g1 = board.create('glider', [this.p3x, this.p3y, c1], { visible : this.visible && this.showGeneratedPoints, name : "P" + this.p3, withLabel : this.showName } );
                    else
                        g1 = board.create('glider', [c1], { visible : this.visible && this.showGeneratedPoints, name : "P" + this.p3, withLabel : this.showName } );
                }
                
                construction.points.push(g1);
                
                construction.lines.push(
                    board.create(
                        'line',
                        [this.p1, this.p2],
                        {
                            visible : this.visible,
                            name : 'l' + this.l1,
                            withLabel : false,
                            straightFirst : false,
                            straightLast : false,
                            dash : this.dash,
                            color : this.color
                        }
                    )
                );
                
                construction.lines.push(
                    board.create(
                        'line',
                        [this.p1, g1],
                        {
                            visible : this.visible,
                            name : 'l' + this.l2,
                            withLabel : false,
                            straightFirst : false,
                            straightLast : false,
                            dash : this.dash,
                            color : this.color
                        }
                    )
                );
                
                construction.lines.push(
                    board.create(
                        'line',
                        [g1, this.p2],
                        {
                            visible : this.visible,
                            name : 'l' + this.l3,
                            withLabel : false,
                            straightFirst : false,
                            straightLast : false,
                            dash : this.dash,
                            color : this.color
                        }
                    )
                );
            }
            
            GeoRestrictedTriangle.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" value="' + this.name + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Show generated points: </span>' + '<span class="geoProperty"><input id="showGeneratedPoints-' + idNum + '" type="checkbox"' + (this.showGeneratedPoints ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">First point: </span>' + '<span class="geoProperty"><input id="firstPoint-' + idNum + '" size="5" value="' + this.p1 + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Second point: </span>' + '<span class="geoProperty"><input id="secondPoint-' + idNum + '" size="5" value="' + this.p2 + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Third point x: </span>' + '<span class="geoProperty"><input id="thirdPointX-' + idNum + '" size="5" value="' + this.p3x + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Third point y: </span>' + '<span class="geoProperty"><input id="thirdPointY-' + idNum + '" size="5" value="' + this.p3y + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Color: </span>' + '<span class="geoProperty"><input id="color-' + idNum + '" type="text" size="8" value="' + this.color + '" /></span><br/>');
                place.append('<input id="nParam-' + idNum + '" type="hidden" value="' + this.l1 + '"/>');
                
                place.append('<span class="geoItemCaption">Type of restriction: </span><select id="' + 'restrictionSelect-' + idNum + '" ></select><br/>');
                var restrictionSelect = place.find('select#restrictionSelect-' + idNum);
                    restrictionSelect.append('<option value="rightangle"' + (this.restriction == 'rightangle' ? ' selected="selected" ': '') + '>Right angle</option>');
                    restrictionSelect.append('<option value="isosceles"' + (this.restriction == 'isosceles' ? ' selected="selected" ': '') + '>Isosceles</option>');
                    restrictionSelect.append('<option value="equilateral"' + (this.restriction == 'isosceles' ? ' selected="selected" ': '') + '>Equilateral</option>');
                
                place.append('<span class="geoItemCaption">Line style: </span><select id="' + 'dashSelect-' + idNum + '"></select>');
                var dashSelect = place.find('select#dashSelect-' + idNum);
                for (var i = 0; i < 7; ++i)
                    dashSelect.append('<option value="' + i + '"' + (this.dash == i ? ' selected="selected" ': '') + '>' + dashStr[i] + '</option>');
                    
                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
            }
            
            GeoRestrictedTriangle.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var p1 = content.find('input#firstPoint-' + idNum).val();
                var p2 = content.find('input#secondPoint-' + idNum).val();
                var p3x = content.find('input#thirdPointX-' + idNum).val();
                var p3y = content.find('input#thirdPointY-' + idNum).val();
                var nParam = content.find('input#nParam-' + idNum).val();
                var dash = parseInt(content.find('select#dashSelect-' + idNum).val());
                var restriction = content.find('select#restrictionSelect-' + idNum).val();
                var color = content.find('input#color-' + idNum).val();
                var showGeneratedPoints = content.find('input#showGeneratedPoints-' + idNum).is(':checked');
                
                return new GeoRestrictedTriangle( { 'p1' : p1, 'p2' : p2, 'p3x' : p3x, 'p3y' : p3y, 'name' : name_Str, 'showName' : showName, 'visible' : visible, 'l1' : nParam, 'dash' : dash, 'restriction' : restriction, 'color' : color, 'showGeneratedPoints' : showGeneratedPoints});
            }
        }
        { // GeoTrapezoid           // TODO to JXG.
            /**
             * Constructor for geometric trapezoid object.
             */
            var GeoTrapezoid = function(params) {
                
                params = $.extend( {
                    'p1' : null,
                    'p2' : null,
                    'p3' : null,
                    'p4x' : null,
                    'p4y' : null,
                    'l1' : null,
                    'name' : null,
                    'showName' : true,
                    'visible' : true,
                    'color' : '#f00',
                    'dash' : 0,
                    'showGeneratedPoints' : true
                }, params);
                
                this.type = 'Trapezoid';
                this.p1 = params.p1;
                this.p2 = params.p2;
                this.p3 = params.p3;
                this.p4x = (params.p4x == 'null' ? null : params.p4x);
                this.p4y = (params.p4y == 'null' ? null : params.p4y);
                this.dash = params.dash;
                this.color = params.color;
                var n;
                if (params.l1 != null) n = parseInt(params.l1);
                else n = popNewGlobalIndex(8);
                
                this.l1 = n;
                this.l2 = n + 1;
                this.l3 = n + 2;
                this.p4 = n + 3;
                this.p5 = n + 4;
                this.p6 = n + 5;
                this.c1 = n + 6;
                this.c2 = n + 7;
                
                this.name = params.name;
                this.showName = params.showName;
                this.visible = params.visible;
                this.showGeneratedPoints = params.showGeneratedPoints;
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoTrapezoid.prototype.iconCSS = 'trapezoidBtn';
            
            GeoTrapezoid.prototype.updateSceneData = function(index, construction, content) {

                // Update values to scene array.
                var p4 = findPointByName('P' + this.p4, construction);
                
                // Two decimal precision.
                var newX = parseInt(p4.coords.usrCoords[1] * 100) / 100;
                var newY = parseInt(p4.coords.usrCoords[2] * 100) / 100;
                
                this.p4x = newX;
                this.p4y = newY;
                
                // Update values to construct accordion.
                content.find('input#fourthPointX-' + index).val(newX);
                content.find('input#fourthPointY-' + index).val(newY);
            }
            
            /**
             * Convert a GeoTrapezoid to JessieScript.
             */
            GeoTrapezoid.prototype.asJessieScript = function() {
                
                var s = 'l' + this.l1 + ' = [' + this.p1 + ' ' + this.p2 + "] nolabel;\n";
                s += 'l' + this.l2 + ' = ||(l' + this.l1 + ', ' + this.p3 + ") invisible;\n";
                s += 'c' + this.c1 + ' = k(' + this.p3 + ", 0.1) invisible;\n";
                s += 'c' + this.c2 + ' = k(' + this.p3 + ", 0.2) invisible;\n";
                s += 'P' + this.p5 + ' = c' + this.c1 + '&l' + this.l2 + " invisible;\n";
                s += 'P' + this.p6 + ' = c' + this.c2 + '&l' + this.l2 + " invisible;\n";
                s += 'l' + this.l3 + ' = ]P' + this.p5 + '_1 P' + this.p6 + "_1] invisible;\n";
                s += 'P' + this.p4 + '(l' + this.l3 + ((this.p4x != null) && (this.p4y != null) ? ', ' + this.p4x + ', ' + this.p4y : "") + ')' + (this.showGeneratedPoints ? '' : ' invisible') + ";\n";
                s += '[' + this.p3 + ' P' + this.p4 + "] nolabel;\n";
                s += '[' + this.p1 + ' ' + this.p3 + "] nolabel;\n";
                s += '[' + this.p2 + ' P' + this.p4 + "] nolabel;\n";
                return s;
            }
            
            GeoTrapezoid.prototype.asConstruct = function(board, construction) { /* Not used. */ }
            
            GeoTrapezoid.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" value="' + this.name + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">First point: </span>' + '<span class="geoProperty"><input id="firstPoint-' + idNum + '" size="5" value="' + this.p1 + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Second point: </span>' + '<span class="geoProperty"><input id="secondPoint-' + idNum + '" size="5" value="' + this.p2 + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Third point: </span>' + '<span class="geoProperty"><input id="thirdPoint-' + idNum + '" size="5" value="' + this.p3 + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Fourth point x: </span>' + '<span class="geoProperty"><input id="fourthPointX-' + idNum + '" size="5" value="' + this.p4x + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Fourth point y: </span>' + '<span class="geoProperty"><input id="fourthPointY-' + idNum + '" size="5" value="' + this.p4y + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Show generated points: </span>' + '<span class="geoProperty"><input id="showGeneratedPoints-' + idNum + '" type="checkbox"' + (this.showGeneratedPoints ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Color: </span>' + '<span class="geoProperty"><input id="color-' + idNum + '" type="text" size="8" value="' + this.color + '" /></span><br/>');
                place.append('<input id="nParam-' + idNum + '" type="hidden" value="' + this.l1 + '"/>');
                
                place.append('<span class="geoItemCaption">Line style: </span><select id="' + 'dashSelect-' + idNum + '"></select>');
                var dashSelect = place.find('select#dashSelect-' + idNum);
                for (var i = 0; i < 7; ++i)
                    dashSelect.append('<option value="' + i + '"' + (this.dash == i ? ' selected="selected" ': '') + '>' + dashStr[i] + '</option>');
                
                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
            }
            
            GeoTrapezoid.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var p1 = content.find('input#firstPoint-' + idNum).val();
                var p2 = content.find('input#secondPoint-' + idNum).val();
                var p3 = content.find('input#thirdPoint-' + idNum).val();
                var p4x = content.find('input#fourthPointX-' + idNum).val();
                var p4y = content.find('input#fourthPointY-' + idNum).val();
                var showGeneratedPoints = content.find('input#showGeneratedPoints-' + idNum).is(':checked');
                var nParam = content.find('input#nParam-' + idNum).val();
                var dash = parseInt(content.find('select#dashSelect-' + idNum).val());
                var color = content.find('input#color-' + idNum).val();
                
                return new GeoTrapezoid({'p1' : p1, 'p2' : p2, 'p3' : p3, 'p4x' : p4x, 'p4y' : p4y, 'name' : name_Str, 'showName' : showName, 'visible' : visible, 'l1' : nParam, 'dash' : dash, 'color' : color, 'showGeneratedPoints' : showGeneratedPoints});
            }
        }
        { // GeoScriptable
            /**
             * Constructor for a scriptable (JessieScript) object.
             */
            var GeoScriptable = function(params) {
                
                params = $.extend( {
                    'name' : null,
                    'script' : '',
                }, params);
                
                this.type = 'Scriptable';
                this.name = params.name;
                this.script = params.script;
            }

            GeoScriptable.prototype.updateSceneData = function(index, construction, content) { /* Not used. */ }

            /**
             * Passthrough function for upper level compatibility
             * (GeoScriptable is already JessieScript).
             */
            GeoScriptable.prototype.asJessieScript = function() {
                return this.script + "\n";
            }
            
            GeoScriptable.prototype.asConstruct = function(board, construction) { /* Not used. */ }
            
            GeoScriptable.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="10" value="' + this.name + '" /></span><br/>');
                place.append(
                    '<span class="geoItemCaption">Object definition: </span>' +
                    '<textarea id="script-' + idNum + '" rows="10" cols="50" >' + this.script + '</textarea>');
                
                place.find('input, select, textarea').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
            }
            
            GeoScriptable.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var scriptStr = content.find('textarea#script-' + idNum).val();
                return new GeoScriptable({'name' : name_Str, 'script' : scriptStr});
            }
        }
        { // GeoRectangle           // TODO to JXG.
            /**
             * Constructor for geometric rectangle object.
             */
            var GeoRectangle = function(params) {
                
                params = $.extend( {
                    'p1' : null,
                    'p2' : null,
                    'p3x' : null,
                    'p3y' : null,
                    'l1' : null,
                    'dash' : 0,
                    'name' : null,
                    'showName' : true,
                    'visible' : true,
                    'color' : '#00f',
                    'showGeneratedPoints' : true
                }, params);
                
                this.type = 'Rectangle';
                this.p1 = params.p1;
                this.p2 = params.p2;
                this.p3x = (params.p3x == 'null' ? null : params.p3x);
                this.p3y = (params.p3y == 'null' ? null : params.p3y);
                this.dash = params.dash;
                this.color = params.color;

                var n;
                if (params.l1 != null) n = parseInt(params.l1);
                else n = popNewGlobalIndex(6);
                
                this.l1 = n;
                this.l2 = n + 1;
                this.l3 = n + 2;
                this.l4 = n + 3;
                this.p3 = n + 4;
                this.p4 = n + 5;

                this.name = params.name;
                this.showName = params.showName;
                this.visible = params.visible;
                this.showGeneratedPoints = params.showGeneratedPoints;
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoRectangle.prototype.iconCSS = 'rectangleBtn';
            
            GeoRectangle.prototype.updateSceneData = GeoRhombus.prototype.updateSceneData;
            
            /**
             * Convert a GeoRectangle to JessieScript.
             */
            GeoRectangle.prototype.asJessieScript = function() {
                
                var s = "l" + this.l1 + "=[" + this.p1 + " " + this.p2 + "]" + (this.visible ? " nolabel" : " invisible") + ";\n";
                s += "l" + this.l2 + " = |_(" + this.p2 + ", l" + this.l1 + ") invisible;\n";
                s += "l" + this.l4 + " = |_(" + this.p1 + ", l" + this.l1 + ") invisible;\n";
                s += "P" + this.p3 + "(l" + this.l2 + ((this.p3x != null) && (this.p3y != null) ? ', ' + this.p3x + ', ' + this.p3y : "") + ")" + (this.visible && this.showGeneratedPoints ? "" : " invisible") + ";\n";
                s += "[" + this.p2 + " P" + this.p3 + "]" + (this.visible ? "" : " invisible") + ";\n";
                s += "l" + this.l3 + " = ||(P" + this.p3 + ",l" + this.l1 + ") invisible;\n";
                s += "P" + this.p4 + "=l" + this.l3 + "&l" + this.l4 + (this.visible && this.showGeneratedPoints ? "" : " invisible") + ";\n";
                s += "[" + this.p1 + " " + this.p2 + "]" + (this.visible ? "" : " invisible") + ";\n";
                s += "[P" + this.p3 + " P" + this.p4 + "]" + (this.visible ? "" : " invisible") + ";\n";
                s += "[P" + this.p4 + " " + this.p1 + "]" + (this.visible ? "" : " invisible") + ";\n";
                
                return s;
            }
            
            GeoRectangle.prototype.asConstruct = function(board, construction) { /* Not used. */ }
            
            GeoRectangle.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" type="text" size="5" value="' + this.name + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Show generated points: </span>' + '<span class="geoProperty"><input id="showGeneratedPoints-' + idNum + '" type="checkbox"' + (this.showGeneratedPoints ? ' checked="checked" ': '') + '/></span><br/>');
                place.append('<span class="geoItemCaption">First point: </span>' + '<span class="geoProperty"><input id="firstPoint-' + idNum + '" type="text" size="5" value="' + this.p1 + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Second point: </span>' + '<span class="geoProperty"><input id="secondPoint-' + idNum + '" type="text" size="5" value="' + this.p2 + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Third point x: </span>' + '<span class="geoProperty"><input id="thirdPointX-' + idNum + '" type="text" size="5" value="' + this.p3x + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Third point y: </span>' + '<span class="geoProperty"><input id="thirdPointY-' + idNum + '" type="text" size="5" value="' + this.p3y + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Color: </span>' + '<span class="geoProperty"><input id="color-' + idNum + '" type="text" size="8" value="' + this.color + '" /></span><br/>');
                place.append('<input id="nParam-' + idNum + '" type="hidden" value="' + this.l1 + '"/>');
                
                place.append('<span class="geoItemCaption">Line style: </span><select id="' + 'dashSelect-' + idNum + '"></select>');
                var dashSelect = place.find('select#dashSelect-' + idNum);
                for (var i = 0; i < 7; ++i)
                    dashSelect.append('<option value="' + i + '"' + (this.dash == i ? ' selected="selected" ': '') + '>' + dashStr[i] + '</option>');
                
                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
            }
            
            GeoRectangle.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var p1 = content.find('input#firstPoint-' + idNum).val();
                var p2 = content.find('input#secondPoint-' + idNum).val();
                var p3x = content.find('input#thirdPointX-' + idNum).val();
                var p3y = content.find('input#thirdPointY-' + idNum).val();
                var showGeneratedPoints = content.find('input#showGeneratedPoints-' + idNum).is(':checked');
                var nParam = content.find('input#nParam-' + idNum).val();
                var dash = parseInt(content.find('select#dashSelect-' + idNum).val());
                var color = content.find('input#color-' + idNum).val();
                
                return new GeoRectangle( { 'p1' : p1, 'p2' : p2, 'p3x' : p3x, 'p3y' : p3y, 'name' : name_Str, 'showName' : showName, 'visible' : visible, 'l1' : nParam, 'dash' : dash, 'color' : color, 'showGeneratedPoints' : showGeneratedPoints } );
            }
        }
        { // GeoGlider
            /**
             * Constructor for geometric glider object.
             */ 
            var GeoGlider = function(params) {
                
                params = $.extend( {
                    'parent' : null,
                    'x' : null,
                    'y' : null,
                    'size' : 3,
                    'name' : null,
                    'showName' : true,
                    'visible' : true,
                    'fixed' : false,
                    'color' : '#0f0'
                }, params);
                
                this.type = 'Glider';
                this.size = params.size;
                this.parent = params.parent;
                this.x = (params.x == 'null' ? null : params.x);
                this.y = (params.y == 'null' ? null : params.y);
                this.name = params.name;
                this.showName = params.showName;
                this.visible = params.visible;
                this.color = params.color;
                this.fixed = params.fixed;
            }
            
            GeoGlider.prototype.nameStr = function(construction) {
                if (this.showName) {
                    
                    var result = this.name;
                    for (var property in this) {
                        result = result.replace(new RegExp('%' + property + '%', 'g'), this[property]);
                    }
                    return result;
                    
                } else return '';
            }
            
            /**
             * CSS style defining the icon representing this type.
             **/
            GeoGlider.prototype.iconCSS = 'gliderBtn';

            GeoGlider.prototype.updateSceneData = GeoPoint.prototype.updateSceneData;
            
            /**
             * Convert a GeoGlider to JessieScript.
             */
            GeoGlider.prototype.asJessieScript = function() { return ""; /* Not used. */ }
            
            GeoGlider.prototype.asConstruct = function(board, construction) {
                /* Not used. */
                var glider;
                if ((this.x != null) && (this.y != null))
                    glider = board.create('glider', [this.x, this.y, this.parent], {
                        name : this.name,
                        size : this.size,
                        color: (this.fixed ? '#000' : this.color),
                        withLabel : this.showName,
                        visible : this.visible,
                        strokeColor: this.color,
                        fillColor: this.color,
                        fixed : this.fixed
                    });
                else
                    glider = board.create('glider', [this.parent], {
                        name : this.name,
                        size : this.size,
                        color: (this.fixed ? '#000' : this.color),
                        withLabel : this.showName,
                        visible : this.visible,
                        strokeColor: this.color,
                        fillColor: this.color,
                        fixed : this.fixed
                    });
                
                construction.points.push(glider);
                construction[this.name] = glider;
                if (this.showName) glider.label.content.setText(this.nameStr(construction));
                
            }
            
            GeoGlider.prototype.addOptionsDialog = function(place, idNum, boxnum, editable) {
                place.append('<span class="geoItemCaption">Label: </span>' + '<span class="geoProperty"><input id="name-' + idNum + '" size="5" type="text" value="' + this.name + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Parent name: </span>' + '<span class="geoProperty"><input id="parent-' + idNum + '" size="5" value="' + this.parent + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Visible: </span>' + '<span class="geoProperty"><input id="visible-' + idNum + '" type="checkbox"' + (this.visible ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Fixed: </span>' + '<span class="geoProperty"><input id="fixed-' + idNum + '" type="checkbox"' + (this.fixed ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Show label: </span>' + '<span class="geoProperty"><input id="showName-' + idNum + '" type="checkbox"' + (this.showName ? ' checked="checked" ': '') + ' /></span><br/>');
                place.append('<span class="geoItemCaption">Size: </span>' + '<span class="geoProperty"><input id="size-' + idNum + '" type="text" size="5" value="' + this.size + '"/></span><br/>');
                place.append('<span class="geoItemCaption">x-coordinate: </span>' + '<span class="geoProperty"><input id="xCoordinate-' + idNum + '" size="5" value="' + this.x + '" /></span><br/>');
                place.append('<span class="geoItemCaption">y-coordinate: </span>' + '<span class="geoProperty"><input id="yCoordinate-' + idNum + '" size="5" value="' + this.y + '" /></span><br/>');
                place.append('<span class="geoItemCaption">Color: </span>' + '<span class="geoProperty"><input id="color-' + idNum + '" type="text" size="8" value="' + this.color + '" /></span><br/>');
                
                place.find('input, select').bind('keypress.geoeditor', function(event) { enterKeyUpdate(event, boxnum, editable); })
                                   .bind('blur.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('input:checkbox, input:radio').bind('click.geoeditor', function(event) { updateScene(boxnum, editable); });
                place.find('select').bind('change.geoeditor', function(event) { updateScene(boxnum, editable); });
            }
            
            GeoGlider.prototype.createFromDialog = function(content, idNum) {
                var name_Str = content.find('input#name-' + idNum).val();
                var parentStr = content.find('input#parent-' + idNum).val();
                var showName = content.find('input#showName-' + idNum).is(':checked');
                var size = parseFloat(content.find('input#size-' + idNum).val());
                var visible = content.find('input#visible-' + idNum).is(':checked');
                var fixed = content.find('input#fixed-' + idNum).is(':checked');
                var x = parseFloat(content.find('input#xCoordinate-' + idNum).val());
                var y = parseFloat(content.find('input#yCoordinate-' + idNum).val());
                var color = content.find('input#color-' + idNum).val();
                
                return new GeoGlider( { 'parent' : parentStr, 'x' : x, 'y' : y, 'size' : size, 'name' : name_Str, 'showName' : showName, 'visible' : visible, 'color' : color, 'fixed' : fixed } );
            }
        }
        { // GeoScene
            /**
             * Constructor for geometric scene.
             */
            var GeoScene = function(params) {
                params = $.extend( {
                    'objects'     : [],
                    'boundingBox' : [12.0, 2.3, 0.8, 12.3],
                    'description' : '1',
                    'name'        : 'Scene',
                    'showGrid'    : false,
                    'isStatic'    : false,
                    'allowControls' : true
                }, params);
                
                this.type = 'Scene';
                this.objects = [];
                for (var i = 0; i < params.objects.length; i++) {
                    this.add(this.dataToObject(params.objects[i]));
                }
                
                this.name = params.name;
                this.boundingBox = params.boundingBox;
                this.description = params.description;
                this.showGrid = params.showGrid;
                this.isStatic = params.isStatic;
                this.allowControls = params.allowControls;
            
            }
            
            /**
             * Adds the given object 'obj' to the scene.
             */
            GeoScene.prototype.add = function(obj) {
                this.objects[this.objects.length] = obj;
            }

            /**
             * Constructs a geometric object from a JSON object.
             */
            GeoScene.prototype.dataToObject = function(data) {
                
                switch(data.type) {
                    case 'Point' : return new GeoPoint(data); break;
                    case 'Line' : return new GeoLine(data); break;
                    case 'Axis' : return new GeoAxis(data); break;
                    case 'Image' : return new GeoImage(data); break;
                    case 'Intersection' : return new GeoIntersection(data); break;
                    case 'RegularPolygon' : return new GeoRegularPolygon(data); break;
                    case 'AssociatedLine' : return new GeoAssociatedLine(data); break;
                    case 'Scriptable' : return new GeoScriptable(data); break;
                    case 'Circle' : return new GeoCircle(data); break;
                    case 'Triangle' : return new GeoTriangle(data); break;
                    case 'Sector' : return new GeoSector(data); break;
                    case 'Square' : return new GeoSquare(data); break;
                    case 'Angle' : return new GeoAngle(data); break;
                    case 'Parallelogram' : return new GeoParallelogram(data); break;
                    case 'Label' : return new GeoLabel(data); break;
                    case 'Rhombus' : return new GeoRhombus(data); break;
                    case 'RestrictedTriangle' : return new GeoRestrictedTriangle(data); break;
                    case 'Trapezoid' : return new GeoTrapezoid(data); break;
                    case 'Rectangle' : return new GeoRectangle(data); break;
                    case 'Polygon' : return new GeoPolygon(data); break;
                    case 'Glider' : return new GeoGlider(data); break;
                    case 'ParametricCurve' : return new GeoParametricCurve(data); break;
                }
                return data;
            }

            /**
             * Convert a scene to JessieScript.
             */
            GeoScene.prototype.asJessieScript = function() {
                var s = "";
                
                if (this.objects != null)
                for (var i = 0; i < this.objects.length; i++)
                    s += this.objects[i].asJessieScript();
                
                return s;
            }
        }
        { // Global index handling.
        // Initialize global index variable for object names.
            var globalIndex = 0;

            var popNewGlobalIndex = function(incCounter) {
                var result = globalIndex;
                globalIndex += incCounter;
                return result;
            }
        }
        { // List of different object types and their constructors.
            // List of all object type labels.
            var objTypes = ['Point', 'Line', 'Axis', 'Circle', 'Triangle', 'RestrictedTriangle', 'Square', 'Angle', 'Parallelogram', 'Label', 'Rhombus', 'Trapezoid', 'Rectangle', 'Glider', 'AssociatedLine', 'RegularPolygon', 'Sector', 'Intersection', 'Image', 'ParametricCurve', 'Scriptable'];

            // Mapper between type labels and their constructors.
            
            var objClasses= new Object();
            objClasses.Point = GeoPoint;
            objClasses.Image = GeoImage;
            objClasses.Axis = GeoAxis;
            objClasses.Line = GeoLine;
            objClasses.Circle = GeoCircle;
            objClasses.Triangle = GeoTriangle;
            objClasses.Scriptable = GeoScriptable;
            objClasses.Angle = GeoAngle;
            objClasses.Label = GeoLabel;
            objClasses.Parallelogram = GeoParallelogram;
            objClasses.Rhombus = GeoRhombus;
            objClasses.Trapezoid = GeoTrapezoid;
            objClasses.Rectangle = GeoRectangle;
            objClasses.Glider = GeoGlider;
            objClasses.AssociatedLine = GeoAssociatedLine;
            objClasses.RegularPolygon = GeoRegularPolygon;
            objClasses.Polygon = GeoPolygon;
            objClasses.Square = GeoSquare;
            objClasses.RestrictedTriangle = GeoRestrictedTriangle;
            objClasses.Sector = GeoSector;
            objClasses.Intersection = GeoIntersection;
            objClasses.ParametricCurve = GeoParametricCurve;
            
            var objCreateGuide = new Object();
            objCreateGuide.Point = ['Click to add a point to the given location.'];
            objCreateGuide.Image = ['Click to add an image to the given location.'];
            objCreateGuide.Axis = ['Click to add an axis to the given location.'];
            objCreateGuide.Line = ['Select the first point of the line.', 'Select the second point of the line.'];
            objCreateGuide.Circle = ['Select the center point of the line.', 'Select a point to set the circle radius.'];
            objCreateGuide.Triangle = ['Select the first point of the triangle.', 'Select the second point of the triangle.', 'Select the third point of the triangle.'];
            objCreateGuide.Scriptable = ['Add a scriptable object.'];
            objCreateGuide.Angle = ['Select the point defining the right border of the angle.', 'Select the corner point.', 'Select the point defining the left border of the angle.'];
            objCreateGuide.Label = ['Click to add a label to the given location.'];
            objCreateGuide.Parallelogram = ['Select the first point of the parallelogram.', 'Select the second point of the parallelogram.', 'Select the third point of the parallelogram.'];
            objCreateGuide.Rhombus = ['Select the first point of the rhombus.', 'Select the second point of the rhombus.'];
            objCreateGuide.Trapezoid = ['Select the first point of the trapezoid.', 'Select the second point of the trapezoid.', 'Click the third point of the trapezoid.'];
            objCreateGuide.Rectangle = ['Select the first point of the rectangle.', 'Select the second point of the rectangle.'];
            objCreateGuide.Glider = ['Click an element to add a glider to the given location.'];
            objCreateGuide.AssociatedLine = ['Select a point of the new line.', 'Select a circle or a line related to the association.'];
            objCreateGuide.RegularPolygon = ['Select the first point of the regular polygon.', 'Select the second point of the regular polygon. The polygon is created to left side of the line, when viewed from the first point towards the second selected point.'];
            objCreateGuide.Polygon = ['Select the first point of the polygon', 'Select the next point of the polygon.'];
            objCreateGuide.Square = ['Select the first point of the square.', 'Select the second point of the square.'];
            objCreateGuide.RestrictedTriangle = ['Select the first point of the triangle. The type of restriction is chosen afterwards.', 'Select the second point of the triangle.'];
            objCreateGuide.Sector = ['Select the corner point of the sector.', 'Select the point defining the radius of the sector.', 'Select the point defining the angle of the sector.'];
            objCreateGuide.Intersection = ['Select the first element of the intersection.', 'Select the second element of the intersection.'];
        }
        { // General elements.
        
            var findTypeByName = function(typeStr, name_Str, construction) {
                var j = -1;
                do ++j; while ((j < construction[typeStr].length) && (name_Str != construction[typeStr][j].name));
                
                var item = null;
                if (j < construction[typeStr].length) item = construction[typeStr][j];
                
                return item;
            }
        
            var findPointByName = function(name_Str, construction) {
                var j = -1;
                do ++j; while ((j < construction.points.length) && (name_Str != construction.points[j].name));
                
                var p1 = null;
                if (j < construction.points.length) {
                    
                    p1 = construction.points[j];
                }
                else {
                    j = -1;
                    do ++j; while ( (j < construction.intersections.length) && (name_Str != construction.intersections[j].name) );
                    if (j < construction.intersections.length) p1 = construction.intersections[j];
                }
                return p1;
            }
        
            var dashStr = [
                "Solid line",
                "Dotted line",
                "Small dashes",
                "Normal dashes",
                "Long dashes",
                "Med./big dashes, large gaps",
                "Med./big dashes, small gaps"
            ];
        }
    }
    { /** jQuery Plugin interface **/
        var methods = {
            'init' : function(params) {
                // call handler.
                params = $.extend( {
                    'editable' : true,
                    'width' : '100%',
                    'height' : '500px',
                    'mode' : 'free',
                    'name' : 'Scene',
                    'isSquare' : false,
                    'browsingMode' : 'free',
                    'scenes' : 
                        [   
                            {
                                'description' : "1",
                                'allowControls' : true,
                                'showAxes' : true
                            }
                        ]
                }, params);
                $(this).data('sendUpdateTrigger', true);
                /*
                 * Free mode uses tabs for numbered examples and balls
                 * for everything else.
                 */
                if (params.browsingMode == 'free') {
                    var i = 0;
                    var useTabs = true;
                    do {
                        useTabs = useTabs && (((i + 1) + '') == params.scenes[i].description.trim());
                        ++i;
                    }
                    while (useTabs && i < params.scenes.length);
                    if (!useTabs) params.browsingMode = 'tabless';
                }
                
                if (params.mode == 'square') params.width = params.height;
                else if (params.mode == 'tiny') {
                    params.width = '200px';
                    params.height = '150px';
                }
                else if (params.mode == 'small') {
                    params.width = '400px';
                    params.height = '300px';
                }
                else if (params.mode == 'medium') {
                    params.width = '512px';
                    params.height = '384px';
                }
                else if (params.mode == 'large') {
                    params.width = '640px';
                    params.height = '480px';
                }
                else if (params.mode == 'full') {
                    params.width = '100%';
                    params.height = '500px';
                }
                if (params.isSquare) params.width = params.height;

                return this.each( function() {
                    init($(this), params);
                });
            },
            'setContent' : function(data) {
                return this.each( function() {
                    setGeoSceneData($(this).data('boxnum'), data);
                    addTabs($(this).data('boxnum'), $(this).data('editable'));
                });
            },
            'getContent' : function() {
                
                //var oldvalue = $(this).data('sendUpdateTrigger');
                //$(this).data('sendUpdateTrigger', false);
                
                var arr = new Array();
                
                this.each( function() {
                    var boxnum = $(this).data('boxnum');
                    var sceneNum = parseInt($('div#previewBox-' + boxnum).find('.currentjessiebutton').eq(0).attr('tab'));
                    //setScene(boxnum, sceneNum, $(this).data('editable'));
                    //$('div#previewBox-' + boxnum).find('.currentjessiebutton').eq(0).click();
                    
                    arr[arr.length] = getGeoSceneData(boxnum);
                });
                
                //$(this).data('sendUpdateTrigger', oldvalue);
                
                return arr;
            },
            'addElement' : function(data) {
                
                data = $.extend( {
                    'state' : -1,
                    'toolType' : GeoTool.TT_CREATE_POINT,
                    'dx' : 0,
                    'dy' : 0,
                    'ux' : 0,
                    'uy' : 0,
                    'temp' : [0, 0, 0],
                    'type' : 'Point',
                    'update' : true,
                }, data);
                    
                return this.each( function() {
                    
                    var tool = new GeoTool(data);
                    var obj = initNew($(this).data('boxnum'), data.type, tool);
                    insertConstruct($(this).data('boxnum'), obj, $(this).data('editable'), data.update);
                    
                    // Added to enable tutorial mode.
                    $('div#previewBox-' + $(this).data('boxnum')).trigger('geoeditor_objectCreated', obj);
                });
            },
            'update' : function(data) {
                return this.each( function() {
                    updateScene($(this).data('boxnum'), $(this).data('editable'));
                });
            },
            'setSceneOptions' : function(data) {
                return this.each( function() {
                    var sceneArr = getGeoSceneData($(this).data('boxnum'));
                    
                    for (var i = 0; i < sceneArr.length; ++i) {
                        var sceneParams = data[i];
                        sceneParams.objects = sceneArr[i].objects;
                        sceneParams.description = sceneArr[i].description;
                        sceneParams.name = sceneArr[i].name;
                        
                        sceneArr[i] = new GeoScene(sceneParams);
                    }
                    
                    setGeoSceneData($(this).data('boxnum'), sceneArr);
                    setScene($(this).data('boxnum'), 0, $(this).data('editable'), true);
                });
            },
            'editDone' : function() {
                return this.each( function() {
                    $(this).trigger('geoeditor_changed');
                });
            },
            'getSceneOptions' : function() {
                var arr = new Array();
                this.each( function() {
                    var current = getGeoSceneData($(this).data('boxnum'));
                    for (var i = 0; i < current.length; ++i)
                        delete current[i].objects;
                    
                    arr[arr.length] = current;
                });
                return arr;
            }
        }
    
        $.fn.geoeditor = function( method ) {
             
            if ( methods[method] ) {
                return methods[method].apply( this, Array.prototype.slice.call( arguments, 1 ));
            } else if ( typeof method === 'object' || ! method ) {
                return methods.init.apply( this, arguments );
            } else {
                $.error( 'Method ' +  method + ' does not exist on jQuery.geoeditor' );
                return false;
            }    

        };
        
        var methods2 = {
            'init': function(params){
                return this.each(function(){
                    var geoeditoralign = "geoeditorcenter";
                    var options = params.data;
                    if (params.data.showmode){
                        var sizeParam = params.data.showmode;
                        if(sizeParam.substr(sizeParam.length-1) === "R" ){
                            geoeditoralign = "geoeditorright"; 
                            sizeParam = sizeParam.substr(0,sizeParam.length-1);
                        } else if( sizeParam.substr(sizeParam.length-1) === "L"){
                            geoeditoralign = "geoeditorleft"; 
                            sizeParam = sizeParam.substr(0,sizeParam.length-1);
                        } else if( sizeParam.substr(sizeParam.length-1) === "C"){
                            sizeParam = sizeParam.substr(0,sizeParam.length-1);
                        }
                        if(sizeParam === "tiny" ||sizeParam === "small" ||sizeParam === "medium" ||sizeParam === "large" ||sizeParam === "full" ){
                            options.mode=sizeParam;
                        }else if(sizeParam.substr(0,2)==="sq"){
                            options.mode="square";
                            options.height=(sizeParam.substr(2) === parseInt(sizeParam.substr(2))+''?sizeParam.substr(2)+"px":"400px");
                            
                        }else if(sizeParam.match(/w[0-9]+h[0-9]+/)){
                            var posh = sizeParam.indexOf("h");
                            options.width = sizeParam.substr(1,posh-1)+"px";
                            options.height = sizeParam.substr(posh+1)+"px";
                        }
                    }
                    $(this).addClass(geoeditoralign).attr('geoeditorsize',(options.showmode ? options.showmode :'full')).geoeditor('init', options);
                });
            }
        }

        $.fn.geoimage = function(method){
            if (methods2[method]) {
                return methods2[method].apply(this, Array.prototype.slice.call(arguments, 1));
            } else if (typeof(method) === 'object' || !method) {
                return methods2.init.apply(this, arguments);
            } else {
                $.error('Method ' + method + ' does not exist in geoimage.');
                return false;
            }
        }
    }
    
    var geoimageinfo = {
        type: 'geoimage',
        elementtype: 'elements',
        jquery: 'geoimage',
        name: 'Geoimage',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="20" height="20" viewBox="0 0 30 30" class="mini-icon mini-icon-geoimage"><circle style="stroke: black; fill: none; stroke-width: 1;" cx="15" cy="15" r="10" /></svg>',
        description: {
            en: 'Geometry image',
            fi: 'Geometriakuva'
        },
        classes: ['viewonly']
    };
    
    // Register geoimage as an element to the elementset and to the elementpanel.
    if (typeof($.fn.elementset) === 'function') {
        $.fn.elementset('addelementtype', geoimageinfo);
    }
    if ($.fn.elementpanel) {
        $.fn.elementpanel('addelementtype', geoimageinfo);
    }
    
})(jQuery)

//}}}
