// Requires: jQuery

function createExternalLink(place,url,label)
{
    var link = document.createElement("a");
    link.className = "externalLink";
    link.href = url;
    link.title = wikiEngine.messages.externalLinkTooltip.format([url]);
    if(wikiEngine.options.chkOpenInNewWindow)
        link.target = "_blank";
    place.appendChild(link);
    if(label)
        createTiddlyText(link, label);
    return link;
}

function createTiddlyElement(parent,element,id,className,text,attribs)
{
    var e = document.createElement(element);
    if(className != null)
        e.className = className;
    if(id != null)
        e.setAttribute("id",id);
    if(text != null)
        e.appendChild(document.createTextNode(text));
    if(attribs) {
        for(var n in attribs) {
            e.setAttribute(n,attribs[n]);
        }
    }
    if(parent != null)
        parent.appendChild(e);
    return e;
}

function createTiddlyText(parent,text)
{
    return parent.appendChild(document.createTextNode(text));
}

// Returns a string containing the description of an exception, optionally prepended by a message
function exceptionText(e,message)
{
    var s = e.description || e.toString();
    return message ? "%0:\n%1".format([message,s]) : s;
}

// Return the content of an element as plain text with no formatting
function getPlainText(e)
{
    return jQuery(e).text();
}

function merge(dst,src,preserveExisting)
{
    for(var i in src) {
        if(!preserveExisting || dst[i] === undefined)
            dst[i] = src[i];
    }
    return dst;
}

// Remove a node and all it's children
function removeNode(e)
{
    jQuery(e).remove();
}

// Displays an alert of an exception description with optional message
function showException(e,message)
{
    alert(exceptionText(e,message));
}

{ // Array extensions

    // Push a new value into an array only if it is not already present in the array. If the optional unique parameter is false, it reverts to a normal push
    /*Array.prototype.pushUnique = function(item,unique)
    {
        if(unique === false) {
            this.push(item);
        } else {
            if(this.indexOf(item) == -1)
                this.push(item);
        }
    };*/
}
{ // String extensions

    // Static method to encode a hashmap into a name:"value"... string
    String.encodeHashMap = function(hashmap) {
        var r = [];
        for(var t in hashmap)
            r.push(t + ':"' + hashmap[t] + '"');
        return r.join(" ");
    };

    // Static method to bracket a string with double square brackets if it contains a space
    String.encodeTiddlyLink = function(title) {
        return title.indexOf(" ") == -1 ? title : "[[" + title + "]]";
    };

    // Convert "\" to "\s", newlines to "\n" (and remove carriage returns)
    String.prototype.escapeLineBreaks = function() {
        return this.replace(/\\/mg,"\\s").replace(/\n/mg,"\\n").replace(/\r/mg,"");
    };

    // Substitute substrings from an array into a format string that includes '%1'-type specifiers
    String.prototype.format = function(s) {
        var substrings = s && s.constructor == Array ? s : arguments;
        var subRegExp = /(?:%(\d+))/mg;
        var currPos = 0;
        var r = [];
        do {
            var match = subRegExp.exec(this);
            if(match && match[1]) {
                if(match.index > currPos)
                    r.push(this.substring(currPos,match.index));
                r.push(substrings[parseInt(match[1])]);
                currPos = subRegExp.lastIndex;
            }
        } while(match);
        if(currPos < this.length)
            r.push(this.substring(currPos,this.length));
        return r.join("");
    };
    
    // Process a string list of unique tiddler names into an array. Tiddler names that have spaces in them must be [[bracketed]]
    String.prototype.readBracketedList = function(unique) {
        var p = this.parseParams("list",null,false,true);
        var n = [];
        for(var t=1; t<p.length; t++) {
            if(p[t].value)
                n.pushUnique(p[t].value,unique);
        }
        return n;
    };
    
    String.prototype.unDash = function() {
        var s = this.split("-");
        if(s.length > 1) {
            for(var t=1; t<s.length; t++)
                s[t] = s[t].substr(0,1).toUpperCase() + s[t].substr(1);
        }
        return s.join("");
    };

    // Convert "\n" to newlines, "\b" to " ", "\s" to "\" (and remove carriage returns)
    String.prototype.unescapeLineBreaks = function() {
        return this.replace(/\\n/mg,"\n").replace(/\\b/mg," ").replace(/\\s/mg,"\\").replace(/\r/mg,"");
    };
}

{ // WikiEngine config
    
    wikiEngine = {}

    { // Basic regular expressions
        wikiEngine.textPrimitives = {};
        wikiEngine.textPrimitives.upperLetter = "[A-Z\u00c0-\u00de\u0150\u0170]";
        wikiEngine.textPrimitives.lowerLetter = "[a-z0-9_\\-\u00df-\u00ff\u0151\u0171]";
        wikiEngine.textPrimitives.anyLetter = "[A-Za-z0-9_\\-\u00c0-\u00de\u00df-\u00ff\u0150\u0170\u0151\u0171]";
        wikiEngine.textPrimitives.anyLetterStrict = "[A-Za-z0-9\u00c0-\u00de\u00df-\u00ff\u0150\u0170\u0151\u0171]";
        wikiEngine.textPrimitives.sliceSeparator = "::";
        wikiEngine.textPrimitives.sectionSeparator = "##";
        wikiEngine.textPrimitives.urlPattern = "(?:file|http|https|mailto|ftp|irc|news|data):[^\\s'\"]+(?:/|\\b)";
        wikiEngine.textPrimitives.unWikiLink = "~";
        wikiEngine.textPrimitives.wikiLink = "(?:(?:" + wikiEngine.textPrimitives.upperLetter + "+" +
            wikiEngine.textPrimitives.lowerLetter + "+" +
            wikiEngine.textPrimitives.upperLetter +
            wikiEngine.textPrimitives.anyLetter + "*)|(?:" +
            wikiEngine.textPrimitives.upperLetter + "{2,}" +
            wikiEngine.textPrimitives.lowerLetter + "+))";

        wikiEngine.textPrimitives.cssLookahead = "(?:(" + wikiEngine.textPrimitives.anyLetter + "+)\\(([^\\)\\|\\n]+)(?:\\):))|(?:(" + wikiEngine.textPrimitives.anyLetter + "+):([^;\\|\\n]+);)";
        wikiEngine.textPrimitives.cssLookaheadRegExp = new RegExp(wikiEngine.textPrimitives.cssLookahead,"mg");

        wikiEngine.textPrimitives.brackettedLink = "\\[\\[([^\\]]+)\\]\\]";
        wikiEngine.textPrimitives.titledBrackettedLink = "\\[\\[([^\\[\\]\\|]+)\\|([^\\[\\]\\|]+)\\]\\]";
        wikiEngine.textPrimitives.tiddlerForcedLinkRegExp = new RegExp("(?:" + wikiEngine.textPrimitives.titledBrackettedLink + ")|(?:" +
            wikiEngine.textPrimitives.brackettedLink + ")|(?:" +
            wikiEngine.textPrimitives.urlPattern + ")","mg");
        wikiEngine.textPrimitives.tiddlerAnyLinkRegExp = new RegExp("("+ wikiEngine.textPrimitives.wikiLink + ")|(?:" +
            wikiEngine.textPrimitives.titledBrackettedLink + ")|(?:" +
            wikiEngine.textPrimitives.brackettedLink + ")|(?:" +
            wikiEngine.textPrimitives.urlPattern + ")","mg");
    }

    // Messages
    wikiEngine.messages = {
        messageClose: {},
        dates: {},
        tiddlerPopup: {},
        customConfigError: "Problems were encountered loading plugins. See PluginManager for details",
        pluginError: "Error: %0",
        pluginDisabled: "Not executed because disabled via 'systemConfigDisable' tag",
        pluginForced: "Executed because forced via 'systemConfigForce' tag",
        pluginVersionError: "Not executed because this plugin needs a newer version of TiddlyWiki",
        nothingSelected: "Nothing is selected. You must select one or more items first",
        savedSnapshotError: "It appears that this TiddlyWiki has been incorrectly saved. Please see http://www.tiddlywiki.com/#Download for details",
        subtitleUnknown: "(unknown)",
        undefinedTiddlerToolTip: "The tiddler '%0' doesn't yet exist",
        shadowedTiddlerToolTip: "The tiddler '%0' doesn't yet exist, but has a pre-defined shadow value",
        tiddlerLinkTooltip: "%0 - %1, %2",
        externalLinkTooltip: "External link to %0",
        noTags: "There are no tagged tiddlers",
        notFileUrlError: "You need to save this TiddlyWiki to a file before you can save changes",
        cantSaveError: "It's not possible to save changes. Possible reasons include:\n- your browser doesn't support saving (Firefox, Internet Explorer, Safari and Opera all work if properly configured)\n- the pathname to your TiddlyWiki file contains illegal characters\n- the TiddlyWiki HTML file has been moved or renamed",
        invalidFileError: "The original file '%0' does not appear to be a valid TiddlyWiki",
        backupSaved: "Backup saved",
        backupFailed: "Failed to save backup file",
        rssSaved: "RSS feed saved",
        rssFailed: "Failed to save RSS feed file",
        emptySaved: "Empty template saved",
        emptyFailed: "Failed to save empty template file",
        mainSaved: "Main TiddlyWiki file saved",
        mainFailed: "Failed to save main TiddlyWiki file. Your changes have not been saved",
        macroError: "Error in macro <<\%0>>",
        macroErrorDetails: "Error while executing macro <<\%0>>:\n%1",
        missingMacro: "No such macro",
        overwriteWarning: "A tiddler named '%0' already exists. Choose OK to overwrite it",
        unsavedChangesWarning: "WARNING! There are unsaved changes in TiddlyWiki\n\nChoose OK to save\nChoose CANCEL to discard",
        confirmExit: "--------------------------------\n\nThere are unsaved changes in TiddlyWiki. If you continue you will lose those changes\n\n--------------------------------",
        saveInstructions: "SaveChanges",
        unsupportedTWFormat: "Unsupported TiddlyWiki format '%0'",
        tiddlerSaveError: "Error when saving tiddler '%0'",
        tiddlerLoadError: "Error when loading tiddler '%0'",
        wrongSaveFormat: "Cannot save with storage format '%0'. Using standard format for save.",
        invalidFieldName: "Invalid field name %0",
        fieldCannotBeChanged: "Field '%0' cannot be changed",
        loadingMissingTiddler: "Attempting to retrieve the tiddler '%0' from the '%1' server at:\n\n'%2' in the workspace '%3'",
        upgradeDone: "The upgrade to version %0 is now complete\n\nClick 'OK' to reload the newly upgraded TiddlyWiki",
        invalidCookie: "Invalid cookie '%0'"
    }

    // Options that can be set in the options panel and/or cookies
    wikiEngine.options = {
        chkRegExpSearch: false,
        chkCaseSensitiveSearch: false,
        chkIncrementalSearch: true,
        chkAnimate: true,
        chkSaveBackups: true,
        chkAutoSave: false,
        chkGenerateAnRssFeed: false,
        chkSaveEmptyTemplate: false,
        chkOpenInNewWindow: true,
        chkToggleLinks: false,
        chkHttpReadOnly: true,
        chkForceMinorUpdate: false,
        chkConfirmDelete: true,
        chkInsertTabs: false,
        chkUsePreForStorage: true, // Whether to use <pre> format for storage
        chkDisplayInstrumentation: false,
        txtBackupFolder: "",
        txtEditorFocus: "text",
        txtMainTab: "tabTimeline",
        txtMoreTab: "moreTabAll",
        txtMaxEditRows: "30",
        txtFileSystemCharSet: "UTF-8",
        txtTheme: ""
    };
    
    // Browser detection... In a very few places, there's nothing else for it but to know what browser we're using.
    wikiEngine.userAgent = navigator.userAgent.toLowerCase();
    wikiEngine.browser = {
        isIE: wikiEngine.userAgent.indexOf("msie") != -1 && wikiEngine.userAgent.indexOf("opera") == -1,
        isGecko: navigator.product == "Gecko" && wikiEngine.userAgent.indexOf("WebKit") == -1,
        ieVersion: /MSIE (\d.\d)/i.exec(wikiEngine.userAgent), // wikiEngine.browser.ieVersion[1], if it exists, will be the IE version string, eg "6.0"
        isSafari: wikiEngine.userAgent.indexOf("applewebkit") != -1,
        isBadSafari: !((new RegExp("[\u0150\u0170]","g")).test("\u0150")),
        firefoxDate: /gecko\/(\d{8})/i.exec(wikiEngine.userAgent), // wikiEngine.browser.firefoxDate[1], if it exists, will be Firefox release date as "YYYYMMDD"
        isOpera: wikiEngine.userAgent.indexOf("opera") != -1,
        isLinux: wikiEngine.userAgent.indexOf("linux") != -1,
        isUnix: wikiEngine.userAgent.indexOf("x11") != -1,
        isMac: wikiEngine.userAgent.indexOf("mac") != -1,
        isWindows: wikiEngine.userAgent.indexOf("win") != -1
    };
}
