/**
 *  medium-editor button extensions
 *  MediumActionButtons v 1.0 (2015-08-25)
 *  (c) Petri Sallasmaa, Petri Salmela
 *  
 */
 (function (root, factory) {
  'use strict';
  if (typeof module === 'object') {
    module.exports = factory;
  } else if (typeof define === 'function' && define.amd) {
    define(factory);
  } else {
    root.MediumExtraButton = factory;
  }
}(this, function () {

  'use strict';
var MediumExtraButton = MediumEditor.extensions.button.extend({
    //default clickAction, can be override with options
    clickAction : "addHtml",
    // default label of the button
    label : "",
    constructor: function (options) {
        MediumEditor.Extension.call(this, options);
        },

    init: function () {
        MediumEditor.Extension.prototype.init.apply(this, arguments);

        this.button = this.createButton();
        this.on(this.button, 'click', this.handleClick.bind(this));
    },

    /* getButton: [function ()]
     *
     * If implemented, this function will be called when
     * the toolbar is being created.  The DOM Element returned
     * by this function will be appended to the toolbar along
     * with any other buttons.
     */
    getButton: function () {
        return this.button;
    },
    getAria: function () {
        return (typeof this.aria === 'function') ? this.aria(this.base.options) : this.aria;
    },
    // Creates button to medium-editor's toolbar
    createButton: function () {
        var button = this.document.createElement('button'),
            content = this.label,
            ariaLabel = this.getAria(),
            buttonLabels = this.getEditorOption('buttonLabels');
        
        // Add class names
        button.classList.add('medium-editor-action');
        if (this.buttonClassList) {
            this.buttonClassList.forEach(function (className) {
                button.classList.add(className);
            });
        }
        button.classList.add(this.addClass);
        // Add attributes
        if (ariaLabel) {
            button.setAttribute('title', ariaLabel);
            button.setAttribute('aria-label', ariaLabel);
        }
        if (this.buttonAttrs) {
            Object.keys(this.buttonAttrs).forEach(function (attr) {
                button.setAttribute(attr, this.buttonAttrs[attr]);
            }, this);
        }

        if (buttonLabels === 'fontawesome' && this.contentFA) {
            content = this.contentFA;
        }
        button.innerHTML = content;
        return button;
    },
    //Click handler, stops also click propagation
    handleClick: function (event) {
        event.preventDefault();
        event.stopPropagation();
        var action = this.getAction();

        if (action) {
            action.apply(this);
        }
    },
    //returns function that is used when button is clicked
    // for now default functionality is addHtml-function
    // action can be passed also by options with key 'clickAction'
    getAction: function () {
        if(typeof(this.clickAction) === "function"){
            return this.clickAction;
        }else if(typeof(this[this.clickAction])==="function"){
            return this[this.clickAction];
        }else{
            //for debug:
            // console.log("No click function("+this.clickAction+") for button:"+(this.name?this.name:this.label));
        }
        return false;
    },
    // returns parent element(node) of same type than action button
    // if not found returns false
    getThistypeParent: function(node){
        while(node){
            if(node.className ==="markdownelement-wysiwygedit")return false;
            if(this.isSameType(node))return node;
            node = node.parentNode;
        }
        return false;
    },
    // returns parent element(node) of same functionality than action button
    // if not found returns false
    getThisFuntionalParent: function(node){
        while(node){
            if(node.className ==="markdownelement-wysiwygedit")return false;
            if(this.isThisFuntionalType(node))return node;
            node = node.parentNode;
        }
        return false;
    },
    // Make selection of element, if outher is "true" selects element otherwise just elements content
    selectElement : function(element,outer){
        var currentPlace = document.getSelection().getRangeAt(0);
        var selection = window.getSelection();            
        var range = document.createRange();
        if(outer){
            range.selectNode(element);
        }else{
            range.selectNodeContents(element);
        }
        selection.removeAllRanges();
        selection.addRange(range);
    },
    addHtml : function(){
        // Cases are thinked with colors but should work with others too
        // if selection is empty check if allready colored
        // 1) is colored: remove or change color -OK
        // 2) not colored: add color-ok
        //      - activation of buttons!-ok
        // if selection isn't empty
        // PROBLEM if selection has "Math" inside of it
        // 1) if selection doesn't has color add it
        // 2) if selection is just one color: remove/change it fo selection
        // 3) if there is allready color in selection, remove other colors
        //      -activation of buttons
        var sele = window.getSelection();
        if(sele.isCollapsed){//selection is empty
            var sameParent = this.getThistypeParent(sele.focusNode);
            var samessortparent = this.getThisFuntionalParent(sele.focusNode);
            if( samessortparent ){
                //element has same sort of parent than this
                if(sameParent){
                    // while breaker for safety reason if data is somehow corrupted
                    var i=0;
                    var parent = sameParent.parentNode;
                    //Remove zero-length whiteSpace from begin of element's text if exists
                    if(sameParent.hasChildNodes() && sameParent.firstChild.nodeType === Node.TEXT_NODE && sameParent.firstChild.nodeValue.charCodeAt(0) ===8203){
                        sameParent.firstChild.nodeValue = sameParent.firstChild.nodeValue.substr(1);
                    }
                    //Remove zero-length whiteSpaces from end of previous element's text if exists
                    while(sameParent.previousSibling && sameParent.previousSibling.nodeType === Node.TEXT_NODE && sameParent.previousSibling.nodeValue.charCodeAt(sameParent.previousSibling.nodeValue.length-1) ===8203 && i<10){
                        sameParent.previousSibling.nodeValue = sameParent.previousSibling.nodeValue.substring(0,sameParent.previousSibling.nodeValue.length-1);
                        i++
                    } 
                    while (sameParent.hasChildNodes()) {
                        parent.insertBefore(sameParent.firstChild, sameParent);
                    }
                    // while breaker for safety reason if data is somehow corrupted
                    i=0;
                    //Remove zero-length whiteSpaces from begin of next element's text if exists
                    while(sameParent.nextSibling && sameParent.nextSibling.nodeType === Node.TEXT_NODE && sameParent.nextSibling.nodeValue.charCodeAt(0) ===8203 && i<10){
                        sameParent.nextSibling.nodeValue = sameParent.nextSibling.nodeValue.substr(1);
                        i++;
                    } 
                    parent.removeChild(sameParent);
                    this.triggerChange();
                }else{
                    var start = sele.anchorOffset;
                    //change to clicked feature
                    //Select inside of "samessortparent"
                    this.selectElement(samessortparent,false);
                    //Get interHTML of "samessortparent" for inserting
                    var insertHtml = this.elementHtml();
                    //Select inside and outside of "samessortparent"
                    this.selectElement(samessortparent,true);
                    this.base.options.ownerDocument.execCommand("insertHTML",false,insertHtml);
                    this.setAllInactive();
                    this.setActive();
                    if(!this.isThisType(sele.focusNode)){
                        this.selectElement(sele.focusNode.previousSibling,false);
                        sele.collapse(sele.focusNode.firstChild,start+1);
                    }
                }
            }else{
                if(sele.focusNode.tagName && sele.focusNode.tagName.toLowerCase() ==="div"){
                    //editor is empty
                    this.base.options.ownerDocument.execCommand("insertHTML",false,"<p>"+this.elementHtml()+"</p>");
                    if(!this.isThisType(sele.focusNode)){
                        this.selectElement(sele.focusNode.previousSibling.firstChild,false);
                    }
                }else{
                    this.base.options.ownerDocument.execCommand("insertHTML",false,this.elementHtml());
                    if(!this.isThisType(sele.focusNode)){
                        this.selectElement(sele.focusNode.previousSibling,false);
                    }
                }
                
                this.setActive();
            }
        }else{//something in selection
            var sameTypeParentAtAnchor = this.getThisFuntionalParent(sele.anchorNode);
            var sameTypeParentAtFocus = this.getThisFuntionalParent(sele.focusNode);
            var range = sele.getRangeAt(0);
            var nonEditable = this.hasNonEditableBlocks(range,sele);
            if(this.isOverBlocks(range)){
                //TODO: handle selections over elements
                // -blocks (h1-6,p,ect)
                // -lists and sublists
                // -combinations
                //TODO: make somehow lokalized alerts
                alert("Don't select over paragraphs");
            }else if(nonEditable){
                //Handle situation whera is someting noneditable in selection
                // -split and do with parts
                //TODO: make somehow lokalized alerts
                alert("Don't select over mathelements");//Now math is only noneditable element
                
            }else{
                var selHTMLorig = this.getSelectionHtml();
                var selHTML = selHTMLorig.replace(new RegExp('<span class="'+this.addClass+'" data-dataid="'+this.addClass+'_[a-z]*">(.*?)</span>','g'),"$1");
                if(sameTypeParentAtAnchor === false && sameTypeParentAtFocus === false){
                    this.base.options.ownerDocument.execCommand("insertHTML",false,this.elementHtml(selHTML));
                }else{
                    var anode = sameTypeParentAtAnchor,anchortext="",anchorData="",arange,
                        fnode = sameTypeParentAtFocus,focustext="",focusData="",frange = document.createRange(),
                        splitHTML, position, backward;
                    position = sele.anchorNode.compareDocumentPosition(sele.focusNode),
                    backward = false;
                    // position == 0 if nodes are the same
                    if (!position && sele.anchorOffset > sele.focusOffset || 
                      position === Node.DOCUMENT_POSITION_PRECEDING)
                      backward = true;
                      
                    if(backward){
                        anode=sameTypeParentAtFocus;
                        fnode=sameTypeParentAtAnchor;
                    }
                    if(anode){
                        //selHTML = selHTML.replace('</span>$','');
                        arange = document.createRange();
                        arange.selectNode(anode);
                        sele.addRange(arange);
                        splitHTML = selHTMLorig.replace(new RegExp('^<span class="'+this.addClass+'" data-dataid="'+this.addClass+'_[a-z]*">'),"");
                    }
                    if(fnode){
                        //selHTML = selHTML.replace((new RegExp('<span class="'+this.addClass+'" dataid="'+this.addClass+'_[a-z]*">'),""));
                        frange = document.createRange();
                        frange.selectNode(fnode);
                        sele.addRange(frange);
                        splitHTML = (splitHTML?splitHTML.replace(/<\/span>$/,''):selHTMLorig.replace(/<\/span>$/,''));
                    }
                    var splitted = this.getSelectionHtml().split(splitHTML);
                    if(splitted[0] !== ""){
                        anchortext = splitted[0]+"</span>";
                    }
                    if(splitted[1] !==""){
                        focustext = "<span class=\""+this.addClass+"\" data-dataid=\""+fnode.attributes['data-dataid'].value+"\">"+splitted[1];
                    }
                                       
                    
                    this.base.options.ownerDocument.execCommand("insertHTML",false,anchortext+this.elementHtml(selHTML)+focustext);
                }
                this.setAllInactive();
                this.setActive();
            }
        }
        
    },
    hasNonEditableBlocks : function(range,selection){
        var allWithinRangeParent = range.commonAncestorContainer.getElementsByTagName?range.commonAncestorContainer.getElementsByTagName("*"):[],
            nonEditables = {start:range.startContainer.getAttribute && range.startContainer.getAttribute('contenteditable') ==="false",end:range.endContainer.getAttribute && range.endContainer.getAttribute('contenteditable') ==="false",middle:[]},
            hasNonEditables = false;
        
        for (var i=0, el; el = allWithinRangeParent[i]; i++) {
          // The second parameter says to include the element 
          // even if it's not fully selected
          if (selection.containsNode(el, false) ) {
            if(el.getAttribute('contenteditable') ==="false"){
                nonEditables.middle.push(el); hasNonEditables = true;
            }
          }
        }
        if(nonEditables.start||nonEditables.end||hasNonEditables){
            return nonEditables;
        }else {
            return false;
            
        }
    },
    isOverBlocks : function(range){
        if(range.startContainer === range.endContainer && range.startContainer === range.commonAncestorContainer){
            return false;
        }
        var commonAncestorContainer = range.commonAncestorContainer;
        if(/h[1-6]|p/.test(commonAncestorContainer.tagName.toLowerCase())){
            return false;
        }
        return true;
    },
    elementHtml : function(htmlText){
        if(typeof(htmlText)==="undefined")htmlText=this.getSelectionHtml();
        var returnText = "\u200B<"
            +this.start
            +" class=\""
            +this.addClass
            +"\" "
            +"data-dataid=\""
            +this.dataId
            // Add zero-length nbsp into span because Medium editor makes otherwise whiteSpace trims to it
            +"\">\u200B"
            +htmlText
            +(this.end?"</"+this.end+">\u200B":"/>\u200B");
        return returnText.replace(/[\u200B-\u200D\uFEFF]+/g, '\u200B');
    },
    getSelectionHtml : function() {
        var html = "";
        if (typeof window.getSelection != "undefined") {
            var sel = window.getSelection();
            if (sel.rangeCount) {
                var container = document.createElement("div");
                for (var i = 0, len = sel.rangeCount; i < len; ++i) {
                    container.appendChild(sel.getRangeAt(i).cloneContents());
                }
                html = container.innerHTML;
            }
        } else if (typeof document.selection != "undefined") {
            if (document.selection.type == "Text") {
                html = document.selection.createRange().htmlText;
            }
        }
        return html;
    },
    isActive: function () {
        return this.button.classList.contains(this.getEditorOption('activeButtonClass'));
    },

    setInactive: function () {
        this.button.classList.remove(this.getEditorOption('activeButtonClass'));
        delete this.knownState;
    },
    setAllInactive: function () {
        var activeButtons = this.getEditorOption('elementsContainer').getElementsByClassName(this.getEditorOption('activeButtonClass'));
        for(var i=0;i<activeButtons.length;i++){
            if(activeButtons[i].classList && activeButtons[i].classList.contains(this.addClass)){
                activeButtons[i].classList.remove(this.getEditorOption('activeButtonClass'));
            }
        }
    },

    setActive: function () {
        this.button.classList.add(this.getEditorOption('activeButtonClass'));
        delete this.knownState;
    },

    isThisType: function (node) {
        if(typeof(node)==="undefined")return false;
        return  node.attributes && node.attributes['data-dataid'] && node.attributes['data-dataid'].value === this.dataId && this.start.toLowerCase() === node.nodeName.toLowerCase() && this.isClassMatch(node.classList)
    },
    isThisFuntionalType: function (node) {
        if(typeof(node)==="undefined" || typeof(node.classList) ==="undefined")return false;
        return this.start.toLowerCase() === node.nodeName.toLowerCase() && node.classList && this.isClassMatch(node.classList)
    },
    isSameType: function (node) {
        return this.isThisFuntionalType(node) && this.isThisType(node);
    },

    isAlreadyApplied: function (node) {

        var isMatch  = false;

        if (this.knownState === false || this.knownState === true) {
            return this.knownState;
        }
        if (this.isThisType(node)) {
            isMatch = true;
            this.knownState = isMatch;
        }
        return isMatch;
    },
    isClassMatch: function(classList){
        if(classList.length !== 1) return false;
        if(classList[0] !== this.addClass) return false;
        return true;
    },
    triggerChange: function(element){
        try{
            if(typeof(element) ==="undefined"){
                element = this.base.elements[0].parentNode;
            }
            element.dispatchEvent(new Event('change'));
        }catch(err){
            console.log("mediumButton2, Error: ",err);
        }
        
    }
});

  return MediumExtraButton;
}()));
  