/****************************
 * EbookLocalizer
 * Class for translating / localizing system of ebooks.
 * 20.5.2014
 * Petri Salmela
 * Petri Sallasmaa
 * Four Ferries Oy
 ****************************/

/**
 * Requirements:
 * - jQuery
 */

try {
    typeof(jQuery) !== 'undefined';
} catch (err) {
    throw new Error('Missing dependency in ' + err.fileName + '\n' + err);
}

window.EbookLocalizer = function(defaultlang){
    this.dictionary = {};
    this.defaultlang = defaultlang || 'en';
}

EbookLocalizer.prototype.setLanguage = function(lang){
    this.defaultlang = lang;
}

EbookLocalizer.prototype.localize = function(term, lang){
    if (typeof(lang) === 'undefined') {
        lang = this.defaultlang;
    }
    var translation = (this.dictionary[lang] && this.dictionary[lang][term]) ||
        (this.dictionary[this.defaultlang] && this.dictionary[this.defaultlang][term]) ||
        (this.dictionary['en'] && this.dictionary['en'][term]) || '';
    if (translation === '') {
        console.log('Missing translation: ' + term + '\n  in language: ' + lang);
    }
    return translation;
}

EbookLocalizer.prototype.localizeText = function(text, lang){
    if (typeof(lang) === 'undefined') {
        lang = this.defaultlang;
    }
    var rex = /{%.*?%}/;
    var allmatch = text.match(/{%.*?%}/g);
    var maxcount = allmatch && allmatch.length || 0;
    var match = text.match(rex);
    var count = 0;
    while (match && count < maxcount){
        count++;
        var placeholder = match[0];
        var term = placeholder.substr(2, placeholder.length-4);
        var newtext = (this.dictionary[lang] && this.dictionary[lang][term]) ||
            (this.dictionary[this.defaultlang] && this.dictionary[this.defaultlang][term]) ||
            (this.dictionary['en'] && this.dictionary['en'][term]) || '';
        if (newtext === '') {
            console.log('Missing translation: ' + term + '\n  in language: ' + lang);
        }
        text = text.replace(rex, newtext);
        match = text.match(rex);
    }
    return text;
}

EbookLocalizer.prototype.addTranslations = function(data){
    this.dictionary = $.extend(true, this.dictionary, data);
}

if (typeof(ebooklocalizer) === 'undefined'){
    window.ebooklocalizer = new EbookLocalizer();
}
