(function($) {
    var fileSystem = new require("fs");

    //var proveWsUrl = "ws://localhost:9000/checker/prove";
    var proveWsUrl = "wss://sdchecker.fourferries.com:9443/checker/prove";

    var settings = {
            variables:[{"name":"x","type":"real"},{"name":"y","type":"real"},{"name":"z","type":"real"}],
            constants:[],
            theories:["real.Real", "real.PowerReal", "real.Square", "real.Abs", "real.FromInt", "real.ExpLog", "Bool",
                "extra.ExtendPowerReal", "extra.GeneralLog", "extra.Trigonometry"],
            decimalSeparator: ","
        };

    var useropts = JSON.parse(fileSystem.readFileSync('data/settings/useroptions.json'));
    var systemopts = JSON.parse(fileSystem.readFileSync('data/settings/systemoptions.json'));

    // A plugins-object can include several plugins with different keys.
    var plugins = {
        /*********************************
         * Checker plugin
         *********************************/
        Checker: {
            // Label of the menu
            label: {
                en: 'Check',
                fi: 'Tarkista',
                sv: 'Granska'
            },
            // Plugins are ordered by this "weight" in the menu.
            order: 1,


            // Menu items that are selectable from this plugin.
            items: [{
                // Name of the menu item.
                name: 'Checker',

                // Label of the menu item in different languages.
                label: {
                    en: 'Check',
                    fi: 'Tarkista',
                    sv: 'Granska'
                },

                // Icon shown in the menu (html5-string, can be empty string).
                icon: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="20" height="20" viewBox="0 0 20 20" class="geoedit-icon geoedit-object-line"><path stroke="none" fill="#666" d="M3 10 l3 0 l3 5 l7 -12 l2 2 l-9 14z" /><path stroke="none" fill="#070" d="M2 9 l3 0 l3 5 l7 -12 l2 2 l-9 14z" /></svg>',

                // Description shown as a tooltip for the menu item.
                description: {
                    en: 'Check the derivation',
                    fi: 'Tarkista päättelyketju',
                    sv: 'Granska härledningen'
                },

                // Function that will be executed, when this menu item is selected.
                // Gets the editor-object as parameter.
                action: function(editor) {
                    // Define some variables.
                    var uilang = editor.settings.uilang,
                        waitanimation = '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="100" height="100" viewBox="0 0 100 100" class="sdeditor-icon sdeditor-icon-wait"><circle stroke="none" fill="#666" cx="50" cy="20" r="0"><animate attributeType="XML" attributeName="r" begin="0.00s" dur="3s" values="0; 8; 0; 0;" repeatCount="indefinite" /><animate attributeType="XML" attributeName="opacity" begin="0.00s" dur="3s" values="0; 1; 0; 0;" repeatCount="indefinite" /></circle><circle stroke="none" fill="#666" cx="70" cy="30" r="0"><animate attributeType="XML" attributeName="r" begin="0.375s" dur="3s" values="0; 8; 0; 0;" repeatCount="indefinite" /><animate attributeType="XML" attributeName="opacity" begin="0.375s" dur="3s" values="0; 1; 0; 0;" repeatCount="indefinite" /></circle><circle stroke="none" fill="#666" cx="80" cy="50" r="0"><animate attributeType="XML" attributeName="r" begin="0.75s" dur="3s" values="0; 8; 0; 0;" repeatCount="indefinite" /><animate attributeType="XML" attributeName="opacity" begin="0.75s" dur="3s" values="0; 1; 0; 0;" repeatCount="indefinite" /></circle><circle stroke="none" fill="#666" cx="70" cy="70" r="0"><animate attributeType="XML" attributeName="r" begin="1.125s" dur="3s" values="0; 8; 0; 0;" repeatCount="indefinite" /><animate attributeType="XML" attributeName="opacity" begin="1.125s" dur="3s" values="0; 1; 0; 0;" repeatCount="indefinite" /></circle><circle stroke="none" fill="#666" cx="50" cy="80" r="0"><animate attributeType="XML" attributeName="r" begin="1.50s" dur="3s" values="0; 8; 0; 0;" repeatCount="indefinite" /><animate attributeType="XML" attributeName="opacity" begin="1.50s" dur="3s" values="0; 1; 0; 0;" repeatCount="indefinite" /></circle><circle stroke="none" fill="#666" cx="30" cy="70" r="0"><animate attributeType="XML" attributeName="r" begin="1.875s" dur="3s" values="0; 8; 0; 0;" repeatCount="indefinite" /><animate attributeType="XML" attributeName="opacity" begin="1.875s" dur="3s" values="0; 1; 0; 0;" repeatCount="indefinite" /></circle><circle stroke="none" fill="#666" cx="20" cy="50" r="0"><animate attributeType="XML" attributeName="r" begin="2.25s" dur="3s" values="0; 8; 0; 0;" repeatCount="indefinite" /><animate attributeType="XML" attributeName="opacity" begin="2.25s" dur="3s" values="0; 1; 0; 0;" repeatCount="indefinite" /></circle><circle stroke="none" fill="#666" cx="30" cy="30" r="0"><animate attributeType="XML" attributeName="r" begin="2.625s" dur="3s" values="0; 8; 0; 0;" repeatCount="indefinite" /><animate attributeType="XML" attributeName="opacity" begin="2.625s" dur="3s" values="0; 1; 0; 0;" repeatCount="indefinite" /></circle></svg>',
                        curtain = $('<div class="sdCheckCurtain">' + waitanimation + '</div>'),
                        css = ['.sdCheckCurtain {position: absolute; top: 0; bottom: 0; left: 0; right: 0; background-color: rgba(255,255,255,0.4);}',
                               '.sdCheckCurtain svg {position: absolute; top: 50%; left: 50%; margin-top: -50px; margin-left: -50px;}'].join('\n');

                    // Data that will be sent to the checker.
                    var checkData = $.extend({
                        username        : editor.settings.username,
                        lang            : editor.settings.uilang,
                        decimalSeparator: settings.decimalSeparator,
                        variables       : settings.variables,
                        constants       : settings.constants,
                        theories        : settings.theories
                    }, editor.getCheckData());

                    function callChecker(signatureData) {
                        var socket = new WebSocket(proveWsUrl);
                        var validData = {
                            signature:signatureData.signature,
                            checkdata:checkData
                        }
                        var messageComment = {
                                empty: {
                                    en: "Nothing to check.",
                                    fi: "Ei mitään tarkistettavaa.",
                                    sv: "Inget att checka."
                                },
                                correct: {
                                    en: "The derivation is correct.",
                                    fi: "Päättelyketju on oikea.",
                                    sv: "Härledningen är korrekt."
                                },
                                wrong: {
                                    en: "Some steps could not be automatically verified.",
                                    fi: "Joitakin askeleita ei voitu automaattisesti tarkistaa.",
                                    sv: "Vissa steg kan inte verifieras automatiskt."
                                },
                                progress: {
                                    en: "Checking is in progress...",
                                    fi: "Tarkistaminen on käynnissä...",
                                    sv: "Kontroll pågår..."
                                },
                                serverfailure: {
                                    en: "The server is not responding.",
                                    fi: "Palvelin ei vastaa.",
                                    sv: "Servern svarar inte."
                                },
                                derivationError: {
                                    en: "The derivation has errors and hence could not be checked.",
                                    fi: "Päättelyketjussa on virheitä, joten sitä ei voi tarkistaa.",
                                    sv: "Härledningen innehåller fel som gör att den inte kunde granskas."
                                }
                            },
                            result = {
                                "general": "General feedback for whole solution",
                                "messages": []
                            },
                            wrongSteps = [],
                            derivationError = false;

                        editor.place.trigger('clearreview');

                        socket.onerror = function(e) {
                            derivationError = true;
                            generalFeedback(result, 'wrong', messageComment.serverfailure[uilang]);
                            socket.close();
                        }

                        socket.onopen = function(e) {
                            $('#checkersendbox').val(JSON.stringify(validData, null, 4));
                            try{
                                //Curtain appears
                                editor.place.trigger('sdeditor-checkstart', validData.checkdata);

                                //Puts progress message to the derivation feedback box for each task and observation.
                                validData.checkdata.steps.forEach(function(value, index) {
                                    if(value.steptype != 'assumption' && value.type != 'declaration') {
                                        result.messages.push({
                                            loc: value.loc,
                                            mark: "wrong",
                                            comment: messageComment.progress[uilang]
                                        });
                                    }
                                });
                                editor.place.trigger('addmarkings', result);
                                socket.send(JSON.stringify(validData));
                            }
                            catch(err){
                                //If derivation list(steps = []) is empty. Meaning nothing to prove
                                if (validData.checkdata.steps.length == 0) {
                                    generalFeedback(result, 'correct', messageComment.empty[uilang])
                                }
                                socket.close()
                            }
                        }
                        socket.onmessage = function(e) {
                            var receivedData = JSON.parse(e.data);
                            /*
                             * Checks if the location is empty which occurs when derivation format is wrong or java error on backend
                             * and also checks if the error is of missing value type. Such as missing relation.
                             */
                            if (receivedData.loc == "" || receivedData.loc == null) {
                                derivationError = true;
                                generalFeedback(result, receivedData.mark, receivedData.comment);
                                return; //Should not append the result messages with null location message.
                            }
                            else if(receivedData.mark == 'missingValue' || receivedData.mark == 'declarationError'){
                                derivationError = true;
                                receivedData.mark = 'wrong';
                                generalFeedback(result, 'wrong', messageComment.derivationError[uilang])
                            }
                            else if (receivedData.mark == 'wrong' || receivedData.mark == "note"){
                                wrongSteps.push($('[data-loc="' + receivedData.loc + '"]').closest('[class=sdlayouttable]').parent().attr('data-loc'));
                            }
                            result.messages.push(receivedData);
                            editor.place.trigger('addmarkings', result);
                        }

                        socket.onclose = function(e) {
                            // Removes the progress objects from the message array.
                            result.messages = result.messages.filter(function(value) {
                                return value.comment !== messageComment.progress[uilang];
                            });

                            // Clear all the markings.
                            editor.place.trigger('clearreview');

                            // Remove the curtain
                            curtain.remove();

                            if (derivationError==false) {
                                validData.checkdata.steps.forEach(function (value, index) {
                                    if (value.steptype != 'assumption' && value.type != 'declaration') {
                                        // Checks if the related derivation has been marked to unproved list of not.
                                        if ($.inArray(value.loc, wrongSteps) == -1) {
                                            result.messages.push({
                                                loc: value.loc,
                                                mark: 'correct',
                                                comment: messageComment.correct[uilang]
                                            })
                                        }
                                        else {
                                            result.messages.push({
                                                loc: value.loc,
                                                mark: 'wrong',
                                                comment: messageComment.wrong[uilang]
                                            })
                                        }
                                    }
                                });
                            }

                            // Render the checker box with updated results
                            $('#checkerbox').html(JSON.stringify(result, null, 4));
                            editor.place.trigger('addmarkings', result);

                            console.log("Connection closed")
                        }
                        function generalFeedback(result, type, message) {
                            return result.messages.push({
                                loc: validData.checkdata.name,
                                mark: type,
                                comment: message
                            });
                        }
                    };


                    // Create a style-tag and put it in the head of html document
                    // and add the "curtain" that prevents editing.
                    // These will be removed, when checking is done.
                    if($('#sdeditor-checker-css').length ===0){
                        $('head').append('<style id="sdeditor-checker-css" type="text/css">' + css + '</style>');
                    }
                    editor.place.append(curtain);

                    var unAuthorizedMessage = {
                            en: "The user has depleted the checking quota.",
                            fi: "Käyttäjä on kuluttanut tarkistusmäärä loppuun.",
                            sv: "Användaren har använt upp sin checkningskvot."
                        };

                    var authServerError = {
                            en: "The authentication server is not responding.",
                            fi: "Todennuspalvelin ei vastaa.",
                            sv: "Autenticeringsservern svarar inte."
                        };

                    try {
                        $.ajax({
                            type: 'POST',
                            url: systemopts["connection"]["serverURL"],
                            dataType: 'json',
                            timeout: 5000,
                            data: {
                                "type" : 13,
                                "username" : editor.settings.username,
                                "appkey" : useropts["applicationkey"],
                                "json"   : JSON.stringify(checkData)
                            }
                        }).done(
                            function(respondData) {
                                if(respondData.success){
                                    callChecker(respondData);
                                }else{
                                    curtain.remove();
                                    editor.place.trigger('clearreview');
                                    editor.place.trigger('addmarkings', {
                                        "general": "General feedback for whole solution",
                                        "messages": [{
                                            loc: checkData.name,
                                            mark: "wrong",
                                            comment: unAuthorizedMessage[uilang]
                                        }]
                                    });
                                }
                            }).fail(
                            function(faildata) {
                                curtain.remove();
                                editor.place.trigger(
                                    'addmarkings',
                                    {
                                        "general": "General feedback for whole solution",
                                        "messages": [{
                                            loc: checkData.name,
                                            mark: "wrong",
                                            comment: authServerError[uilang]
                                        }]
                                    });
                                console.log('error', faildata);
                            });
                    } catch(e) {
                        console.log('ERROR', e);
                        curtain.remove();
                    }
                }
            }, {
                // This menu item clears the review markings from the derivation.
                name: 'Clear markings',
                label: {
                    en: 'Clear markings',
                    fi: 'Poista merkinnät',
                    sv: 'Avlägsna markeringarna'
                },
                icon: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="200" height="200" viewBox="0 0 20 20" class="geoedit-icon geoedit-object-line"><path stroke="none" fill="#666" d="M4.5 3.5 l2 -1 l14 16 l-3 1z m13 0 l2 1 l-15 15 l-2 -2z" /><path stroke="none" fill="#a00" d="M3 3 l2 -1 l14 16 l-3 1z m13 0 l2 1 l-15 15 l-2 -2z" /></svg>',
                description: {
                    en: 'Clear the correction markings',
                    fi: 'Poista korjausmerkinnät',
                    sv: 'Avlägsna korrigeringsmarkeringarna'
                },
                action: function(editor) {
                    // Just set empty review.
                    editor.place.trigger('clearreview');
                    //curtain.remove();
                }
            }]
        }
    };
    // Load this plugin to the sdeditor.
    $.fn.sdeditor('addplugin', plugins);
})(jQuery)