/*******************************************
 * Main/start javascript for application         
 * 20.5.2014
 * Petri Sallasmaa
 * Petri Salmela
 * Four Ferries Oy
*******************************************/
//catch error if loading systemjavascripts
window.onerror = function (errorMsg, url, lineNumber) {
    if(typeof(window.systemPreLoad) !== "undefined"){
        try{
            var spliturl = url.split("/");
            var element = document.getElementById(spliturl[spliturl.length-1]);
            element.onload = null;
            element.parentNode.removeChild(element);
            window.systemPreLoad.fileIndex +=1;
            window.systemPreLoad.fileList.list.push(spliturl[spliturl.length-1]);
            window.systemPreLoad.loadLoop();
            return true;
        }catch(e){
            console.log("windowError:"+e);
            console.log(e);
            return false;
        }
    }else{
        return false;
    }
}
/***********
* object to handle dynamic javascriptloading
***********/
window.systemPreLoad={};

window.systemPreLoad.loadSystemCSS = function() {
    window.systemPreLoad.loadCSS(window.systemPreLoad.fileSystem.getSystemCSS());
}
window.systemPreLoad.loadSystemThemeCSS = function() {
    window.systemPreLoad.loadCSS(window.systemPreLoad.fileSystem.getSystemThemeCSS());
}
window.systemPreLoad.loadCSS = function(fileList) {
    for(var i=0;i<fileList.list.length;i++){
        window.systemPreLoad.embedToHead(fileList.path+"/",fileList.list[i],"css");
    }
    
}
window.systemPreLoad.loadSystemJs = function() {
    window.systemPreLoad.fileList = window.systemPreLoad.fileSystem.getSystemJS();
    
    window.systemPreLoad.systemJs = [
        // {path:"data/js",listItem:"appFileSystem.js"},//TODO: try load also filesystem. Now loaded in main html
        {path:"data/js",listItem:"connection.js"},
        {path:"data/js",listItem:"systemJs.js"}
    ];
    
    window.systemPreLoad.fileIndex = 0;
    window.systemPreLoad.loadLoop();
}
window.systemPreLoad.loadLoop = function() {
    if(window.systemPreLoad.fileList.list.length >0 && window.systemPreLoad.fileList.list.length >= window.systemPreLoad.fileIndex){ 
        window.systemPreLoad.listItem = window.systemPreLoad.fileList.list.shift();
        
        try{
            // console.log("TRY",window.systemPreLoad.listItem);
            window.systemPreLoad.embedToHead(window.systemPreLoad.fileList.path+"/",window.systemPreLoad.listItem,"js");
        }catch(e){
            window.systemPreLoad.fileList.list.push(window.systemPreLoad.listItem);
            window.systemPreLoad.fileIndex +=1;
            window.systemPreLoad.loadLoop();
        }
    }else{
        if(window.systemPreLoad.systemJs.length>0){
            var loadItem = window.systemPreLoad.systemJs.shift();
            try{
                window.systemPreLoad.embedToHead(loadItem.path+"/",loadItem.listItem,"js");
            }catch(e){
                console.log("systemJs load error:");
                console.log(e);
            }
        }else{
            window.systemPreLoad.startSystem();
        }
    }
}
window.systemPreLoad.embedToHead = function(path,filename, filetype){
    // console.log("EMBED",path,filename, filetype)
    try{
        var fileInprogress=filename;
        if (filetype=="js"){ //if filename is a external JavaScript file
            var fileref=document.createElement('script');
            fileref.setAttribute("id",filename);
            fileref.setAttribute("type","text/javascript");
            fileref.setAttribute("src", path+filename);
        }
        else if (filetype=="css"){ //if filename is an external CSS file
            var fileref=document.createElement("link");
            fileref.setAttribute("rel", "stylesheet");
            fileref.setAttribute("type", "text/css");
            fileref.setAttribute("href", path+filename);
        }
        if (typeof fileref!="undefined"){
            try{
                document.getElementsByTagName("head")[0].appendChild(fileref);
            }catch(e){
                console.log("appendError:"+e);
            }
        }
        fileref.onload = function(e){
            try{
                
                try{
                    //Do if window.preload still exists if not everything it ready to go.
                    window.systemPreLoad.fileIndex = 0;
                    window.systemPreLoad.loadLoop();
                }catch(e){
                    //Do nothing
                }
                fileref.onload = null;
            }catch(e){
                console.log("onloadError:"+e);
                fileref.onload = null;
            }
        }
    }catch(e){
        console.log(e);
    }
}    
window.systemPreLoad.startSystem = function(){
    jQuery('#system').system();
    delete window.systemPreLoad;
} 

try{
    window.systemPreLoad.fileSystem = new appFileSystem();
}catch(e){
    console.log("appFileSystem error");
}

/***********
* start loading system
***********/
window.onload = function(){
try{
    try{
        var msgSpan = document.createElement('span');
        msgSpan.innerHTML = "loading system";
        msgSpan.setAttribute("type", "notification");
        msgSpan.setAttribute("class", "currentMsg");
        document.getElementById('notificationArea').appendChild(msgSpan);
    } catch(e){
        //no notification area
    }
    window.systemPreLoad.loadSystemCSS();
    window.systemPreLoad.loadSystemThemeCSS();
    window.systemPreLoad.loadSystemJs();
} catch(e){
    console.log(e);
    alert("preloadError:"+e);
}
}

