/*****************************************************************
 * Application filesystem for node-webkit
 * Constructor
 * 20.5.2014
 * Petri Sallasmaa
 * Petri Salmela
 * Four Ferries Oy
 *****************************************************************/
    function appConnection(params) {
        
        var self = this;
        this.defaulParameters = 
            {
                config: {
                    general: {
                        version: 2015.0506
                    }
                },
                serverURL:"http://virum.fi/service/app",
                // serverURL:"http://virum.fi:8080/serviceqanew/app",
                errors:{
                    1:{
                        "errorclass":"connection",
                        "errortype":1,
                        "localizableerror":"CONNECTION_FAILED",
                        "errormessage":"connection to server failed",
                        "success":false
                    },
                    2:{
                        "errorclass":"connection",
                        "errortype":2,
                        "localizableerror":"DATAPARSING_ERROR",
                        "errormessage":"Error in server responsedata",
                        "success":false
                    }
                },
                debugmode : false
            };
        // Handle params.
        var extended = $.extend(true,
            {},
            this.defaulParameters,
            params
        );
        
        for (var item in extended) {
            this[item] = extended[item];
        }
        this.request = new require("request");
        
    }
    
    /******
     *get from internet
     ******/
    appConnection.prototype.serverConnection = function(type,data,replyPlace,connectionid) {
        var connector = this;
        //For debug serverresponse settings
        var debugConnection = this.debugmode;
        var disablereturnData= false;
        //For debug server
        if(debugConnection)console.log("serverConnection",type,data,replyPlace,connectionid);
        this.request.post({
                url:     this.serverURL,
                form:    data
            }, function(error, response, body){
                //For debug serverresponse
                if(debugConnection && false ){
                    console.log("response:");
                    console.log(response);
                    console.log(body);
                    console.log(error);  
                }
                if(error){
                    var responseObject=connector.errors[1];
                    responseObject['requesttype']=type;
                    console.log("Server ERROR:"+type);
                    console.log(error);
                    console.log("--------------");
                }else{
                    try{
                        var responseObject=JSON.parse(body);
                        if(disablereturnData){
                            responseObject['systemupdate']=[];
                            responseObject['contentupdate']=[];
                        }
                        responseObject['requesttype']=type;
                        responseObject['username']=data.username;
                        responseObject['originalData']=data;
                        
                    }
                    catch(e){
                        var responseObject=connector.errors[2];
                        responseObject['requesttype']=type;
                        console.log("Server ERROR:"+type);
                        console.log(e);
                        console.log("--------------");
                    }
                }
                // for debug 
                if(debugConnection) 
                    console.log('connection.'+type,connectionid,[responseObject]);
                replyPlace.trigger('connection-'+(typeof(connectionid) !== "undefined"?connectionid:type),[responseObject]);
            });
    }
    