(function ($) {
    /*****************************************************************
     * System
     * Constructor
     *****************************************************************/
    function Notebooks(place, params) {
        params = $.extend(
            true,
            {},
            {
                config: {
                    general: {
                        lang: "en-US",
                        uilang: "en",
                        version: 2015.0227
                    },
                    dialogHeight:function(){return Math.floor(window.outerHeight*0.8)}
                },
                neededPlugins:[
                    "notebook","reader"
                ],
                CSSrules:[
                    {"element":".removeActive .applicationButton.addnotebook",
                    "rules":"display: none;"},            
                    {"element":" .notebookselection",
                    "rules":"display: flex;margin-top: 1em;  flex-wrap: wrap;min-width:150px;"},
                    {"element":".removeActive .notebookselection .notebookSelector:before",
                    "rules":"content:\"X\";width:15px;height:15px;border:1px solid black;border-radius:10px;padding:5px;background-color:red;color:white;font-weight:bold;position: absolute;margin-left: 4.5em;"},
                    {"element":".notebooks",
                    "rules":"min-width:300px;"},
                    {"element":" .notebookSelector:hover",
                    "rules":"box-shadow:5px 5px 5px #999,-5px -5px 5px #999;"},
                    {"element":" .notebookSelector",
                    "rules":"cursor:pointer;background-color:white;border:1px solid gray;padding:0.2em;border-radius:5px;min-height:100px;min-width:100px;display:inline-block;margin-left:1em; margin-bottom:1em;"},
                    {"element":" .notebookSelector .bookname",
                    "rules":"overflow: hidden; min-width: 90px; min-height: 90px; text-overflow: ellipsis; display: inline-block;"}
                ],
                applicationType:"notebooks",
                applicationcontentpath : "own_notes",
                contexttype : "own_notes",
                defaultnew:{
                    type: 'book',
                    metadata: {
                        
                    },
                    data: {
                        bookid: '',
                        title: {
                            common: 'Notebook'
                        },
                        toc:
                            {                        
                                type:"toc",
                                metadata:{},
                                data:{
                                    firstpage: {
                                        
                                    }   
                                }
                                
                            },
                        pagetitles: {
                            common: {}
                        },
                        content: {}
                    }
                },
                translations:{
                    "en":{
                        "Notebooks:notebook":"Notebook",
                        "Notebooks:serverimport":"Import notebook from server",
                        "Notebooks:addnewnotebook":"Add new notebook",
                        "Notebooks:notebookstitle":"Notebook title",
                        "Notebooks:addnotebook":"Add notebook",
                        "Notebooks:print_page": "Print page",
                        "Notebooks:save": "Save",
                        "Notebooks:file": "File",
                        "Notebooks:opentutorial": "Learn to use a notebook"
                    },
                    "sv":{
                        "Notebooks:notebook":"Häfte",
                        "Notebooks:serverimport":"Hämta häftet från servern",
                        "Notebooks:addnewnotebook":"Lägg till ett nytt häfte",
                        "Notebooks:notebookstitle":"Häftets namn",
                        "Notebooks:addnotebook":"Lägg till ett nytt häfte",
                        "Notebooks:print_page": "Skriv ut sida",
                        "Notebooks:save": "Spara",
                        "Notebooks:file": "Fil",
                        "Notebooks:opentutorial": "Lär dig använda häften"
                    },
                    "fi":{
                        "Notebooks:notebook":"Vihko",
                        "Notebooks:serverimport":"Tuo vihko palvelimelta",
                        "Notebooks:addnewnotebook":"Lisää uusi vihko",
                        "Notebooks:notebookstitle":"Vihkon nimi",
                        "Notebooks:addnotebook":"Lisää vihko",
                        "Notebooks:print_page": "Tulosta sivu",
                        "Notebooks:save": "Tallenna",
                        "Notebooks:file": "Tiedosto",
                        "Notebooks:opentutorial": "Opi vihon käyttö"
                    }
                }//TODO: read tranlations from file
            },
            params
        );
        application.call(this, place, params);
    }
    //Inherit from application
    Notebooks.prototype = Object.create(application.prototype);
    Notebooks.prototype.constructor = Notebooks;
    Notebooks.prototype.parentClass = application.prototype;
    Notebooks.prototype.eventHandlerInitParent = Notebooks.prototype.eventHandlerInit;
    Notebooks.prototype.mainParent = Notebooks.prototype.main;
    /******
     * Event handlers
     ******/
    Notebooks.prototype.eventHandlerInit = function() {
        this.eventHandlerInitParent();
        var notebookSelf = this;
        this.place.on('openBook.notebooks', function(e,data) {
            console.log(JSON.stringify(jQuery(this)[0]));
        });
        this.place.on('pluginsAvailable.notebooks', function(e,data) {
            if (data.pluginsAvailable){
                notebookSelf.place.trigger('getAvailableContent.system', {path: "own_notes", event: "avilableBooks.notebooks"});
            } else {
                notebookSelf.getMissingPlugin(data.missing || notebookSelf.neededPlugins);
            };
        });
        this.place.on('click',".notebookSelector:not(.editname)", function(e, data) {
            var contextid = jQuery(this).attr('fileRef').replace(/\.json$/, '');
            if (notebookSelf.place.hasClass('removeActive')){
                if (jQuery(this).hasClass('contextOpen'))return true;
                if (confirm(notebookSelf.config.localizer.localize('system:remove_element_confirm'))){
                    notebookSelf.place.trigger("systemrequest.system", {
                        type:"removeContent" ,
                        removeFile : {"content": "own_notes", "contextid": (jQuery(this).attr("contextid") ? jQuery(this).attr("contextid") : jQuery(this).attr("fileRef")),"contenttype":"own_notes","contexttype":"own_notes"},
                        callbackEvent: "refreshview.notebooks",
                        callbacktype: "jQuery"
                    });
                }
            } else {
                notebookSelf.openNotebook(contextid);
            };
        });
        this.place.on('avilableBooks.notebooks', function(e, data) {
            if(!data.contentList || data.contentList.length===0){
                notebookSelf.books = [];
                notebookSelf.place.append('<span class="noContent">No books available</span>');
                notebookSelf.place.trigger('initialized.notebooks');
            } else {
                notebookSelf.books = data.contentList;
                notebookSelf.place.trigger('getAvailableViews.system',{event:"avilableViews.notebooks"});
            };
        });
        this.place.on('avilableViews.notebooks', function(e, data) {
            var appendPlace = notebookSelf.place.append("<div class=\"notebookselection contentselection\"></div>").find(".notebookselection");
            for (var bookFile in notebookSelf.books){
                notebookSelf.addBookSelector(notebookSelf.books[bookFile],appendPlace);
            };
            notebookSelf.place.trigger('initialized.notebooks');
            notebookSelf.place.trigger(
                'notify.system',
                {msg: "notebooksDone", type: "notification"}
            );
        });
        this.place.off('click.addnotebook').on('click.addnotebook','.addnotebook,.contentSelector.newcontentSelector', function() {
            notebookSelf.place.trigger('newContentinfo.system', {
                contenttype: "own_notes",
                includelocal: true,
                filetype: "json",
                event: 'addnotebookinit.ready',
                includeserverdata: true,
                servercontenttype: "own_notes",
                callbacktype: "jQuery"
            });
        });
        this.place.off('click.opentutorial').on('click.opentutorial', '.opentutorial', function(event) {
            event.stopPropagation();
            notebookSelf.openTutorial();
        });
        this.place.off('addnotebookinit.ready').on('addnotebookinit.ready', function(e, e_data) {
            if (typeof(e_data.detail) !=="undefined"){
                e_data = e_data.detail;
            };
            /* error 12 is EULA and 13 is servicetime expired
            *  we want that user can still make new notebooks
            *  even without service.
            *  NOTE: this may create a problem then when user 
            *        renew service subscription
            */
            // if(!e_data.success && (e_data.errortype == 12 || e_data.errortype == 13) ){
            if(!e_data.success && (e_data.errortype == 12) ){
                notebookSelf.place.trigger(e_data.localizableerror+'_error');
                return false;
            }

            if(typeof(jQuery.modal) ==="function"){
                var show = function(dialog){
                    notebookSelf.addNotebookShow(dialog,notebookSelf);
                }
                var diagogHTML = '<h1>'+notebookSelf.config.localizer.localize('Notebooks:addnotebook')+'</h1><div class="addnotebook" data-firstname="'+e_data.localdata.firstname+'"  data-lastname="'+e_data.localdata.lastname+'"  data-username="'+e_data.localdata.username+'" data-filename="'+e_data.localdata.filename+'"><h4>'+notebookSelf.config.localizer.localize('Notebooks:addnewnotebook')+'</h4><label>'+notebookSelf.config.localizer.localize('Notebooks:notebookstitle')+':<input class="notebooktitle" type="text"></label></div>';
                if(e_data.serverdata && e_data.serverdata.length){
                    diagogHTML +='<div class="servernotebooks"><h4>'+notebookSelf.config.localizer.localize('Notebooks:serverimport')+'</h4>';
                    diagogHTML +='<ul class="serverdatalist">';
                    for(var i=0;i<e_data.serverdata.length;i++){
                        try{
                            var titles = JSON.parse(e_data.serverdata[i].data).titles;
                            diagogHTML +='<li class="oneserverbook" >'+
                                            '<span class="oneserverbookdata" style="display:none">'+JSON.stringify(e_data.serverdata[i])+'</span>'+
                                            '<label>'+notebookSelf.config.localizer.localize('Notebooks:notebook')+': '+notebookSelf.sanitize(titles[notebookSelf.config.general.uilang]?titles[notebookSelf.config.general.uilang]:titles['common'])+'<input type="checkbox"/></label>'+
                                        '</li>';
                        }catch(err){
                            console.log("error",err,e_data.serverdata[i]);
                        }
                    }
                    diagogHTML +='</ul>';
                    diagogHTML +='</div>';
                }
                diagogHTML +='<div class="buttons dialogButtons"><span class="applicationButton ok-button buttondisabled">OK</span></div></div>';
                notebookSelf.dialog = jQuery.modal(diagogHTML,
                {
                        closeHTML: `<a href='#' title='Close' class='modal-close'>${application.prototype.icons.close}</a>`,
                        close: true,
                        minHeight :notebookSelf.config.dialogHeight(),
                        maxHeight :notebookSelf.config.dialogHeight(),
                        minWidth  :600,
                        autoResize :true,
                        onShow: show,
                        overlayId: undefined,
                        containerId: 'notebookadd',
                        escClose: false
                    });
            }else{
                var newtitle = prompt("Notebook title");
                var newdata = {  
                                "metadata":{
                                    "creator":e_data.username,
                                    "created":(new Date()).toString()
                                },
                                "data":{
                                    "bookid":e_data.filename,
                                    "title":{
                                        "common":newtitle
                                    }
                                }
                            };
                newdata.data.title[notebookSelf.config.general.uilang] = newtitle;
                notebookSelf.place.trigger('createNewContent.system',{
                    application:"notebooks",
                    type:"notebooks",
                    event:"contentCreated.notebooks",
                    content:jQuery.extend(true,{},notebookSelf.defaultnew,
                            newdata
                )});
            }
        });
        this.place.off('createNewContent.notebooks').on('createNewContent.notebooks', function(e,e_data) {
            var currenttime = new Date();
            var bookid= e_data.filename.replace(/\.json$/,"");
            var new_data = {  
                                "metadata":{
                                    "creator":e_data.username,
                                    "created":currenttime.toString()
                                },
                                "data":{
                                    "bookid":bookid,
                                    "title":{
                                        "common":notebookSelf.sanitize(e_data.title)
                                    },
                                    "defaultlang" : notebookSelf.config.general.uilang,
                                    "langs" : [notebookSelf.config.general.uilang],
                                },
                                "name":bookid
                            };
            new_data.data.title[notebookSelf.config.general.uilang] =notebookSelf.sanitize(e_data.title);
            new_data =jQuery.extend(true,{},notebookSelf.defaultnew,new_data);
            var contentdata = {
                "appdata":{
                    
                },
                "materialdata":{
                    
                },
                "storage":{},
                "storageparts":[],
                "updateparts":{}
            };
            contentdata.materialdata[bookid]=new_data;
            var groups = {};
            groups[e_data.filename+"own"]={
                description : 'Ownergroup',
                optional_role : null,
                groupid: e_data.filename+"own",
                gid: e_data.filename+"own",
                tags:['ownergroup'],
                members:[e_data.username]
            };
            var contextrights = {"edit":{"sharecontent":[{"whoid":e_data.filename+"own","whotype":"group"}],"notebookcontent":[{"whoid":e_data.filename+"own","whotype":"group"}],"message":[{"whoid":e_data.filename+"own","whotype":"group"}],"solution":[{"whoid":e_data.filename+"own","whotype":"group"}],"review":[{"whoid":e_data.filename+"own","whotype":"group"}],"booknote":[{"whoid":e_data.filename+"own","whotype":"group"}],"marginnote":[{"whoid":e_data.filename+"own","whotype":"group"}]},"publish":{"notebookcontent":[{"whoid":e_data.filename+"own","whotype":"group","toid":"context","totype":"context"}],"message":[{"whoid":e_data.filename+"own","whotype":"group","toid":e_data.filename+"own","totype":"group"},{"whoid":e_data.filename+"own","whotype":"group","toid":e_data.filename+"own","totype":"group","tomembers":true}],"solution":[{"whoid":e_data.filename+"own","whotype":"group","toid":e_data.filename+"own","totype":"group"}],"review":[{"whoid":e_data.filename+"own","whotype":"group","toid":e_data.filename+"own","totype":"group","tomembers":true}]},"elementclasses":{"general":[{"whoid":e_data.filename+"own","whotype":"group"}],"math":[{"whoid":e_data.filename+"own","whotype":"group"}],"media":[{"whoid":e_data.filename+"own","whotype":"group"}],"programming":[{"whoid":e_data.filename+"own","whotype":"group"}],"container":[{"whoid":e_data.filename+"own","whotype":"group"}],"action":[{"whoid":e_data.filename+"own","whotype":"group"}],"lists":[{"whoid":e_data.filename+"own","whotype":"group"}],"assignments":[{"whoid":e_data.filename+"own","whotype":"group"}]}};

            
            var groupkey = Math.random().toString(36).replace(/^0\./,'');
            var datainfo ={
                "type": "own_notes",
                "serversync":false,
                "contexttype": "own_notes",
                "titles":{
                    "common":notebookSelf.sanitize(e_data.title)
                    },
                "id":e_data.filename.replace(/\.json$/,""),
                "filename":e_data.filename,
                "metadata":{
                    "timestamp":currenttime,
                    "creator":e_data.username
                },
                "material": [
                            {
                                type: 'notebook',
                                jq: 'notebookview',
                                id: bookid
                            }
                        ],
                "apps": [
                            {
                                "type": "marginnotes",
                                "jq": "marginnotes",
                                "id": "marginnotes-"+bookid
                            },
                            {
                                "type": "sharer",
                                "jq": "sharertool",
                                "id": "sharer-"+bookid
                            }
                        ],
                "users": [e_data.user],
                "groups":function(){var retlist = [];for(var i in groups){retlist.push(groups[i])};return retlist}(),  
                "rights": contextrights,
                "createdata":{
                    contentdata : contentdata,
                    savetype    : "objtofiles",
                    contenttype : "own_notes",
                    contextid   : e_data.filename,
                },
                "contentid":bookid,
                "contextid":bookid,
            };
            datainfo.titles[notebookSelf.config.general.uilang] = notebookSelf.sanitize(e_data.title);
            
            notebookSelf.place.trigger('createNewContent.system',{
                application:"notebooks",
                type:"notebooks",
                contexttype : "own_notes",
                contextid   : e_data.filename,
                event:"contentCreated.notebooks",
                filename:e_data.filename,
                info:datainfo,
                newcontent:{
                    contentdata : contentdata,
                    savetype    : "objtofiles",
                    contenttype : "own_notes",
                    contexttype : "own_notes",
                    contextid   : e_data.filename,
                },
                serverdata:{
                    contexttype : 'own_notes', 
                    contextid : e_data.filename,
                    data:JSON.stringify(jQuery.extend(true,{},datainfo,{serversync:true})),
                    timestamp:currenttime,
                    name : notebookSelf.sanitize(e_data.title), 
                    short_desc : null,
                    description : null,
                    pubtype : 'group', 
                    public_to: null, 
                    create_groups : groups, 
                    keys_to_groups : [{value: groupkey, groups : [e_data.filename+"own"]}], 
                    rights: contextrights,
                    join_groups:[e_data.filename+"own"]
                }
            });
           
        });
        this.place.off('importContent.notebooks').on('importContent.notebooks', function(e,e_data) {
            notebookSelf.place.trigger('importContent.system',{
                application:"notebooks",
                type:"own_notes",
                filetype:"json",
                updatetype:"own_notes",
                event:"contentCreated.notebooks",
                content:e_data.contentinfos
            });
           
        });
        this.place.off('contentCreated.notebooks').on('contentCreated.notebooks', function(e,e_data) {
            jQuery.modal.close();
            notebookSelf.place.trigger('refreshview.notebooks');
        });
        this.place.off('refreshview').on('refreshview', function() {
            notebookSelf.place.trigger('refreshview.notebooks');
        });
        this.place.off('refreshview.notebooks').on('refreshview.notebooks', function() {
            notebookSelf.place.empty();
            notebookSelf.place.off();
            notebookSelf.place.notebooks(notebookSelf.initParams);
        });
    };
    
    /**
     * Open notebook
     */
    Notebooks.prototype.openNotebook = function(contextid) {
        var plugindata = {
            parameters: {
                contenttype: 'own_notes',
                contentid: contextid,
                contexttype: 'own_notes',
                contextid: contextid
            },
            plugins: [
                {
                    pluginName: 'notebook',
                    params: {
                        systemRequests: [
                            {
                                type: 'getContentAsObject',
                                getContentAsObject: {
                                    category: 'content',
                                    type: 'own_notes',
                                    context: {
                                        contextid: contextid,
                                        contexttype: 'own_notes'
                                    },
                                    filename: contextid
                                },
                                callbackEvent: 'notebookdataReady',
                                relayParams: {
                                    contentId: contextid,
                                    bookid: contextid
                                }
                            }
                        ],
                        contentInfo: {
                            contentType: 'own_notes',
                            contentFile: contextid
                        },
                        menu: []
                    }
                }
            ],
            windowAddons: {},
            menu: [{
                label: this.config.localizer.localize('Notebooks:file'),
                submenu: [
                    {label: this.config.localizer.localize('Notebooks:print_page'), click: 'printPage'}
                ]
            }]
        };
        this.place.trigger('startPlugin.system', plugindata);
    };
    
    /******
     * Notebook selector
     * TODO:
     ******/
    Notebooks.prototype.addBookSelector = function(fileRef, appPlace) {
        if (fileRef.error) {
            jQuery('body').trigger('content_error', {"errorIn": "notebooksApp", "errorType": "fileError", "errorMsg": fileRef.error});
            return false;//info.json file has information about error
        };
        var bookname = this.sanitize(fileRef.titles && fileRef.titles[this.config.general.uilang] ? fileRef.titles[this.config.general.uilang] : (fileRef.titles && fileRef.titles['common'] ? fileRef.titles['common'] : fileRef.filename));
        var subjecticon = '', subject;
        if (fileRef.subjects && fileRef.subjects.length > 0) {
            subject = this.subjects[fileRef.subjects[0]];
            subjecticon = `<div class="contentitemsubjecticon">${subject.icon || ''}</div>`
        };
        var selector = `<span class="notebookSelector contentSelector" contexttype="own_notes" contextid="${fileRef.contextid}" fileRef="${fileRef.filename}" title="${bookname}">${subjecticon}<span class="contentname bookname">${bookname}</span></span>`;
        if (typeof(appPlace) !== "undefined"){
            appPlace.append(selector);
        } else {
            this.place.append(selector);  
        };
    };
    
    Notebooks.prototype.addNotebookShow = function(dialog,Noteself) {
        dialog.container.on("change",'div.servernotebooks input[type="checkbox"]',function(e){
            if(dialog.container.find('div.servernotebooks input[type="checkbox"]:checked').length){
                dialog.container.trigger('disable_choise',{"elementclass":"addnotebook"}).trigger('enable_ok');
            }else{
                dialog.container.trigger('enable_choise',{"elementclass":"addnotebook"}).trigger('disalbe_ok');
            }
        });
        dialog.container.on("keyup",'input[type="text"]',function(e){
            var inputvalue = jQuery(this).val();
            if(inputvalue !== ""){
                if(e.keyCode ===13){
                    dialog.container.find('.dialogButtons .ok-button').click();
                }else{
                    dialog.container.trigger('disable_choise',{"elementclass":"servernotebooks"}).trigger('enable_ok');
                }
            }else{
                dialog.container.trigger('clear_notValidName').trigger('enable_choise',{"elementclass":"servernotebooks"}).trigger('disalbe_ok');
            }
        });
        dialog.container.on("notValidName",function(){
            dialog.container.find('input[type="text"]').addClass('notvalidname').css('background-color','light-red');
        });
        dialog.container.on("clear_notValidName",function(){
            dialog.container.find('input[type="text"]').removeClass('notvalidname').css('background-color','white');
        });
        dialog.container.on("enable_ok",function(){
            dialog.container.find('.ok-button').removeClass('buttondisabled');
        });
        dialog.container.on("disalbe_ok",function(){
            dialog.container.find('.ok-button').addClass('buttondisabled');
        });
        dialog.container.on("enable_choise",function(e,e_data){
            dialog.container.find('.ok-button').addClass('buttondisabled');
        });
        dialog.container.on("disable_choise",function(e,e_data){
            dialog.container.find('div.'+e_data.elementclass).addClass('elementdisable').find('input').prop('disabled',true);
        });
        dialog.container.on("enable_choise",function(e,e_data){
            dialog.container.find('div.'+e_data.elementclass).removeClass('elementdisable').find('input').prop('disabled',false);
        });
        dialog.container.on("click",".ok-button",function(){
            var inputvalue = dialog.container.find('input[type="text"]').val();
            if(jQuery(this).hasClass('buttondisabled'))return false;
            if(inputvalue !== ""){
                Noteself.place.trigger('createNewContent.notebooks',
                    {
                        title:dialog.container.find('input[type="text"]').val(),
                        user:{
                            username:dialog.container.find('div.addnotebook').attr('data-username'),
                            realname:{
                                firstname:dialog.container.find('div.addnotebook').attr('data-firstname'),
                                lastname:dialog.container.find('div.addnotebook').attr('data-lastname')
                            }
                        },
                        username:dialog.container.find('div.addnotebook').attr('data-username'),
                        filename:dialog.container.find('div.addnotebook').attr('data-filename')
                    });                
            }else{
                var servercontentinfos = [];
                var imports = dialog.container.find('div.servernotebooks input[type="checkbox"]:checked');
                for(var i=0;i<imports.length;i++){
                    servercontentinfos.push(JSON.parse(imports.eq(i).closest('li').find('.oneserverbookdata').text()));
                }
                Noteself.place.trigger('importContent.notebooks',{contentinfos:servercontentinfos});
            }
            
        });
    }
    /******
     *
     ******/
    Notebooks.prototype.main = function() {
        this.mainParent();
        this.showTutorialButton();
        this.place.find('.controlpanel').append('<span class="applicationButton add-button addnotebook defaultaddbutton"><span class="buttonIcon"></span><span class="buttonText">'+this.config.localizer.localize('Notebooks:addnotebook')+'</span></span>');
    }
    
    Notebooks.prototype.showTutorialButton = function() {
        this.place.find('.controlpanel').append(`
            <span class="applicationButton opentutorial">
                <span class="buttonIcon">${this.icons.tutorial}</span>
                <span class="buttonText">${this.config.localizer.localize('Notebooks:opentutorial')}</span>
            </span>
        `);
    };
    
    Notebooks.prototype.openTutorial = function() {
        var uilang = this.config.general.uilang;
        var contextid = 'notebook-4fnotes-tutorial';
        var plugindata = {
            plugins: [
                {
                    pluginName: 'notebook',
                    params: {
                        systemRequests: [{type: 'getContentAsObject'}]
                    }
                }
            ],
            menu: [{
                label: this.config.localizer.localize('Notebooks:file'),
                submenu: [
                    {label: this.config.localizer.localize('Notebooks:print_page'), click: 'printPage'}
                ]
            }]
        };
        this.place.trigger('startTutorial.system', plugindata);
    };
    
    Notebooks.prototype.icons = {
        tutorial: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="30" height="30" viewBox="0 0 30 30" class="mini-icon mini-icon-question mini-icon-help"><circle class="mini-icon-background" stroke="none" fill="none" cx="15" cy="15" r="15" /><path class="mini-icon-foreground" style="stroke: none;" d="M8 11 c2 -9 14 -8 14 0 c0 4 -5 6 -5 8 v1 h-4 v-1 c0 -4 5 -5 5 -8 c0 -3 -5 -4 -6 1z m5 11 h4 v4 h-4z"></path></svg>'
    }
    
    { /** jQuery Plugin interface    **/
        var methods = {
            'init' : function(params) {
                return this.each( function() {
                    var notebooks = new Notebooks($(this), params);
                    $(this).data('notebooks', notebooks);
                });
            },
            'refresh' : function() {
                return this.each( function() {
                    $(this).trigger('refreshview.notebooks');
                });
            },
            'get' : function(params) {
                return $(this).data('notebooks')[params];
            },
            'set' : function(params) {
                return $(this).data('notebooks')[params[0]] = params[1];
            }
        }
        
        $.fn.notebooks = function( method ) {
            if ( methods[method] ) {
                return methods[method].apply( this, Array.prototype.slice.call( arguments, 1 ));
            } else if ( typeof method === 'object' || ! method ) {
                return methods.init.apply( this, arguments );
            } else {
                $.error( 'Method ' +  method + ' does not exist.' );
                return false;
            }
        }
    }
})(jQuery)