(function ($) {
    /*****************************************************************
     * System
     * Constructor
     *****************************************************************/
    function Courses(place, params) {
        params = $.extend(
            true,
            {},
            {
                config: {
                    lang: "en-US",
                    general: {
                        version: 2015.0227
                    },
                    dialogHeight:function(){return Math.floor(window.outerHeight*0.8)},
                    dialogWidth:function(){return Math.max(600, Math.floor(window.outerWidth*0.8))}
                },
                neededPlugins:[
                    "course"
                ],
                CSSrules:[
            
                    {"element":".courses .courseselection",
                    "rules":"display: flex;margin-top: 1em;  flex-wrap: wrap;min-width:150px;"},
                    {"element":".courses.removeActive .applicationButton.addnewcourse",
                    "rules":"display: none;"},
                    {"element":".courses.removeActive .applicationButton.addcourse",
                    "rules":"display: none;"},
                    {"element":".courses.removeActive .courseselection .courseSelector:before",
                    "rules":"content:\"X\";width:15px;height:15px;border:1px solid black;border-radius:10px;padding:5px;background-color:red;color:white;font-weight:bold;position: absolute;margin-left: 4.5em;"}, 
                    {"element":".courses",
                    "rules":"min-width:300px;"},
                    {"element":".courses .courseSelector:hover",
                    "rules":"box-shadow:5px 5px 5px #999,-5px -5px 5px #999;"},
                    {"element":".courses .courseSelector",
                    "rules":"cursor:pointer;background-color:white;border:1px solid gray;padding:0.2em;border-radius:5px;width:100px;height:100px;min-width:100px;display:inline-block;margin-left:1em; "},
                    {"element":".courses .courseSelector .coursename",
                    "rules":"overflow: hidden; min-width: 90px; min-height: 90px; text-overflow: ellipsis; display: inline-block;"}
                ],
                applicationType:"courses",
                applicationcontentpath : "course",
                contexttype : "course",
                defaultnew : {},
                translations:{
                    "en":{
                        "Courses:selectcontext":"Select...",
                        "Courses:own_notes":"Notebook",
                        "Courses:book":"Readerbook",
                        "Courses:course":"Course",
                        "Courses:serverimport":"Import course from server",
                        "Courses:addnewcourse":"Add new course",
                        "Courses:coursestitle":"Course title",
                        "Courses:addcourse":"Join course",
                        "Courses:short_desc":"Short description",
                        "Courses:teacherkey":"Teachers registration key",
                        "Courses:studentkey":"Students registration key",
                        "Courses:description":"Course description",
                        "Courses:schools": "Schools",
                        "Courses:nocourses":"No new courses",
                        "Courses:givekey":"Key",
                        "Courses:startdatatype":"Materialtype for course",
                        "Courses:working":"Working...",
                        "Courses:CONNECTION_FAILED":"Connection to server failed",
                        "Courses:ERROR":"ERROR: ",
                        "Courses:emptymaterial":"Empty material",
                        "Courses:courseinfo":"Courseinformation",
                        "Courses:loadcourse":"Download course",
                        "Courses:standardcourse":"Standardcourse",
                        "Courses:privatecourse":"Personalcourse",
                        "Courses:search":"Search",
                        "Courses:searchempty":"No matching courses",
                        "Courses:notemptyerrormsg":"Field can't be empty",
                        "Courses:notequalerrormsg":"Values can't be same",
                        "Courses:allschools": "All schools",
                        "Courses:allsubjects": "All subjects",
                        "Courses:miscsubject": "Other",
                        "Courses:subject": "Subject",
                        "Courses:visibility": "Visibility",
                        "Courses:teacher": "Teacher",
                        "Courses:shortdescription": "Briefly",
                        "Courses:close": "Close",
                        "Courses:providing_school": "Providing school",
                        "Courses:start_time": "Start time",
                        "Courses:end_time": "End time",
                        "Courses:permanent_course": "Permanent",
                        "Courses:endbeforestarterrormsg": "End time before start time"
                    },
                    "sv":{
                        "Courses:selectcontext": "Välj...",
                        "Courses:own_notes": "ViRum-häfte",
                        "Courses:course": "Kurs",
                        "Courses:serverimport": "Hämta kurs från servern",
                        "Courses:addnewcourse": "Lägg till en ny kurs",
                        "Courses:coursestitle": "Kursen namn",
                        "Courses:addcourse": "Lägg till en kurs",
                        "Courses:short_desc": "Kort beskrivning av kursen",
                        "Courses:teacherkey": "Kursnyckel för lärare",
                        "Courses:studentkey": "Kursnyckel för studerande",
                        "Courses:description": "Beskrivning av kursen",
                        "Courses:schools": "Skolor",
                        "Courses:nocourses": "Det finns inga nya kurser tillgängliga",
                        "Courses:givekey": "Kursnyckel",
                        "Courses:book": "Bok",
                        "Courses:working": "Arbetar...",
                        "Courses:CONNECTION_FAILED": "Anslutning till servern misslyckades",
                        "Courses:startdatatype": "Typ av utgångsmaterial för kursen",
                        "Courses:emptymaterial": "Tomt material",
                        "Courses:courseinfo": "Kursinformation",
                        "Courses:standardcourse": "Standard kurs",
                        "Courses:privatecourse": "Personlig kurs",
                        "Courses:search": "Sök",
                        "Courses:ERROR": "FEL:",
                        "Courses:loadcourse": "Ladda ner kurs",
                        "Courses:searchempty": "Sökningen hittade inga kurser",
                        "Courses:notemptyerrormsg":"Fältet får inte lämnas tomt",
                        "Courses:notequalerrormsg":"Fälten får inte ha samma innehåll",
                        "Courses:allschools": "Alla skolor",
                        "Courses:allsubjects": "Alla ämnen",
                        "Courses:miscsubject": "Andra",
                        "Courses:subject": "Ämne",
                        "Courses:visibility": "Synlighet",
                        "Courses:teacher": "Lärare",
                        "Courses:shortdescription": "I korthet",
                        "Courses:close": "Stäng",
                        "Courses:providing_school": "Erbjudande skola",
                        "Courses:start_time": "Startdatum",
                        "Courses:end_time": "Slutdatum",
                        "Courses:permanent_course": "Permanent",
                        "Courses:endbeforestarterrormsg": "Slutdatum före startdatum"
                    },
                    "fi":{
                        "Courses:selectcontext":"Valitse...",
                        "Courses:own_notes":"Vihko",
                        "Courses:book":"Lukukirja",
                        "Courses:course":"Kurssi",
                        "Courses:serverimport":"Tuo kurssi palvelimelta",
                        "Courses:addnewcourse":"Lisää uusi kurssi",
                        "Courses:coursestitle":"Kurssin nimi",
                        "Courses:addcourse":"Liity kurssille",
                        "Courses:short_desc":"Lyhyt kuvaus",
                        "Courses:teacherkey":"Opettajien rekisteröintiavain",
                        "Courses:studentkey":"Oppilaiden rekisteröintiavain",
                        "Courses:description":"Kurssin kuvaus",
                        "Courses:schools": "Koulut",
                        "Courses:nocourses":"Ei uusia kursseja",
                        "Courses:givekey":"Avain",
                        "Courses:startdatatype":"Materiaalityyppi kurssille",
                        "Courses:working":"Prosessoi...",
                        "Courses:CONNECTION_FAILED":"Yhteys palvelimeen epäonnistui",
                        "Courses:ERROR":"VIRHE: ",
                        "Courses:emptymaterial":"Tyhjä materiaali",
                        "Courses:courseinfo":"Kurssin tiedot",
                        "Courses:loadcourse":"Lataa kurssi",
                        "Courses:standardcourse":"Yleinen kurssi",
                        "Courses:privatecourse":"Yksityinen kurssi",
                        "Courses:search":"Etsi",
                        "Courses:searchempty":"Ei vastaavia kursseja",
                        "Courses:notemptyerrormsg":"Kenttä eivä saa olla tyhjä",
                        "Courses:notequalerrormsg":"Arvot eivät saa olla samat",
                        "Courses:allschools": "Kaikki koulut",
                        "Courses:allsubjects": "Kaikki aineet",
                        "Courses:miscsubject": "Muu",
                        "Courses:subject": "Aine",
                        "Courses:visibility": "Näkyvyys",
                        "Courses:teacher": "Opettaja",
                        "Courses:shortdescription": "Lyhyesti",
                        "Courses:close": "Sulje",
                        "Courses:providing_school": "Järjestävä koulu",
                        "Courses:start_time": "Alkaa",
                        "Courses:end_time": "Päättyy",
                        "Courses:permanent_course": "Jatkuva",
                        "Courses:endbeforestarterrormsg": "Päättymisaika ennen alkuaikaa"
                    }
                }
            },
            params
        );
        application.call(this,place,params);
    }
    Courses.prototype = Object.create(application.prototype);
    Courses.prototype.constructor = Courses;
    Courses.prototype.parentClass = application.prototype;
    Courses.prototype.eventHandlerInitParent = Courses.prototype.eventHandlerInit;
    Courses.prototype.mainParent = Courses.prototype.main;
    /******
     * Event handlers
     ******/
    Courses.prototype.eventHandlerInit = function() {
        this.eventHandlerInitParent();
        var courseSelf = this;
        this.place.off('openCourse.courses').on('openCourse.courses', function(e,data) {
        });
        this.place.off('pluginsAvailable.courses').on('pluginsAvailable.courses', function(e,data) {
            if(data.pluginsAvailable){
                courseSelf.place.trigger('getAvailableContent.system',{path:"course",event:"avilableCourses.courses"});
            }else{
                courseSelf.getMissingPlugin(data.missing || courseSelf.neededPlugins);
            };
        });
        this.place.off('click').on('click', '.courseSelector', function(e, data) {
            var courseid = jQuery(this).attr("courseid");
            if (courseSelf.place.hasClass('removeActive')) {
                if (jQuery(this).hasClass('contextOpen')) return true;
                if (confirm(courseSelf.config.localizer.localize('system:remove_element_confirm'))) {
                    courseSelf.place.trigger("systemrequest.system", {
                        type: "removeContent" ,
                        removeFile: {"content": "course", "contextid": courseid, "contenttype": "course", "contexttype": "course"},
                        callbackEvent: "refreshview.courses",
                        callbacktype: "jQuery"
                    });
                }
            } else {
                courseSelf.openCourse(courseid);
            };
        });
        this.place.off('avilableCourses.courses').on('avilableCourses.courses', function(e,data) {
            if (!data.contentList || data.contentList.length === 0){
                courseSelf.courses = [];
                courseSelf.place.append("<span>No courses available</span>");
            } else {
                courseSelf.courses = data.contentList;
                courseSelf.subjects = {};
                for (var i = 0, len = data.subjects.length; i < len; i++) {
                    courseSelf.subjects[data.subjects[i].id] = data.subjects[i];
                };
                courseSelf.place.trigger('getAvailableViews.system', {event: "avilableViews.courses"});
            };
        });
        this.place.off('avilableViews.courses').on('avilableViews.courses', function(e,data) {
            var appendPlace = courseSelf.place.append("<div class=\"courseselection contentselection\"></div>").find(".courseselection");
            for (var courseFile in courseSelf.courses){
                courseSelf.addCourseSelector(courseSelf.courses[courseFile], appendPlace);
            };
            courseSelf.place.trigger('initialized.courses');
            courseSelf.place.trigger(
                'notify.system',
                {msg:"coursesDone",type:"notification"}
                
            );
        });
        
        /*******************
        * Add course handlers
        *******************/
        this.place.off('click.addcourse').on('click.addcourse','.addcourse,.contentSelector.newcontentSelector', function() {
            //TODO: addcourse is more register to course or add allready registered course to application
           courseSelf.place.trigger('newContentinfo.system',
            {
                contenttype         : "course",
                contexttype         : "course",
                includelocal        : true,
                filetype            : "json",//TODO:fix when data for course is defined
                event               : 'addcourseinit.ready',
                includeserverdata   : true,
                servercontenttype   : "course",
                callbacktype        : "jQuery"
            }
            );
        });
        this.place.off('click.addnewcourse').on('click.addnewcourse','.addnewcourse', function() {
           courseSelf.place.trigger('newContentinfo.system',
            {
                contenttype                 :"course",
                contexttype                 :"course",
                includelocal                :true,
                includeavailableaddcontexts :['book','own_notes'],
                filetype                    :"json",//TODO:fix when data for course is defined
                event                       :'addnewcourseinit.ready',
                includeserverdata           : false,
                callbacktype                :"jQuery"
            }
            );
        });
        this.place.off('addnewcourseinit.ready').on('addnewcourseinit.ready', function(e, e_data) {
             if (typeof(e_data.detail) !=="undefined") {
                e_data = e_data.detail;
            };
            if (!e_data.success && (e_data.errortype == 12 || e_data.errortype == 13) ) {
                courseSelf.place.trigger(e_data.localizableerror + '_error');
                return false;
            };
            courseSelf.openCreateDialog(e_data);
        });
        this.place.off('addcourseinit.ready').on('addcourseinit.ready', function(e,e_data) {
            if(typeof(e_data.detail) !=="undefined"){
                e_data = e_data.detail;
            };
            if(!e_data.success && (e_data.errortype == 12 || e_data.errortype == 13) ){
                courseSelf.place.trigger(e_data.localizableerror+'_error');
                return false;
            };
            courseSelf.openSelectDialog(e_data);
        });
        this.place.off('createNewContent.courses').on('createNewContent.courses', function(e, e_data) {
            e.stopPropagation();
            courseSelf.createNewContent(e_data);
        });
        this.place.off("importContent.courses").on("importContent.courses", function(e,e_data) {
            courseSelf.place.trigger("importContent.system",{
                application: "courses",
                type: "course",
                updatetype: "course",
                event: "joinedincontext.courses",
                content: e_data.contentinfos
            });
           
        });
        this.place.off("servererror").on("servererror", function(e,e_data) {
            console.log('servererror',e_data);
        });
        this.place.off("contentCreated.courses").on("contentCreated.courses", function(e,e_data) {
            if(e_data.success){
                jQuery.modal.close();
                courseSelf.place.trigger("refreshview.courses");
            }else{
                courseSelf.place.trigger('servererror',e_data);
                if(e_data.errormessage){
                    var errormsgplace = jQuery('.simplemodal-container .dialogmessagearea').text(courseSelf.config.localizer.localize('Courses:ERROR')+courseSelf.config.localizer.localize('Courses:'+e_data.localizableerror));
                }
            }
        });
        this.place.off("clearDialog.courses").on("clearDialog.courses", function(e,e_data) {
            jQuery.modal.close();
            courseSelf.place.trigger("refreshview.courses");
        });
        
        this.place.off('refreshview').on('refreshview', function() {
            courseSelf.place.trigger('refreshview.courses');
        });
        
        this.place.off("refreshview.courses").on("refreshview.courses", function() {
            courseSelf.place.empty();
            courseSelf.place.off();
            courseSelf.place.courses(courseSelf.initParams);
        });
        this.place.off("contentafterregister_done.courses").on("contentafterregister_done.courses", function() {
        });
    }
    
    /**
     * Open the selected course in the new window.
     */
    Courses.prototype.openCourse = function(courseid) {
        var plugindata = {
            parameters: {
                contenttype: 'course',
                contentid: courseid,
                contexttype: 'course',
                contextid: courseid
            },
            plugins: [
                {
                    pluginName: 'course',
                    params: {
                        systemRequests: [
                            {
                                type: 'getContentAsObject',
                                getContentAsObject: {
                                    category: 'content',
                                    type: 'course',
                                    context: {
                                        contextid: courseid,
                                        contexttype: 'course'
                                    },
                                    filename: courseid
                                },
                                callbackEvent: 'coursedataReady',
                                relayParams: {
                                    contentId: courseid
                                }
                            }
                        ]
                    }
                }
            ],
            windowAddons: {}
            //, menu: [{
            //    label: 'File',
            //    submenu: [
            //        {label: 'print', click: 'printPage'}
            //    ]
            //}]
        };
        this.place.trigger('startPlugin.system', plugindata);
    };
    /******
     * Course selector
     * Add selector items into the courselist.
     ******/
    Courses.prototype.addCourseSelector = function(courseinfo, appPlace) {
        if (courseinfo.error) return false;
        var coursename = (courseinfo.titles && courseinfo.titles["common"] ? courseinfo.titles['common'] : "Content name missing!");
        var courseid = "";
        if (courseinfo.id||courseinfo.contentid){
            courseid=courseinfo.id||courseinfo.contentid;
        };
        var subjecticon = '', subject;
        if (courseinfo.subjects && courseinfo.subjects.length > 0) {
            subject = this.subjects[courseinfo.subjects[0]];
            subjecticon = `<div class="contentitemsubjecticon">${subject.icon || ''}</div>`
        };
        var selector = `<span class="courseSelector contentSelector" ${(courseid ? 'courseid="' + courseid + '"' : '')} contexttype="course" contextid="${courseid}" fileRef="${courseinfo.filename}" title="${coursename}">${subjecticon}<span class="coursename contentname">${coursename}</span></span>`;
        if (typeof(appPlace) !== "undefined") {
            appPlace.append(selector);
        } else {
            this.place.append(selector);  
        };
    }
    
    /**
     * Open Course select dialog
     */
    Courses.prototype.openSelectDialog = function(options) {
        this.dialog = new CourseSelectDialog(this.place, options, this.config);
        this.dialog.show();
    };
    
    /**
     * Open Course create dialog
     */
    Courses.prototype.openCreateDialog = function(options) {
        this.dialog = new CourseCreateDialog(this.place, options, this.config);
        this.dialog.show();
    };
    
    /**
     * Create new course content from given data
     * @param {Object} data    The data for creating a new course
     */
    Courses.prototype.createNewContent = function(data) {
        /*
            NOTES:
                Now courses allways have:
                - one material
                    -empty notebook
                    -own notebook
                    -reader
                -apps
                    -feed
                    -dashboard
                    -videochat
                    -marginnotes
                    -pagesharer
            TODO:
                - fixit so that material and apps can be chosen more freely
                - Split in smaller methods?
        */
        var uilang = this.config.general.uilang;
        var currenttime = new Date();
        var courseid= data.filename.replace(/\.json$/,""); //replace just for sure, filename == id
        
        // Define the groups for the course.
        var create_groups ={};
        var teachergroupid = courseid + '_teachers';
        var studentgroupid = courseid + '_students';
        var groupdescriptions = {
            "teachergroup":{
                "fi": "Opettajat",
                "sv": "Lärarna",
                "en": "Teachers",
                "common": "Teachers"
            },
            "studentgroup":{
                "fi": "Opiskelijat",
                "sv": "Elever",
                "en": "Students",
                "common": "Students"
            }
        }
        create_groups[teachergroupid] = {
            "description": groupdescriptions['teachergroup'][uilang] || groupdescriptions['teachergroup']['common'],
            "optional_role": 'TEACHER',
            "groupid": teachergroupid,
            "gid": teachergroupid,
            "tags": ["teachers"],
            "members": [
                data.username
            ]
        };
        create_groups[studentgroupid] = {
            "description": groupdescriptions['studentgroup'][uilang] || groupdescriptions['studentgroup']['common'],
            "optional_role": 'STUDENT',
            "groupid": studentgroupid,
            "gid": studentgroupid,
            "tags": ["students"],
            "members": [
            ]
        };

        // Define the access rights for the course.
        var courseRightsTemplate = {
            "edit": {
                "sharecontent": [
                    {
                        "whoid"  : teachergroupid,
                        "whotype": "group"
                    }
                ],
                "notebookcontent": [
                    {
                        "whoid"     : teachergroupid,
                        "whotype"   : "group",
                        "joint_edit": true
                    }
                ],
                "message": [
                    {
                        "whoid"  : teachergroupid,
                        "whotype": "group"
                    }, {
                        "whoid"  : studentgroupid,
                        "whotype": "group"
                    }
                ],
                "hamessage": [
                    {
                        "whoid"  : teachergroupid,
                        "whotype": "group",
                        "joint_edit": true
                    }
                ],
                "solution": [
                    {
                        "whoid"  : teachergroupid,
                        "whotype": "group"
                    }, {
                        "whoid"  : studentgroupid,
                        "whotype": "group"
                    }
                ],
                "review": [
                    {
                        "whoid"  : teachergroupid,
                        "whotype": "group"
                    }
                ],
                "booknote": [
                    {
                        "whoid"  : teachergroupid,
                        "whotype": "group",
                        "joint_edit": true
                    }
                ],
                "commentnote": [
                    {
                        "whoid"  : teachergroupid,
                        "whotype": "group"
                    }
                ],
                "marginnote": [
                    {
                        "whoid"  : teachergroupid,
                        "whotype": "group"
                    }, {
                        "whoid"  : studentgroupid,
                        "whotype": "group"
                    }
                ],
            },
            "publish": {
                "message": [
                    {
                        "whoid": teachergroupid,
                        "whotype": "group",
                        "toid": studentgroupid,
                        "totype": "group"
                    }, {
                        "whoid": teachergroupid,
                        "whotype": "group",
                        "toid": studentgroupid,
                        "totype": "group",
                        "tomembers": true
                    }, {
                        "whoid": teachergroupid,
                        "whotype": "group",
                        "toid": teachergroupid,
                        "totype": "group",
                        "tomembers": true
                    }, {
                        "whoid": teachergroupid,
                        "whotype": "group",
                        "toid": courseid,
                        "totype": "context"
                    }, {
                        "whoid": teachergroupid,
                        "whotype": "group",
                        "toid": courseid,
                        "totype": "context",
                        "tomembers": true
                    }, {
                        "whoid": studentgroupid,
                        "whotype": "group",
                        "toid": teachergroupid,
                        "totype": "group"
                    }, {
                        "whoid": studentgroupid,
                        "whotype": "group",
                        "toid": teachergroupid,
                        "totype": "group",
                        "tomembers": true
                    }
                ],
                "hamessage": [
                    {
                        "whoid": teachergroupid,
                        "whotype": "group",
                        "toid": studentgroupid,
                        "totype": "group"
                    }, {
                        "whoid": teachergroupid,
                        "whotype": "group",
                        "toid": studentgroupid,
                        "totype": "group",
                        "tomembers": true
                    }, {
                        "whoid": teachergroupid,
                        "whotype": "group",
                        "toid": teachergroupid,
                        "totype": "group",
                        "tomembers": true
                    }, {
                        "whoid": teachergroupid,
                        "whotype": "group",
                        "toid": courseid,
                        "totype": "context"
                    }, {
                        "whoid": teachergroupid,
                        "whotype": "group",
                        "toid": courseid,
                        "totype": "context",
                        "tomembers": true
                    }
                ],
                "solution": [
                    {
                        "whoid": studentgroupid,
                        "whotype": "group",
                        "toid": teachergroupid,
                        "totype": "group"
                    }
                ],
                "review": [
                    {
                        "whoid": teachergroupid,
                        "whotype": "group",
                        "toid": studentgroupid,
                        "totype": "group",
                        "tomembers": true
                    }, {
                        "whoid": teachergroupid,
                        "whotype": "group",
                        "toid": teachergroupid,
                        "totype": "group"
                    }
                ],
                "notebookcontent": [
                    {
                        "whoid": teachergroupid,
                        "whotype": "group",
                        "toid": courseid,
                        "totype": "context"
                    }
                ],
                "booknote": [
                    {
                        "whoid": teachergroupid,
                        "whotype": "group",
                        "toid": teachergroupid,
                        "totype": "group"
                    },
                    {
                        "whoid": teachergroupid,
                        "whotype": "group",
                        "toid": courseid,
                        "totype": "context"
                    }
                ]
            },
            "view": {
                "solution": [
                    {
                        "whoid": teachergroupid,
                        "whotype": "group"
                    }
                ]
            },
            "elementclasses": {
                "general": [
                    {
                        "whoid": teachergroupid,
                        "whotype": "group"
                    }, {
                        "whoid": studentgroupid,
                        "whotype": "group"
                    }
                ],
                "math": [
                    {
                        "whoid": teachergroupid,
                        "whotype": "group"
                    }, {
                        "whoid": studentgroupid,
                        "whotype": "group"
                    }
                ],
                "media": [
                    {
                        "whoid": teachergroupid,
                        "whotype": "group"
                    }, {
                        "whoid": studentgroupid,
                        "whotype": "group"
                    }
                ],
                "programming": [
                    {
                        "whoid": teachergroupid,
                        "whotype": "group"
                    }, {
                        "whoid": studentgroupid,
                        "whotype": "group"
                    }
                ],
                "container": [
                    {
                        "whoid": teachergroupid,
                        "whotype": "group"
                    }
                ],
                "action": [
                    {
                        "whoid": teachergroupid,
                        "whotype": "group"
                    }
                ],
                "lists": [
                    {
                        "whoid": teachergroupid,
                        "whotype": "group"
                    }
                ],
                "assignments": [
                    {
                        "whoid": teachergroupid,
                        "whotype": "group"
                    }
                ]
            }
        };

        // Define the available apps on the course.
        var apps=[
            {
                "type"  : "coursefeed",
                "jq"    : "virumcoursefeed",
                "id"    : "coursefeed-" + courseid
            },
            {
                "type"  : "coursedashboard",
                "jq"    : "coursedashboard",
                "id"    : "coursedashboard-" + courseid
            },
            {
                "type"  : "coursevideoconf",
                "jq"    : "coursevideoconf",
                "id"    : "coursevideoconf-" + courseid
            },
            {
                "type"  : "marginnotes",
                "jq"    : "marginnotes",
                "id"    : "marginnotes-" + courseid
            },
            {
                "type"  : "sharer",
                "jq"    : "sharertool",
                "id"    : "sharer-" + courseid
            }
        ];

        // Define the contextinfo of the course.
        var coursedata = {
            "type"                  : "course",
            "serversync"            : false,
            "id"                    : courseid,
            "titles"                : { "common": this.sanitize(data.inputvalues.name) },
            "short_desc"            : this.sanitize(data.inputvalues.short_desc),
            "description"           : this.sanitize(data.inputvalues.description),
            "apps"                  : apps,
            "metadata"              : {
                                        "creator": data.username,
                                        "created": currenttime.toJSON()
                                      },
            "users"                 : [data.user],
            "groups"                : function() {
                                        var retlist = [];
                                        for (var i in create_groups) {
                                            retlist.push(create_groups[i])
                                        };
                                        return retlist
                                    }(),
            "schools"               : data.schools || [],
            "subjects"              : data.subjects || [],
            "providing_school"      : data.providing_school || '',
            "start_time"            : this.sanitize(data.inputvalues.start_time),
            "end_time"              : this.sanitize(data.inputvalues.end_time),
            "teacher"               : data.user,
            "rights"                : courseRightsTemplate,
            "startdata_identifiers" : (data.inputvalues.startdatatype === "empty_notebook" ?
                                        []
                                        :
                                        data.inputvalues.startdatatype === "own_notes" ?
                                            [{
                                                startdatatype: "id",
                                                startdataid_or_contextid: "startdata_course" + courseid,
                                                context_type: "own_notes"
                                            }]
                                            :
                                            [{
                                                startdatatype: "context",
                                                startdataid_or_contextid: data.inputvalues["selected_" + data.inputvalues.startdatatype],
                                                context_type: data.inputvalues.startdatatype
                                            }])
        };

        // Create the startdata for the course.
        if (data.inputvalues.startdatatype === "empty_notebook") {
            coursedata['material'] = [
                {
                    "type": "notebook",
                    "jq": "notebookview",
                    "id": "coursematerial_" + courseid
                }
            ];
        } else {
            //For now there is only one material fix it when multiple material can be set
            var selectedLocalMaterial = data.relaydata.localcontextdata[data.inputvalues.startdatatype];
            for (var i = 0; i < selectedLocalMaterial.length; i++) {
                if (selectedLocalMaterial[i].contextid === data.inputvalues["selected_" + data.inputvalues.startdatatype]) {
                    coursedata['material'] = data.relaydata.localcontextdata[data.inputvalues.startdatatype][i].material;
                    break;
                };
            };
        };

        coursedata.titles[uilang] = this.sanitize(data.inputvalues.name);
        var filedata={
            "appdata":{
                
            },
            "materialdata":{
                
            },
            "storage":{},
            "storageparts":[],
            "updateparts":{}
        };

        filedata.appdata["coursefeed-" + courseid] = {};
        
        this.place.trigger("createNewContent.system",{
            application                 : "courses",
            type                        : "courses",
            contexttype                 : "course",
            contextid                   : courseid,
            event                       : "contentCreated.courses",
            filename                    : courseid,
            info                        : coursedata,
            sendStartdata               : data.inputvalues.sendstartdata || data.inputvalues.startdatatype === "own_notes",
            newcontent: {
                copymaterialfromcontext : (data.inputvalues.startdatatype === "empty_notebook" ? false : {
                                            contextid: data.inputvalues["selected_" + data.inputvalues.startdatatype],
                                            context_type: data.inputvalues.startdatatype
                                        }),
                includeStorage          : data.inputvalues.includestorage || data.inputvalues.startdatatype === "own_notes",
                contentdata             : filedata,
                savetype                : "objtofiles",
                contenttype             : "course",
                contextid               : courseid,
            },
            serverdata:{
                contexttype             : "course", 
                contextid               : courseid,
                data                    : JSON.stringify($.extend(true, {}, coursedata, {serversync: true})),
                timestamp               : currenttime,
                name                    : this.sanitize(data.inputvalues.name), 
                short_desc              : this.sanitize(data.inputvalues.short_desc),
                description             : this.sanitize(data.inputvalues.description),
                subject                 : data.subjects[0] || 'misc',   // For now the subjects-list has only one item!
                schools                 : data.schools,
                providing_school        : data.providing_school,
                start_time              : this.sanitize(data.inputvalues.start_time),
                end_time                : this.sanitize(data.inputvalues.end_time),
                pubtype                 : (data.inputvalues.coursevisibility !== "privatecourse" ? "all" : "group"), 
                public_to               : null, 
                create_groups           : create_groups,
                keys_to_groups          : (data.inputvalues.coursevisibility !== "privatecourse" ?
                                            [
                                                {
                                                    value   : data.inputvalues.teacherkey, 
                                                    groups  : [teachergroupid]
                                                },
                                                {
                                                    value   : data.inputvalues.studentkey, 
                                                    groups  : [studentgroupid]
                                                }
                                            ]
                                            :
                                            (function(){
                                                var key1 = Math.random().toString(36).replace(/[^a-z]+/g, '').substr(0, 10);
                                                var key2 = Math.random().toString(36).replace(/[^a-z]+/g, '').substr(0, 10);
                                                while (key1 === key2){
                                                    key2 = Math.random().toString(36).replace(/[^a-z]+/g, '').substr(0, 10);
                                                };
                                                var returnlist = [
                                                    {
                                                        value   : key1, 
                                                        groups  : [teachergroupid]
                                                    },
                                                    {
                                                        value   : key2, 
                                                        groups  : [studentgroupid]
                                                   }
                                                ];
                                                return returnlist;
                                            })()
                                        ), 
                rights                  : courseRightsTemplate,
                join_groups             : [teachergroupid],
                startdata_identifiers   : (data.inputvalues.startdatatype === "empty_notebook" ?
                                            []
                                            :
                                            data.inputvalues.startdatatype === "own_notes" ?
                                                [{
                                                    startdatatype: "id",
                                                    startdataid_or_contextid: "startdata_course" + courseid,
                                                    context_type: "own_notes"
                                                }]
                                                :
                                                [{
                                                    startdatatype: "context",
                                                    startdataid_or_contextid: data.inputvalues["selected_" + data.inputvalues.startdatatype],
                                                    context_type: data.inputvalues.startdatatype
                                                }]
                                        )
            }
        });           

    };
    
    /******
     *
     ******/
    Courses.prototype.main = function() {
        this.mainParent();
        try {
            if(this.config.user.defaultroles.indexOf("teacher") !== -1 || this.config.user.defaultroles.indexOf("admin") !== -1)
                this.place.find('.controlpanel').append('<span class="applicationButton add-button addnewcourse"><span class="buttonIcon"></span><span class="buttonText">'+this.config.localizer.localize('Courses:addnewcourse')+'</span></span>');
                
        }catch(err){
            console.log('Defaultrole error',err);
        }
        this.place.find('.controlpanel').append('<span class="applicationButton add-button addcourse defaultaddbutton"><span class="buttonIcon"></span><span class="buttonText">'+this.config.localizer.localize('Courses:addcourse')+'</span></span>');
    }

    { /** jQuery Plugin interface    **/
        var methods = {
            'init' : function(params) {
                return this.each( function() {
                    var courses = new Courses($(this), params);
                    $(this).data('courses', courses);
                });
            },
            'close' : function() {
                return this.each( function() {
                    return $(this).data('courses').close();
                });
            },
            'get' : function(params) {
                return $(this).data('courses')[params];
            },
            'set' : function(params) {
                return $(this).data('courses')[params[0]] = params[1];
            }
        }
        
        $.fn.courses = function( method ) {
            if ( methods[method] ) {
                return methods[method].apply( this, Array.prototype.slice.call( arguments, 1 ));
            } else if ( typeof method === 'object' || ! method ) {
                return methods.init.apply( this, arguments );
            } else {
                $.error( 'Method ' +  method + ' does not exist.' );
                return false;
            }
        }
    }
   
   
   
    /**
     * Class for existing course selecting dialog
     * @class CourseSelectDialog
     * @constructor
     * @param {jQuery} place    The place for this dialog
     * @param {Object} options  All needed options
     * @param {Object} config   The configs for the dialog
     */
    var CourseSelectDialog = function(place, options, config) {
        this.place = place;
        this.config = config;
        this.options = $.extend(true, {}, this.defaults, options);
        this.addStyles();
        this.init();
        return this;
    };
    
    /**
     * Do some initing for the dialog object
     */
    CourseSelectDialog.prototype.init = function() {
        var uilang = this.config.general.uilang;
        var localdata = this.options.localdata;
        if (localdata) {
            localdata.availableschools.sort(function(a, b) {return (a.name < b.name ? -1 : 1);});
            localdata.subjects.sort(function(a, b){return ((a.title[uilang].toLowerCase() || a.title['en'].toLowerCase()) < (b.title[uilang].toLowerCase() || b.title['en'].toLowerCase()) ? -1 : 1);});
            this.subjects = {};
            for (var i = 0, len = localdata.subjects.length; i < len; i++) {
                this.subjects[localdata.subjects[i].id] = localdata.subjects[i];
            };
        };
    };
    
    /**
     * Show the course selection dialog
     */
    CourseSelectDialog.prototype.show = function() {
        var seldialog = this;
        var localizer = this.config.localizer;
        if (typeof(jQuery.modal) === 'function') {
            this.dialog = jQuery.modal(this.getHtml(), {
                closeHTML: `<a href='#' title='${localizer.localize('Courses:close')}' class='modal-close'>${application.prototype.icons.close}</a>`,
                close: true,
                minHeight: this.config.dialogHeight(),
                maxHeight : this.config.dialogHeight(),
                minWidth: this.config.dialogWidth(),
                autoResize :true,
                onShow: function(dialog){},
                overlayId: undefined,
                containerId: 'courseadd',
                escClose: false
            });
            this.container = this.dialog.d.container;
        };
        this.initHandlers();
        this.updateFiltering()
    };
    
    /**
     * Init the event handlers.
     */
    CourseSelectDialog.prototype.initHandlers = function() {
        var selectdialog = this;
        var localizer = this.config.localizer;
        var dialog = this.dialog;
        var container = dialog.d.container;

        container.off('keyup', '.coursesearch input[type="text"]').on('keyup', '.coursesearch input[type="text"]', function(event) {
            if(jQuery(this).val() !== ''){
                var found = 0;
                var courselist = container.find('ul.serverdatalist').addClass('searchmode');
                courselist.find('.nocoursefound').remove();
                var serverdatalistelements = courselist.find('li');
                for (var i = 0; i < serverdatalistelements.length; i++) {
                    serverdatalistelements.eq(i).removeClass('matching');
                    if (serverdatalistelements.eq(i).find('.titletext').text().toLowerCase().search(jQuery(this).val().toLowerCase()) !== -1){
                        serverdatalistelements.eq(i).addClass('matching');
                        found ++;
                    };
                };
                if (found === 0 && courselist.find('.selectedli').length === 0) {
                    courselist.append(`<li class="nocoursefound matching">${localizer.localize('Courses:searchempty')}</li>`);
                };
            } else {
                container.find('ul.serverdatalist').removeClass('searchmode').find('.nocoursefound').remove();
                container.find('li.matching').removeClass('matching');
            };
            selectdialog.updateZebra();
        }).off('keyup', '.courseinfojoinarea input[type="text"]').on('keyup', '.courseinfojoinarea input[type="text"]', function(event) {
            container.removeClass('showvaliderrors').find('.dialogmessagearea').html('');
            if (jQuery(this).val() !== '') {
                if (!jQuery(this).hasClass('activeinput')){
                    jQuery(this).addClass('activeinput');
                    container.trigger('disable_choise', {"inputelement": this}).trigger('enable_ok');
                };
                if (event.keyCode === 13) {
                    container.find('.dialogButtons .ok-button').click();
                };
            } else {
                jQuery(this).removeClass('activeinput');
                container.trigger('enable_choise').trigger('disable_ok');
            };
        }).off('enable_ok').on('enable_ok', function(event) {
            container.find('.ok-button').removeClass('buttondisabled');
        }).off('disable_ok').on('disable_ok', function(event) {
            container.find('.ok-button').addClass('buttondisabled');
        }).off('click', 'li.oneservercourse').on('click', 'li.oneservercourse', function(event) {
            var courseindex = jQuery(this).attr('data-courselistindex') | 0;
            selectdialog.updateInfoView(courseindex);
            selectdialog.updateZebra();
        }).off('registrationerror').on('registrationerror', function(event) {
            var keyinput = container.find('.activeinput');
            keyinput.closest('li').css('border','1px solid red');
            container.find('.dialogmessagearea').html('<span style="color:red">'+(data.msg?data.msg:'error')+'</span>');
            keyinput.focus();
        }).off('click', '.ok-button').on('click', '.ok-button', function(event) {
            if (jQuery(this).hasClass('buttondisabled')){
                return false;
            };
            selectdialog.place.off('joinedincontext.courses').on('joinedincontext.courses', function(e, data){
                if (typeof(data.detail) !== 'undefined') {
                    data = data.detail;
                };
                if (data.success) {
                    selectdialog.place.trigger('clearDialog.courses');
                } else {
                    container.trigger('registrationerror', {"msg": "registeration error"});
                };
                selectdialog.place.off('joinedincontext.courses');
            });
            var servercontentinfos = [];
            var courseindex = container.find('.selectedli').attr('data-courselistindex');
            var serverData = selectdialog.options.serverdata && selectdialog.options.serverdata[courseindex] || {};
            serverData['contextkey'] = container.find('.activeinput').val();
            servercontentinfos.push(serverData);
            selectdialog.place.trigger('importContent.courses', {contentinfos: servercontentinfos});
            return true;
        }).off('click', 'ul.coursefilterlist > li').on('click', 'ul.coursefilterlist > li', function(event) {
            event.stopPropagation();
            var item = $(this);
            var parent = item.parent();
            var allitems = parent.children('li');
            var filtertype = parent.attr('data-filtertype');
            if (parent.is('.filter-open')) {
                allitems.removeClass('filter-selected');
                item.addClass('filter-selected');
                parent.removeClass('filter-open');
                var filtervalue = item.attr('data-filtervalue');
                var filter = {};
                filter[filtertype] = filtervalue ? [filtervalue] : [];
                selectdialog.updateFiltering(filter);
            } else {
                parent.addClass('filter-open');
            };
        });
    };
    
    /**
     * Get the html-code for the dialog.
     */
    CourseSelectDialog.prototype.getHtml = function() {
        var options = this.options;
        var localizer = this.config.localizer;
        var dialogHTML = `<h1>${localizer.localize('Courses:addcourse')}</h1>
        <div class="serverconnection dialog_message hide">
            <div class="container"><span class="infotext">${localizer.localize('Courses:working')}</span></div>
        </div>`;
        /*
            TODO: make cancel functionality
            '<span class="applicationButton cancelAction cancel-button">cancel</span>'+ 
        */
        if (options.serverdata && options.serverdata.length) {
            dialogHTML += `
            <div class="servercourseselector">
            <div class="servercourses">
                <h4>${localizer.localize('Courses:serverimport')}</h4>
                <div class="coursesearch">
                    <span class="searchicon"></span>${localizer.localize('Courses:search')} <input type="text">
                </div>
                <div class="coursefilter">
                    <ul class="coursefilterlist coursefilter-schools" data-filtertype="schools">
                    ${this.getSchoolList()}
                    </ul>
                    <ul class="coursefilterlist coursefilter-subjects" data-filtertype="subjects">
                    ${this.getSubjectList()}
                    </ul>
                </div>
                <ul class="serverdatalist">
                ${this.getServerDataList()}
                </ul>
            </div>
            <div class="courseinfojoinarea">
                <h3>${localizer.localize('Courses:courseinfo')}</h3>
            </div>
            </div>
            <div class="dialogmessagearea">
            </div>`
        } else {
            dialogHTML += `<div class="nocourses"><h4>${localizer.localize('Courses:nocourses')}</h4></div>`
        };
        return dialogHTML;
    };

    /**
     * Get the list of schools for filtering
     */
    CourseSelectDialog.prototype.getSchoolList = function() {
        var localizer = this.config.localizer;
        var options = this.options;
        var html = [], school;
        html.push(`<li class="coursefilter-school-item filter-selected">${localizer.localize('Courses:allschools')}</li>`)
        if (options.localdata) {
            for (var i = 0, len = options.localdata.availableschools.length; i < len; i++) {
                school = options.localdata.availableschools[i];
                if (options.localdata.schools.indexOf(school.id) > -1) {
                    html.push(`<li class="coursefilter-school-item" data-filtervalue="${sanitize(school.id)}">${sanitize(school.name)}</li>`);
                };
            };
        };
        return html.join('\n');
    }
    
    /**
     * Get the list of subjects for filtering
     */
    CourseSelectDialog.prototype.getSubjectList = function() {
        var uilang = this.config.general.uilang || 'en';
        var localizer = this.config.localizer;
        var options = this.options;
        var html = [], subject;
        html.push(`<li class="coursefilter-subject-item filter-selected">${localizer.localize('Courses:allsubjects')}</li>`)
        if (options.localdata) {
            var subjects = (options.localdata.subjects || []).slice();
            subjects.sort(function(a, b) {
                return ((a.weight < b.weight) || (a.weight === b.weight && (a.title[uilang] || a.title['en']).toLowerCase() < (b.title[uilang] || b.title['en']).toLowerCase()) ? -1 : 1);
            });
            for (var i = 0, len = subjects.length; i < len; i++) {
                subject = subjects[i];
                html.push(`<li class="coursefilter-subject-item" data-filtervalue="${sanitize(subject.id)}">${sanitize(subject.title[uilang])}</li>`)
            };
        };
        return html.join('\n');
    }
    
    /**
     * Get the list of server datas
     */
    CourseSelectDialog.prototype.getServerDataList = function() {
        var html = [], titles, schools, subjects;
        var uilang = this.config.general.uilang;
        var serverdata = this.options.serverdata || [];
        var cdata;
        serverdata.sort(function(a, b){return (a.name < b.name ? -1 : 1)});
        for (var i = 0, len = serverdata.length; i < len; i++) {
            cdata = JSON.parse(serverdata[i].data);
            schools = cdata.schools || [];
            subjects = cdata.subjects || [];
            titles = cdata.titles || {fi: 'otsikko', en: 'title', sv: 'rubrik'};
            html.push(`<li class="oneservercourse" data-schools="${sanitize(schools.join(' '))}" data-subjects="${sanitize(subjects.join(' '))}" data-courselistindex="${i}">
                <span class="titletext">${sanitize(titles[uilang] ? titles[uilang] : titles['common'])}</span>
            </li>`);
        };
        return html.join('\n');
    };
    
    /**
     * Update the even-odd zebra-coloring of the courselist
     */
    CourseSelectDialog.prototype.updateZebra = function() {
        this.container.find('ul.serverdatalist li.oneservercourse:visible:even').removeClass('zebra_even zebra_odd').addClass('zebra_even');
        this.container.find('ul.serverdatalist li.oneservercourse:visible:odd').removeClass('zebra_even zebra_odd').addClass('zebra_odd');
    };
    
    /**
     * Update the filtering settings
     * @param {Object} filters    Filtering selections
     */
    CourseSelectDialog.prototype.updateFiltering = function(filters) {
        this.filters = $.extend({
            schools: [],
            subjects: []
        }, this.filters, filters);
        var options = this.options;
        var selschools = this.filters.schools.slice();
        var i, len, j, jlen, subject;
        var currentsel = this.container.find('.selectedli');
        var currschools = (currentsel.attr('data-schools') || '').split(' ');
        var currsubjects = (currentsel.attr('data-subjects') || '').split(' ');
        var isschool = false, issubject = false;
        // Hide all courses
        var styles = ['.servercourses .serverdatalist .oneservercourse {display: none;}'];
        
        if (options.localdata) {
            if (this.filters.schools.length === 0) {
                //selschools = options.localdata.availableschools.map(function(x){return x.id;});
                // Select all schools of this user.
                selschools = options.localdata.schools.slice();
                isschool = true;
            };
            if (this.filters.subjects.length === 0) {
                // No filtering. Show all courses that are available for own schools or unrestrected.
                // Show all courses that are not restricted to any school.
                // (available on all schools either by listing all or listing none)
                styles.push('.servercourses .serverdatalist .oneservercourse[data-schools="'+this.filters.schools.join(' ')+'"] {display: block;}');
                issubject = true;
                // Show courses that are restricted to any of selected schools.
                for (i = 0, len = selschools.length; i < len; i++) {
                    isschool = isschool || (currschools.indexOf(selschools[i]) > -1);
                    styles.push('.servercourses .serverdatalist .oneservercourse[data-schools~="' + selschools[i] + '"] {display: block;}');
                };
            } else {
                // Filtering by subject. Show all courses of that subject and that are available for own schools or are unrestricted.
                for (j = 0, jlen = this.filters.subjects.length; j < jlen; j++) {
                    subject = this.filters.subjects[j];
                    issubject = issubject || (currsubjects.indexOf(subject) > -1);
                    // Show all courses that are not restricted to any school.
                    // (available on all schools either by listing all or listing none)
                    styles.push('.servercourses .serverdatalist .oneservercourse[data-schools="'+this.filters.schools.join(' ')+'"][data-subjects~="'+subject+'"] {display: block;}');
                    // Show courses that are restricted to any of selected schools.
                    for (i = 0, len = selschools.length; i < len; i++) {
                        isschool = isschool || (currschools.indexOf(selschools[i]) > -1);
                        styles.push('.servercourses .serverdatalist .oneservercourse[data-schools~="' + selschools[i] + '"][data-subjects~="'+subject+'"] {display: block;}');
                    };
                };
            };
            // Keep selected visible
            //styles.push('.servercourses .serverdatalist .oneservercourse.selectedli {display: block;}')
            if (!(isschool && issubject)) {
                this.updateInfoView(false);
            };
        };
        $('head style#courseselectionfilter').remove();
        $('head').prepend('<style id="courseselectionfilter" type="text/css">' + styles.join('\n') + '</style>');
        this.updateZebra();
    };
    
    /**
     * Update the courseinfo view
     * @param {Number|Boolean} index   The index of the selected listitem or false, if no item is selected.
     */
    CourseSelectDialog.prototype.updateInfoView = function(index) {
        var uilang = this.config.general.uilang || 'en';
        var localizer = this.config.localizer;
        var container = this.container;
        var infoarea = container.find('.courseinfojoinarea');
        container.find('.selectedli').removeClass('selectedli');
        if (typeof(index) === 'number') {
            container.find(`[data-courselistindex="${index}"]`).addClass('selectedli');
            var courseserverdata = this.options.serverdata && this.options.serverdata[index] || {};
            var coursedata = JSON.parse(courseserverdata.data);
            var startdate = coursedata.start_time && (new Date(coursedata.start_time)).toLocaleDateString() || '-';
            var enddate = coursedata.end_time && (new Date(coursedata.end_time)).toLocaleDateString() || '-';
            var subjects = coursedata.subjects || [];
            var subjhtml = [], currsubj;
            for (var i = 0, len = subjects.length; i < len; i++) {
                currsubj = this.subjects[subjects[i]] || {icon: ''};
                subjhtml.push(`<div class="courseinfosubject">
                    <div class="courseinfosubjecticon">${currsubj.icon}</div>
                    <div class="courseinfosubjecttext">${currsubj.title[uilang] || currsubj.title.en}</div>
                </div>`);
            };
            infoarea.html(
                `<h3>${localizer.localize('Courses:courseinfo')}</h3>
                <div class="courseinfoelement">
                    ${subjhtml.join('\n')}
                </div>
                <div class="courseinfoelement">
                    <span class="headlinetext">${localizer.localize('Courses:course')}</span>: <span>${courseserverdata.name}</span>
                </div>
                <div class="courseinfoelement">
                    <span class="headlinetext">${localizer.localize('Courses:teacher')}</span>: <span>${coursedata.teacher ? sanitize(coursedata.teacher.realname.firstname + ' ' + coursedata.teacher.realname.lastname) : '-'}</span>
                </div>
                <div class="courseinfoelement">
                    <span class="headlinetext">${localizer.localize('Courses:start_time')}</span>: <span>${startdate}</span>
                </div>
                <div class="courseinfoelement">
                    <span class="headlinetext">${localizer.localize('Courses:end_time')}</span>: <span>${enddate}</span>
                </div>
                <div class="courseinfoelement">
                    <span class="headlinetext">${localizer.localize('Courses:shortdescription')}</span>: <span>${coursedata.short_desc ? sanitize(coursedata.short_desc || '') : '-'}</span>
                </div>
                <div class="courseinfoelement">
                    <span class="headlinetext">${localizer.localize('Courses:description')}</span>:
                </div>
                <div class="courseinfoelement">${sanitize(coursedata.description || '')}</div>
                ${(courseserverdata.user_registered ? '' : '<div class="courseinfoelement"><span class="headlinetext">' + localizer.localize('Courses:givekey') + '</span>: <input data-inputfor="coursekey" class="nonempty" type="text"></div>')}
                <div class="buttons dialogButtons"><span class="applicationButton ok-button ${(courseserverdata.user_registered ? '' : 'buttondisabled')}">${localizer.localize('Courses:loadcourse')}</span></div></div>
            `);
        } else {
            infoarea.html(`<h3>${localizer.localize('Courses:courseinfo')}</h3>`);
        };
    };
    
    CourseSelectDialog.prototype.addStyles = function() {
        if ($('head style#courseaddcss').length === 0) {
            $('head').append(`
            <style id="courseaddcss" type="text/css">
            #coursenewadd label.inlinelabel{
                display: inline-block;
                margin-left: 1em;
                margin-top: 0.3em;
            }
            .dialogmessagearea {
                min-height: 2em;
            }
            .servercourseselector {
                display: flex;
                flex-direction: rew;
            }
            .servercourses .coursesearch {
                margin: 0 1em;
            }
            li.oneservercourse,
            li.oneservercourse label {
                cursor: pointer;
            }
            ul.searchmode li {
                display: none;
            }
            ul.searchmode li.selectedli,
            ul.searchmode li.matching {
                display: list-item;
            }
            ul.serverdatalist.searchmode li.oneservercourse:not(.matching) {
                display: none;
            }
            li.selectedli {
                border: 1px solid red;
            }
            .courseinfojoinarea {
                /*border: 1px solid #999;*/
                min-height: 8em;
                margin: 0.5em 0.5em 0.5em 0.1em;
                padding: 0.3em;
                flex-shrink: 0;
                min-width: 18em;
                width: 50%;
                background-color: rgba(255,255,255,0.1);
                overflow-y: auto;
            }
            #simplemodal-data ul.serverdatalist {
                margin: 0.3em 0.1em 0.3em 1em;
            }
            #simplemodal-data .courseinfojoinarea h3 {
                margin: 0;
                font-size: 110%;
            }
            .courseinfojoinarea .courseinfoelement {
                margin-bottom: 0.3em;
                overflow-y: auto;
            }
            .courseinfojoinarea .courseinfoelement .headlinetext {
                text-decoration: underline;
            }
            .courseinfojoinarea div.dialogButtons {
                border-top: none;
                margin-top: 0.5em;
            }
            .courseinfojoinarea .courseinfosubject {
                display: inline-block;
                text-align: center;
                border-radius: 8px;
                border: 1px solid #ccc;
                background-color: rgba(255,255,255,0.1);
                margin: 0.2em;
                padding: 0.3em;
            }
            .courseinfojoinarea .courseinfosubjecticon svg {
                width: 20px;
                height: 20px;
            }
            .courseinfojoinarea .courseinfosubjecticon svg .mini-icon-background {
                fill: #eee;
            }
            .courseinfojoinarea .courseinfosubjecticon svg .mini-icon-foreground {
                fill: #333;
            }
            .courseinfojoinarea .courseinfosubjecttext {
                font-size: 60%;
            }
            .coursefilter {
                display: flex;
                flex-direction: row;
                margin: 0 1em;
                min-height: 2em;
                max-height: 3em;
                position: relative;
            }
            .coursefilterlist {
                list-style: none;
                margin: 0.2em 0.4em;
                padding: 0;
                position: relative;
                z-index: 10;
            }
            .coursefilterlist.filter-open {
                max-height: 1em;
                z-index: 11;
            }
            .coursefilterlist li {
                padding: 0.1em  0.2em;
                border: 1px solid rgba(0,0,0,0.3);
                border-radius: 4px;
                background-color: rgba(255,255,255,0.05);
                display: none;
                cursor: pointer;
            }
            .coursefilterlist li.filter-selected {
                display: inline-block;
            }
            .coursefilterlist.filter-open li {
                display: block;
                border-radius: 0;
                background-color: #444;
                color: white;
                box-shadow: 1px 1px 6px rgba(0,0,0,0.5);
                padding-left: 1.6em;
            }
            .coursefilterlist.filter-open li::before {
                display: inline-block;
                margin-left: -1.5em;
                content: " ";
                width: 1em;
                height: 1em;
                margin-right: 0.4em;
                background: transparent url("data:image/svg+xml;charcode=utf-8,<svg xmlns='http://www.w3.org/2000/svg' version='1.1' width='1em' height='1em' viewBox='0 0 30 30' class='mini-icon mini-icon-radio-off'><path style='stroke: black; fill: white; stroke-width: 1;' d='M15 1 a14 14 0 0 1 0 28 a14 14 0 0 1 0 -28z'></path></svg>") center center no-repeat;
            }
            .coursefilterlist.filter-open li.filter-selected::before {
                content: " ";
                background: transparent url("data:image/svg+xml;charcode=utf-8,<svg xmlns='http://www.w3.org/2000/svg' version='1.1' width='1em' height='1em' viewBox='0 0 30 30' class='mini-icon mini-icon-radio-on'><path style='stroke: black; fill: white; stroke-width: 1;' d='M15 1 a14 14 0 0 1 0 28 a14 14 0 0 1 0 -28z'></path><path style='stroke: none;' d='M15 7 a8 8 0 0 0 0 16 a8 8 0 0 0 0 -16z'></path></svg>") center center no-repeat;
            }
            </style>`);
        };
    }
    
    CourseSelectDialog.prototype.defaults = {
        
    }
    
    
    /**
     * Class for new course creation dialog
     * @class CourseCreateDialog
     * @constructor
     * @param {jQuery} place    The place for this dialog
     * @param {Object} options  All needed options
     * @param {Object} config   The configs for the dialog
     */
    var CourseCreateDialog = function(place, options, config) {
        this.place = place;
        this.config = config;
        this.options = $.extend(true, {}, this.defaults, options);
        this.addStyles();
        return this;
    };
    
    CourseCreateDialog.prototype.show = function() {
        var createdialog = this;
        var localizer = this.config.localizer;
        if (typeof(jQuery.modal) === 'function') {
            this.dialog = jQuery.modal(this.getHtml(), {
                closeHTML: `<a href='#' title='${localizer.localize('Courses:close')}' class='modal-close'>${application.prototype.icons.close}</a>`,
                close: true,
                minHeight: this.config.dialogHeight(),
                maxHeight: this.config.dialogHeight(),
                minWidth: 600,
                autoResize: true,
                onShow: function(dialog) {},
                overlayId: undefined,
                containerId: 'coursenewadd',
                escClose: false
            });
        } else {
            var newtitle = prompt('Course title');
            var newdata = {};

            this.place.trigger('createNewContent.system',{
                application: 'courses',
                type: 'courses',
                event: 'contentCreated.courses',
                content: jQuery.extend(true,{}, this.defaultnew, newdata) //TODO make dafaultnew
            });
        };
        this.initHandlers();
    };
    
    CourseCreateDialog.prototype.initHandlers = function() {
        var createdialog = this;
        var localizer = this.config.localizer;
        var dialog = this.dialog;
        var container = dialog.d.container;

        // Validator for fields that should be non-empty.
        var formValidNotEmpty = function(inputfields) {
            var result = true;
            inputfields.removeClass('errornotempty');
            for (var i = 0, len = inputfields.length; i < len; i++) {
                if (inputfields.eq(i).val() === '') {
                    result = false;
                    inputfields.eq(i).addClass('errornotempty');
                };
            };
            if (!result) {
                container.trigger('showerrormsg', {
                    msg: localizer.localize('Courses:notemptyerrormsg'),
                    'class': 'validationerror'
                });
            };
            return result;
        };
        
        // Validator for fields that should not be equal (caseinsensitive!)
        var formValidNotEqual = function(inputfields) {
            var checkObj = {};
            var neqval;
            var result = true;
            inputfields.removeClass('errornotequal');
            for (var i = 0, len = inputfields.length; i < len; i++) {
                if (inputfields.eq(i).is(':disabled')) {
                    continue;
                };
                neqval = inputfields.eq(i).attr('data-notequal');
                if (typeof(checkObj[neqval]) === 'undefined') {
                    checkObj[neqval] = [];
                };
                if (checkObj[neqval].indexOf(inputfields.eq(i).val().toLowerCase()) !== -1) {
                    result = result && false;
                    inputfields.filter(`[data-notequal="${neqval}"]`).addClass('errornotequal');
                };
                checkObj[neqval].push(inputfields.eq(i).val().toLowerCase());
            };
            if (!result) {
                container.trigger('showerrormsg', {
                    msg: localizer.localize('Courses:notequalerrormsg'),
                    'class': 'validationerror'
                });
            };
            return result;
        };
        
        // Validator for dates (start is before end)
        var formValidDates = function() {
            var startinput = container.find('input[data-inputfor="start_time"]');
            var endinput = container.find('input[data-inputfor="end_time"]');
            var startval = startinput.val();
            var endval = endinput.val();
            var start = startval && (new Date(startval)).getTime() || false;
            var end = endval && (new Date(endval)).getTime() || false;
            var result = (start && !end) || (start <= end);
            if (!result) {
                endinput.addClass('errordate');
                container.trigger('showerrormsg', {
                    msg: localizer.localize('Courses:endbeforestarterrormsg'),
                    'class': 'validationerror'
                });
            } else {
                endinput.removeClass('errordate');
                container.removeClass('showvaliderrors')
                    .find('.dialogmessagearea')
                    .html('').removeClass('validationerror');
            };
            return result;
        };

        // Event handlers
        container.off('showerrormsg').on('showerrormsg', function(event, data) {
            // Show error messages
            container.find('.dialogmessagearea').html(`<span class="errormsgplace ${data.class ? data.class : ''}">${data.msg ? data.msg : localizer.localize('Courses:ERROR')}</span>`)
        }).off('keyup', 'textarea, input[type="text"]').on('keyup', 'textarea, input[type="text"]', function(event) {
            // On keyup do validation and enable or disable OK-button
            container.removeClass('showvaliderrors')
                .find('.dialogmessagearea')
                .html('').removeClass('validationerror');
            if (formValidNotEmpty(container.find('.nonempty')) && formValidNotEqual(container.find('[data-notequal]')) && formValidDates()) {
                container.trigger('enable_ok');
                if (event.keyCode === 13) {
                    container.find('.dialogButtons .ok-button').click();
                };
            } else {
                container.trigger('disable_ok');
            };
        }).off('enable_ok').on('enable_ok', function() {
            // Enable OK-button
            container.find('.ok-button').removeClass('buttondisabled');
        }).off('disable_ok').on('disable_ok', function() {
            // Disable OK-button
            container.find('.ok-button').addClass('buttondisabled');
        }).off('valid-form').on('valid-form', function() {
            // Validate the form
            if (formValidNotEmpty(container.find('.nonempty')) && formValidNotEqual(container.find('[data-notequal]')) && formValidDates()) {
                container.trigger('enable_ok');
                container.trigger('form-is-valid');
            } else {
                container.trigger('disable_ok');
                container.trigger('form-not-valid');
            };
        }).off('change', 'input.coursetimepermanent').on('change', 'input.coursetimepermanent', function() {
            // If the select changes, toggle ending time disabled.
            var etinput = container.find('input[data-inputfor="end_time"]');
            var ispermanent = $(this).is(':checked');
            if (ispermanent) {
                etinput.val('').attr('disabled', 'true').removeClass('nonempty errornotempty');
            } else {
                etinput.removeAttr('disabled').addClass('nonempty').removeClass('errornotempty');
            };
            container.trigger('valid-form');
        }).off('change', 'input[data-inputfor="end_time"]').on('change', 'input[data-inputfor="end_time"]', function() {
            container.trigger('valid-form');
        }).off('change', 'select.startdataselector').on('change', 'select.startdataselector', function() {
            // If the select changes, validate the form.
            container.trigger('valid-form');
        }).off('change', 'input[data-inputfor="coursevisibility"]').on('change', 'input[data-inputfor="coursevisibility"]', function() {
            // If the visibility changes, handle enablin/disabling coursekeys.
            var clickedradio = jQuery(this);
            var coursevisibility= clickedradio.parents('.coursevisibility');
            var coursekeyinputarea = coursevisibility.find('.coursekeyinput');
            var keyinputs = coursekeyinputarea.find('input');
            if (clickedradio.val() !== 'privatecourse') {
                keyinputs.addClass('nonempty');
                coursekeyinputarea.removeClass('disablekeyinput');
                coursevisibility.addClass('standardcourse');
                keyinputs.prop('disabled', false);
            } else {
                keyinputs.removeClass('nonempty');
                coursekeyinputarea.addClass('disablekeyinput');
                coursevisibility.removeClass('standardcourse');
                keyinputs.prop('disabled', true);
            };
            container.trigger('valid-form');
        }).off('change', 'select[data-inputfor="startdatatype"]').on('change', 'select[data-inputfor="startdatatype"]', function() {
            var parentlabel = jQuery(this).parent();
            parentlabel.attr('data-selectvalue',jQuery(this).val()).find('.nonempty').removeClass('nonempty');
            parentlabel.find('select.type_'+jQuery(this).val()+'.startdataselector').addClass('nonempty').val('');
            container.trigger('valid-form');
        //}).off('click', '.coursecreator-schoolitem').on('click', '.coursecreator-schoolitem', function(event) {
        //    event.stopPropagation();
        //    $(this).toggleClass('selectedschool');
        }).off('click', '.ok-button').on('click', '.ok-button', function() {
            // Handle the OK-button clicking. Send the course creating event.
            if (jQuery(this).hasClass('buttondisabled')) {
                container.addClass('showvaliderrors');
                container.trigger('valid-form');
            } else {
                var valueObj = {};
                var inputElements = container.find('[data-inputfor]');
                inputElements.each(function() {
                    if (jQuery(this).prop('type') !== 'radio' || jQuery(this).prop('checked')) {
                        valueObj[jQuery(this).attr('data-inputfor')] = jQuery(this).val();
                    };
                });
                var schools = [];
                if (valueObj.coursevisibility !== 'privatecourse' && valueObj.coursevisibility !== 'standardcourse') {
                    schools = [valueObj.coursevisibility];
                    valueObj.coursevisibility = 'standardcourse';
                };
                var providingSchool = valueObj.courseprovider || '';
                var subjects = [valueObj.coursesubject];
                var localdata = createdialog.options.localdata || {};
                var relaydata = {
                    localcontextdata: localdata.availableaddcontexts || {}
                };
                createdialog.place.trigger('createNewContent.courses', {
                    inputvalues: valueObj,
                    relaydata: relaydata,
                    user: {
                        username: localdata.username,
                        realname: {
                            firstname: localdata.firstname,
                            lastname: localdata.lastname
                        }
                    },
                    username: localdata.username,
                    filename: localdata.filename,
                    schools: schools,
                    subjects: subjects,
                    providing_school: providingSchool
                });
            };
        });
    };
    
    
    CourseCreateDialog.prototype.getHtml = function() {
        var options = this.options;
        var localizer = this.config.localizer;
        var schools = options.localdata.availableschools;
        var myschools = options.localdata.schools;
        schools.sort(function(a, b){return (a.name < b.name ? -1 : 1);});
        var dialogHTML = `<h1>${this.config.localizer.localize('Courses:addnewcourse')}</h1>
            <div class="serverconnection dialog_message hide">
            <div class="container">
                <span class="infotext">${localizer.localize('Courses:working')}</span>
            </div>
            </div>`;
        if (options.localdata) {
            dialogHTML += `<div class="addcourse" data-firstname="${sanitize(options.localdata.firstname)}"  data-lastname="${sanitize(options.localdata.lastname)}"  data-username="${sanitize(options.localdata.username)}" data-filename="${sanitize(options.localdata.filename)}">
                <div class="courseteacher">
                    ${localizer.localize('Courses:teacher')}: ${sanitize(options.localdata.firstname + ' ' + options.localdata.lastname)}
                </div>
                <label><span class="dialoginputlabeltext">${localizer.localize('Courses:coursestitle')}:</span><input data-inputfor="name" class="nonempty" type="text"></label>
                <label><span class="dialoginputlabeltext">${localizer.localize('Courses:short_desc')}:</span><input data-inputfor="short_desc" class="nonempty" type="text"></label>
                <label><span class="dialoginputlabeltext">${localizer.localize('Courses:description')}:</span><textarea data-inputfor="description" class="nonempty"></textarea></label>
                <div class="coursetimeframe">
                    <div class="dialoginputcell"><label><span class="dialoginputlabeltext">${localizer.localize('Courses:start_time')}</span><input class="nonempty" data-inputfor="start_time" type="date" value="${(new Date()).toISOString().substr(0, 10)}"></input></label></div>
                    <div class="dialoginputcell"><label><span class="dialoginputlabeltext">${localizer.localize('Courses:end_time')}</span><input class="nonempty" data-inputfor="end_time" type="date"></input></label></div>
                    <div class="dialoginputcell"><label><span class="dialoginputlabeltext">${localizer.localize('Courses:permanent_course')}</span><input type="checkbox" class="coursetimepermanent"></input></label></div>
                </div>
                <fieldset class="courserproviderselector">
                    <legend>${localizer.localize('Courses:providing_school')}</legend>
                    ${this.getMyschoolsRadio('courseproviderschoolselector', 'courseprovider')}
                </fieldset>
                <fieldset class="coursesubjectselector">
                    <legend>${localizer.localize('Courses:subject')}</legend>
                    ${this.getSubjectsRadio()}
                </fieldset>
                <fieldset class="coursevisibility standardcourse">
                    <legend>${localizer.localize('Courses:visibility')}</legend>
                    <div class="coursevisibilityselector">
                        <div class="courseprivacy">
                            <label class="inlinelabel"><input name="coursevisibilityselector" value="standardcourse" data-inputfor="coursevisibility" ${myschools.length === 0 ? checked="checked" : ''} type="radio"><span class="dialogradiobuttonlabeltext">${localizer.localize('Courses:standardcourse')}</span></label>
                            ${this.getMyschoolsRadio('coursevisibilityselector', 'coursevisibility')}
                            <label class="inlinelabel"><input name="coursevisibilityselector" value="privatecourse" data-inputfor="coursevisibility"  type="radio"><span class="dialogradiobuttonlabeltext">${localizer.localize('Courses:privatecourse')}</span></label>
                        </div>
                    </div>
                    <div class="coursekeyinput">
                        <label><span class="dialoginputlabeltext">${localizer.localize('Courses:teacherkey')}:</span><input data-notequal="coursekey" data-inputfor="teacherkey" class="nonempty" type="text"></label>
                        <label><span class="dialoginputlabeltext">${localizer.localize('Courses:studentkey')}:</span><input data-notequal="coursekey"  data-inputfor="studentkey" class="nonempty" type="text"></label>
                    </div>
                </fieldset>
                <span style="display:none" data-spanfor="localcontextdata" >${JSON.stringify(options.localdata.availableaddcontexts)}</span>
                <label>
                    <span class="dialoginputlabeltext">${localizer.localize('Courses:startdatatype')}:</span>
                    <select data-inputfor="startdatatype" >
                    <option value="empty_notebook">${localizer.localize('Courses:emptymaterial')}</option>
                    ${this.getContextTypeOptions()}
                    </select>
                    ${this.getContextSelects()}
                </label>
            </div>`;
        };
        dialogHTML += `<div class="dialogmessagearea" style="min-height:2em;">
            </div>
            <div class="buttons dialogButtons"><span class="applicationButton ok-button buttondisabled">OK</span></div>
        </div>`;
        return dialogHTML;
    };
    
    /**
     * Get the HTML-code for available context type options (books, notebooks);
     */
    CourseCreateDialog.prototype.getContextTypeOptions = function() {
        var localizer = this.config.localizer;
        var contexts = (this.options.localdata ? this.options.localdata.availableaddcontexts : {});
        var ctypes = Object.keys(contexts);
        var result = [];
        for (var i = 0, len = ctypes.length; i < len; i++) {
            if (contexts[ctypes[i]].length > 0) {
                result.push(`<option value="${ctypes[i]}">${localizer.localize('Courses:' + ctypes[i])}</option>`);
            };
        };
        return result.join('\n');
    };
    
    /**
     * Get the HTML-code of <select>-elements of available context types (books, notebooks).
     */
    CourseCreateDialog.prototype.getContextSelects = function() {
        var localizer = this.config.localizer;
        var options = this.options;
        var uilang = this.options.localdata.uilang;
        var contexts = (this.options.localdata ? this.options.localdata.availableaddcontexts : {});
        var ctypes = Object.keys(contexts);
        var result = [];
        var contexttitle, cdata;
        for (var i = 0, len = ctypes.length; i < len; i ++) {
            if (contexts[ctypes[i]].length > 0) {
                result.push(`<select data-inputfor="selected_${ctypes[i]}" class="type_${ctypes[i]} startdataselector">`);
                result.push(`    <option data-defaultoption="" value="">${localizer.localize('Courses:selectcontext')}</option>`);
                for (var j = 0, jlen = contexts[ctypes[i]].length; j < jlen; j++) {
                    contexttitle = '';
                    cdata = contexts[ctypes[i]][j];
                    if (cdata.titles) {
                        if (cdata.titles[uilang]) {
                            contexttitle = cdata.titles[uilang];
                        } else if (cdata.titles['common']) {
                            contexttitle = cdata.titles['common'];
                        } else {
                            contexttitle = cdata.contextid;
                        };
                    } else {
                        contexttitle = cdata.contextid;
                    };
                    result.push(`    <option value="${cdata.contextid}">${sanitize(contexttitle)}</option>`);
                };
                result.push('</select>')
            };
        };
        return result.join('\n');
    };
    
    /**
     * Get html for radio buttons for user's own schools
     * @param {String} classname    The classname for items
     * @param {String} inputfor     The inputfor name
     */
    CourseCreateDialog.prototype.getMyschoolsRadio = function(classname, inputfor) {
        var myschools = this.options.localdata && this.options.localdata.schools || [];
        var schools = this.options.localdata && this.options.localdata.availableschools || [];
        schools.sort(function(a, b){return (a.name < b.name ? -1 : 1);});
        var result = [], oneschool, first = true;
        for (var i = 0, len = schools.length; i < len; i++) {
            oneschool = schools[i];
            if (myschools.indexOf(oneschool.id) !== -1) {
                result.push(`<label class="inlinelabel"><input name="${classname}" value="${oneschool.id}" data-inputfor="${inputfor}" ${first ? 'checked="checked"' : ''} type="radio"><span class="dialogradiobuttonlabeltext">${oneschool.name}</span></label>`);
                first = false;
            };
        };
        return result.join(' ');
    };
    
    /**
     * Get html for radio buttons for the subject of the course.
     */
    CourseCreateDialog.prototype.getSubjectsRadio = function() {
        var uilang = this.config.general.uilang;
        var localizer = this.config.localizer;
        var options = this.options;
        var subjects, rows = 0, cols = 3, subj;
        result = [];
        if (options.localdata) {
            subjects = options.localdata && options.localdata.subjects.slice() || [];
            subjects.sort(function(a, b) {
                return ((a.weight < b.weight) || (a.weight === b.weight && (a.title[uilang] || a.title['en']).toLowerCase() < (b.title[uilang] || b.title['en']).toLowerCase()) ? -1 : 1);
            });
            rows = Math.ceil(subjects.length / cols);
            result.push('<table class="coursesubjecttable">', '<tbody>');
            for (var i = 0; i < rows; i++) {
                result.push('<tr>');
                for (var j = 0; j < cols; j++) {
                    subj = subjects[cols * i + j];
                    if (subj) {
                        result.push(`<td><label class="coursesubject-item" title="${sanitize(subj.title[uilang] || subj.title.en)}"><input name="coursesubjectselector" value="${sanitize(subj.id)}" data-inputfor="coursesubject" type="radio" ${subj.id === 'misc' ? 'checked="checked"' : ''}> ${subj.icon} <span class="subjectlabel">${sanitize(subj.title[uilang] || subj.title.en)}</span></label></td>`);
                    } else {
                        result.push('<td></td>');
                    };
                };
                result.push('</tr>');
            };
            result.push('</tbody>', '</table>');
        };
        return result.join('\n');
    };
    
    /**
     * Add css-styles for creating a new course
     */
    CourseCreateDialog.prototype.addStyles = function() {
        if ($('head style#coursenewaddcss').length === 0) {
            $('head').append(`
            <style id="coursenewaddcss" type="text/css">
                #coursenewadd label.inlinelabel {
                    display: inline-block;
                    margin-left: 1em;
                    margin-top: 0.3em;
                }
                .disablekeyinput {
                    opacity: 0.2;
                    display: block;
                }
                .dialoginputcell {
                    display: inline-block;
                }
                .coursesubjectselector td {
                    padding: 0.2em 1em;
                    vertical-align: middle;
                }
                .coursesubjectselector td:hover {
                    background-color: rgba(255,255,255,0.1);
                }
                .coursesubjectselector label {
                    cursor: pointer;
                }
                .coursesubjectselector label.coursesubject-item {
                    font-size: 90%;
                    padding-left: 32px;
                    line-height: 1.2em;
                }
                .coursesubjectselector label.coursesubject-item svg.mini-icon {
                    margin-left: -32px;
                    float: left;
                }
                .coursesubjectselector td input[name="coursesubjectselector"] {
                    display: none;
                }
                .coursesubjectselector .coursesubject-item {
                    display: inline-block;
                }
                .coursesubjectselector .coursesubject-item svg {
                    display: inline-block;
                    vertical-align: middle;
                }
                .coursesubjectselector .coursesubject-item svg .mini-icon-background {
                    fill: #eee;
                }
                .coursesubjectselector .coursesubject-item svg .mini-icon-foreground {
                    fill: #333;
                }
                .coursesubjectselector td input[name="coursesubjectselector"]:checked + svg .mini-icon-background {
                    fill: #333;
                }
                .coursesubjectselector td input[name="coursesubjectselector"]:checked + svg .mini-icon-foreground {
                    fill: #eee;
                }
                .coursesubjectselector input[name="coursesubjectselector"]:checked + .subjectlabel,
                .coursesubjectselector td input[name="coursesubjectselector"]:checked + svg + .subjectlabel {
                    text-decoration: underline;
                    text-shadow: 0 0 0, 0 0 0;
                }
                .coursevisibility .courseschoolselector {
                    display: none;
                }
                .coursesubjecttable td {
                    width: 32%;
                    vertical-align: top;
                }
                .coursevisibility.standardcourse .courseschoolselector {
                    display: block;
                }
                .courseschoolselector {
                    background-color: rgba(255,255,255,0.9);
                    padding: 0.3em 0.5em;
                    border: 1px solid #555;
                }
                .addcourse legend {
                    border-radius: 0.3em;
                    padding: 0 0.3em;
                }
                .coursecreator-schoolitem {
                    font-size: 80%;
                    margin-right: 0.5em;
                    border: 1px solid #aaa;
                    border-radius: 4px;
                    padding: 0.1em 0.3em;
                    cursor: pointer;
                    background-color: white;
                    color: #555;
                    white-space: nowrap;
                    line-height: 1.8em;
                }
                .coursecreator-schoolitem::before {
                    content: " ";
                    margin-right: 0.3em;
                    margin-bottom: -1px;
                    width: 0.7em;
                    height: 0.7em;
                    line-height: 0.65em;
                    display: inline-block;
                    border: 1px solid #555;
                    background-color: white;
                    color: #333;
                    font-weight: bold;
                    text-align: center;
                }
                .coursecreator-schoolitem.selectedschool {
                    text-shadow: 0 0 0 white;
                    background-color: #444;
                    color: white;
                }
                .coursecreator-schoolitem.selectedschool::before {
                    content: "\u00D7";
                    background-color: white;
                    color: #333;
                    text-shadow: none;
                }
                .showvaliderrors .errordate,
                .showvaliderrors .errornotequal,
                .showvaliderrors .errornotempty {
                    background-color: #FBBBB9;
                }
                .errormsgplace {
                    color: red;
                }
                .validationerror {
                    display: none;
                }
                .showvaliderrors .validationerror {
                    display: inline-block;
                }
            </style>`);
        };
    };
    
    CourseCreateDialog.prototype.defaults = {
        
    }
    
    
    
    /**
     * Use the sanitizer of the Courses-class.
     */
    var sanitize = Courses.prototype.sanitize;
    
})(jQuery)