(function ($) {
    /*****************************************************************
     * System
     * Constructor
     *****************************************************************/
    function Bookshelf(place, params) {
        params = $.extend(
            true,
            {},
            {
                config: {
                    general:{
                        lang: "en-US",
                        bookshelfversion: 2015.0227,
                        uilang:"fi"
                    },
                    dialogHeight:function(){return Math.floor(window.outerHeight*0.8)}
                    
                },
                neededPlugins:[
                    "reader"
                ],
                CSSrules:[            
                    {"element":" .bookselection",
                    "rules":"display: flex;margin-top: 1em;  flex-wrap: wrap;min-width:150px;"},
                    {"element":"",
                    "rules":"min-width:300px;"},
                    {"element":".removeActive .contentselection .contentSelector:before",
                    "rules":"content:\"X\";width:15px;height:15px;border:1px solid black;border-radius:10px;padding:5px;background-color:red;color:white;font-weight:bold;position: absolute;margin-left: 4.5em;"},
                    {"element":" .contentSelector:hover",
                    "rules":"box-shadow:5px 5px 5px #999,-5px -5px 5px #999;"},
                    {"element":" .contentSelector",
                    "rules":"cursor:pointer;background-color:white; border:1px solid gray;padding:0.2em;border-radius:5px;box-shadow:3px 3px 3px #999;min-height:100px;min-width:100px;display:inline-block;margin-left:1em; "},
                    {"element":" .contentSelector .bookname",
                    "rules":"overflow: hidden; min-width: 90px; min-height: 90px; text-overflow: ellipsis; display: inline-block;"}
                ],
                applicationType:"bookshelf",
                applicationcontentpath:"book",
                contexttype:"book",
                translations:{
                    "en":{
                        "Bookshelf:book":"Book",
                        "Bookshelf:addbook":"Add readerbook",
                        "Bookshelf:bookshelf":"Bookshelf",
                        "Bookshelf:serverimport":"Load book from server"
                        },
                    "sv":{
                        "Bookshelf:book": "Bok",
                        "Bookshelf:bookshelf": "Bokhylla",
                        "Bookshelf:serverimport": "Ladda ner en bok från servern",
                        "Bookshelf:addbook": "Lägg till en bok"
                        },
                    "fi":{
                        "Bookshelf:book":"Kirja",
                        "Bookshelf:addbook":"Lisää lukukirja",
                        "Bookshelf:bookshelf":"Kirjahylly",
                        "Bookshelf:serverimport":"Lataa kirja palvelimelta"
                        }
                }
            },
            params
        );
        
        application.call(this,place,params);
    }
    Bookshelf.prototype =Object.create(application.prototype);
    Bookshelf.prototype.constructor = Bookshelf;
    Bookshelf.prototype.parentClass = application.prototype;
    Bookshelf.prototype.eventHandlerInitParent = Bookshelf.prototype.eventHandlerInit;
    Bookshelf.prototype.mainParent = Bookshelf.prototype.main;
    /******
     * Event handlers
     ******/
    Bookshelf.prototype.eventHandlerInit = function() {
        this.eventHandlerInitParent();
        var bookshelfSelf = this;
        this.place.on('openBook.bookshelf', function(e,data) {
            //console.log(JSON.stringify(jQuery(this)[0]));
        });
        this.place.on('pluginsAvailable.bookshelf', function(e,data) {
            if(data.pluginsAvailable){
                bookshelfSelf.place.trigger('getAvailableContent.system',{path:"book",event:"avilableBooks.bookshelf"});
            }else{
                bookshelfSelf.getMissingPlugin(data.missing || bookshelfSelf.neededPlugins);
            };
        });
        this.place.on('click',".bookSelector" ,function(e,data) {
            if(bookshelfSelf.place.hasClass('removeActive')){
                if(jQuery(this).hasClass('contextOpen'))return true;
                if(confirm(bookshelfSelf.config.localizer.localize('system:remove_element_confirm'))){
                    bookshelfSelf.place.trigger("systemrequest.system",{
                        
                                                    type:"removeContent" ,
                                                    removeFile : {
                                                        "content":"book" ,
                                                        "contextid":jQuery(this).attr("bookid"),//.replace(/\.json^/,''),
                                                        "contenttype":"book",
                                                        "contexttype":"book"
                                                        },
                                                    callbackEvent:"refreshview.bookshelf",
                                                    callbacktype:"jQuery"
                                                });
                }
            }else{
                bookshelfSelf.place.trigger("startPlugin.system",
                                {
                                    "view":jQuery(this).attr("view"),
                                    "parameters":{
                                        bookid:jQuery(this).attr("bookid").replace(".json",""),
                                        contenttype:"book",
                                        contentid:jQuery(this).attr("bookid"),
                                        contexttype:"book",
                                        contextid:jQuery(this).attr("bookid")
                                    },
                                    "plugins" : [
                                                    {
                                                        pluginName : "reader",
                                                        params : {
                                                            systemRequests:[
                                                                {
                                                                    type:"getContentAsObject" ,
                                                                    getContentAsObject : {
                                                                        "category":'content',
                                                                        "type":"book" ,
                                                                        "context":{
                                                                            "contextid":jQuery(this).attr("bookid"),
                                                                            "contexttype":"book"
                                                                        },
                                                                        "category":'content',
                                                                        "type":"book" ,
                                                                        "filename":jQuery(this).attr("fileRef")},
                                                                    callbackEvent:"bookdataReady",
                                                                    relayParams : {
                                                                        bookid : jQuery(this).attr("bookid").replace(".json", ""),
                                                                        uilang : bookshelfSelf.config.general.uilang
                                                                    }
                                                                }
                                                            ]                                                        
                                                        }
                                                    }
                                    		], 
                                    "windowAddons" :{}
                                });
            }
        });
        this.place.on('avilableBooks.bookshelf', function(e,data) {
            if(!data.contentList || data.contentList.length===0){
                bookshelfSelf.books = [];
                bookshelfSelf.place.append("<span>No books available</span>");
            }else{
                bookshelfSelf.books = data.contentList;
                bookshelfSelf.place.trigger('getAvailableViews.system',{event:"avilableViews.bookshelf"});
            }
        });
        this.place.on('avilableViews.bookshelf', function(e,data) {
            var appendPlace = bookshelfSelf.place.append("<div class=\"bookselection contentselection\"></div>").find(".bookselection");
            for(var bookFile in bookshelfSelf.books){
                bookshelfSelf.addcontentSelector(bookshelfSelf.books[bookFile],appendPlace);
            }
            var sorted = appendPlace.find('.contentSelector').sort(
                function (a, b) {
                      var contentA = jQuery(a).attr('title');
                      var contentB = jQuery(b).attr('title');
                      return (contentA < contentB) ? -1 : 1;
                   }
            );
            appendPlace.empty().append(sorted);
            bookshelfSelf.place.trigger('initialized.bookshelf');
            bookshelfSelf.place.trigger(
                'notify.system',
                {msg:"bookshelfDone",type:"notification"}
                
            );
        });
        this.place.off('refreshview').on('refreshview', function() {
            bookshelfSelf.place.trigger('refreshview.bookshelf');
        });
        this.place.on('refreshview.bookshelf', function() {
            console.log('refreshBoobsheld');
            bookshelfSelf.place.empty();
            bookshelfSelf.place.off();
            bookshelfSelf.place.bookshelf(bookshelfSelf.initParams);
        });
        this.place.off('click.addbook').on('click.addbook','.addbook,.contentSelector.newcontentSelector', function() {
           bookshelfSelf.place.trigger('newContentinfo.system',
            {
                contenttype:"book",
                includelocal:true,
                filetype:"json",
                event:'addbookinit.ready',
                includeserverdata : true,
                servercontenttype:"book",
                callbacktype:"jQuery"
            }
            );
        });
        
        this.place.off('addbookinit.ready').on('addbookinit.ready', function(e,e_data) {
            if(typeof(e_data.detail) !=="undefined"){
                e_data = e_data.detail;
            }
            if(!e_data.success && (e_data.errortype == 12 || e_data.errortype == 13) ){
                bookshelfSelf.place.trigger(e_data.localizableerror+'_error');
                return false;
            }
            if(typeof(jQuery.modal) ==="function"){
                var show = function(dialog){
                    bookshelfSelf.addbookShow(dialog,bookshelfSelf);
                }
                var diagogHTML = '<h1>'+bookshelfSelf.config.localizer.localize('Bookshelf:addbook')+'</h1>';
                if(e_data.serverdata && e_data.serverdata.length){
                    e_data.serverdata.sort(function(a,b) {
                        try{
                            var titlesA = JSON.parse(a.data).titles;
                            var titlesB = JSON.parse(b.data).titles;
                            var titleA = titlesA[bookshelfSelf.config.general.uilang]?titlesA[bookshelfSelf.config.general.uilang]:titlesA['common'];
                            var titleB = titlesB[bookshelfSelf.config.general.uilang]?titlesB[bookshelfSelf.config.general.uilang]:titlesB['common'];
                        }catch(err){
                            console.log(err);
                            return -1;
                        }
                        return (titleA > titleB) ? 1 : ((titleB > titleA) ? -1 : 0);
                        } );
                    diagogHTML +='<div class="servernotebooks"><h4>'+bookshelfSelf.config.localizer.localize('Bookshelf:serverimport')+'</h4>';
                    diagogHTML +='<ul class="serverdatalist">';
                    for(var i=0;i<e_data.serverdata.length;i++){
                        try{
                            var titles = JSON.parse(e_data.serverdata[i].data).titles;
                            diagogHTML +='<li class="oneserverbook" ><span class="oneserverbookdata" style="display:none">'+JSON.stringify(e_data.serverdata[i])+'</span><label>'+bookshelfSelf.sanitize(titles[bookshelfSelf.config.general.uilang]?titles[bookshelfSelf.config.general.uilang]:titles['common'])+'<input type="radio" name="readerselector"/></label></li>';
                        }catch(err){
                            console.log("error",err,e_data.serverdata[i]);
                        }
                    }
                    diagogHTML +='</ul>';
                    diagogHTML +='</div>';
                }
                diagogHTML +='<div class="buttons dialogButtons"><span class="applicationButton ok-button buttondisabled">OK</span></div></div>';
                bookshelfSelf.dialog = jQuery.modal(diagogHTML,
                {
                        closeHTML: `<a href='#' title='Close' class='modal-close'>${application.prototype.icons.close}</a>`,
                        close: true,
                        minHeight:bookshelfSelf.config.dialogHeight(),
                        maxHeight :bookshelfSelf.config.dialogHeight(),
                        minWidth : 600,
                        autoResize :true,
                        onShow: show,
                        overlayId: undefined,
                        containerId: 'bookadd',
                        escClose: false
                    });
            }else{
                //TODO:
                //Some prompt if jQuery modal not available
            }
        });
        this.place.off('importContent.bookshelf').on('importContent.bookshelf', function(e,e_data) {
            // console.log('importContent.bookshelf',e_data);
            bookshelfSelf.place.trigger('importContent.system',{
                application:"bookshelf",
                type:"book",
                updatetype:"book",
                event:"contentCreated.bookshelf",
                content:e_data.contentinfos
            });
           
        });
        this.place.off('contentCreated.bookshelf').on('contentCreated.bookshelf', function(e,e_data) {
            jQuery.modal.close();
            bookshelfSelf.place.trigger('refreshview.bookshelf');
        });
        this.place.off('refreshview.bookshelf').on('refreshview.bookshelf', function() {
            bookshelfSelf.place.empty();
            bookshelfSelf.place.off();
            bookshelfSelf.place.bookshelf(bookshelfSelf.initParams);
        });
    }

    /******
     * Book selector
     ******/
    Bookshelf.prototype.addcontentSelector = function(fileRef, appPlace) {
        if(fileRef.error)return false;
        var bookname = this.sanitize(fileRef.titles && fileRef.titles[this.config.general.uilang]?
            fileRef.titles[this.config.general.uilang]:
            (fileRef.titles["en"]?
                fileRef.titles['en']:
                    (Object.keys(fileRef.titles)?fileRef.titles[Object.keys(fileRef.titles)[0]]:
                    "Content name missing!")
            )
            );
        var selector = "<span class=\"contentSelector bookSelector\" contexttype = \""+fileRef.contexttype+"\"  contextid=\""+fileRef.id+"\" fileRef=\""+fileRef.filename+"\" bookid=\""+fileRef.id+"\" title=\""+bookname+"\"><span class=\"contentname bookname\">"+bookname+"</span>\n";
        if(typeof(appPlace) !=="undefined"){
            appPlace.append(selector);
        }else{
            this.place.append(selector);  
        }
    }
    Bookshelf.prototype.addbookShow = function(dialog,BookSelf) {
        if(typeof(BookSelf) ==="undefined") BookSelf = this;
        dialog.container.on("change",'div.servernotebooks input[type="radio"]',function(e){
            dialog.container.trigger('disable_choise',{"elementclass":"addnotebook"}).trigger('enable_ok');
        });
        dialog.container.on("enable_ok",function(){
            dialog.container.find('.ok-button').removeClass('buttondisabled');
        });
        dialog.container.on("enable_choise",function(e,e_data){
            dialog.container.find('.ok-button').addClass('buttondisabled');
        });
        dialog.container.on("disable_choise",function(e,e_data){
            dialog.container.find('div.'+e_data.elementclass).addClass('elementdisable').find('input').prop('disabled',true);
        });
        dialog.container.on("enable_choise",function(e,e_data){
            dialog.container.find('div.'+e_data.elementclass).removeClass('elementdisable').find('input').prop('disabled',false);
        });
        dialog.container.on("click",".ok-button",function(){
            if(jQuery(this).hasClass('buttondisabled'))return false;
                var servercontentinfos = [];
                var imports = dialog.container.find('div.servernotebooks input[type="radio"]:checked');
                for(var i=0;i<imports.length;i++){
                    var one_info = JSON.parse(imports.eq(i).closest('li').find('.oneserverbookdata').text());
                    if(typeof(one_info.contextkey) ==="undefined") one_info.contextkey = "join_"+one_info.contextid;
                    servercontentinfos.push(one_info);
                }
                dialog.container.append('<span style="position:absolute;top:0;bottom:0;right:0;left:0;background-color:rgba(255,255,255,0.5);z-index:10;text-align: center;">Loading...</span>');
                BookSelf.place.trigger('importContent.bookshelf',{contentinfos:servercontentinfos});
        });
    }
    /******
     *
     ******/
    Bookshelf.prototype.main = function() {
        this.mainParent();
        this.place.find('.controlpanel').append('<span class="applicationButton add-button addbook defaultaddbutton"><span class="buttonIcon"></span><span class="buttonText">'+this.config.localizer.localize('Bookshelf:addbook')+'</span></span>');
    }

    { /** jQuery Plugin interface    **/
        var methods = {
            'init' : function(params) {
                return this.each( function() {
                    var bookshelf = new Bookshelf($(this), params);
                    $(this).data('bookshelf', bookshelf);
                });
            },
            'close' : function() {
                return this.each( function() {
                    return $(this).data('bookshelf').close();
                });
            },
            'get' : function(params) {
                return $(this).data('bookshelf')[params];
            },
            'set' : function(params) {
                return $(this).data('bookshelf')[params[0]] = params[1];
            }
        }
        
        $.fn.bookshelf = function( method ) {
            if ( methods[method] ) {
                return methods[method].apply( this, Array.prototype.slice.call( arguments, 1 ));
            } else if ( typeof method === 'object' || ! method ) {
                return methods.init.apply( this, arguments );
            } else {
                $.error( 'Method ' +  method + ' does not exist.' );
                return false;
            }
        }
    }
})(jQuery)